/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import opennlp.ccg.synsem.Sign;

public class Edge
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Sign sign;
    protected double score;
    protected int wordPos = -1;
    protected List<Edge> altEdges = null;
    protected transient List<Edge> savedAltEdges = null;
    private static final NumberFormat nf3 = Edge.initNF3();
    private static final NumberFormat nfE = new DecimalFormat("0.##E0");

    public static Edge getEdge(Sign sign) {
        EdgeRef eref = (EdgeRef)sign.getData(EdgeRef.class);
        return eref != null ? eref.edge : null;
    }

    public Edge(Sign sign) {
        this(sign, 0.0);
    }

    public Edge(Sign sign, double score) {
        this.sign = sign;
        this.score = score;
        sign.addData(new EdgeRef(this));
    }

    public Sign getSign() {
        return this.sign;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public int getWordPos() {
        return this.wordPos;
    }

    public void setWordPos(int pos) {
        this.wordPos = pos;
    }

    public boolean isRepresentative() {
        return this.altEdges != null;
    }

    public boolean isDisjunctive() {
        return this.altEdges != null && this.altEdges.size() > 1;
    }

    public List<Edge> getAltEdges() {
        if (this.altEdges == null) {
            return Collections.emptyList();
        }
        return this.altEdges;
    }

    public void initAltEdges() {
        this.initAltEdges(3);
    }

    public void initAltEdges(int capacity) {
        if (this.altEdges != null) {
            throw new RuntimeException("Alt edges already initialized!");
        }
        this.altEdges = new ArrayList<Edge>(capacity);
        this.altEdges.add(this);
    }

    public void replaceAltEdges(List<Edge> newAlts) {
        this.savedAltEdges = this.altEdges;
        this.altEdges = newAlts;
    }

    public void restoreAltEdges() {
        if (this.savedAltEdges != null) {
            this.altEdges = this.savedAltEdges;
            this.savedAltEdges = null;
            for (Edge alt : this.altEdges) {
                Sign[] inputs = alt.sign.getDerivationHistory().getInputs();
                if (inputs == null) continue;
                for (Sign s : inputs) {
                    Edge.getEdge(s).restoreAltEdges();
                }
            }
        }
    }

    public int hashCode() {
        return this.sign.hashCode() * 23;
    }

    public int surfaceWordHashCode() {
        return this.sign.surfaceWordHashCode() * 23;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge edge = (Edge)obj;
        return this.sign.equals(edge.sign);
    }

    public boolean surfaceWordEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge edge = (Edge)obj;
        return this.sign.surfaceWordEquals(edge.sign);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        if (this.score >= 0.001 || this.score == 0.0) {
            sbuf.append("[" + nf3.format(this.score) + "] ");
        } else {
            sbuf.append("[" + nfE.format(this.score) + "] ");
        }
        sbuf.append(this.sign.toString());
        return sbuf.toString();
    }

    private static NumberFormat initNF3() {
        NumberFormat f = NumberFormat.getInstance();
        f.setMinimumIntegerDigits(1);
        f.setMinimumFractionDigits(3);
        f.setMaximumFractionDigits(3);
        return f;
    }

    public static class EdgeRef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Edge edge;

        public EdgeRef(Edge edge) {
            this.edge = edge;
        }
    }
}

