/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse.tagger.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import opennlp.ccg.lexicon.Tokenizer;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.parse.supertagger.util.PipedTokenizer;
import opennlp.ccg.parse.tagger.io.CorpusIterator;

public class PipeDelimitedFactoredBundleCorpusIterator
implements CorpusIterator,
Iterator<List<Word>>,
Iterable<List<Word>> {
    private BufferedReader reader;
    private String nextLine;
    private String nextID;
    public static final String SENT_START = "<s>";
    public static final String SENT_END = "</s>";
    private Tokenizer toker = new PipedTokenizer();

    public PipeDelimitedFactoredBundleCorpusIterator(BufferedReader file) {
        try {
            this.reader = file;
            String line = this.reader.readLine();
            if (line != null && line.length() > 0) {
                this.nextLine = line = line.trim();
            } else {
                this.nextID = null;
                this.nextLine = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<Word> next() {
        List<Word> currentSent;
        block6: {
            currentSent = null;
            try {
                if (this.hasNext()) {
                    String line = this.reader.readLine();
                    if (line != null) {
                        line = line.trim();
                    }
                    currentSent = this.nextLine.endsWith(SENT_END) ? this.toker.tokenize(this.nextLine.substring(this.nextLine.indexOf(">") + 1, this.nextLine.lastIndexOf("<")).trim()) : this.toker.tokenize(this.nextLine.substring(this.nextLine.indexOf(">") + 1).trim());
                    if (line != null && !line.trim().equals("")) {
                        this.nextLine = line;
                    } else {
                        this.nextID = null;
                        this.nextLine = null;
                    }
                    break block6;
                }
                throw new IOException("There is no next line.");
            }
            catch (IOException ex) {
                Logger.getLogger("global").log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return currentSent;
    }

    public String getCurrentID() {
        return this.nextID;
    }

    @Override
    public boolean hasNext() {
        return this.nextLine != null;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException ex) {
            Logger.getLogger("global").log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Iterator<List<Word>> iterator() {
        return this;
    }
}

