/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.perceptron;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import opennlp.ccg.perceptron.Alphabet;
import opennlp.ccg.perceptron.FeatureExtractor;
import opennlp.ccg.perceptron.FeatureList;
import opennlp.ccg.perceptron.FeatureVector;
import opennlp.ccg.synsem.Sign;

public class EventFile {
    private Alphabet alphabet;
    private File file;
    private Reader reader;
    private StreamTokenizer tokenizer;
    private List<Block> blocks = null;
    private Iterator<Block> blockIt = null;
    private boolean eofReached = false;

    public EventFile(String filename) throws IOException {
        this(filename, false);
    }

    public EventFile(String filename, boolean inMemory) throws IOException {
        this(filename, new Alphabet(10000), inMemory);
    }

    public EventFile(String filename, Alphabet alphabet) throws IOException {
        this(filename, alphabet, false);
    }

    public EventFile(String filename, Alphabet alphabet, boolean inMemory) throws IOException {
        this.file = new File(filename);
        this.init();
        this.alphabet = alphabet;
        if (inMemory) {
            this.blocks = new ArrayList<Block>(10000);
        }
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public void reset() throws IOException {
        this.close();
        this.init();
    }

    private void init() throws IOException {
        if (this.blocks != null && this.eofReached) {
            this.blockIt = this.blocks.iterator();
            return;
        }
        if (this.blocks != null) {
            this.blocks.clear();
        }
        this.reader = EventFile.openReader(this.file);
        this.tokenizer = EventFile.initTokenizer(this.reader);
    }

    public static StreamTokenizer initTokenizer(Reader reader) throws IOException {
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.resetSyntax();
        tokenizer.wordChars(33, 255);
        tokenizer.whitespaceChars(0, 32);
        return tokenizer;
    }

    public boolean endOfFile() throws IOException {
        this.tokenizer.nextToken();
        boolean eof = this.tokenizer.ttype == -1;
        this.tokenizer.pushBack();
        return eof;
    }

    private Event nextEvent() throws IOException {
        this.tokenizer.nextToken();
        int count = Integer.parseInt(this.tokenizer.sval);
        this.tokenizer.nextToken();
        int numFeats = Integer.parseInt(this.tokenizer.sval);
        FeatureList fv = new FeatureList(numFeats);
        for (int i = 0; i < numFeats; ++i) {
            this.tokenizer.nextToken();
            String feat = this.tokenizer.sval;
            this.tokenizer.nextToken();
            float val = Float.parseFloat(this.tokenizer.sval);
            Alphabet.Feature f = this.alphabet.index(feat);
            if (f == null) continue;
            fv.add(f, Float.valueOf(val));
        }
        return new Event(fv, count);
    }

    public Block nextBlock() throws IOException {
        if (this.blockIt != null) {
            return this.blockIt.hasNext() ? this.blockIt.next() : null;
        }
        if (this.endOfFile()) {
            this.eofReached = true;
            return null;
        }
        this.tokenizer.nextToken();
        int numEvents = Integer.parseInt(this.tokenizer.sval);
        ArrayList<Event> events = new ArrayList<Event>(numEvents);
        for (int i = 0; i < numEvents; ++i) {
            events.add(this.nextEvent());
        }
        Block retval = new Block(events);
        if (this.blocks != null) {
            this.blocks.add(retval);
        }
        return retval;
    }

    public static Reader openReader(File file) throws IOException {
        if (file.getName().endsWith(".gz")) {
            return new InputStreamReader(new GZIPInputStream(new FileInputStream(file)));
        }
        return new BufferedReader(new FileReader(file));
    }

    public static PrintWriter openWriter(File file) throws IOException {
        if (file.getName().endsWith(".gz")) {
            return new PrintWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(file))));
        }
        return new PrintWriter(new BufferedWriter(new FileWriter(file)));
    }

    public static void writeEvents(PrintWriter pw, List<Sign> signs, Sign best, FeatureExtractor fe) throws IOException {
        Collections.shuffle(signs);
        pw.println(Integer.toString(signs.size()));
        for (Sign s : signs) {
            int count = 0;
            if (s == best) {
                count = 1;
            }
            pw.print(count + " ");
            FeatureVector fvect = fe.extractFeatures(s, true);
            int numfeats = fvect.size();
            pw.print(numfeats + " ");
            FeatureVector.Iterator it = fvect.iterator();
            while (it.hasNext()) {
                pw.print(it.nextFeature().name() + " " + it.nextValue() + " ");
            }
            pw.println();
        }
    }

    public static class Event {
        public int count;
        public FeatureVector features;

        public Event(FeatureVector features, int count) {
            this.features = features;
            this.count = count;
        }

        public String toString() {
            return "event: count: " + this.count + " " + this.features;
        }
    }

    public static class Block {
        public List<Event> events;

        public Block(List<Event> events) {
            this.events = events;
        }

        public Event best() {
            Event retval = null;
            int max = -1;
            for (Event event : this.events) {
                if (event.count <= max) continue;
                retval = event;
                max = event.count;
            }
            return retval;
        }
    }
}

