/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.perceptron;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import opennlp.ccg.perceptron.Alphabet;
import opennlp.ccg.perceptron.FeatureVector;

public class FeatureMap
implements FeatureVector {
    private static final long serialVersionUID = -5054109887068464041L;
    private HashMap<Alphabet.Feature, Float> map;

    public FeatureMap() {
        this.map = new LinkedHashMap<Alphabet.Feature, Float>();
    }

    public FeatureMap(int size) {
        this.map = new LinkedHashMap<Alphabet.Feature, Float>(size * 2);
    }

    public FeatureMap(FeatureVector fv) {
        this(fv.size() * 4);
        FeatureVector.Iterator it = fv.iterator();
        while (it.hasNext()) {
            this.map.put(it.nextFeature(), it.nextValue());
        }
    }

    public FeatureMap(FeatureVector fv1, FeatureVector fv2) {
        this((fv1.size() + fv2.size()) * 3);
        FeatureVector.Iterator it = fv1.iterator();
        while (it.hasNext()) {
            this.map.put(it.nextFeature(), it.nextValue());
        }
        this.add(fv2);
    }

    public void inc(Alphabet.Feature feature) {
        float count = 1.0f;
        Float val = this.map.get(feature);
        if (val != null) {
            count = Math.round(val.floatValue()) + 1;
        }
        this.map.put(feature, Float.valueOf(count));
    }

    public void add(Alphabet.Feature feature, Float value) {
        Float val = this.map.get(feature);
        if (val != null) {
            this.map.put(feature, Float.valueOf(val.floatValue() + value.floatValue()));
        } else {
            this.map.put(feature, value);
        }
    }

    public void add(FeatureVector fv) {
        FeatureVector.Iterator it = fv.iterator();
        while (it.hasNext()) {
            this.add(it.nextFeature(), it.nextValue());
        }
    }

    public float get(Alphabet.Feature feature) {
        Float retval = this.map.get(feature);
        return retval != null ? retval.floatValue() : 0.0f;
    }

    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public FeatureVector.Iterator iterator() {
        return new FeatureVector.Iterator(){
            Iterator<Map.Entry<Alphabet.Feature, Float>> it;
            Map.Entry<Alphabet.Feature, Float> entry;
            {
                this.it = FeatureMap.this.map.entrySet().iterator();
                this.entry = null;
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Alphabet.Feature nextFeature() {
                this.entry = this.it.next();
                return this.entry.getKey();
            }

            @Override
            public Float nextValue() {
                return this.entry.getValue();
            }
        };
    }
}

