/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.perceptron;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import opennlp.ccg.perceptron.Alphabet;
import opennlp.ccg.perceptron.EventFile;
import opennlp.ccg.perceptron.FeatureVector;
import opennlp.ccg.util.Pair;

public class Model {
    public boolean debug = false;
    private double[] weights;
    private Alphabet alphabet;

    public Model(Alphabet alphabet) {
        this.alphabet = alphabet;
        this.weights = new double[alphabet.size()];
        this.zero();
    }

    public Model(String filename) throws IOException {
        this(filename, null);
    }

    public Model(String filename, FeatureFilter filter) throws IOException {
        Reader reader = EventFile.openReader(new File(filename));
        StreamTokenizer tokenizer = EventFile.initTokenizer(reader);
        tokenizer.nextToken();
        int size = Integer.parseInt(tokenizer.sval);
        this.alphabet = new Alphabet(size);
        this.weights = new double[size];
        for (int i = 0; i < size; ++i) {
            tokenizer.nextToken();
            String name = tokenizer.sval;
            tokenizer.nextToken();
            double weight = Double.parseDouble(tokenizer.sval);
            if (filter != null) {
                weight = filter.adjustedWeight(name, weight);
            }
            this.alphabet.add(name);
            this.weights[i] = weight;
        }
        reader.close();
        this.alphabet.setClosed(true);
    }

    public int size() {
        return this.weights.length;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public double getWeight(int index) {
        return this.weights[index];
    }

    public double getWeight(String feat) {
        return this.weights[this.alphabet.index(feat).getIndex()];
    }

    public double getWeight(Alphabet.Feature f) {
        return this.weights[f.getIndex()];
    }

    public void setWeight(int index, double weight) {
        this.weights[index] = weight;
    }

    public void setWeight(String feat, double weight) {
        this.weights[this.alphabet.index((String)feat).getIndex().intValue()] = weight;
    }

    public void setWeight(Alphabet.Feature f, double weight) {
        this.weights[f.getIndex().intValue()] = weight;
    }

    public double score(FeatureVector fv) {
        double retval = 0.0;
        FeatureVector.Iterator it = fv.iterator();
        while (it.hasNext()) {
            Alphabet.Feature feat = it.nextFeature();
            Float value = it.nextValue();
            Integer index = feat.getIndex();
            if (index == null) continue;
            retval += this.weights[index] * (double)value.floatValue();
        }
        if (this.debug) {
            System.err.println("score: " + retval + " " + fv);
        }
        return retval;
    }

    public void add(FeatureVector fv) {
        FeatureVector.Iterator it = fv.iterator();
        while (it.hasNext()) {
            Alphabet.Feature feat = it.nextFeature();
            Float value = it.nextValue();
            Integer index = feat.getIndex();
            if (index == null) continue;
            int n = index;
            this.weights[n] = this.weights[n] + (double)value.floatValue();
        }
    }

    public void subtract(FeatureVector fv) {
        FeatureVector.Iterator it = fv.iterator();
        while (it.hasNext()) {
            Alphabet.Feature feat = it.nextFeature();
            Float value = it.nextValue();
            Integer index = feat.getIndex();
            if (index == null) continue;
            int n = index;
            this.weights[n] = this.weights[n] - (double)value.floatValue();
        }
    }

    public void add(Model model) {
        for (int i = 0; i < this.weights.length; ++i) {
            int n = i;
            this.weights[n] = this.weights[n] + model.weights[i];
        }
    }

    public void multiply(double num) {
        int i = 0;
        while (i < this.weights.length) {
            int n = i++;
            this.weights[n] = this.weights[n] * num;
        }
    }

    public void zero() {
        for (int i = 0; i < this.weights.length; ++i) {
            this.weights[i] = 0.0;
        }
    }

    public void set(Model model) {
        this.zero();
        for (int i = 0; i < model.weights.length; ++i) {
            Alphabet.Feature f = model.alphabet.feature(i);
            Alphabet.Feature f0 = this.alphabet.index(f);
            if (f0 == null || f0.getIndex() == null) continue;
            this.weights[f0.getIndex().intValue()] = model.weights[i];
        }
    }

    public FeatureVector best(List<FeatureVector> fvs) {
        FeatureVector retval = null;
        double max = Double.NEGATIVE_INFINITY;
        for (FeatureVector fv : fvs) {
            double score = this.score(fv);
            if (!(score > max)) continue;
            retval = fv;
            max = score;
        }
        return retval;
    }

    public EventFile.Event best(EventFile.Block block) {
        EventFile.Event retval = null;
        double max = Double.NEGATIVE_INFINITY;
        for (EventFile.Event event : block.events) {
            double score = this.score(event.features);
            if (!(score > max)) continue;
            retval = event;
            max = score;
        }
        return retval;
    }

    public double accuracy(EventFile eventFile) throws IOException {
        EventFile.Block block;
        if (this.alphabet != eventFile.getAlphabet()) {
            throw new RuntimeException("Model and EventFile must share the same alphabet!");
        }
        int correct = 0;
        int total = 0;
        while ((block = eventFile.nextBlock()) != null) {
            ++total;
            if (this.best(block) == block.best()) {
                ++correct;
                if (!this.debug) continue;
                System.err.println("CORRECT");
                continue;
            }
            if (!this.debug) continue;
            System.err.println("WRONG; best: " + block.best());
        }
        if (this.debug) {
            System.err.println("correct: " + correct + " total: " + total);
        }
        return 1.0 * (double)correct / (double)total;
    }

    public void save(String filename) throws IOException {
        this.save(filename, 0.0);
    }

    public void save(String filename, double minPrune) throws IOException {
        File file = new File(filename);
        PrintWriter out = EventFile.openWriter(file);
        int size = this.size();
        int pruned = 0;
        for (int i = 0; i < size; ++i) {
            if (!(Math.abs(this.weights[i]) <= minPrune)) continue;
            ++pruned;
        }
        int prunedSize = size - pruned;
        out.println(Integer.toString(prunedSize));
        ArrayList<Pair<Alphabet.Feature, Double>> featWeights = new ArrayList<Pair<Alphabet.Feature, Double>>(prunedSize);
        for (int i = 0; i < size; ++i) {
            if (Math.abs(this.weights[i]) <= minPrune) continue;
            featWeights.add(new Pair<Alphabet.Feature, Double>(this.alphabet.feature(i), this.weights[i]));
        }
        Collections.sort(featWeights, new Comparator<Pair<Alphabet.Feature, Double>>(){

            @Override
            public int compare(Pair<Alphabet.Feature, Double> entry1, Pair<Alphabet.Feature, Double> entry2) {
                double val2;
                double val1 = Math.abs((Double)entry1.b);
                if (val1 > (val2 = Math.abs((Double)entry2.b))) {
                    return -1;
                }
                if (val1 < val2) {
                    return 1;
                }
                return 0;
            }
        });
        for (Pair pair : featWeights) {
            out.println(((Alphabet.Feature)pair.a).name() + " " + pair.b);
        }
        out.close();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Usage: java perceptron.Model <modelfile> <eventfile> (-debug)");
            System.exit(0);
        }
        String modelfile = args[0];
        String eventfile = args[1];
        boolean debug = Arrays.asList(args).contains("-debug");
        System.out.println("Loading model from: " + modelfile);
        Model model = new Model(modelfile);
        model.debug = debug;
        System.out.println("model size: " + model.size());
        System.out.println("debug: " + debug);
        System.out.println("Scoring events in: " + eventfile);
        EventFile eventFile = new EventFile(eventfile, model.alphabet);
        double accuracy = model.accuracy(eventFile);
        System.out.println("accuracy: " + accuracy);
    }

    public static interface FeatureFilter {
        public double adjustedWeight(String var1, double var2);
    }
}

