/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.realize.hypertagger;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.realize.Realizer;
import opennlp.ccg.realize.hypertagger.LFInfo;
import opennlp.ccg.synsem.LF;
import org.jdom.Document;
import org.jdom.Element;

public class LFLoader
implements Iterator<LFInfo> {
    Grammar grammar;
    ArrayList<File> lfFiles;
    int filePos = 0;
    LinkedList<LFInfo> lfs = new LinkedList();
    int total = 0;
    int skipped = 0;

    public LFLoader(File grammarFile, File baseDir, List<String> paths) {
        URL grammarURL = null;
        try {
            grammarURL = grammarFile.toURI().toURL();
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        try {
            this.grammar = new Grammar(grammarURL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lfFiles = new ArrayList();
        paths = this.normalize(paths);
        for (String lfFilename : paths) {
            File f = new File(baseDir, lfFilename);
            if (f.isDirectory()) {
                this.lfFiles.addAll(Arrays.asList(f.listFiles(new XmlFilenameFilter())));
                continue;
            }
            this.lfFiles.add(f);
        }
    }

    private List<String> normalize(List<String> paths) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String s : paths) {
            String[] fields;
            if (s.indexOf(44) < 0) {
                ret.add(s.trim());
                continue;
            }
            for (String f : fields = s.split(",")) {
                ret.add(f.trim());
            }
        }
        return ret;
    }

    private void loadFile(File lfFile) {
        Document doc = null;
        int n = 0;
        try {
            doc = this.grammar.loadFromXml(lfFile.getAbsolutePath());
        }
        catch (IOException e) {
            System.err.println("Couldn't open input file " + lfFile + ", skipping.\n");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Element root = doc.getRootElement();
        List testItems = root.getChildren();
        for (Element item : testItems) {
            String lfNum = "unk";
            lfNum = item.getAttributeValue("info");
            Element itemLFElt = item.getChild("lf");
            Element itemPredInfoElt = item.getChild("pred-info");
            String predInfo = null;
            if (itemPredInfoElt != null) {
                predInfo = itemPredInfoElt.getAttributeValue("data");
            }
            if (predInfo == null || predInfo.equals("")) {
                System.err.println("No pred-info found for lf #" + n + " (info: " + lfNum + ") in file " + lfFile + ", skipping.");
                ++this.skipped;
                continue;
            }
            try {
                LF lf = Realizer.getLfFromElt(itemLFElt);
                LF flatLF = HyloHelper.flattenLF(lf);
                this.lfs.offer(new LFInfo(flatLF, predInfo, lfNum));
            }
            catch (Exception exc) {
                System.err.println("Skipping lf #" + n + " (info: " + lfNum + ") in file " + lfFile + ", uncaught exception:");
                System.err.println(exc.getMessage());
                exc.printStackTrace(System.err);
                ++this.skipped;
                continue;
            }
            ++n;
            ++this.total;
        }
        System.err.println("LFL: loaded " + n + " LFs from " + lfFile);
    }

    @Override
    public boolean hasNext() {
        if (!this.lfs.isEmpty()) {
            return true;
        }
        while (this.lfs.isEmpty()) {
            if (this.filePos == this.lfFiles.size()) {
                return false;
            }
            this.loadFile(this.lfFiles.get(this.filePos));
            ++this.filePos;
        }
        return true;
    }

    @Override
    public LFInfo next() {
        if (!this.lfs.isEmpty()) {
            return this.lfs.poll();
        }
        while (this.lfs.isEmpty()) {
            if (this.filePos == this.lfFiles.size()) {
                return null;
            }
            this.loadFile(this.lfFiles.get(this.filePos));
        }
        return this.lfs.poll();
    }

    @Override
    public void remove() {
        throw new RuntimeException("Method not implemented");
    }

    public int getTotal() {
        return this.total;
    }

    public int getSkipped() {
        return this.skipped;
    }

    static class XmlFilenameFilter
    implements FileFilter {
        XmlFilenameFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.getName().toLowerCase().endsWith(".xml");
        }
    }
}

