/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.synsem;

import gnu.trove.TObjectIntHashMap;
import java.util.List;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.synsem.AbstractCat;
import opennlp.ccg.synsem.Arg;
import opennlp.ccg.synsem.ArgStack;
import opennlp.ccg.synsem.AtomCat;
import opennlp.ccg.synsem.BasicArg;
import opennlp.ccg.synsem.CatReader;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.CategoryFcn;
import opennlp.ccg.synsem.Dollar;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.SetArg;
import opennlp.ccg.synsem.TargetCat;
import opennlp.ccg.unify.FeatureStructure;
import opennlp.ccg.unify.GUnifier;
import opennlp.ccg.unify.ModFcn;
import opennlp.ccg.unify.Substitution;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.unify.Variable;
import opennlp.ccg.util.DisplayPrefs;
import org.jdom.Content;
import org.jdom.Element;

public final class ComplexCat
extends AbstractCat {
    private static final long serialVersionUID = 1L;
    private TargetCat _target;
    private ArgStack _args;

    public ComplexCat(TargetCat target, Arg arg) {
        this(target, new ArgStack(arg));
    }

    public ComplexCat(TargetCat target, ArgStack args) {
        this(target, args, null);
    }

    public ComplexCat(TargetCat target, ArgStack args, LF lf) {
        super(lf);
        this._target = target;
        if (args.size() < 1) {
            System.out.println("WARNING!!! Creating a ComplexCat with empty argument stack!");
        }
        this._args = args;
    }

    public ComplexCat(Element el) {
        super(el);
        List info = el.getChildren();
        Element lfElt = el.getChild("lf");
        if (lfElt != null) {
            info.remove(lfElt);
        }
        this._target = (TargetCat)CatReader.getCat((Element)info.get(0));
        this._args = new ArgStack(info.subList(1, info.size()));
        this.setModifierSlashes();
    }

    @Override
    public Element toXml() {
        Element retval = new Element("complexcat");
        retval.addContent((Content)this._target.toXml());
        this._args.toXml(retval);
        super.toXml(retval);
        return retval;
    }

    private void setModifierSlashes() {
        FeatureStructure targetFS = this._target.getFeatureStructure();
        int targetIndex = targetFS.getIndex();
        if (targetIndex == 0) {
            targetIndex = targetFS.getInheritsFrom();
        }
        if (targetIndex == 0) {
            return;
        }
        for (int i = 0; i < this._args.size(); ++i) {
            Arg arg = this._args.get(i);
            if (arg instanceof BasicArg) {
                this.setModifierSlash(targetIndex, (BasicArg)arg);
                continue;
            }
            if (!(arg instanceof SetArg)) continue;
            SetArg sArg = (SetArg)arg;
            for (int j = 0; j < sArg.size(); ++j) {
                this.setModifierSlash(targetIndex, sArg.get(j));
            }
        }
    }

    private void setModifierSlash(int targetIndex, BasicArg arg) {
        FeatureStructure argFS = arg.getCat().getTarget().getFeatureStructure();
        if (targetIndex == argFS.getIndex() || targetIndex == argFS.getInheritsFrom()) {
            arg.getSlash().setModifier(true);
        }
    }

    @Override
    public TargetCat getTarget() {
        return this._target;
    }

    public Arg getArg(int pos) {
        return this._args.get(pos);
    }

    public Arg getOuterArg() {
        return this._args.getLast();
    }

    public Category getResult() {
        return this.getSubResult(this.arity() - 1);
    }

    public Category getSubResult(int upto) {
        if (upto == 0) {
            return this._target;
        }
        return new ComplexCat(this._target, this._args.subList(0, upto));
    }

    public ArgStack getArgStack() {
        return this._args;
    }

    public ArgStack getArgStack(int from) {
        return this._args.subList(from);
    }

    public boolean containsDollarArg() {
        return this._args.containsDollarArg();
    }

    public boolean containsSetArg() {
        return this._args.containsSetArg();
    }

    public void add(Arg a) {
        this._args.add(a);
    }

    public void add(ArgStack as) {
        this._args.add(as);
    }

    public void addBeforeEnd(ArgStack as) {
        int size = this._args.size();
        if (size < 1) {
            this.add(as);
        } else {
            this._args.addAt(as, size - 1);
        }
    }

    public void addFront(ArgStack as) {
        this._args.addFront(as);
    }

    public void insertFront(ArgStack as) {
        this._args.insertFront(as);
    }

    public void insertEnd(ArgStack as) {
        this._args.insertEnd(as);
    }

    public void set(int index, Arg c) {
        this._args.set(index, c);
    }

    public void setOuterArgument(Arg c) {
        this._args.setLast(c);
    }

    public int arity() {
        return this._args.size();
    }

    @Override
    public Category copy() {
        return new ComplexCat((TargetCat)this._target.copy(), this._args.copy(), this._lf == null ? null : this._lf.copy());
    }

    @Override
    public Category shallowCopy() {
        return new ComplexCat(this._target, this._args, this._lf);
    }

    @Override
    public void deepMap(ModFcn mf) {
        super.deepMap(mf);
        this._target.deepMap(mf);
        this._args.deepMap(mf);
    }

    @Override
    public void forall(CategoryFcn f) {
        f.forall(this);
        this._target.forall(f);
        this._args.forall(f);
    }

    @Override
    public void unifyCheck(Object u) throws UnifyFailure {
        if (u instanceof ComplexCat) {
            ComplexCat cc = (ComplexCat)u;
            this._target.unifyCheck(cc._target);
        }
    }

    @Override
    public Object unify(Object u, Substitution sub) throws UnifyFailure {
        if (u instanceof AtomCat && this.arity() == 1 & this.containsDollarArg()) {
            sub.makeSubstitution((Dollar)this._args.get(0), new ArgStack());
            return GUnifier.unify(this._target, (AtomCat)u, sub);
        }
        if (u instanceof ComplexCat) {
            ComplexCat cc = (ComplexCat)u;
            ArgStack $args = this._args.unify(cc._args, sub);
            Category $target = GUnifier.unify(this._target, cc._target, sub);
            if ($args.size() == 0) {
                return $target;
            }
            return new ComplexCat((TargetCat)$target, $args);
        }
        throw new UnifyFailure();
    }

    @Override
    public boolean occurs(Variable v) {
        return super.occurs(v) || this._target.occurs(v) || this._args.occurs(v);
    }

    @Override
    public Object fill(Substitution s) throws UnifyFailure {
        LF $lf;
        Category $target = (Category)this._target.fill(s);
        ArgStack $args = this._args.fill(s);
        LF lF = $lf = this._lf == null ? null : (LF)this._lf.fill(s);
        if ($args.size() == 0) {
            $target.setLF($lf);
            return $target;
        }
        if ($target instanceof TargetCat) {
            return new ComplexCat((TargetCat)$target, $args, $lf);
        }
        if ($target instanceof ComplexCat) {
            ((ComplexCat)$target).add($args);
            $target.setLF($lf);
            return $target;
        }
        throw new UnifyFailure();
    }

    @Override
    public String toString() {
        DisplayPrefs prefs = Grammar.theGrammar.prefs;
        StringBuffer sb = new StringBuffer();
        sb.append(this._target.toString()).append(this._args.toString());
        if (this._lf != null && prefs.showSem) {
            sb.append(" : ").append(this._lf.toString());
        }
        return sb.toString();
    }

    @Override
    public String getSupertag() {
        if (this._supertag != null) {
            return this._supertag;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this._target.getSupertag()).append(this._args.getSupertag());
        this._supertag = sb.toString().intern();
        return this._supertag;
    }

    @Override
    public String toTeX() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._target.toTeX()).append(this._args.toTeX());
        return sb.toString();
    }

    @Override
    public int hashCodeNoLF(TObjectIntHashMap varMap) {
        int retval = this._target.hashCodeNoLF(varMap);
        return retval += this._args.hashCode(varMap);
    }

    @Override
    public boolean equalsNoLF(Object obj, TObjectIntHashMap varMap, TObjectIntHashMap varMap2) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ComplexCat cc = (ComplexCat)obj;
        if (!this._target.equalsNoLF(cc._target, varMap, varMap2)) {
            return false;
        }
        return this._args.equals(cc._args, varMap, varMap2);
    }
}

