/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.synsem;

import gnu.trove.TObjectIntHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import opennlp.ccg.synsem.Arg;
import opennlp.ccg.synsem.ArgStack;
import opennlp.ccg.synsem.BasicArg;
import opennlp.ccg.synsem.CatReader;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.CategoryFcn;
import opennlp.ccg.synsem.Slash;
import opennlp.ccg.unify.GUnifier;
import opennlp.ccg.unify.ModFcn;
import opennlp.ccg.unify.Substitution;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.unify.Variable;
import org.jdom.Content;
import org.jdom.Element;

public final class SetArg
implements Arg,
Serializable {
    private static final long serialVersionUID = -7067480310511294657L;
    private ArgStack _args;

    public SetArg(Element el) {
        List info = el.getChildren();
        ArrayList<BasicArg> args = new ArrayList<BasicArg>();
        Iterator infoIt = info.iterator();
        while (infoIt.hasNext()) {
            Slash s = new Slash((Element)infoIt.next());
            Category c = CatReader.getCat((Element)infoIt.next());
            args.add(new BasicArg(s, c));
        }
        Arg[] list = new Arg[args.size()];
        args.toArray(list);
        this._args = new ArgStack(list);
    }

    public SetArg(Arg[] args) {
        this._args = new ArgStack(args);
    }

    public SetArg(ArgStack args) {
        this._args = args;
    }

    public Element toXml() {
        Element retval = new Element("setarg");
        for (Arg arg : this._args._list) {
            if (!(arg instanceof BasicArg)) continue;
            BasicArg barg = (BasicArg)arg;
            retval.addContent((Content)barg.getSlash().toXml());
            retval.addContent((Content)barg.getCat().toXml());
        }
        return retval;
    }

    @Override
    public Arg copy() {
        return new SetArg(this._args.copy());
    }

    public void add(ArgStack as) {
        this._args.add(as);
    }

    @Override
    public void forall(CategoryFcn fcn) {
        this._args.forall(fcn);
    }

    public Arg copyWithout(int pos) {
        if (this._args.size() == 2) {
            if (pos == 0) {
                return this._args.get(1);
            }
            return this._args.get(0);
        }
        return new SetArg(this._args.copyWithout(pos));
    }

    public int size() {
        return this._args.size();
    }

    public BasicArg get(int pos) {
        return (BasicArg)this._args.get(pos);
    }

    public Category getCat(int pos) {
        return ((BasicArg)this._args.get(pos)).getCat();
    }

    public int indexOf(BasicArg a) {
        int index = -1;
        for (int i = 0; i < this._args.size() && index < 0; ++i) {
            try {
                a.unifySlash(((BasicArg)this._args.get(i)).getSlash());
                GUnifier.unify(this.getCat(i), a.getCat());
                index = i;
                continue;
            }
            catch (UnifyFailure unifyFailure) {
                // empty catch block
            }
        }
        return index;
    }

    public int indexOf(Category cat) {
        int index = -1;
        for (int i = 0; i < this._args.size() && index < 0; ++i) {
            try {
                GUnifier.unify(this.getCat(i), cat);
                index = i;
                continue;
            }
            catch (UnifyFailure unifyFailure) {
                // empty catch block
            }
        }
        return index;
    }

    @Override
    public void setSlashModifier(boolean modifier) {
        for (int i = 0; i < this._args.size(); ++i) {
            BasicArg arg = this.get(i);
            arg.setSlashModifier(modifier);
        }
    }

    @Override
    public void setSlashHarmonicCompositionResult(boolean harmonicResult) {
        for (int i = 0; i < this._args.size(); ++i) {
            BasicArg arg = this.get(i);
            arg.setSlashHarmonicCompositionResult(harmonicResult);
        }
    }

    public boolean containsContrarySlash() {
        for (int i = 0; i < this._args.size(); ++i) {
            if (((BasicArg)this._args.get(i)).getSlash().sameDirAsModality()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void unifySlash(Slash s) throws UnifyFailure {
        for (int i = 0; i < this._args.size(); ++i) {
            this._args.get(i).unifySlash(s);
        }
    }

    @Override
    public void unifyCheck(Object u) throws UnifyFailure {
    }

    @Override
    public Object unify(Object u, Substitution sub) throws UnifyFailure {
        throw new UnifyFailure();
    }

    @Override
    public Object fill(Substitution s) throws UnifyFailure {
        return new SetArg(this._args.fill(s));
    }

    @Override
    public void deepMap(ModFcn mf) {
        this._args.deepMap(mf);
    }

    @Override
    public boolean occurs(Variable v) {
        return this._args.occurs(v);
    }

    @Override
    public boolean equals(Object c) {
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(10);
        sb.append('{').append(this._args.toString()).append('}');
        return sb.toString();
    }

    @Override
    public String getSupertag() {
        StringBuffer sb = new StringBuffer();
        sb.append("{").append(this._args.getSupertag()).append("}");
        return sb.toString();
    }

    @Override
    public String toTeX() {
        StringBuffer sb = new StringBuffer(10);
        sb.append("\\{").append(this._args.toTeX()).append("\\}");
        return sb.toString();
    }

    @Override
    public int hashCode(TObjectIntHashMap varMap) {
        return this._args.hashCode(varMap);
    }

    @Override
    public boolean equals(Object obj, TObjectIntHashMap varMap, TObjectIntHashMap varMap2) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SetArg sa = (SetArg)obj;
        return this._args.equals(sa._args, varMap, varMap2);
    }
}

