/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.synsem;

import gnu.trove.TObjectIntHashMap;
import java.io.Serializable;
import opennlp.ccg.synsem.Modality;
import opennlp.ccg.synsem.SlashMode;
import opennlp.ccg.synsem.VarModality;
import opennlp.ccg.unify.ModFcn;
import opennlp.ccg.unify.Mutable;
import opennlp.ccg.unify.Substitution;
import opennlp.ccg.unify.Unifiable;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.unify.Variable;
import org.jdom.Element;

public final class Slash
implements Unifiable,
Mutable,
Serializable {
    private static final long serialVersionUID = -1935688863458012637L;
    public static final byte L = 0;
    public static final byte B = 1;
    public static final byte R = 2;
    public static final byte INERT_OR_ACTIVE = 0;
    public static final byte ACTIVE = 1;
    public static final byte INERT = 2;
    private final byte _dir;
    private final Modality _modality;
    private byte _ability = 0;
    private boolean _modifier = false;
    private boolean _harmonicCompositionResult = false;

    public Slash(Element el) {
        String d = el.getAttributeValue("dir");
        if (d == null) {
            d = el.getAttributeValue("d");
        }
        if (d == null) {
            d = "|";
        }
        this._dir = Slash.encode(d.charAt(0));
        String m = el.getAttributeValue("mode");
        if (m == null) {
            m = el.getAttributeValue("m");
        }
        if (m != null) {
            this._modality = new SlashMode(m);
        } else {
            String vm = el.getAttributeValue("varmodality");
            if (vm == null) {
                vm = el.getAttributeValue("varModality");
            }
            this._modality = vm != null ? new VarModality(vm) : new SlashMode();
        }
        String ability = el.getAttributeValue("ability");
        if (null != ability) {
            this.setAbility(ability);
        }
    }

    public Slash() {
        this('|');
    }

    public Slash(char sd) {
        this._dir = Slash.encode(sd);
        this._modality = new SlashMode();
    }

    public Slash(char sd, String md) {
        this._dir = Slash.encode(sd);
        this._modality = new SlashMode(md);
    }

    public Slash(char sd, Modality md) {
        this._dir = Slash.encode(sd);
        this._modality = md;
    }

    private Slash(byte d, Modality m, byte a) {
        this._dir = d;
        this._modality = m;
        this._ability = a;
    }

    public Element toXml() {
        Element retval = new Element("slash");
        retval.setAttribute("dir", this.encode());
        String ability = this.decodeAbility();
        if (this._modality instanceof SlashMode) {
            String mode = this._modality.toString();
            if (!mode.equals(".")) {
                retval.setAttribute("mode", mode);
            }
        } else if (this._modality instanceof VarModality) {
            retval.setAttribute("varmodality", ((VarModality)this._modality).name());
        }
        if (ability != null) {
            retval.setAttribute("ability", ability);
        }
        return retval;
    }

    public Slash copy() {
        Slash retval = new Slash(this._dir, (Modality)this._modality.copy(), this._ability);
        retval._modifier = this._modifier;
        retval._harmonicCompositionResult = this._harmonicCompositionResult;
        return retval;
    }

    @Override
    public boolean occurs(Variable v) {
        return this._modality.occurs(v);
    }

    @Override
    public void deepMap(ModFcn mf) {
        mf.modify(this);
    }

    public boolean isActive() {
        return this._ability == 1 || this._ability == 0;
    }

    public boolean setAbility(String ability) {
        byte newAbility = ability.equals("inert") ? (byte)2 : (ability.equals("active") ? (byte)1 : 0);
        if (Slash.abilitiesMatch(this._ability, newAbility)) {
            this._ability = newAbility;
            return true;
        }
        return false;
    }

    public String decodeAbility() {
        if (this._ability == 2) {
            return "inert";
        }
        if (this._ability == 1) {
            return "active";
        }
        return null;
    }

    public boolean isModifier() {
        return this._modifier;
    }

    public void setModifier(boolean modifier) {
        this._modifier = modifier;
    }

    public boolean isHarmonicCompositionResult() {
        return this._harmonicCompositionResult;
    }

    public void setHarmonicCompositionResult(boolean harmonicResult) {
        this._harmonicCompositionResult = harmonicResult;
    }

    @Override
    public void unifyCheck(Object u) throws UnifyFailure {
        if (u instanceof Slash) {
            if (!Slash.abilitiesMatch(this._ability, ((Slash)u)._ability)) {
                throw new UnifyFailure();
            }
            if (!Slash.directionsMatch(this._dir, ((Slash)u)._dir)) {
                throw new UnifyFailure();
            }
        } else {
            throw new UnifyFailure();
        }
        this._modality.unifyCheck(((Slash)u)._modality);
    }

    @Override
    public Object unify(Object u, Substitution sub) throws UnifyFailure {
        if (u instanceof Slash) {
            Slash s2 = (Slash)u;
            byte newAbility = this._ability;
            if (this._ability == 0) {
                newAbility = s2._ability;
            } else if (s2._ability == 0) {
                newAbility = this._ability;
            } else if (this._ability != s2._ability) {
                throw new UnifyFailure();
            }
            byte newDir = this._dir;
            if (this._dir == 1) {
                newDir = s2._dir;
            } else if (s2._dir == 1) {
                newDir = this._dir;
            } else if (this._dir != s2._dir) {
                throw new UnifyFailure();
            }
            Modality newModality = (Modality)this._modality.unify(((Slash)u)._modality, sub);
            Slash retval = new Slash(newDir, newModality, newAbility);
            retval._modifier = this._modifier;
            return retval;
        }
        throw new UnifyFailure();
    }

    @Override
    public Object fill(Substitution sub) throws UnifyFailure {
        Slash retval = new Slash(this._dir, (Modality)this._modality.fill(sub), this._ability);
        retval._modifier = this._modifier;
        return retval;
    }

    public boolean sameDirAsModality() {
        return Slash.directionsMatch(this._dir, this._modality.getDirection());
    }

    private static byte encode(char sd) {
        switch (sd) {
            case '/': {
                return 2;
            }
            case '\\': {
                return 0;
            }
        }
        return 1;
    }

    public static boolean directionsMatch(byte s1, byte s2) {
        if (s1 == 1 || s2 == 1) {
            return true;
        }
        return s1 == s2;
    }

    private static boolean abilitiesMatch(byte ab1, byte ab2) {
        if (ab1 == 0 || ab2 == 0) {
            return true;
        }
        return ab1 == ab2;
    }

    public int hashCode() {
        return 31 * this._dir + 7 * this._ability + this._modality.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Slash s = (Slash)obj;
        if (this._dir != s._dir || this._ability != s._ability) {
            return false;
        }
        return this._modality.equals(s._modality);
    }

    public int hashCode(TObjectIntHashMap varMap) {
        int retval = 31 * this._dir + 7 * this._ability;
        retval = this._modality instanceof Variable ? (retval += ((Variable)((Object)this._modality)).hashCode(varMap)) : (retval += this._modality.hashCode());
        return retval;
    }

    public boolean equals(Object obj, TObjectIntHashMap varMap, TObjectIntHashMap varMap2) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Slash s = (Slash)obj;
        if (this._dir != s._dir || this._ability != s._ability) {
            return false;
        }
        if (this._modality instanceof Variable) {
            return ((Variable)((Object)this._modality)).equals(s._modality, varMap, varMap2);
        }
        return this._modality.equals(s._modality);
    }

    private String abilityStr() {
        if (this._ability == 1) {
            return "@";
        }
        if (this._ability == 2) {
            return "!";
        }
        return "";
    }

    public String toString() {
        switch (this._dir) {
            case 2: {
                return "/" + this.abilityStr() + this._modality.toString((byte)2);
            }
            case 0: {
                return "\\" + this.abilityStr() + this._modality.toString((byte)0);
            }
        }
        return "|" + this.abilityStr() + this._modality;
    }

    public String encode() {
        switch (this._dir) {
            case 2: {
                return "/";
            }
            case 0: {
                return "\\";
            }
        }
        return "|";
    }

    public String getSupertag() {
        return this.encode();
    }

    public String toTeX() {
        StringBuffer sb = new StringBuffer();
        String sup = "\\sups";
        String sub = "\\subs";
        String modTeX = null;
        switch (this._dir) {
            case 2: {
                sb.append("/ ");
                sup = "\\supsb";
                sub = "\\subsa";
                modTeX = this._modality.toTeX((byte)2);
                break;
            }
            case 0: {
                sb.append("\\bs ");
                sub = "\\subsb";
                sup = "\\supsa";
                modTeX = this._modality.toTeX((byte)0);
                break;
            }
            default: {
                sb.append("| ");
                sub = "\\subs";
                sup = "\\sups";
                modTeX = this._modality.toTeX();
            }
        }
        if (this._ability == 1) {
            sb.append(sup).append("{").append("+").append("} ");
        }
        if (this._ability == 2) {
            sb.append(sup).append("{").append("-").append("} ");
        }
        if (modTeX != "" && this._ability == 1) {
            if (this._dir == 2) {
                sb.append("\\hspace{-1.45mm} ");
            } else if (this._dir == 0) {
                sb.append("\\hspace{-0.50mm} ");
            }
        }
        if (modTeX != "") {
            sb.append(sub).append("{").append(modTeX).append("} ");
        }
        return sb.toString();
    }
}

