/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.unify;

import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.unify.FeatureStructure;
import opennlp.ccg.unify.GFeatVar;
import opennlp.ccg.unify.GSubstitution;
import opennlp.ccg.unify.ModFcn;
import opennlp.ccg.unify.Mutable;
import opennlp.ccg.unify.SimpleType;
import opennlp.ccg.unify.Substitution;
import opennlp.ccg.unify.Unifiable;
import opennlp.ccg.unify.Unifier;
import opennlp.ccg.unify.UnifyControl;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.unify.Variable;
import org.jdom.Content;
import org.jdom.Element;

public class GFeatStruc
extends HashMap<String, Object>
implements FeatureStructure {
    private static final long serialVersionUID = 1L;
    boolean _empty = true;
    int _index = 0;
    int _inheritsFrom = 0;

    public GFeatStruc() {
        super(3);
    }

    public GFeatStruc(int i) {
        super(i);
    }

    public GFeatStruc(Element fsEl) {
        super(fsEl.getChildren().size());
        List feats;
        String inheritsFrom;
        String index = fsEl.getAttributeValue("id");
        if (index != null) {
            this._index = Integer.parseInt(index);
        }
        if ((inheritsFrom = fsEl.getAttributeValue("inheritsFrom")) != null) {
            this._inheritsFrom = Integer.parseInt(inheritsFrom);
        }
        if ((feats = fsEl.getChildren()).size() == 0) {
            this.setFeature(fsEl);
        } else {
            Iterator featIt = feats.iterator();
            while (featIt.hasNext()) {
                this.setFeature((Element)featIt.next());
            }
        }
    }

    public Element toXml() {
        Element retval = new Element("fs");
        if (this._index > 0) {
            retval.setAttribute("id", Integer.toString(this._index));
        }
        if (this._inheritsFrom > 0) {
            retval.setAttribute("inheritsFrom", Integer.toString(this._inheritsFrom));
        }
        ArrayList keys = new ArrayList(this.keySet());
        Collections.sort(keys);
        if (this.size() == 1 && this.get(keys.get(0)) instanceof SimpleType) {
            String attr = (String)keys.get(0);
            SimpleType val = (SimpleType)this.get(attr);
            retval.setAttribute("attr", attr);
            retval.setAttribute("val", val.getName());
        } else {
            for (String attr : keys) {
                Element featElt = new Element("feat");
                featElt.setAttribute("attr", attr);
                retval.addContent((Content)featElt);
                Object val = this.get(attr);
                if (val instanceof SimpleType) {
                    featElt.setAttribute("val", ((SimpleType)val).getName());
                    continue;
                }
                if (val instanceof GFeatVar) {
                    GFeatVar var = (GFeatVar)val;
                    Element varElt = new Element("featvar");
                    featElt.addContent((Content)varElt);
                    String name = var.name();
                    String typeName = var.getType().getName();
                    if (!typeName.equals("top")) {
                        name = name + ":" + typeName;
                    }
                    varElt.setAttribute("name", name);
                    continue;
                }
                if (val instanceof LF) {
                    featElt.addContent((Content)HyloHelper.toXml((LF)val));
                    continue;
                }
                throw new RuntimeException("Unsupported feature value type in constructing XML: " + val);
            }
        }
        return retval;
    }

    @Override
    public void deepMap(ModFcn mf) {
        Iterator attributes = this.keySet().iterator();
        while (attributes.hasNext()) {
            Object val1 = this.getValue((String)attributes.next());
            if (!(val1 instanceof Mutable)) continue;
            ((Mutable)val1).deepMap(mf);
        }
        mf.modify(this);
    }

    @Override
    public void setFeature(String attribute, Object val) {
        this.put(attribute, val);
        this._empty = false;
    }

    private void setFeature(Element e) {
        Unifiable value;
        String attr = e.getAttributeValue("attr");
        if (attr == null) {
            attr = e.getAttributeValue("a");
        }
        if (attr == null) {
            return;
        }
        String val = e.getAttributeValue("val");
        if (val == null) {
            val = e.getAttributeValue("v");
        }
        if (val != null) {
            value = Grammar.theGrammar.types.getSimpleType(val);
        } else {
            Element valEl = (Element)e.getChildren().get(0);
            if (valEl.getName().equals("featvar") || valEl.getName().equals("fvar")) {
                String[] name = valEl.getAttributeValue("name").split(":");
                if (name[0] == null) {
                    name = valEl.getAttributeValue("n").split(":", 2);
                }
                value = name.length < 2 ? new GFeatVar(name[0]) : new GFeatVar(name[0], Grammar.theGrammar.types.getSimpleType(name[1]));
            } else {
                value = HyloHelper.getLF((Element)e.getChildren().get(0));
            }
        }
        this.setFeature(attr, value);
    }

    @Override
    public Object getValue(String attribute) {
        return this.get(attribute);
    }

    @Override
    public boolean hasAttribute(String attribute) {
        return this.containsKey(attribute);
    }

    @Override
    public boolean attributeHasValue(String attribute, Object val) {
        return val.equals(this.getValue(attribute));
    }

    @Override
    public Set<String> getAttributes() {
        return this.keySet();
    }

    @Override
    public void clear() {
        this.clear();
        this._empty = true;
    }

    @Override
    public boolean equals(FeatureStructure fs) {
        Set<String> atts2;
        if (!(fs instanceof GFeatStruc)) {
            return false;
        }
        GFeatStruc bfs = (GFeatStruc)fs;
        if (this._index != bfs._index) {
            return false;
        }
        if (this.size() != bfs.size()) {
            return false;
        }
        Set<String> atts1 = this.getAttributes();
        if (!atts1.containsAll(atts2 = bfs.getAttributes())) {
            return false;
        }
        for (String att : atts1) {
            if (this.getValue(att).equals(bfs.getValue(att))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this._index;
    }

    @Override
    public FeatureStructure copy() {
        GFeatStruc $fs = new GFeatStruc(this.size());
        $fs.setIndex(this._index);
        $fs._inheritsFrom = this._inheritsFrom;
        for (String a : this.getAttributes()) {
            $fs.setFeature(a, UnifyControl.copy(this.getValue(a)));
        }
        return $fs;
    }

    @Override
    public boolean contains(FeatureStructure fs) {
        Set<String> atts2;
        if (this.size() < fs.size()) {
            return false;
        }
        Set<String> atts1 = this.getAttributes();
        if (atts1.containsAll(atts2 = fs.getAttributes())) {
            for (String a2 : atts2) {
                boolean foundA2 = false;
                Iterator<String> i1 = atts1.iterator();
                while (!foundA2 && i1.hasNext()) {
                    String a1 = i1.next();
                    if (!a1.equals(a2)) continue;
                    if (!this.getValue(a1).equals(fs.getValue(a2))) {
                        return false;
                    }
                    foundA2 = true;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean occurs(Variable v) {
        for (Object $_ : this.values()) {
            if (!($_ instanceof Unifiable) || !((Unifiable)$_).occurs(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void unifyCheck(Object u) throws UnifyFailure {
        if (!(u instanceof FeatureStructure)) {
            throw new UnifyFailure();
        }
        FeatureStructure fs2 = (FeatureStructure)u;
        Set<String> keys1 = this.getAttributes();
        for (String k1 : keys1) {
            Object val2;
            Object val1 = this.getValue(k1);
            if (!(val1 instanceof SimpleType) || !((val2 = fs2.getValue(k1)) instanceof SimpleType)) continue;
            ((SimpleType)val1).unifyCheck(val2);
        }
    }

    @Override
    public Object unify(Object u, Substitution sub) throws UnifyFailure {
        if (!(u instanceof FeatureStructure)) {
            throw new UnifyFailure();
        }
        FeatureStructure fs2 = (FeatureStructure)u;
        GFeatStruc $fs = new GFeatStruc(this.size());
        Set<String> keys1 = this.getAttributes();
        Set<String> keys2 = fs2.getAttributes();
        for (String k1 : keys1) {
            Object val1 = this.getValue(k1);
            Object val2 = fs2.getValue(k1);
            if (val2 != null) {
                $fs.setFeature(k1, Unifier.unify(val1, val2, sub));
                continue;
            }
            $fs.setFeature(k1, UnifyControl.copy(val1));
        }
        for (String k2 : keys2) {
            if (keys1.contains(k2)) continue;
            $fs.setFeature(k2, UnifyControl.copy(fs2.getValue(k2)));
        }
        int fs2Index = fs2.getIndex();
        int newIndex = 0;
        if (this._index == 0) {
            newIndex = fs2Index;
        } else if (fs2Index == 0) {
            newIndex = this._index;
        } else if (sub instanceof GSubstitution) {
            newIndex = ((GSubstitution)sub).makeNewIndex(this._index, fs2Index);
        }
        $fs.setIndex(newIndex);
        if (sub instanceof GSubstitution && newIndex > 0) {
            ((GSubstitution)sub).addIndexedObject(newIndex, $fs);
        }
        return $fs;
    }

    @Override
    public Object fill(Substitution sub) throws UnifyFailure {
        FeatureStructure otherVals;
        FeatureStructure $fs = this.copy();
        for (String a : $fs.getAttributes()) {
            Object varVal;
            Object value = this.getValue(a);
            if (!(value instanceof Variable) || null == (varVal = sub.getValue((Variable)value))) continue;
            $fs.setFeature(a, Unifier.unify(value, varVal, sub));
        }
        if (this._index > 0 && sub instanceof GSubstitution && null != (otherVals = (FeatureStructure)((GSubstitution)sub).getIndexedObject(this._index)) && !$fs.equals(otherVals)) {
            $fs = (FeatureStructure)$fs.unify(otherVals, sub);
            $fs.setIndex(otherVals.getIndex());
        }
        return $fs;
    }

    @Override
    public FeatureStructure inherit(FeatureStructure fs) {
        FeatureStructure $fs = this.copy();
        for (String a : fs.getAttributes()) {
            $fs.setFeature(a, UnifyControl.copy(fs.getValue(a)));
        }
        return $fs;
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    @Override
    public void setIndex(int index) {
        this._index = index;
    }

    @Override
    public int getInheritsFrom() {
        return this._inheritsFrom;
    }

    private void addFeatureString(String attribute, StringBuffer sb) {
        Object val = this.getValue(attribute);
        sb.append(attribute).append('=').append(val.toString());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(this.size() * 4);
        if (this._index > 0) {
            sb.append('<');
            sb.append(this._index);
            sb.append('>');
        }
        if (this._empty) {
            return sb.toString();
        }
        String featsToShow = Grammar.theGrammar.prefs.featsToShow;
        sb.append('{');
        ArrayList<Object> filteredKeys = new ArrayList<Object>(this.size());
        if (featsToShow.length() == 0) {
            filteredKeys.addAll(this.keySet());
        } else {
            for (String key : this.keySet()) {
                if (featsToShow.indexOf(key) == -1) continue;
                filteredKeys.add(key);
            }
        }
        Object[] keys = new String[filteredKeys.size()];
        filteredKeys.toArray(keys);
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            this.addFeatureString((String)keys[i], sb);
            if (i >= keys.length - 1) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String getSupertagInfo() {
        if (this._empty) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        ArrayList<String> attrs = new ArrayList<String>(this.getAttributes());
        Collections.sort(attrs);
        Set<String> supertagFeatures = Grammar.theGrammar.supertagFeatures;
        for (int i = 0; i < attrs.size(); ++i) {
            Object val;
            String attr = attrs.get(i);
            if (!supertagFeatures.contains(attr) || (val = this.getValue(attr)) instanceof Variable) continue;
            String s = val.toString();
            if (s.equals("+") || s.equals("-")) {
                s = s + attr;
            }
            sb.append('[').append(s).append(']');
        }
        return sb.toString();
    }

    private void addFeatureTeX(String attribute, StringBuffer sb) {
        Object val = this.getValue(attribute);
        String s = this.cleanText(val.toString());
        if (s.equals("+") || s.equals("-")) {
            s = attribute + s;
        }
        sb.append(" ").append(s);
    }

    private String cleanText(String s) {
        String str = s;
        try {
            str = str.replaceAll("\\\\", " \\\\\\backslash ");
            str = str.replaceAll("\\{", " \\\\\\{ ");
            str = str.replaceAll("\\}", " \\\\\\} ");
            str = str.replaceAll("\\$", " \\\\\\$ ");
            str = str.replaceAll("\\#", " \\\\\\# ");
            str = str.replaceAll("\\%", " \\\\\\% ");
            str = str.replaceAll("\\&", " \\\\\\& ");
            str = str.replaceAll("\\~", "  \\\\\\tilde\\{\\} ");
            str = str.replaceAll("\\_", " \\\\\\_ ");
            str = str.replaceAll("\\^", "  \\\\\\hat\\{\\} ");
        }
        catch (Exception e) {
            System.out.println("Error while evaluating RegExp: " + e.toString());
        }
        return str;
    }

    @Override
    public String toTeX() {
        StringBuffer sb = new StringBuffer();
        if (this._index > 0 && this._empty) {
            sb.append(" \\subsf{ < ");
            sb.append(this._index);
            sb.append(" > } ");
        }
        if (this._empty) {
            return sb.toString();
        }
        String featsToShow = Grammar.theGrammar.prefs.featsToShow;
        sb.append(" \\subsf{ ");
        if (this._index > 0) {
            sb.append("  < ");
            sb.append(this._index);
            sb.append(" > ");
        }
        ArrayList<Object> filteredKeys = new ArrayList<Object>(this.size());
        if (featsToShow.length() == 0) {
            filteredKeys.addAll(this.keySet());
        } else {
            for (String key : this.keySet()) {
                if (featsToShow.indexOf(key) == -1) continue;
                filteredKeys.add(key);
            }
        }
        Object[] keys = new String[filteredKeys.size()];
        filteredKeys.toArray(keys);
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            this.addFeatureTeX((String)keys[i], sb);
            if (i >= keys.length - 1) continue;
            sb.append(" , ");
        }
        sb.append(" } ");
        return sb.toString();
    }

    public int hashCode(TObjectIntHashMap varMap) {
        int next;
        int retval = 0;
        if (this._index != 0) {
            if (varMap.containsKey((Object)this._index)) {
                retval = varMap.get((Object)this._index);
            } else {
                next = varMap.size() + 1;
                varMap.put((Object)this._index, next);
                retval = next;
            }
        } else {
            next = varMap.size() + 1;
            varMap.put((Object)(-1 * Math.abs(System.identityHashCode(this))), next);
            retval = next;
        }
        if (this._empty) {
            return retval;
        }
        Set keySet = this.keySet();
        Object[] keys = new String[keySet.size()];
        keySet.toArray(keys);
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            retval += ((String)keys[i]).hashCode();
            Object val = this.getValue((String)keys[i]);
            if (val instanceof Variable) {
                retval += ((Variable)val).hashCode(varMap);
                continue;
            }
            retval += val.hashCode();
        }
        return retval;
    }

    public boolean equals(Object obj, TObjectIntHashMap varMap, TObjectIntHashMap varMap2) {
        Set<String> atts2;
        int fsMappedIndex;
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GFeatStruc fs = (GFeatStruc)obj;
        int mappedIndex = this._index != 0 ? varMap.get((Object)this._index) : varMap.get((Object)(-1 * Math.abs(System.identityHashCode(this))));
        int n = fsMappedIndex = fs._index != 0 ? varMap2.get((Object)fs._index) : varMap2.get((Object)(-1 * Math.abs(System.identityHashCode(fs))));
        if (mappedIndex != fsMappedIndex) {
            return false;
        }
        if (this.size() != fs.size()) {
            return false;
        }
        Set<String> atts1 = this.getAttributes();
        if (!atts1.containsAll(atts2 = fs.getAttributes())) {
            return false;
        }
        for (String att : atts1) {
            Object val = this.getValue(att);
            Object val2 = fs.getValue(att);
            if (!(val instanceof Variable && val2 instanceof Variable ? !((Variable)val).equals(val2, varMap, varMap2) : !val.equals(val2))) continue;
            return false;
        }
        return true;
    }
}

