/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.lexicon.Tokenizer;
import opennlp.ccg.synsem.Sign;

public class Visualizer {
    private String ruleToTeX(String rule, int indent, int length) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (i = 0; i < indent; ++i) {
            sb.append("&");
        }
        sb.append(" \\mc{" + Integer.toString(length) + "} ");
        if (rule == null || rule.length() == 1) {
            sb.append("{\\hrulefill_{" + rule + "}} \\\\\n");
        } else {
            sb.append("{\\hrulefill_{" + rule.substring(0, 1) + "\\mathbf{" + rule.substring(1) + "}}}\\\\\n");
        }
        return sb.toString();
    }

    public String getTempFileName() {
        File f1 = null;
        File f2 = null;
        int i = 0;
        f1 = new File("~tmp" + Integer.toString(i) + ".tex");
        f2 = new File("~tmp" + Integer.toString(i) + ".div");
        while (f1.exists() || f2.exists()) {
            f1 = null;
            f2 = null;
            f1 = new File("~tmp" + Integer.toString(++i) + ".tex");
            f2 = new File("~tmp" + Integer.toString(i) + ".div");
        }
        f1 = null;
        f2 = null;
        return "~tmp" + Integer.toString(i);
    }

    public String getTempDirName() {
        File f1 = null;
        int i = 0;
        f1 = new File("tmp");
        while (f1.exists()) {
            f1 = null;
            f1 = new File("tmp" + Integer.toString(++i));
        }
        f1 = null;
        return "tmp" + Integer.toString(i);
    }

    public int getTreeDepth(Sign sign, int level) {
        int max_depth = 0;
        int depth = 0;
        Sign[] children = sign.getDerivationHistory().getInputs();
        if (children != null && sign.getWords().size() > 1) {
            for (int i = 0; i < children.length; ++i) {
                depth = this.getTreeDepth(children[i], level + 1);
                if (depth <= max_depth) continue;
                max_depth = depth;
            }
        } else {
            max_depth = level;
        }
        return max_depth;
    }

    private int numberOfLeaves(Sign results) {
        int totalLeaves = 0;
        Sign[] children = results.getDerivationHistory().getInputs();
        if (children == null || results.getWords().size() == 1) {
            return 1;
        }
        for (int i = 0; i < children.length; ++i) {
            totalLeaves += this.numberOfLeaves(children[i]);
        }
        return totalLeaves;
    }

    public List<TeXSign> processSign(Sign results, int level, int identation) {
        ArrayList<TeXSign> signList = new ArrayList<TeXSign>();
        Sign[] children = results.getDerivationHistory().getInputs();
        int depth = this.getTreeDepth(results, 0);
        TeXSign ts = new TeXSign();
        int offset = 0;
        if (children != null && results.getWords().size() > 1) {
            for (int i = 0; i < children.length; ++i) {
                if (i > 0) {
                    offset += this.numberOfLeaves(children[i - 1]);
                }
                signList.addAll(this.processSign(children[i], level + 1, identation + offset));
            }
        }
        ts.identation = identation;
        ts.height = depth;
        ts.sign = results;
        signList.add(ts);
        return signList;
    }

    public boolean writeFooter(String fileName) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(fileName, true));
            bw.write("\\end{document}\n");
            bw.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean writeHeader(String fileName) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(fileName));
            bw.write("\\documentclass{article}\n");
            bw.write("\\usepackage[margin=0.5in]{geometry}\n");
            bw.write("\\newcommand{\\deriv}[2]\n");
            bw.write("{  \\renewcommand{\\arraystretch}{.5}\n");
            bw.write("$\\begin{array}[t]{*{#1}{c}}\n");
            bw.write("     #2\n");
            bw.write("   \\end{array}$ }\n");
            bw.write("\\newcommand{\\gf}[1]{\\textsf{\\textsl{#1}}}\n");
            bw.write("\\newcommand{\\cf}[1]{\\mbox{\\ensuremath{\\cfont{#1}}}}\n");
            bw.write("\\newcommand{\\uline}[1]\n");
            bw.write("{\\mc{#1}{\\hrulefill} }\n");
            bw.write("\\newcommand{\\mc}[2]\n");
            bw.write("  {\\multicolumn{#1}{c}{#2}}\n");
            bw.write("\\newcommand{\\cfont}{\\mathsf}\n");
            bw.write("\\newcommand{\\bs}{\\backslash}\n");
            bw.write("\\newcommand{\\subsa}[1]{\\hspace{-0.75mm}_{_{#1}}}\n");
            bw.write("\\newcommand{\\subsb}[1]{\\hspace{-0.10mm}_{_{#1}}}\n");
            bw.write("\\newcommand{\\subs}[1]{\\hspace{-0.40mm}_{#1}}\n");
            bw.write("\\newcommand{\\subsf}[1]{\\hspace{-0.75mm}_{_{#1}}}\n");
            bw.write("\\newcommand{\\supsa}[1]{\\hspace{-1.75mm}^{^{#1}} }\n");
            bw.write("\\newcommand{\\supsb}[1]{\\hspace{-0.80mm}^{^{#1}}  }\n");
            bw.write("\\newcommand{\\sups}[1]{\\hspace{-0.40mm}^{#1}}\n");
            bw.write("\\pagestyle{empty}\n");
            bw.write("\\begin{document}\n");
            bw.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean show(String fileName) {
        String viewerName = null;
        try {
            Visualizer.runCommand("latex " + fileName + ".tex");
            Runtime.getRuntime().exec("latex " + fileName + ".tex");
            viewerName = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS") ? "yap" : "xdvi";
            System.out.println("Close " + viewerName + " to continue ...");
            Visualizer.runCommand(viewerName + " " + fileName);
        }
        catch (Exception e) {
            System.out.println("Error invoking latex/" + viewerName + " : " + e.toString());
            return false;
        }
        return true;
    }

    public boolean cleanFiles(String fileName) {
        try {
            File dir = new File(System.getProperty("user.dir"));
            myFileNameFilter filter = new myFileNameFilter(fileName);
            File[] allFiles = dir.listFiles(filter);
            for (int i = 0; i < allFiles.length; ++i) {
                allFiles[i].delete();
            }
        }
        catch (Exception e) {
            System.out.println("Error cleaning files: " + e.toString());
            return false;
        }
        return true;
    }

    public boolean cleanAuxFiles(String fileName) {
        try {
            File dir = new File(System.getProperty("user.dir"));
            auxFileNameFilter filter = new auxFileNameFilter(fileName);
            File[] allFiles = dir.listFiles(filter);
            for (int i = 0; i < allFiles.length; ++i) {
                allFiles[i].delete();
            }
        }
        catch (Exception e) {
            System.out.println("Error cleaning files: " + e.toString());
            return false;
        }
        return true;
    }

    public boolean saveTeXFile(Sign results, String fileName) {
        List<TeXSign> signList = null;
        BufferedWriter bw = null;
        try {
            int i = 0;
            int numDerivs = 0;
            TeXSign texSign = null;
            bw = new BufferedWriter(new FileWriter(fileName, true));
            signList = this.sortList(this.processSign(results, 0, 0));
            numDerivs = results.getWords().size();
            Tokenizer tokenizer = Grammar.theGrammar.lexicon.tokenizer;
            bw.write("\\deriv{" + Integer.toString(numDerivs) + "}{\n");
            for (i = 0; i < results.getWords().size(); ++i) {
                if (i != 0) {
                    bw.write(" & ");
                }
                String orth = tokenizer.getOrthography(results.getWords().get(i), false);
                orth = orth.replaceAll("_", "\\\\_");
                orth = orth.replaceAll("%", "\\\\%");
                bw.write("\\gf{" + orth + "}");
            }
            bw.write(" \\\\\n\\uline{1}");
            for (i = 1; i < results.getWords().size(); ++i) {
                bw.write(" & \\uline{1}");
            }
            bw.write(" \\\\\n");
            texSign = signList.get(0);
            bw.write("\\cf{" + texSign.sign.getCategory().toTeX() + "}");
            for (i = 1; i < numDerivs; ++i) {
                texSign = signList.get(i);
                bw.write(" & \\cf{" + texSign.sign.getCategory().toTeX() + "}");
            }
            bw.write(" \\\\\n");
            for (i = numDerivs; i < signList.size(); ++i) {
                String ruleStr = null;
                texSign = signList.get(i);
                ruleStr = this.ruleToTeX(texSign.sign.getDerivationHistory().getRule().name(), texSign.identation, texSign.sign.getWords().size());
                bw.write(ruleStr);
                for (int j = 0; j < texSign.identation; ++j) {
                    bw.write("&");
                }
                bw.write(" \\mc{" + texSign.sign.getWords().size() + "}{\\cf{" + texSign.sign.getCategory().toTeX() + "}} \\\\\n");
            }
            bw.write("}\n\n\\vspace{5mm}\n\n");
            bw.close();
        }
        catch (Exception e) {
            System.out.println("Error while saving to TeX: " + e.toString());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private List<TeXSign> sortList(List<TeXSign> signList) {
        for (int i = 0; i < signList.size(); ++i) {
            for (int j = i; j < signList.size(); ++j) {
                TeXSign texSign1 = signList.get(i);
                TeXSign texSign2 = signList.get(j);
                if (texSign1.height > texSign2.height) {
                    signList.set(i, texSign2);
                    signList.set(j, texSign1);
                }
                if (texSign1.height != texSign2.height || texSign1.identation <= texSign2.identation) continue;
                signList.set(i, texSign2);
                signList.set(j, texSign1);
            }
        }
        return signList;
    }

    public static void runCommand(String cmd) {
        Visualizer.runCommand(cmd, true);
    }

    public static void runCommand(String cmd, boolean wait) {
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while (br.readLine() != null) {
            }
            if (wait) {
                try {
                    proc.waitFor();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            proc.getInputStream().close();
            proc.getOutputStream().close();
            proc.getErrorStream().close();
        }
        catch (IOException e) {
            System.out.println("Unable to run command: " + cmd);
        }
    }

    private class TeXSign {
        Sign sign = null;
        int identation = 0;
        int height = 0;

        private TeXSign() {
        }
    }

    public class auxFileNameFilter
    implements FilenameFilter {
        public String fn = null;

        public auxFileNameFilter(String s) {
            this.fn = s;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(this.fn) && !name.toUpperCase().endsWith(".TEX") && !name.toUpperCase().endsWith(".DVI");
        }
    }

    public class myFileNameFilter
    implements FilenameFilter {
        public String fn = null;

        public myFileNameFilter(String s) {
            this.fn = s;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(this.fn);
        }
    }

    class myFilter
    implements FileFilter {
        String baseFileName = null;

        public myFilter(String s) {
            this.baseFileName = s.toUpperCase();
        }

        @Override
        public boolean accept(File f) {
            System.out.println("checking: " + f.getName());
            return f.getName().toUpperCase().startsWith(this.baseFileName);
        }
    }
}

