/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.alignment;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import opennlp.ccg.alignment.Alignments;
import opennlp.ccg.alignment.IndexBase;
import opennlp.ccg.alignment.Phrase;
import opennlp.ccg.alignment.PhraseReader;

public class IdentifiedPhraseReader
extends PhraseReader {
    static final String TAG_START = "<";
    static final String TAG_END = ">";
    final String phraseTag;
    final String phraseIdentifierAttribute;
    private String lastId = null;

    public IdentifiedPhraseReader(Reader in) {
        this(in, Alignments.DEFAULT_PHRASE_NUMBER_BASE);
    }

    public IdentifiedPhraseReader(Reader in, IndexBase numberBase) {
        this(in, numberBase, "s", "snum");
    }

    public IdentifiedPhraseReader(Reader in, IndexBase numberBase, String phraseTag, String phraseIdentifierAttribute) {
        super(in, numberBase);
        if (phraseIdentifierAttribute == null) {
            throw new IllegalArgumentException("phraseIdentifierAttribute is null");
        }
        if (phraseTag == null) {
            throw new IllegalArgumentException("phraseTag is null");
        }
        this.phraseIdentifierAttribute = phraseIdentifierAttribute;
        this.phraseTag = phraseTag;
    }

    public String getLastId() {
        return this.lastId;
    }

    public String getPhraseTag() {
        return this.phraseTag;
    }

    public String getPhraseIdentifierAttribute() {
        return this.phraseIdentifierAttribute;
    }

    @Override
    public Phrase readPhrase() throws IOException {
        String t;
        String ln = this.readLine();
        if (ln == null) {
            return null;
        }
        String[] chunks = Alignments.DEFAULT_WORD_DELIMITER.split(ln);
        String c = chunks[0];
        if (!c.trim().startsWith(TAG_START)) {
            throw new IOException("unable to parse: " + ln + "; expected <, but was " + c.trim());
        }
        int clen = c.length();
        int pos = clen > 1 ? 1 : 2;
        String string = t = pos == 1 ? c.substring(1).trim() : chunks[1];
        if (!t.equals(this.phraseTag)) {
            throw new IOException("expected sequence tag " + this.phraseTag + ", but was " + t);
        }
        boolean foundIndex = false;
        int start2 = -1;
        for (int i = pos; i < chunks.length; ++i) {
            String[] subchunks;
            if (!foundIndex && (subchunks = chunks[i].trim().split("=")).length > 1 && subchunks[0].equals(this.phraseIdentifierAttribute)) {
                char[] idVal = subchunks[1].toCharArray();
                int idStart = 0;
                int idEnd = idVal.length - 1;
                boolean foundStart = false;
                for (int j = 0; j < idVal.length; ++j) {
                    if (idVal[j] != '\'' && idVal[j] != '\"') continue;
                    if (foundStart) {
                        idEnd = j;
                        break;
                    }
                    foundStart = true;
                    idStart = j + 1;
                }
                this.lastId = new String(idVal).substring(idStart, idEnd);
                foundIndex = true;
            }
            if (!chunks[i].contains(TAG_END)) continue;
            start2 = i;
            break;
        }
        if (!foundIndex) {
            throw new IOException("no ID found on line " + this.getLineNumber());
        }
        ArrayList<String> l = new ArrayList<String>(chunks.length);
        for (int j = start2; j < chunks.length; ++j) {
            int ts;
            int te;
            String cj = chunks[j];
            if (j == start2 && (te = cj.indexOf(TAG_END)) != -1) {
                cj = cj.substring(te + 1);
            }
            if (j + 1 == chunks.length && (ts = cj.indexOf(TAG_START)) != -1) {
                cj = cj.substring(0, ts);
            }
            if (cj.length() <= 0) continue;
            l.add(cj);
        }
        return new Phrase(this.lastId, this.getPhraseNumber(), l);
    }
}

