/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.builders;

import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.grammar.RuleGroup;
import opennlp.ccg.grammar.Types;
import opennlp.ccg.lexicon.Lexicon;

public class GrammarBuilder {
    private Grammar grammar = new Grammar();

    public static GrammarBuilder builder() {
        return new GrammarBuilder();
    }

    private GrammarBuilder() {
    }

    public boolean isGlobalGrammarInit() {
        return Grammar.theGrammar != null;
    }

    public GrammarBuilder withTypes(Types types) {
        this.grammar.setTypes(types);
        types.setGrammar(this.grammar);
        return this;
    }

    public GrammarBuilder withLexicon(Lexicon lexicon) {
        this.grammar.setLexicon(lexicon);
        lexicon.setGrammar(this.grammar);
        return this;
    }

    public GrammarBuilder withRules(RuleGroup rules) {
        this.grammar.setRules(rules);
        rules.setGrammar(this.grammar);
        return this;
    }

    public Grammar build() {
        assert (this.grammar.lexicon != null);
        assert (this.grammar.rules != null);
        assert (this.grammar.types != null);
        return this.grammar;
    }
}

