/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.builders;

import java.util.ArrayList;
import java.util.List;
import opennlp.ccg.lexicon.Family;
import opennlp.ccg.lexicon.Lexicon;
import opennlp.ccg.lexicon.MacroItem;
import opennlp.ccg.lexicon.MorphItem;

public class LexiconBuilder {
    private Lexicon lexicon;
    private List<Family> familyList = new ArrayList<Family>();
    private List<MorphItem> morphList = new ArrayList<MorphItem>();
    private List<MacroItem> macroList = new ArrayList<MacroItem>();

    public static LexiconBuilder builder() {
        return new LexiconBuilder();
    }

    private LexiconBuilder() {
        this.lexicon = new Lexicon();
    }

    public LexiconBuilder addFamily(Family family) {
        this.familyList.add(family);
        return this;
    }

    public LexiconBuilder addMorph(MorphItem item) {
        this.morphList.add(item);
        return this;
    }

    public LexiconBuilder addMacro(MacroItem item) {
        this.macroList.add(item);
        return this;
    }

    public Lexicon ref() {
        return this.lexicon;
    }

    public Lexicon build() {
        this.lexicon.init(this.familyList, this.morphList, this.macroList);
        return this.lexicon;
    }
}

