/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.grammar;

import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import opennlp.ccg.grammar.AbstractRule;
import opennlp.ccg.grammar.BackwardApplication;
import opennlp.ccg.grammar.BackwardComposition;
import opennlp.ccg.grammar.BackwardSubstitution;
import opennlp.ccg.grammar.BackwardTypeRaising;
import opennlp.ccg.grammar.ForwardApplication;
import opennlp.ccg.grammar.ForwardComposition;
import opennlp.ccg.grammar.ForwardSubstitution;
import opennlp.ccg.grammar.ForwardTypeRaising;
import opennlp.ccg.grammar.GlueRule;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.grammar.Rule;
import opennlp.ccg.grammar.TypeChangingRule;
import opennlp.ccg.grammar.WithGrammar;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.synsem.CatReader;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.util.GroupMap;
import opennlp.ccg.util.XmlScanner;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class RuleGroup
implements Serializable,
WithGrammar {
    private static final long serialVersionUID = -6240266013357142289L;
    public transient Grammar grammar;
    private List<Rule> unaryRules = new ArrayList<Rule>();
    private List<Rule> binaryRules = new ArrayList<Rule>();
    private GroupMap<String, TypeChangingRule> predsToRules = new GroupMap();
    private GroupMap<String, TypeChangingRule> relsToRules = new GroupMap();
    private BackwardApplication bapp = new BackwardApplication();
    private GlueRule glueRule = new GlueRule();
    private transient Set<SupercatRuleCombo> supercatRuleCombos = null;
    private transient SupercatComboSet supercatCombosSeen = null;
    private transient SupercatRuleCombo combo = new SupercatRuleCombo("dummy", "dummy");
    private boolean dynamicCombos = false;

    public RuleGroup() {
        this.bapp.setRuleGroup(this);
    }

    public RuleGroup(Grammar grammar) {
        this.grammar = grammar;
        this.bapp.setRuleGroup(this);
    }

    public RuleGroup(URL url, Grammar grammar) throws IOException {
        this.grammar = grammar;
        this.bapp.setRuleGroup(this);
        XmlScanner ruleScanner = new XmlScanner(){

            @Override
            public void handleElement(Element ruleEl) {
                String active = ruleEl.getAttributeValue("active");
                if (active == null || active.equals("true")) {
                    try {
                        RuleGroup.this.addRule(RuleGroup.this.readRule(ruleEl));
                    }
                    catch (RuntimeException exc) {
                        System.err.println("Skipping rule: " + ruleEl.getAttributeValue("name"));
                        System.err.println(exc.toString());
                    }
                }
            }
        };
        ruleScanner.parse(url);
    }

    @Override
    public void setGrammar(Grammar grammar) {
        this.grammar = grammar;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.grammar = Grammar.theGrammar;
        this.borrowSupercatRuleCombos(this.grammar.rules);
    }

    private Rule readRule(Element ruleEl) {
        Rule r;
        String type = ruleEl.getName();
        if (type.equals("application")) {
            String dir = ruleEl.getAttributeValue("dir");
            r = dir.equals("forward") ? new ForwardApplication() : new BackwardApplication();
        } else if (type.equals("composition")) {
            String dir = ruleEl.getAttributeValue("dir");
            String harmonic = ruleEl.getAttributeValue("harmonic");
            boolean isHarmonic = new Boolean(harmonic);
            r = dir.equals("forward") ? new ForwardComposition(isHarmonic) : new BackwardComposition(isHarmonic);
        } else if (type.equals("substitution")) {
            String dir = ruleEl.getAttributeValue("dir");
            String harmonic = ruleEl.getAttributeValue("harmonic");
            boolean isHarmonic = new Boolean(harmonic);
            r = dir.equals("forward") ? new ForwardSubstitution(isHarmonic) : new BackwardSubstitution(isHarmonic);
        } else if (type.equals("typeraising")) {
            String dir = ruleEl.getAttributeValue("dir");
            String useDollar = ruleEl.getAttributeValue("useDollar");
            boolean addDollar = new Boolean(useDollar);
            Category arg = null;
            Element argElt = ruleEl.getChild("arg");
            if (argElt != null) {
                arg = CatReader.getCat((Element)argElt.getChildren().get(0));
            }
            Category result = null;
            Element resultElt = ruleEl.getChild("result");
            if (resultElt != null) {
                result = CatReader.getCat((Element)resultElt.getChildren().get(0));
            }
            r = dir.equals("forward") ? new ForwardTypeRaising(addDollar, arg, result) : new BackwardTypeRaising(addDollar, arg, result);
        } else if (type.equals("typechanging")) {
            r = this.readTypeChangingRule(ruleEl);
        } else {
            throw new RuntimeException("Invalid element in rules: " + type);
        }
        return r;
    }

    private Rule readTypeChangingRule(Element ruleEl) {
        String rname = ruleEl.getAttributeValue("name");
        Element argCatElt = (Element)ruleEl.getChild("arg").getChildren().get(0);
        Category arg = CatReader.getCat(argCatElt);
        Element resultCatElt = (Element)ruleEl.getChild("result").getChildren().get(0);
        Element lfElt = resultCatElt.getChild("lf");
        Category result = CatReader.getCat(resultCatElt);
        LF firstEP = null;
        if (lfElt != null) {
            firstEP = HyloHelper.firstEP(HyloHelper.getLF(lfElt));
        }
        this.grammar.lexicon.propagateTypes(result, arg);
        this.grammar.lexicon.propagateDistributiveAttrs(result, arg);
        this.grammar.lexicon.expandInheritsFrom(result, arg);
        return new TypeChangingRule(arg, result, rname, firstEP);
    }

    public void toXml(String filename) throws IOException {
        XMLOutputter xout = new XMLOutputter();
        xout.setFormat(Format.getPrettyFormat());
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<rules name=\"" + this.grammar.getName() + "\">");
        for (Rule r : this.binaryRules) {
            xout.output(r.toXml(), (Writer)out);
            out.println();
        }
        for (Rule r : this.unaryRules) {
            xout.output(r.toXml(), (Writer)out);
            out.println();
        }
        out.println("</rules>");
        out.flush();
        out.close();
    }

    public void setDynamicCombos(boolean dynamic) {
        this.dynamicCombos = dynamic;
        if (!this.dynamicCombos) {
            this.supercatCombosSeen = null;
        } else if (this.dynamicCombos) {
            if (this.supercatCombosSeen == null) {
                this.supercatCombosSeen = new SupercatComboSet();
            }
            if (this.supercatRuleCombos == null) {
                this.supercatRuleCombos = new HashSet<SupercatRuleCombo>();
            }
        }
    }

    public boolean getDynamicCombos() {
        return this.dynamicCombos;
    }

    public void loadSupercatRuleCombos(URL url) throws IOException {
        String line;
        this.supercatRuleCombos = new HashSet<SupercatRuleCombo>();
        File combosFile = new File(url.getFile());
        if (!combosFile.exists()) {
            return;
        }
        System.out.println("Loading supercat combos from " + url.getFile());
        BufferedReader in = new BufferedReader(new FileReader(combosFile));
        while ((line = in.readLine()) != null) {
            String[] tokens = line.split("\\s");
            if (tokens.length < 2) {
                System.err.println("Warning: skipping supercat-rule combo with fewer than two tokens: " + line);
                continue;
            }
            if (tokens.length == 2) {
                this.supercatRuleCombos.add(new SupercatRuleCombo(tokens[0], tokens[1]));
                continue;
            }
            if (tokens.length > 3) {
                System.err.println("Warning: ignoring extra tokens (beyond 3rd) in supercat-rule combo: " + line);
            }
            this.supercatRuleCombos.add(new SupercatRuleCombo(tokens[0], tokens[1], tokens[2]));
        }
        in.close();
    }

    public void borrowSupercatRuleCombos(RuleGroup ruleGroup) {
        this.supercatRuleCombos = ruleGroup.supercatRuleCombos;
        this.supercatCombosSeen = ruleGroup.supercatCombosSeen;
    }

    public void addRule(Rule r) {
        r.setRuleGroup(this);
        if (r instanceof TypeChangingRule) {
            this.unaryRules.add(r);
            this.index((TypeChangingRule)r);
        } else if (r.arity() == 1) {
            this.unaryRules.add(r);
        } else if (r.arity() == 2) {
            this.binaryRules.add(r);
        } else {
            throw new RuntimeException("Can't determine arity of rule: " + r);
        }
    }

    private void index(TypeChangingRule rule) {
        LF firstEP = rule.getFirstEP();
        if (firstEP == null) {
            return;
        }
        String pred = HyloHelper.getLexPred(firstEP);
        if (pred != null) {
            this.predsToRules.put(pred, rule);
            return;
        }
        String rel = HyloHelper.getRel(firstEP);
        if (rel != null) {
            this.relsToRules.put(rel, rule);
        }
    }

    public List<Rule> getUnaryRules() {
        return this.unaryRules;
    }

    public List<Rule> getBinaryRules() {
        return this.binaryRules;
    }

    public TypeChangingRule getTypeChangingRule(String name) {
        for (Rule rule : this.unaryRules) {
            TypeChangingRule tcr;
            if (!(rule instanceof TypeChangingRule) || !(tcr = (TypeChangingRule)rule).name().equals(name)) continue;
            return tcr;
        }
        return null;
    }

    public Collection<TypeChangingRule> getRulesForPred(String pred) {
        return this.predsToRules.get(pred);
    }

    public Collection<TypeChangingRule> getRulesForRel(String rel) {
        return this.relsToRules.get(rel);
    }

    public List<Sign> applyUnaryRules(Sign input) {
        Sign[] inputs = new Sign[]{input};
        ArrayList<Sign> results = new ArrayList<Sign>(2);
        String supertag = input.getCategory().getSupertag();
        boolean dynamicCombosUpdate = false;
        boolean skip = false;
        if (this.dynamicCombos) {
            this.combo.setCombo(supertag, null);
            SupercatRuleCombo rep = this.supercatCombosSeen.get(this.combo);
            if (rep == null) {
                dynamicCombosUpdate = true;
            } else if (rep.rule == null) {
                skip = true;
            }
        }
        if (skip) {
            return results;
        }
        for (Rule r : this.unaryRules) {
            if (!dynamicCombosUpdate && this.supercatRuleCombos != null) {
                this.combo.setCombo(supertag, r.name());
                if (!this.supercatRuleCombos.contains(this.combo)) continue;
            }
            if (dynamicCombosUpdate) {
                int prevsize = results.size();
                ((AbstractRule)r).applyRule(inputs, results);
                if (results.size() <= prevsize) continue;
                SupercatRuleCombo newCombo = null;
                this.combo.setCombo(supertag, r.name());
                if (!this.supercatRuleCombos.contains(this.combo)) {
                    newCombo = new SupercatRuleCombo(supertag, r.name());
                    this.supercatRuleCombos.add(newCombo);
                }
                if (this.supercatCombosSeen.contains(this.combo)) continue;
                if (newCombo == null) {
                    newCombo = new SupercatRuleCombo(supertag, r.name());
                }
                this.supercatCombosSeen.add(newCombo);
                continue;
            }
            ((AbstractRule)r).applyRule(inputs, results);
        }
        if (dynamicCombosUpdate) {
            this.combo.setCombo(supertag, null);
            if (!this.supercatCombosSeen.contains(this.combo)) {
                SupercatRuleCombo newCombo = new SupercatRuleCombo(supertag, null);
                this.supercatCombosSeen.add(newCombo);
            }
        }
        return results;
    }

    public List<Sign> applyBinaryRules(Sign input1, Sign input2) {
        Sign[] inputs = new Sign[]{input1, input2};
        ArrayList<Sign> results = new ArrayList<Sign>(2);
        String supertag1 = input1.getCategory().getSupertag();
        String supertag2 = input2.getCategory().getSupertag();
        boolean dynamicCombosUpdate = false;
        boolean skip = false;
        if (this.dynamicCombos) {
            this.combo.setCombo(supertag1, supertag2, null);
            SupercatRuleCombo rep = this.supercatCombosSeen.get(this.combo);
            if (rep == null) {
                dynamicCombosUpdate = true;
            } else if (rep.rule == null) {
                skip = true;
            }
        }
        if (skip) {
            return results;
        }
        for (Rule r : this.binaryRules) {
            if (!dynamicCombosUpdate && this.supercatRuleCombos != null) {
                this.combo.setCombo(supertag1, supertag2, r.name());
                if (!this.supercatRuleCombos.contains(this.combo)) continue;
            }
            if (dynamicCombosUpdate) {
                int prevsize = results.size();
                ((AbstractRule)r).applyRule(inputs, results);
                if (results.size() <= prevsize) continue;
                SupercatRuleCombo newCombo = null;
                this.combo.setCombo(supertag1, supertag2, r.name());
                if (!this.supercatRuleCombos.contains(this.combo)) {
                    newCombo = new SupercatRuleCombo(supertag1, supertag2, r.name());
                    this.supercatRuleCombos.add(newCombo);
                }
                if (this.supercatCombosSeen.contains(this.combo)) continue;
                if (newCombo == null) {
                    newCombo = new SupercatRuleCombo(supertag1, supertag2, r.name());
                }
                this.supercatCombosSeen.add(newCombo);
                continue;
            }
            ((AbstractRule)r).applyRule(inputs, results);
        }
        if (dynamicCombosUpdate) {
            this.combo.setCombo(supertag1, supertag2, null);
            if (!this.supercatCombosSeen.contains(this.combo)) {
                SupercatRuleCombo newCombo = new SupercatRuleCombo(supertag1, supertag2, null);
                this.supercatCombosSeen.add(newCombo);
            }
        }
        return results;
    }

    public List<Sign> applyGlueRule(Sign input1, Sign input2) {
        Sign[] inputs = new Sign[]{input1, input2};
        ArrayList<Sign> results = new ArrayList<Sign>(1);
        this.glueRule.applyRule(inputs, results);
        return results;
    }

    public void applyCoart(Sign lexSign, Sign coartSign, List<Sign> results) {
        Category[] cats = new Category[]{lexSign.getCategory(), coartSign.getCategory()};
        try {
            List<Category> resultCats = this.bapp.applyRule(cats);
            if (resultCats.isEmpty()) {
                return;
            }
            for (Category catResult : resultCats) {
                this.bapp.distributeTargetFeatures(catResult);
                Sign sign = Sign.createCoartSign(catResult, lexSign, coartSign);
                results.add(sign);
            }
        }
        catch (UnifyFailure unifyFailure) {
            // empty catch block
        }
    }

    private static class SupercatComboSet
    extends THashSet {
        private static final long serialVersionUID = 1L;

        SupercatComboSet() {
            super(new TObjectHashingStrategy(){
                private static final long serialVersionUID = 1L;

                public int computeHashCode(Object o) {
                    return o instanceof SupercatRuleCombo ? ((SupercatRuleCombo)o).supercatHashCode() : 0;
                }

                public boolean equals(Object o1, Object o2) {
                    return o1 instanceof SupercatRuleCombo ? ((SupercatRuleCombo)o1).supercatEquals(o2) : false;
                }
            });
        }

        SupercatRuleCombo get(SupercatRuleCombo combo) {
            int index = this.index(combo);
            if (index < 0) {
                return null;
            }
            return (SupercatRuleCombo)this._set[index];
        }
    }

    private class SupercatRuleCombo {
        private String supercat;
        private String supercat2;
        private String rule;

        public SupercatRuleCombo(String supercat, String rule) {
            this.setCombo(supercat.intern(), rule != null ? rule.intern() : null);
        }

        public SupercatRuleCombo(String supercat, String supercat2, String rule) {
            this.setCombo(supercat.intern(), supercat2.intern(), rule != null ? rule.intern() : null);
        }

        public void setCombo(String supercat, String rule) {
            this.supercat = supercat;
            this.supercat2 = null;
            this.rule = rule;
        }

        public void setCombo(String supercat, String supercat2, String rule) {
            this.supercat = supercat;
            this.supercat2 = supercat2;
            this.rule = rule;
        }

        public int hashCode() {
            return 31 * System.identityHashCode(this.supercat) + 17 * System.identityHashCode(this.rule) + System.identityHashCode(this.supercat2);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SupercatRuleCombo)) {
                return false;
            }
            SupercatRuleCombo combo = (SupercatRuleCombo)obj;
            return this.supercat == combo.supercat && this.supercat2 == combo.supercat2 && this.rule == combo.rule;
        }

        public int supercatHashCode() {
            return 31 * System.identityHashCode(this.supercat) + System.identityHashCode(this.supercat2);
        }

        public boolean supercatEquals(Object obj) {
            if (!(obj instanceof SupercatRuleCombo)) {
                return false;
            }
            SupercatRuleCombo combo = (SupercatRuleCombo)obj;
            return this.supercat == combo.supercat && this.supercat2 == combo.supercat2;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.supercat);
            if (this.supercat2 != null) {
                sb.append(' ').append(this.supercat2);
            }
            sb.append(' ').append(this.rule);
            return sb.toString();
        }
    }
}

