/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.grammar;

import gnu.trove.TObjectIntHashMap;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.grammar.WithGrammar;
import opennlp.ccg.unify.SimpleType;
import opennlp.ccg.util.GroupMap;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Types
implements WithGrammar {
    public Grammar grammar;
    private final HashMap<String, SimpleType> nameToType = new HashMap();
    private final ArrayList<SimpleType> indexToType = new ArrayList();
    private int maxTypeIndex = 0;
    public static final String TOP_TYPE = "top";
    public static final String BOT_TYPE = "bottom";

    public Types() {
    }

    public Types(Grammar grammar) {
        this.getSimpleType(TOP_TYPE);
        this.grammar = grammar;
    }

    public Types(URL url, Grammar grammar) throws IOException {
        Document doc;
        this.grammar = grammar;
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build(url);
        }
        catch (JDOMException exc) {
            this.getSimpleType(TOP_TYPE);
            throw (IOException)new IOException().initCause(exc);
        }
        List entries = doc.getRootElement().getChildren();
        this.readTypes(entries);
    }

    @Override
    public void setGrammar(Grammar grammar) {
        this.grammar = grammar;
    }

    public SimpleType getSimpleType(String typeName) {
        SimpleType type = this.nameToType.get(typeName);
        if (type == null) {
            BitSet bs = new BitSet();
            bs.set(this.maxTypeIndex);
            SimpleType newtype = new SimpleType(this.maxTypeIndex, typeName, bs, this);
            this.nameToType.put(typeName, newtype);
            this.indexToType.add(newtype);
            this.nameToType.get(TOP_TYPE).getBitSet().set(this.maxTypeIndex++);
            return newtype;
        }
        return type;
    }

    public boolean containsSimpleType(String typeName) {
        return this.nameToType.containsKey(typeName);
    }

    public ArrayList<SimpleType> getIndexMap() {
        return this.indexToType;
    }

    public void readTypes(List<Element> _types) {
        GroupMap<String, String> hierarchy = new GroupMap<String, String>();
        GroupMap<String, String> parents = new GroupMap<String, String>();
        TObjectIntHashMap depthMap = new TObjectIntHashMap();
        for (int i = 0; i < _types.size(); ++i) {
            Element typeEl = _types.get(i);
            String typeName = typeEl.getAttributeValue("name");
            String _parents = typeEl.getAttributeValue("parents");
            hierarchy.put(typeName, BOT_TYPE);
            if (_parents == null) {
                hierarchy.put(TOP_TYPE, typeName);
                parents.put(typeName, TOP_TYPE);
                continue;
            }
            String[] parentsArray = _parents.split("\\s+");
            for (int j = 0; j < parentsArray.length; ++j) {
                hierarchy.put(parentsArray[j], typeName);
                parents.put(typeName, parentsArray[j]);
            }
        }
        for (String type : parents.keySet()) {
            int depth = Types.computeDepth(type, parents, type);
            depthMap.put((Object)type, depth);
        }
        for (String type : hierarchy.keySet()) {
            hierarchy.putAll(type, this.findAllSubtypes(hierarchy, type));
        }
        this.createSimpleTypes(hierarchy, depthMap);
    }

    private static int computeDepth(String type, GroupMap<String, String> parents, String startType) {
        if (type.equals(TOP_TYPE)) {
            return 0;
        }
        int maxParentDepth = 0;
        Set<String> parentSet = parents.get(type);
        if (parentSet != null) {
            for (String parent : parentSet) {
                if (parent.equals(startType)) {
                    throw new RuntimeException("Error, type hierarchy contains cycle from/to: " + startType);
                }
                int parentDepth = Types.computeDepth(parent, parents, startType);
                maxParentDepth = Math.max(maxParentDepth, parentDepth);
            }
        }
        return maxParentDepth + 1;
    }

    private Collection<String> findAllSubtypes(GroupMap<String, String> hierarchy, String key) {
        ArrayList<String> subs = new ArrayList<String>();
        if (hierarchy.get(key) != null) {
            Stack<String> look = new Stack<String>();
            for (String type : hierarchy.get(key)) {
                look.push(type);
            }
            while (!look.empty()) {
                String new_sub = (String)look.pop();
                subs.add(new_sub);
                if (hierarchy.get(new_sub) == null) continue;
                for (String type : hierarchy.get(new_sub)) {
                    look.push(type);
                }
            }
        }
        return subs;
    }

    private void createSimpleTypes(GroupMap<String, String> hierarchy, TObjectIntHashMap depthMap) {
        int i;
        int maxDepth = 0;
        int[] depths = depthMap.getValues();
        for (int i2 = 0; i2 < depths.length; ++i2) {
            maxDepth = Math.max(maxDepth, depths[i2]);
        }
        ArrayList<String> typesVisited = new ArrayList<String>();
        typesVisited.add(TOP_TYPE);
        Object[] types = depthMap.keys();
        ArrayList<String> typesAtSameDepth = new ArrayList<String>();
        for (i = 1; i <= maxDepth; ++i) {
            typesAtSameDepth.clear();
            for (int j = 0; j < types.length; ++j) {
                if (depthMap.get(types[j]) != i) continue;
                typesAtSameDepth.add((String)types[j]);
            }
            Collections.sort(typesAtSameDepth);
            typesVisited.addAll(typesAtSameDepth);
        }
        for (i = 0; i < typesVisited.size(); ++i) {
            String typeName = (String)typesVisited.get(i);
            BitSet bitset = new BitSet();
            bitset.set(i);
            if (hierarchy.get(typeName) != null) {
                for (String type : hierarchy.get(typeName)) {
                    int indexToSet = typesVisited.indexOf(type);
                    if (indexToSet == -1) continue;
                    bitset.set(indexToSet);
                }
            }
            SimpleType st = new SimpleType(i, typeName, bitset, this);
            this.nameToType.put(typeName, st);
            this.indexToType.add(st);
        }
        this.maxTypeIndex = typesVisited.size();
    }

    public void printTypes() {
        System.out.println("types:");
        for (int i = 0; i < this.indexToType.size(); ++i) {
            SimpleType st = this.indexToType.get(i);
            System.out.println(i + ": " + st.getName() + " subtypes: " + st.getBitSet());
        }
        System.out.println();
    }

    public void debugSerialization() throws IOException, ClassNotFoundException {
        SimpleType st = this.indexToType.get(1);
        String filename = "tmp.ser";
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filename));
        System.out.println("Writing st: " + st.getIndex() + ": " + st + " " + st.getBitSet());
        out.writeObject(st);
        out.close();
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(filename));
        System.out.print("Reading st2: ");
        SimpleType st2 = (SimpleType)in.readObject();
        System.out.println(st2.getIndex() + ": " + st2 + " " + st2.getBitSet());
        in.close();
        System.out.println("st == st2?: " + (st == st2));
    }
}

