/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.grammardoc;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import opennlp.ccg.grammardoc.Documenter;
import opennlp.ccg.grammardoc.DocumenterContext;
import opennlp.ccg.grammardoc.DocumenterException;
import opennlp.ccg.grammardoc.DocumenterFactory;
import opennlp.ccg.grammardoc.DocumenterNotFoundException;
import opennlp.ccg.grammardoc.DocumenterSourceException;
import opennlp.ccg.grammardoc.GrammarDocException;
import opennlp.ccg.grammardoc.SourceGrammar;
import opennlp.ccg.grammardoc.SourceGrammarFile;
import opennlp.ccg.grammardoc.SourceGrammarFileType;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GrammarDoc
extends Task
implements DocumenterContext {
    private File srcDir;
    private File destDir;

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            this.srcDir = new File(System.getProperty("user.dir"));
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("Source directory does not exist");
        }
        if (this.destDir == null) {
            this.destDir = new File(this.srcDir, "docs");
        }
        if (!this.destDir.exists()) {
            this.log("Creating directory " + this.destDir);
            this.destDir.mkdirs();
        }
        try {
            Documenter documenter = DocumenterFactory.newInstance().newDocumenter();
            this.log("Using " + documenter.getName());
            this.log("Documenting " + this.srcDir.getAbsolutePath());
            this.log("Generating documentation to " + this.destDir);
            documenter.setDocumenterContext(this);
            documenter.document(this.loadSourceGrammar());
            this.log("Done");
        }
        catch (DocumenterNotFoundException dnfe) {
            throw new BuildException("documenter not found: " + dnfe.getMessage(), this.getLocation());
        }
        catch (DocumenterSourceException dse) {
            throw new BuildException("problem in source file " + dse.getSourceGrammarFile() + ": " + dse.getMessage(), this.getLocation());
        }
        catch (DocumenterException de) {
            throw new BuildException("problem documenting: " + de.getMessage(), (Throwable)de);
        }
        catch (GrammarDocException gde) {
            throw new BuildException(gde.getMessage(), this.getLocation());
        }
    }

    SourceGrammar loadSourceGrammar() throws GrammarDocException {
        SourceGrammar sourceGrammar = new SourceGrammar(this.srcDir);
        try {
            SourceGrammarFile grammar = this.loadGrammarFile(SourceGrammarFileType.GRAMMAR, new File(this.srcDir, SourceGrammarFileType.GRAMMAR.fileName + ".xml"));
            sourceGrammar.addSourceGrammarFile(SourceGrammarFileType.GRAMMAR, grammar);
            File gd = grammar.sourceFile;
            for (SourceGrammarFileType fileType : SourceGrammarFileType.values()) {
                if (fileType.equals((Object)SourceGrammarFileType.GRAMMAR)) continue;
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = db.parse(gd);
                NodeList fileEls = doc.getElementsByTagName(fileType.name().toLowerCase());
                if (fileEls.getLength() == 0) {
                    if (!fileType.isRequired()) continue;
                    throw new GrammarDocException("file type required but missing: " + (Object)((Object)fileType));
                }
                sourceGrammar.addSourceGrammarFile(fileType, this.loadGrammarFile(fileType, new File(this.srcDir, fileType.fileName + ".xml")));
            }
        }
        catch (ParserConfigurationException pce) {
            throw new GrammarDocException("parser configuration problem: " + pce.getMessage(), pce);
        }
        catch (SAXException se) {
            throw new GrammarDocException("problem parsing source files: " + se.getMessage(), se);
        }
        catch (IOException io) {
            throw new GrammarDocException("io problem with source files: " + io.getMessage(), io);
        }
        return sourceGrammar;
    }

    SourceGrammarFile loadGrammarFile(SourceGrammarFileType fileType, File file) throws GrammarDocException {
        if (!file.exists()) {
            throw new GrammarDocException("file " + file.getName() + " does not exist in " + this.srcDir);
        }
        if (file.isDirectory()) {
            throw new GrammarDocException(file.getName() + " refers to a directory in " + this.srcDir);
        }
        this.log("Loading " + file.getName());
        try {
            return new SourceGrammarFile(fileType, file);
        }
        catch (Exception e) {
            throw new GrammarDocException("problem parsing " + file + ": " + e.getMessage(), e);
        }
    }

    @Override
    public File getDestinationDirectory() {
        return this.getDestDir();
    }

    public File getDestDir() {
        return this.destDir;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir.getAbsoluteFile();
    }

    public File getSrcDir() {
        return this.srcDir;
    }

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir.getAbsoluteFile();
    }

    public static void main(String[] args) {
        List<String> arguments = Arrays.asList(args);
        PrintStream out = System.out;
        CommandGrammarDoc gd = new CommandGrammarDoc(out);
        if (arguments.contains("-h") || arguments.contains("--help")) {
            out.println("usage: ccg-grammardoc [-s|--source sourceDir] [-d|--dest destDir]");
        } else {
            Iterator<String> i = arguments.iterator();
            try {
                while (i.hasNext()) {
                    String s = i.next();
                    if (s.equals("-s") || s.equals("--source")) {
                        if (gd.srcDir != null) {
                            throw new IllegalArgumentException("source directory already specified");
                        }
                        if (!i.hasNext()) {
                            throw new IllegalArgumentException("encountered flag " + s + ", but no directory specified");
                        }
                        gd.setSrcDir(new File(i.next()));
                        continue;
                    }
                    if (!s.equals("-d") && !s.equals("--dest")) continue;
                    if (gd.destDir != null) {
                        throw new IllegalArgumentException("destination directory already specified");
                    }
                    if (!i.hasNext()) {
                        throw new IllegalArgumentException("encountered flag " + s + ", but no directory specified");
                    }
                    gd.setDestDir(new File(i.next()));
                }
                gd.execute();
            }
            catch (Exception e) {
                gd.log("Error: " + e.getMessage());
            }
        }
    }

    static final class CommandGrammarDoc
    extends GrammarDoc {
        PrintStream out;
        static final String logPrefix = "[grammardoc] ";

        CommandGrammarDoc(PrintStream out) {
            this.out = out;
            this.setProject(new Project());
            this.setOwningTarget(new Target());
        }

        @Override
        public void log(String s) {
            this.out.print(logPrefix);
            this.out.println(s);
        }
    }
}

