/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.hylo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import opennlp.ccg.hylo.Diamond;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.hylo.Op;
import opennlp.ccg.hylo.SatOp;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.util.GroupMap;

public class Compacter {
    static LF compact(LF lf, Nominal root) {
        Nominal nom;
        SatOp pred;
        int i;
        Nominal nom2;
        Iterator<Object> it;
        List<SatOp> preds = HyloHelper.getPreds(lf);
        for (int i2 = 0; i2 < preds.size(); ++i2) {
            SatOp pred2 = preds.get(i2);
            preds.set(i2, (SatOp)pred2.copy());
        }
        if (preds.size() == 1) {
            return preds.get(0);
        }
        HashMap<Nominal, Nominal> parents = new HashMap<Nominal, Nominal>();
        GroupMap<Nominal, Nominal> multipleParents = new GroupMap<Nominal, Nominal>();
        for (int i3 = 0; i3 < preds.size(); ++i3) {
            SatOp pred3 = preds.get(i3);
            Nominal nom1 = HyloHelper.getPrincipalNominal(pred3);
            Nominal nom22 = HyloHelper.getSecondaryNominal(pred3);
            if (nom22 == null || root != null && nom22.equals(root)) continue;
            if (multipleParents.containsKey(nom22)) {
                multipleParents.put(nom22, nom1);
                continue;
            }
            if (parents.containsKey(nom22)) {
                multipleParents.put(nom22, (Nominal)parents.get(nom22));
                multipleParents.put(nom22, nom1);
                parents.remove(nom22);
                continue;
            }
            parents.put(nom22, nom1);
        }
        int prevSize = -1;
        ArrayList<Nominal> history = new ArrayList<Nominal>();
        while (multipleParents.size() != prevSize) {
            prevSize = multipleParents.size();
            it = multipleParents.keySet().iterator();
            while (it.hasNext()) {
                nom2 = (Nominal)it.next();
                Set nomParents = multipleParents.get(nom2);
                Iterator it2 = nomParents.iterator();
                while (it2.hasNext()) {
                    Nominal parent = (Nominal)it2.next();
                    history.clear();
                    history.add(nom2);
                    while (parent != null && !history.contains(parent)) {
                        history.add(parent);
                        parent = (Nominal)parents.get(parent);
                    }
                    if (parent == null) continue;
                    it2.remove();
                }
                if (nomParents.size() != 1) continue;
                Nominal parent = (Nominal)nomParents.iterator().next();
                parents.put(nom2, parent);
                it.remove();
            }
        }
        it = parents.keySet().iterator();
        while (it.hasNext()) {
            nom2 = (Nominal)it.next();
            Nominal parent = (Nominal)parents.get(nom2);
            history.clear();
            history.add(nom2);
            while (parent != null && !history.contains(parent)) {
                history.add(parent);
                parent = (Nominal)parents.get(parent);
            }
            if (parent == null) continue;
            it.remove();
        }
        HyloHelper.sort(preds);
        ArrayList<SatOp> combinedPreds = new ArrayList<SatOp>(preds.size());
        ArrayList<SatOp> dupPreds = new ArrayList<SatOp>(preds.size());
        SatOp currentSatOp = preds.get(0);
        Nominal currentNominal = currentSatOp.getNominal();
        combinedPreds.add(currentSatOp);
        for (i = 1; i < preds.size(); ++i) {
            SatOp satOp = preds.get(i);
            if (satOp.equals(preds.get(i - 1))) {
                dupPreds.add(satOp);
                continue;
            }
            Nominal nominal = satOp.getNominal();
            if (!nominal.equals(currentNominal)) {
                currentSatOp = satOp;
                currentNominal = nominal;
                combinedPreds.add(currentSatOp);
                continue;
            }
            Compacter.combine(currentSatOp, satOp);
        }
        for (i = 0; i < combinedPreds.size(); ++i) {
            SatOp satOp1 = (SatOp)combinedPreds.get(i);
            Nominal nom1 = satOp1.getNominal();
            if (!parents.containsValue(nom1)) continue;
            for (int j = 0; j < combinedPreds.size(); ++j) {
                SatOp satOp2 = (SatOp)combinedPreds.get(j);
                Nominal nom23 = satOp2.getNominal();
                if (nom1.equals(nom23) || !parents.containsKey(nom23) || !nom1.equals(parents.get(nom23))) continue;
                Compacter.subst(satOp1, satOp2, nom23, null);
            }
        }
        ArrayList<Nominal> roots = new ArrayList<Nominal>();
        ArrayList<SatOp> rootPreds = new ArrayList<SatOp>();
        ArrayList<SatOp> multipleParentPreds = new ArrayList<SatOp>();
        for (int i4 = 0; i4 < combinedPreds.size(); ++i4) {
            pred = (SatOp)combinedPreds.get(i4);
            nom = pred.getNominal();
            if (!parents.containsKey(nom) && !multipleParents.containsKey(nom)) {
                roots.add(nom);
                rootPreds.add(pred);
            }
            if (!multipleParents.containsKey(nom)) continue;
            multipleParentPreds.add(pred);
        }
        prevSize = -1;
        while (multipleParentPreds.size() != prevSize) {
            prevSize = multipleParentPreds.size();
            Iterator it2 = multipleParentPreds.iterator();
            while (it2.hasNext()) {
                pred = (SatOp)it2.next();
                nom = pred.getNominal();
                Set nomParents = multipleParents.get(nom);
                Nominal parentClosestToRoot = null;
                int closestDist = 0;
                int closestRootIndex = -1;
                for (Nominal parent : nomParents) {
                    int dist = 0;
                    Nominal topAncestor = parent;
                    while (parents.containsKey(topAncestor)) {
                        topAncestor = (Nominal)parents.get(topAncestor);
                        ++dist;
                    }
                    if (roots.contains(topAncestor)) {
                        if (parentClosestToRoot != null && dist >= closestDist) continue;
                        parentClosestToRoot = parent;
                        closestDist = dist;
                        closestRootIndex = roots.indexOf(topAncestor);
                        continue;
                    }
                    closestDist = -1;
                }
                if (closestDist == -1 || closestRootIndex == -1) continue;
                SatOp closestRootPred = (SatOp)rootPreds.get(closestRootIndex);
                Compacter.subst(closestRootPred, pred, nom, parentClosestToRoot);
                parents.put(nom, parentClosestToRoot);
                it2.remove();
            }
        }
        ArrayList<LF> retPreds = new ArrayList<LF>();
        retPreds.addAll(rootPreds);
        retPreds.addAll(multipleParentPreds);
        LF retval = retPreds.size() == 1 ? (LF)retPreds.get(0) : new Op("conj", retPreds);
        for (SatOp dup : dupPreds) {
            Nominal nom3 = dup.getNominal();
            Nominal dupParent = Compacter.findDupParent(retval, dup, nom3);
            Compacter.subst(retval, dup, nom3, dupParent);
        }
        return retval;
    }

    private static void combine(SatOp satOp1, SatOp satOp2) {
        LF arg1 = satOp1.getArg();
        LF arg2 = satOp2.getArg();
        if (arg1 instanceof Op && ((Op)arg1).getName().equals("conj")) {
            List<LF> args = ((Op)arg1).getArguments();
            args.add(arg2);
        } else {
            ArrayList<LF> args = new ArrayList<LF>(2);
            args.add(arg1);
            args.add(arg2);
            satOp1.setArg(new Op("conj", args));
        }
    }

    private static boolean subst(LF lf, SatOp satOp2, Nominal nom2, Nominal requiredParent) {
        return Compacter.subst(lf, null, satOp2, nom2, requiredParent);
    }

    private static boolean subst(LF lf, Nominal currentParent, SatOp satOp2, Nominal nom2, Nominal requiredParent) {
        if (lf instanceof SatOp) {
            SatOp satOp = (SatOp)lf;
            return Compacter.subst(satOp.getArg(), satOp.getNominal(), satOp2, nom2, requiredParent);
        }
        if (lf instanceof Diamond) {
            Diamond d = (Diamond)lf;
            LF arg = d.getArg();
            if (arg.equals(nom2) && (requiredParent == null || requiredParent.equals(currentParent))) {
                d.setArg(HyloHelper.append(arg, satOp2.getArg()));
                return true;
            }
            return Compacter.subst(arg, currentParent, satOp2, nom2, requiredParent);
        }
        if (lf instanceof Op) {
            Op op2 = (Op)lf;
            List<LF> args = op2.getArguments();
            for (int i = 0; i < args.size(); ++i) {
                LF arg = args.get(i);
                if (arg instanceof Nominal) {
                    if (arg.equals(nom2) && (requiredParent == null || requiredParent.equals(currentParent))) {
                        op2.appendArgs(satOp2.getArg());
                        return true;
                    }
                    currentParent = (Nominal)arg;
                    continue;
                }
                boolean madeSubst = Compacter.subst(arg, currentParent, satOp2, nom2, requiredParent);
                if (!madeSubst) continue;
                return true;
            }
        }
        return false;
    }

    private static Nominal findDupParent(LF lf, SatOp dup, Nominal dupNom) {
        return Compacter.findDupParent(lf, null, dup, dupNom);
    }

    private static Nominal findDupParent(LF lf, Nominal currentParent, SatOp dup, Nominal dupNom) {
        if (lf instanceof SatOp) {
            SatOp satOp = (SatOp)lf;
            return Compacter.findDupParent(satOp.getArg(), satOp.getNominal(), dup, dupNom);
        }
        if (lf instanceof Diamond) {
            Diamond d = (Diamond)lf;
            LF arg = d.getArg();
            if (arg.equals(dupNom)) {
                return currentParent;
            }
            return Compacter.findDupParent(arg, currentParent, dup, dupNom);
        }
        if (lf instanceof Op) {
            Op op2 = (Op)lf;
            List<LF> args = op2.getArguments();
            for (int i = 0; i < args.size(); ++i) {
                LF arg = args.get(i);
                if (arg instanceof Nominal) {
                    if (arg.equals(dupNom) && !args.contains(dup.getArg())) {
                        return currentParent;
                    }
                    currentParent = (Nominal)arg;
                    continue;
                }
                Nominal retval = Compacter.findDupParent(arg, currentParent, dup, dupNom);
                if (retval == null) continue;
                return retval;
            }
        }
        return null;
    }
}

