/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.hylo;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import opennlp.ccg.hylo.LexDependency;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.perceptron.Alphabet;
import opennlp.ccg.perceptron.FeatureExtractor;
import opennlp.ccg.perceptron.FeatureMap;
import opennlp.ccg.perceptron.FeatureVector;
import opennlp.ccg.synsem.AtomCat;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.ComplexCat;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.synsem.TargetCat;
import opennlp.ccg.unify.FeatureStructure;
import opennlp.ccg.unify.SimpleType;
import opennlp.ccg.util.TrieMap;

public class EnglishAgreementExtractor
implements FeatureExtractor {
    protected Alphabet alphabet = null;
    protected FeatureMap currentMap = null;
    protected Sign headSign = null;
    protected Sign depSign = null;
    String sentId = null;
    int INSTANCENUM = 0;
    protected List<List<TrieMap.KeyExtractor<String>>> agrExtractors = new ArrayList<List<TrieMap.KeyExtractor<String>>>();
    protected List<List<TrieMap.KeyExtractor<String>>> agrConjExtractors = new ArrayList<List<TrieMap.KeyExtractor<String>>>();
    protected List<List<TrieMap.KeyExtractor<String>>> agrOfComplementExtractors = new ArrayList<List<TrieMap.KeyExtractor<String>>>();
    protected List<List<TrieMap.KeyExtractor<String>>> whExtractors = new ArrayList<List<TrieMap.KeyExtractor<String>>>();
    protected List<List<TrieMap.KeyExtractor<String>>> whConjExtractors = new ArrayList<List<TrieMap.KeyExtractor<String>>>();
    protected List<List<TrieMap.KeyExtractor<String>>> punctExtractor = new ArrayList<List<TrieMap.KeyExtractor<String>>>();

    public EnglishAgreementExtractor() {
        this.init();
    }

    public EnglishAgreementExtractor(String sentId) {
        this.sentId = sentId;
        this.INSTANCENUM = 0;
        this.init();
    }

    @Override
    public void setAlphabet(Alphabet alphabet) {
        this.alphabet = alphabet;
    }

    public void init() {
        this.agrExtractors.add(this.dep_word_head_word(1));
        this.agrExtractors.add(this.dep_word_head_pos(1));
        this.agrExtractors.add(this.dep_pos_head_word(1));
        this.agrExtractors.add(this.dep_pos_head_pos(1));
        this.agrConjExtractors.add(this.dep_word_head_word(2));
        this.agrConjExtractors.add(this.dep_word_head_pos(2));
        this.agrConjExtractors.add(this.dep_pos_head_word(2));
        this.agrConjExtractors.add(this.dep_pos_head_pos(2));
        this.agrOfComplementExtractors.add(this.dep_word_head_word(3));
        this.agrOfComplementExtractors.add(this.dep_word_head_pos(3));
        this.agrOfComplementExtractors.add(this.dep_pos_head_word(3));
        this.agrOfComplementExtractors.add(this.dep_pos_head_pos(3));
        this.whExtractors.add(this.dep_word_head_stem(4));
        this.whExtractors.add(this.dep_word_head_pos(4));
        this.whExtractors.add(this.dep_word_head_class(4));
        this.whConjExtractors.add(this.dep_word_head_stem(5));
        this.whConjExtractors.add(this.dep_word_head_pos(5));
        this.whConjExtractors.add(this.dep_word_head_class(5));
        this.punctExtractor.add(this.unbal_punct());
    }

    @Override
    public FeatureVector extractFeatures(Sign sign, boolean complete) {
        this.addFeatures(sign, complete);
        return this.getFeatureMap(sign);
    }

    protected void addFeatures(Sign sign, boolean complete) {
        if (this.getFeatureMap(sign) != null) {
            return;
        }
        if (sign.isLexical()) {
            this.currentMap = new FeatureMap(0);
        } else {
            Sign[] inputs;
            for (Sign child : inputs = sign.getDerivationHistory().getInputs()) {
                this.addFeatures(child, false);
            }
            if (inputs.length == 1) {
                this.currentMap = new FeatureMap(this.getFeatureMap(inputs[0]));
            } else if (inputs.length == 2) {
                this.currentMap = new FeatureMap(this.getFeatureMap(inputs[0]), this.getFeatureMap(inputs[1]));
            }
            String subjArg = null;
            for (LexDependency dep : sign.getFilledDeps()) {
                ArrayList<String> rels;
                this.headSign = dep.lexHead;
                this.depSign = dep.lexDep;
                if (subjArg == null && (subjArg = this.getSubjectFeature(dep.lexHead.getCategory())) == null) {
                    subjArg = "Arg0";
                }
                if (subjArg.equals(dep.rel) && (dep.lexHead.getOrthography().equals("was") || dep.lexHead.getOrthography().equals("were") || dep.lexHead.getPOS().equals("VBZ") || dep.lexHead.getPOS().equals("VBP"))) {
                    if (this.sentId != null) {
                        ++this.INSTANCENUM;
                    }
                    this.inc(this.agrExtractors);
                    if (dep.lexDep.getOrthography().equals("or")) {
                        ArrayList<String> rels2 = new ArrayList<String>(2);
                        rels2.add("First");
                        rels2.add("Next");
                        Hashtable<LexDependency, Sign> cdeps = this.getLowerSiblingDeps(inputs, dep.lexDep, rels2, null);
                        if (cdeps != null) {
                            Enumeration<LexDependency> e = cdeps.keys();
                            while (e.hasMoreElements()) {
                                LexDependency cdep = e.nextElement();
                                this.depSign = cdep.lexDep;
                                this.inc(this.agrConjExtractors);
                            }
                        }
                    }
                    String subjClass = dep.lexDep.getWords().get(0).getSemClass();
                    String subjPOS = dep.lexDep.getPOS();
                    if (subjClass == null) {
                        subjClass = "NULL";
                    }
                    if (!subjClass.equals("PERCENT") && !subjPOS.startsWith("CD")) {
                        rels = new ArrayList(1);
                        rels.add("Mod");
                        ArrayList<String> depPreds = new ArrayList<String>(1);
                        depPreds.add("of");
                        Hashtable<LexDependency, Sign> ofComplDeps = this.getLowerSiblingDeps(inputs, dep.lexDep, rels, depPreds);
                        if (ofComplDeps != null) {
                            Enumeration<LexDependency> e1 = ofComplDeps.keys();
                            while (e1.hasMoreElements()) {
                                LexDependency ofComplDep = e1.nextElement();
                                Sign[] ofComplSigns = ofComplDeps.get(ofComplDep).getDerivationHistory().getInputs();
                                rels = new ArrayList(1);
                                rels.add("Arg1");
                                Hashtable<LexDependency, Sign> ofDeps = this.getLowerSiblingDeps(ofComplSigns, ofComplDep.lexDep, rels, null);
                                if (ofDeps == null) continue;
                                Enumeration<LexDependency> e2 = ofDeps.keys();
                                while (e2.hasMoreElements()) {
                                    LexDependency ofDep = e2.nextElement();
                                    this.depSign = ofDep.lexDep;
                                    this.inc(this.agrOfComplementExtractors);
                                }
                            }
                        }
                    }
                }
                String whPrn = dep.lexDep.getOrthography();
                if (!dep.rel.equals("GenRel") && !dep.rel.equals("whApposRel") || !whPrn.equals("that") && !whPrn.equals("who") && !whPrn.equals("which") && !whPrn.equals("whose")) continue;
                Sign sib = this.getSibling(sign.getSiblingFilledDeps(), "Arg");
                if (sib != null) {
                    this.headSign = sib;
                }
                if (this.sentId != null) {
                    ++this.INSTANCENUM;
                }
                this.inc(this.whExtractors);
                if (!dep.lexDep.getPOS().equals("CC") && !dep.lexDep.getOrthography().equals(",") && !dep.lexDep.getOrthography().equals(";") && !dep.lexDep.getOrthography().equals("or") && !dep.lexDep.getOrthography().equals("and")) continue;
                rels = new ArrayList<String>(1);
                rels.add("Next");
                Hashtable<LexDependency, Sign> cdeps = this.getLowerSiblingDeps(inputs, dep.lexDep, rels, null);
                if (cdeps == null) continue;
                Enumeration<LexDependency> e = cdeps.keys();
                while (e.hasMoreElements()) {
                    LexDependency cdep = e.nextElement();
                    this.depSign = cdep.lexDep;
                    this.inc(this.whConjExtractors);
                }
            }
            if (sign != null && inputs != null) {
                Word nextWord;
                SignProps lchildProps;
                SignProps childProps;
                TargetCat target = sign.getCategory().getTarget();
                FeatureStructure fs = target.getFeatureStructure();
                String punctFeatVal = null;
                if (fs != null && fs.hasAttribute("unbal")) {
                    Object val = fs.getValue("unbal");
                    String string = punctFeatVal = val instanceof SimpleType ? ((SimpleType)val).getName() : null;
                }
                if ((childProps = (SignProps)inputs[inputs.length - 1].getData(SignProps.class)) != null) {
                    punctFeatVal = childProps.getUnbalancedPunct();
                }
                if (punctFeatVal != null) {
                    SignProps currProps = new SignProps(punctFeatVal);
                    sign.addData(currProps);
                }
                if (inputs.length == 2 && (lchildProps = (SignProps)inputs[0].getData(SignProps.class)) != null && lchildProps.getUnbalancedPunct() != null && !this.isPunct(nextWord = inputs[1].getWords().get(0))) {
                    this.inc(this.punctExtractor);
                }
            }
        }
        this.storeFeatureMap(sign);
    }

    public Sign getOfComplSign() {
        Sign retval = null;
        return retval;
    }

    protected void storeFeatureMap(Sign sign) {
        sign.addData(new FeatureMapWrapper(this.currentMap));
    }

    public FeatureMap getFeatureMap(Sign sign) {
        FeatureMapWrapper fmw = (FeatureMapWrapper)sign.getData(FeatureMapWrapper.class);
        return fmw != null ? fmw.featureMap : null;
    }

    protected void inc(List<List<TrieMap.KeyExtractor<String>>> extractors) {
        for (List<TrieMap.KeyExtractor<String>> lazyExtractor : extractors) {
            Alphabet.Feature f = this.alphabet.indexLazy(lazyExtractor);
            if (f == null) continue;
            this.currentMap.inc(f);
        }
    }

    public String getSubjectFeature(Category cat) {
        String retval = null;
        if (cat instanceof ComplexCat) {
            Category resCat = ((ComplexCat)cat).getResult();
            retval = this.getSubjectFeature(resCat);
        } else if (cat instanceof AtomCat) {
            AtomCat ac = (AtomCat)cat;
            FeatureStructure fs = ac.getFeatureStructure();
            for (String attr : fs.getAttributes()) {
                if (!attr.equals("sbj")) continue;
                retval = fs.getValue(attr).toString();
                break;
            }
        }
        return retval;
    }

    private boolean isPunct(Word w) {
        String pos = w.getPOS();
        boolean retval = pos.startsWith("PUNCT");
        retval = retval || pos.equals(".") || pos.equals(",") || pos.equals(";") || pos.equals(":") || pos.equals("LRB") || pos.equals("RRB");
        return retval;
    }

    public Hashtable<LexDependency, Sign> getLowerSiblingDeps(Sign[] inputs, Sign headSign, ArrayList<String> rels, ArrayList<String> depPreds) {
        Hashtable<LexDependency, Sign> retval = new Hashtable<LexDependency, Sign>();
        for (Sign sign : inputs) {
            if (retval.size() == rels.size()) break;
            List<LexDependency> sdeps = sign.getSiblingFilledDeps();
            sdeps.addAll(sign.getFilledDeps());
            for (LexDependency sdep : sdeps) {
                if (sdep.lexHead != headSign || !rels.contains(sdep.rel) || retval.containsKey(sdep) || depPreds != null && !depPreds.contains(sdep.lexDep.getOrthography())) continue;
                retval.put(sdep, sign);
            }
        }
        if (retval.size() == 0) {
            retval = null;
        }
        return retval;
    }

    private Sign getSibling(List<LexDependency> sdeps, String rel) {
        Sign retval = null;
        if (sdeps != null) {
            for (LexDependency dep : sdeps) {
                if (!dep.rel.equals(rel)) continue;
                retval = dep.lexDep;
                break;
            }
        }
        return retval;
    }

    private String adjustWord(String word) {
        String retval = word;
        if (word.equals("'ve")) {
            retval = "have";
        } else if (word.equals("'s")) {
            retval = "is";
        } else if (word.equals("'re")) {
            retval = "are";
        }
        return retval;
    }

    private String adjustPOS(String word, String pos, String semClass) {
        String retval = pos;
        if (word.equals("has")) {
            retval = "VBZ";
        } else if (word.equals("have")) {
            retval = "VBP";
        } else if (word.equals("one") || word.equals("1")) {
            pos = "CD-1";
        } else if (semClass != null && semClass.equals("PERCENT")) {
            retval = semClass;
        } else if (word.equals(",") || word.equals(";")) {
            retval = "CC";
        }
        return retval;
    }

    private String adjustSemClass(String semClass) {
        String retval = "UNK";
        if (semClass != null) {
            String[] temp = semClass.split("\\|");
            retval = temp[0].split(":")[0];
        }
        return retval;
    }

    private void add_prefix_main1(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return "AGR";
            }
        });
    }

    private void add_prefix_main2(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return "AGRCONJ";
            }
        });
    }

    private void add_prefix_main3(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return "AGROF";
            }
        });
    }

    private void add_prefix_main4(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return "AGRWH";
            }
        });
    }

    private void add_prefix_main5(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return "AGRWHCONJ";
            }
        });
    }

    private void add_instance_num(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return Integer.toString(EnglishAgreementExtractor.this.INSTANCENUM);
            }
        });
    }

    private void add_prefix_sub1(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return "WW";
            }
        });
    }

    private void add_prefix_sub2(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return "WP";
            }
        });
    }

    private void add_prefix_sub3(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return "PW";
            }
        });
    }

    private void add_prefix_sub4(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return "PP";
            }
        });
    }

    private void add_prefix_sub5(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return "WS";
            }
        });
    }

    private void add_prefix_sub6(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return "WC";
            }
        });
    }

    private void add_prefix(int prefix, List<TrieMap.KeyExtractor<String>> retval) {
        switch (prefix) {
            case 1: {
                this.add_prefix_main1(retval);
                break;
            }
            case 2: {
                this.add_prefix_main2(retval);
                break;
            }
            case 3: {
                this.add_prefix_main3(retval);
                break;
            }
            case 4: {
                this.add_prefix_main4(retval);
                break;
            }
            case 5: {
                this.add_prefix_main5(retval);
            }
        }
    }

    private List<TrieMap.KeyExtractor<String>> dep_word_head_word(int prefix) {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(3);
        if (this.sentId != null) {
            this.add_instance_num(retval);
        }
        this.add_prefix(prefix, retval);
        this.add_prefix_sub1(retval);
        this.add_dep_word(retval);
        this.add_head_word(retval);
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> dep_word_head_pos(int prefix) {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(3);
        if (this.sentId != null) {
            this.add_instance_num(retval);
        }
        this.add_prefix(prefix, retval);
        this.add_prefix_sub2(retval);
        this.add_dep_word(retval);
        this.add_head_pos(retval);
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> dep_pos_head_word(int prefix) {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(3);
        if (this.sentId != null) {
            this.add_instance_num(retval);
        }
        this.add_prefix(prefix, retval);
        this.add_prefix_sub3(retval);
        this.add_dep_pos(retval);
        this.add_head_word(retval);
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> dep_pos_head_pos(int prefix) {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(3);
        if (this.sentId != null) {
            this.add_instance_num(retval);
        }
        this.add_prefix(prefix, retval);
        this.add_prefix_sub4(retval);
        this.add_dep_pos(retval);
        this.add_head_pos(retval);
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> dep_word_head_stem(int prefix) {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(3);
        if (this.sentId != null) {
            this.add_instance_num(retval);
        }
        this.add_prefix(prefix, retval);
        this.add_prefix_sub5(retval);
        this.add_dep_word(retval);
        this.add_head_stem(retval);
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> dep_word_head_class(int prefix) {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(3);
        if (this.sentId != null) {
            this.add_instance_num(retval);
        }
        this.add_prefix(prefix, retval);
        this.add_prefix_sub6(retval);
        this.add_dep_word(retval);
        this.add_head_class(retval);
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> unbal_punct() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(1);
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return "$punct";
            }
        });
        return retval;
    }

    private void add_head_word(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                String word = EnglishAgreementExtractor.this.adjustWord(EnglishAgreementExtractor.this.headSign.getWordForm());
                return word;
            }
        });
    }

    private void add_head_stem(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return EnglishAgreementExtractor.this.headSign.getWords().get(0).getStem();
            }
        });
    }

    private void add_head_class(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                String semClass = EnglishAgreementExtractor.this.adjustSemClass(EnglishAgreementExtractor.this.headSign.getWords().get(0).getSemClass());
                return semClass;
            }
        });
    }

    private void add_head_pos(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                String pos = EnglishAgreementExtractor.this.adjustPOS(EnglishAgreementExtractor.this.headSign.getOrthography(), EnglishAgreementExtractor.this.headSign.getPOS(), EnglishAgreementExtractor.this.headSign.getWords().get(0).getSemClass());
                return pos;
            }
        });
    }

    private void add_dep_word(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                String word = EnglishAgreementExtractor.this.adjustWord(EnglishAgreementExtractor.this.depSign.getWordForm());
                return word;
            }
        });
    }

    private void add_dep_pos(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                String pos = EnglishAgreementExtractor.this.adjustPOS(EnglishAgreementExtractor.this.depSign.getOrthography(), EnglishAgreementExtractor.this.depSign.getPOS(), EnglishAgreementExtractor.this.depSign.getWords().get(0).getSemClass());
                return pos;
            }
        });
    }

    private class SignProps {
        private String unbalPunct = null;

        public SignProps(String unbalPunct) {
            this.unbalPunct = unbalPunct;
        }

        public String getUnbalancedPunct() {
            return this.unbalPunct;
        }
    }

    public static class FeatureMapWrapper {
        public FeatureMap featureMap;

        public FeatureMapWrapper(FeatureMap featureMap) {
            this.featureMap = featureMap;
        }
    }
}

