/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.hylo.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import opennlp.ccg.hylo.Mode;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.hylo.Proposition;
import opennlp.ccg.hylo.SatOp;
import opennlp.ccg.hylo.graph.LFVertexType;

public class LFVertex {
    final Nominal nominal;
    final Proposition proposition;
    protected Map<Mode, Proposition> attributes;
    private Integer index;
    private LFVertexType type;

    public LFVertex(SatOp satOp) {
        this(satOp.getNominal(), (Proposition)satOp.getArg());
    }

    public LFVertex(Nominal nominal) {
        this(nominal, null);
    }

    public LFVertex(Nominal nominal, Proposition proposition) {
        this(nominal, proposition, null);
    }

    public LFVertex(Nominal nominal, Proposition proposition, Map<Mode, Proposition> attributes) {
        if (nominal == null) {
            throw new IllegalArgumentException("nominal is null");
        }
        this.nominal = nominal;
        this.proposition = proposition;
        this.attributes = attributes;
    }

    public String getName() {
        return this.getNominal().getName();
    }

    public String getPredicate() {
        Proposition p = this.getProposition();
        return p == null ? null : p.getName();
    }

    public Nominal getNominal() {
        return this.nominal;
    }

    public Proposition getProposition() {
        return this.proposition;
    }

    public LFVertexType getType() {
        return this.type == null ? (this.type = LFVertexType.fromPrefix(this.nominal.getName())) : this.type;
    }

    public Integer getIndex() {
        return this.index == null ? (this.index = LFVertex.parseVertexIndex(this.nominal)) : this.index;
    }

    public static Integer parseVertexIndex(Nominal nominal) {
        String nm = nominal.getName();
        int colidx = nm.indexOf(58);
        String s = colidx == -1 ? nm : nm.substring(0, colidx);
        return Integer.parseInt(s.substring(1));
    }

    public Map<Mode, Proposition> getAttributeMap() {
        return this.attributes == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this.attributes);
    }

    public Set<Mode> attributeNames() {
        return this.attributes == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(this.attributes.keySet());
    }

    public boolean containsAttribute(Mode attributeName) {
        return this.attributes != null && this.attributes.containsKey(attributeName);
    }

    public Proposition getAttributeValue(Mode attributeName) {
        return this.attributes == null ? null : this.attributes.get(attributeName);
    }

    public boolean addAttribute(Mode attributeName, Proposition value) {
        return !value.equals(this.setAttribute(attributeName, value));
    }

    public Proposition setAttribute(Mode attributeName, Proposition value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<Mode, Proposition>();
        }
        return this.attributes.put(attributeName, value);
    }

    public Proposition removeAttribute(Mode attributeName) {
        return this.attributes == null ? null : this.attributes.remove(attributeName);
    }

    public int hashCode() {
        int i = 37 * this.nominal.hashCode();
        if (this.proposition != null) {
            i += this.proposition.hashCode();
        }
        return i;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LFVertex) {
            LFVertex v = (LFVertex)obj;
            return this.nominal.equals(v.nominal) && (this.proposition == null ? v.proposition == null : this.proposition.equals(v.proposition)) && (this.attributes == null ? v.attributes == null : this.attributes.equals(v.attributes));
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.nominal.getName());
        if (this.proposition != null) {
            sb.append('@');
            sb.append(this.proposition.getName());
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            sb.append(' ');
            sb.append(this.attributes.toString());
        }
        return sb.toString();
    }
}

