/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.lexicon;

import java.util.List;
import opennlp.ccg.lexicon.Word;

public interface Tokenizer {
    public static final String WORD_ATTR = "W";
    public static final String STEM_ATTR = "S";
    public static final String POS_ATTR = "P";
    public static final String SUPERTAG_ATTR = "T";
    public static final String SEM_CLASS_ATTR = "C";
    public static final String PITCH_ACCENT_ATTR = "A";
    public static final String DATE_VAL = "[*DATE*]";
    public static final String DATE_CLASS = "date";
    public static final String TIME_VAL = "[*TIME*]";
    public static final String TIME_CLASS = "time";
    public static final String NUM_VAL = "[*NUM*]";
    public static final String NUM_CLASS = "num";
    public static final String AMT_VAL = "[*AMT*]";
    public static final String AMT_CLASS = "amt";
    public static final String DUR_VAL = "[*DUR*]";
    public static final String DUR_CLASS = "dur";
    public static final String NE_VAL = "[*NE*]";
    public static final String NE_CLASS = "ne";

    public List<Word> tokenize(String var1);

    public List<Word> tokenize(String var1, boolean var2);

    public Word parseToken(String var1);

    public Word parseToken(String var1, boolean var2);

    public String isSpecialToken(String var1);

    public String getSpecialTokenConstant(String var1);

    public boolean isSpecialTokenConstant(String var1);

    public boolean isDate(String var1);

    public boolean isTime(String var1);

    public boolean isNum(String var1);

    public boolean isAmt(String var1);

    public boolean isNamedEntity(String var1);

    public void addReplacementSemClass(String var1);

    public boolean isReplacementSemClass(String var1);

    public String getOrthography(List<Word> var1);

    public String getOrthography(List<Word> var1, boolean var2);

    public String getOrthography(Word var1, boolean var2);

    public String format(List<Word> var1);

    public String format(Word var1);

    public String format(List<Word> var1, boolean var2);

    public String format(Word var1, boolean var2);

    public List<String> expandWord(Word var1);

    public List<String> expandDate(String var1);

    public List<String> expandTime(String var1);

    public List<String> expandNum(String var1);

    public List<String> expandAmt(String var1);

    public List<String> expandNamedEntity(String var1);
}

