/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.lexicon;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import opennlp.ccg.lexicon.DefaultTokenizer;
import opennlp.ccg.lexicon.Word;

public class TrueCaser {
    public boolean skipAlreadyLower = true;
    private Map<String, String> caseMap = new HashMap<String, String>();
    private double titleCaseThreshold;

    public TrueCaser(String pathToOnlyUCWords) {
        this(pathToOnlyUCWords, 0.5);
    }

    public TrueCaser(String pathToOnlyUCWords, double titleCaseThreshold) {
        this.titleCaseThreshold = titleCaseThreshold;
        this.caseMap = TrueCaser.readInCaseMap(pathToOnlyUCWords);
        if (this.caseMap == null) {
            System.err.println("Something went wrong." + System.getProperty("line.separator") + "Make sure you passed in a file of true-cased words, etc.");
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readInCaseMap(String pathToOnlyUCWords) {
        HashMap<String, String> caseMap = new HashMap<String, String>();
        BufferedReader inRead = null;
        try {
            Charset utf8 = (Charset)Charset.availableCharsets().get("UTF-8");
            inRead = new BufferedReader(pathToOnlyUCWords.toLowerCase().endsWith(".gz") ? new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(new File(pathToOnlyUCWords))), utf8) : new InputStreamReader((InputStream)new FileInputStream(new File(pathToOnlyUCWords)), utf8));
            String ln = inRead.readLine();
            while (ln != null) {
                if (!(ln = ln.trim()).startsWith("#")) {
                    caseMap.put(ln.toLowerCase(), ln);
                }
                ln = inRead.readLine();
            }
        }
        catch (IOException ioe) {
            Map<String, String> map = null;
            return map;
        }
        finally {
            try {
                inRead.close();
            }
            catch (Exception exception) {}
        }
        return caseMap;
    }

    public String trueCase(String theWord, boolean isTitle, boolean isFirstWord) {
        String loweredWord = theWord.toLowerCase();
        if (this.skipAlreadyLower && theWord.equals(loweredWord)) {
            return theWord;
        }
        String trueCasedTheWord = this.caseMap.get(loweredWord);
        if (trueCasedTheWord != null) {
            return trueCasedTheWord;
        }
        return isTitle || isFirstWord ? loweredWord : theWord;
    }

    public String trueCaseSentence(String sentence) {
        String[] parts = sentence.split("\\s+");
        StringBuffer res = new StringBuffer(parts.length);
        boolean isTitle = this.isTitleCased(parts);
        int i = 0;
        for (String prt : parts) {
            boolean isFirstWord = i == 0 || i == 1 && (parts[0].equals("``") || parts[0].equals("`"));
            res.append(" " + this.trueCase(prt, isTitle, isFirstWord));
            ++i;
        }
        return res.toString().trim();
    }

    public boolean isTitleCased(String[] words) {
        int numCased = 0;
        int cursor = 0;
        for (String wd : words) {
            if (cursor >= 10) break;
            if (!wd.toLowerCase().equals(wd)) {
                ++numCased;
            }
            ++cursor;
        }
        return (double)numCased / (words.length < 10 ? (double)words.length + 0.0 : 10.0) >= this.titleCaseThreshold;
    }

    public String tcWordToString(String newWordForm, Word oldWord) {
        StringBuffer sb = new StringBuffer();
        sb.append(newWordForm);
        if (oldWord.getPOS() != null) {
            sb.append(":P-").append(DefaultTokenizer.escape(oldWord.getPOS()));
        }
        if (oldWord.getSupertag() != null) {
            sb.append(":T-").append(DefaultTokenizer.escape(oldWord.getSupertag()));
        }
        if (oldWord.getSemClass() != null) {
            sb.append(":C-").append(DefaultTokenizer.escape(oldWord.getSemClass()));
        }
        if (sb.length() == 0) {
            sb.append((String)null);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        String newline = System.getProperty("line.separator");
        String usage = newline + "java TrueCaser -t <truecase-file> -r <title-threshold> -i <input [default=stdin]> -o <output [default=stdout]>" + newline;
        if (args.length == 0 || args[0].equals("h") || args[0].equals("-h") || args[0].equals("--h") || args[0].equals("--help") || args[0].equals("-help")) {
            System.err.println(usage);
            System.exit(0);
        }
        String truecasefile = null;
        String inputfile = null;
        String outputfile = null;
        double tcThresh = 0.5;
        for (int a = 0; a < args.length; ++a) {
            if (args[a].equals("-t")) {
                truecasefile = args[++a];
                continue;
            }
            if (args[a].equals("-r")) {
                tcThresh = Double.parseDouble(args[++a]);
                continue;
            }
            if (args[a].equals("-i")) {
                inputfile = args[++a];
                continue;
            }
            if (args[a].equals("-o")) {
                outputfile = args[++a];
                continue;
            }
            System.err.println("unrecognized option " + args[a] + ".");
            System.err.println(usage);
            System.exit(0);
        }
        Charset utf8 = (Charset)Charset.availableCharsets().get("UTF-8");
        BufferedReader in = new BufferedReader(new InputStreamReader(inputfile == null ? System.in : new FileInputStream(new File(inputfile)), utf8));
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outputfile == null ? System.out : new FileOutputStream(new File(outputfile)), utf8));
        TrueCaser tc = new TrueCaser(truecasefile, tcThresh);
        String sent = in.readLine();
        while (sent != null) {
            sent = tc.trueCaseSentence(sent.trim());
            out.write(sent + System.getProperty("line.separator"));
            sent = in.readLine();
        }
        out.close();
        in.close();
    }
}

