/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIdentityHashingStrategy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opennlp.ccg.grammar.AbstractRule;
import opennlp.ccg.grammar.Rule;
import opennlp.ccg.grammar.RuleGroup;
import opennlp.ccg.parse.DerivationHistory;
import opennlp.ccg.parse.Edge;
import opennlp.ccg.parse.EdgeHash;
import opennlp.ccg.parse.ParseException;
import opennlp.ccg.synsem.ReRankingScorer;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.synsem.SignHash;
import opennlp.ccg.synsem.SignScorer;

public class Chart {
    private static TObjectHashingStrategy representativeEdgeStrategy = new TObjectHashingStrategy(){
        private static final long serialVersionUID = 1L;

        public int computeHashCode(Object o) {
            Sign sign = ((Edge)o).sign;
            int headpos = Edge.getEdge((Sign)sign.getLexHead()).wordPos;
            return 31 * headpos + sign.getCategory().hashCodeNoLF();
        }

        public boolean equals(Object o1, Object o2) {
            if (!(o1 instanceof Edge) || !(o2 instanceof Edge)) {
                return false;
            }
            Sign sign1 = ((Edge)o1).sign;
            Sign sign2 = ((Edge)o2).sign;
            return Edge.getEdge((Sign)sign1.getLexHead()).wordPos == Edge.getEdge((Sign)sign2.getLexHead()).wordPos && sign1.getCategory().equalsNoLF(sign2.getCategory());
        }
    };
    public static final Comparator<Edge> edgeComparator = new Comparator<Edge>(){

        @Override
        public int compare(Edge edge1, Edge edge2) {
            if (edge1.score != edge2.score) {
                return -1 * Double.compare(edge1.score, edge2.score);
            }
            return SignHash.compareTo(edge1.sign, edge2.sign);
        }
    };
    protected Cell[][] _table;
    protected int _size;
    protected int _numEdges = 0;
    protected int _numUnpackingEdges = 0;
    protected int _maxCellSize = 0;
    protected RuleGroup _rules;
    protected SignScorer _signScorer = SignScorer.nullScorer;
    protected int _pruneVal = 0;
    protected int _timeLimit = 0;
    protected long _startTime = 0L;
    protected int _edgeLimit = 0;
    protected int _cellLimit = 0;

    private static Map<Edge, Edge> createEdgeMap() {
        return new THashMap(11, representativeEdgeStrategy);
    }

    private boolean addEdgeSorted(Edge edge, List<Edge> list, Map<Edge, Edge> map, int limit) {
        boolean limitActive;
        int index = Collections.binarySearch(list, edge, edgeComparator);
        if ((index = Math.abs(index) - 1) < 0) {
            index = list.size();
        }
        boolean bl = limitActive = limit > 0 && !edge.sign.isLexical();
        if (limitActive && index >= limit) {
            return false;
        }
        list.add(index, edge);
        if (map != null) {
            map.put(edge, edge);
        }
        if (limitActive && list.size() > limit) {
            Edge last = list.remove(list.size() - 1);
            if (map != null) {
                map.remove(last);
            }
        }
        return true;
    }

    public Chart(int s, RuleGroup _R) {
        this._rules = _R;
        this._size = s;
        this._table = new Cell[this._size][this._size];
    }

    public void setSignScorer(SignScorer signScorer) {
        this._signScorer = signScorer;
    }

    public void setPruneVal(int n) {
        this._pruneVal = n;
    }

    public void setTimeLimit(int timeLimit) {
        this._timeLimit = timeLimit;
    }

    public void setStartTime(long startTime) {
        this._startTime = startTime;
    }

    public void setEdgeLimit(int edgeLimit) {
        this._edgeLimit = edgeLimit;
    }

    public void setCellLimit(int cellLimit) {
        this._cellLimit = cellLimit;
    }

    public int edgeCount() {
        return this._numEdges;
    }

    public int unpackingEdgeCount() {
        return this._numUnpackingEdges;
    }

    public int maxCellSize() {
        return this._maxCellSize;
    }

    public boolean insert(int x, int y, Sign w) {
        Edge rep;
        Cell cell = this.get(x, y);
        boolean retval = false;
        Edge edge = new Edge(w);
        if (w.isLexical()) {
            edge.setWordPos(x);
        }
        if ((rep = cell.get(edge)) == null) {
            edge.initAltEdges();
            retval = cell.add(edge);
        } else {
            this.addEdgeSorted(edge, rep.altEdges, null, this._pruneVal);
        }
        ++this._numEdges;
        if (cell.size() > this._maxCellSize) {
            this._maxCellSize = cell.size();
        }
        return retval;
    }

    protected Cell get(int x, int y) {
        if (this._table[x][y] == null) {
            this._table[x][y] = new Cell();
        }
        return this._table[x][y];
    }

    protected SignHash getSigns(int x, int y) {
        Cell cell = this.get(x, y);
        return cell.getSigns();
    }

    protected void insertCell(int x, int y) throws ParseException {
        if (this._table[x][y] == null) {
            return;
        }
        List<Sign> inputs = this._table[x][y].getSignsSorted();
        ArrayList<Sign> nextInputs = new ArrayList<Sign>(inputs.size());
        while (inputs.size() > 0) {
            for (Sign sign : inputs) {
                this.checkLimits();
                List<Sign> results = this._rules.applyUnaryRules(sign);
                for (Sign result : results) {
                    boolean newEdgeClass;
                    if (result.getDerivationHistory().containsCycle() || !(newEdgeClass = this.insert(x, y, result))) continue;
                    nextInputs.add(result);
                }
            }
            inputs.clear();
            inputs.addAll(nextInputs);
            nextInputs.clear();
        }
    }

    protected void insertCell(int x1, int y1, int x2, int y2, int x3, int y3) throws ParseException {
        if (this._table[x1][y1] == null) {
            return;
        }
        if (this._table[x2][y2] == null) {
            return;
        }
        List<Sign> inputs1 = this._table[x1][y1].getSignsSorted();
        List<Sign> inputs2 = this._table[x2][y2].getSignsSorted();
        for (Sign sign1 : inputs1) {
            for (Sign sign2 : inputs2) {
                this.checkLimits();
                List<Sign> results = this._rules.applyBinaryRules(sign1, sign2);
                for (Sign result : results) {
                    this.insert(x3, y3, result);
                }
            }
        }
    }

    protected void insertCellFrag(int x1, int y1, int x2, int y2, int x3, int y3) throws ParseException {
        if (this._table[x1][y1] == null) {
            return;
        }
        if (this._table[x2][y2] == null) {
            return;
        }
        if (!this.cellIsEmpty(x3, y3)) {
            return;
        }
        List<Sign> inputs1 = this._table[x1][y1].getSignsSorted();
        List<Sign> inputs2 = this._table[x2][y2].getSignsSorted();
        for (Sign sign1 : inputs1) {
            for (Sign sign2 : inputs2) {
                this.checkLimits();
                List<Sign> results = this._rules.applyGlueRule(sign1, sign2);
                for (Sign result : results) {
                    this.insert(x3, y3, result);
                }
            }
        }
    }

    private void checkLimits() throws ParseException {
        int timeSoFar;
        if (this._edgeLimit > 0 && this._numEdges > this._edgeLimit) {
            throw new ParseException("Edge limit exceeded");
        }
        if (this._timeLimit > 0 && (timeSoFar = (int)(System.currentTimeMillis() - this._startTime)) > this._timeLimit) {
            throw new ParseException("Time limit exceeded");
        }
    }

    public boolean cellIsEmpty(int x, int y) {
        Cell cell = this.get(x, y);
        return cell.list.isEmpty();
    }

    public List<Edge> unpack(int x, int y) {
        Cell cell = this.get(x, y);
        THashSet unpacked = new THashSet((TObjectHashingStrategy)new TObjectIdentityHashingStrategy());
        THashSet startedUnpacking = new THashSet((TObjectHashingStrategy)new TObjectIdentityHashingStrategy());
        for (Edge edge : cell.list) {
            this.unpack(edge, (Set<Edge>)unpacked, (Set<Edge>)startedUnpacking);
        }
        EdgeHash merged = new EdgeHash();
        for (Edge edge : cell.list) {
            merged.addAll(edge.altEdges);
        }
        ArrayList<Edge> arrayList = new ArrayList<Edge>(merged.asEdgeSet());
        Collections.sort(arrayList, edgeComparator);
        if (this._pruneVal > 0) {
            while (arrayList.size() > this._pruneVal) {
                arrayList.remove(arrayList.size() - 1);
            }
        }
        for (Edge edge : cell.list) {
            edge.restoreAltEdges();
        }
        return arrayList;
    }

    private void unpack(Edge edge, Set<Edge> unpacked, Set<Edge> startedUnpacking) {
        if (unpacked.contains(edge)) {
            return;
        }
        if (startedUnpacking.contains(edge)) {
            System.err.println("Warning, revisiting edge before unpacking complete: " + edge);
            System.err.println(edge.sign.getDerivationHistory().toString());
            return;
        }
        startedUnpacking.add(edge);
        EdgeHash merged = new EdgeHash();
        for (Edge edge2 : edge.altEdges) {
            this.unpackAlt(edge2, unpacked, startedUnpacking, merged);
        }
        boolean complete = edge.sign.getWords().size() == this._size;
        for (Edge m : merged.asEdgeSet()) {
            m.setScore(this._signScorer.score(m.sign, complete));
        }
        ArrayList<Edge> arrayList = new ArrayList<Edge>(merged.asEdgeSet());
        Collections.sort(arrayList, edgeComparator);
        if (this._pruneVal > 0) {
            while (arrayList.size() > this._pruneVal) {
                arrayList.remove(arrayList.size() - 1);
            }
        }
        edge.replaceAltEdges(arrayList);
        unpacked.add(edge);
    }

    private void unpackAlt(Edge alt, Set<Edge> unpacked, Set<Edge> startedUnpacking, EdgeHash merged) {
        DerivationHistory history = alt.sign.getDerivationHistory();
        Sign[] inputSigns = history.getInputs();
        if (inputSigns == null) {
            merged.insert(alt);
            return;
        }
        Edge[] inputEdges = new Edge[inputSigns.length];
        for (int i = 0; i < inputSigns.length; ++i) {
            inputEdges[i] = Edge.getEdge(inputSigns[i]);
            this.unpack(inputEdges[i], unpacked, startedUnpacking);
        }
        Rule rule = history.getRule();
        List<Sign[]> altCombos = this.inputCombos(inputEdges, 0);
        ArrayList<Sign> results = new ArrayList<Sign>(1);
        for (Sign[] combo : altCombos) {
            if (this.sameSigns(inputSigns, combo)) {
                merged.insert(alt);
                continue;
            }
            results.clear();
            ((AbstractRule)rule).applyRule(combo, results);
            if (results.isEmpty()) continue;
            Sign sign = (Sign)results.get(0);
            merged.insert(new Edge(sign));
            ++this._numUnpackingEdges;
        }
    }

    private List<Sign[]> inputCombos(Edge[] inputEdges, int index) {
        Edge edge = inputEdges[index];
        if (index == inputEdges.length - 1) {
            List<Edge> altEdges = edge.altEdges;
            ArrayList<Sign[]> retval = new ArrayList<Sign[]>(altEdges.size());
            for (Edge alt : altEdges) {
                retval.add(new Sign[]{alt.sign});
            }
            return retval;
        }
        List<Sign[]> nextCombos = this.inputCombos(inputEdges, index + 1);
        List<Edge> altEdges = edge.altEdges;
        ArrayList<Sign[]> retval = new ArrayList<Sign[]>(altEdges.size() * nextCombos.size());
        for (Edge alt : altEdges) {
            for (int i = 0; i < nextCombos.size(); ++i) {
                Sign[] nextSigns = nextCombos.get(i);
                Sign[] newCombo = new Sign[nextSigns.length + 1];
                newCombo[0] = alt.sign;
                System.arraycopy(nextSigns, 0, newCombo, 1, nextSigns.length);
                retval.add(newCombo);
            }
        }
        return retval;
    }

    private boolean sameSigns(Sign[] a, Sign[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public List<Edge> lazyUnpack(int x, int y) {
        if (this._pruneVal <= 0) {
            return this.unpack(x, y);
        }
        Cell cell = this.get(x, y);
        ArrayList<Candidate> topcands = new ArrayList<Candidate>(this._pruneVal);
        THashMap derivsmap = new THashMap((TObjectHashingStrategy)new TObjectIdentityHashingStrategy());
        for (Edge edge : cell.list) {
            List<Candidate> cands = this.getCandidates(edge, (Map<Edge, List<Edge>>)derivsmap);
            topcands.addAll(cands);
        }
        this.sortAndPrune(topcands);
        ArrayList<Edge> retval = new ArrayList<Edge>(this._pruneVal);
        EdgeHash merged = new EdgeHash();
        while (merged.size() < this._pruneVal && !topcands.isEmpty()) {
            this.appendNext(topcands, merged, (Map<Edge, List<Edge>>)derivsmap);
        }
        retval.addAll(merged.asEdgeSet());
        if (this._signScorer instanceof ReRankingScorer) {
            ReRankingScorer rescorer = (ReRankingScorer)this._signScorer;
            rescorer.setFullModel(true);
            for (Edge e : retval) {
                e.score = rescorer.score(e.sign, true);
            }
            rescorer.setFullModel(false);
        }
        Collections.sort(retval, edgeComparator);
        return retval;
    }

    private void findKBest(Edge edge, Map<Edge, List<Edge>> derivsmap) {
        if (derivsmap.containsKey(edge)) {
            return;
        }
        List<Candidate> cands = this.getCandidates(edge, derivsmap);
        EdgeHash merged = new EdgeHash();
        while (merged.size() < this._pruneVal && !cands.isEmpty()) {
            this.appendNext(cands, merged, derivsmap);
        }
        ArrayList<Edge> derivs = new ArrayList<Edge>(this._pruneVal);
        derivs.addAll(merged.asEdgeSet());
        Collections.sort(derivs, edgeComparator);
        derivsmap.put(edge, derivs);
    }

    private void appendNext(List<Candidate> cands, EdgeHash merged, Map<Edge, List<Edge>> derivsmap) {
        Candidate cand = cands.remove(0);
        merged.add(cand.edge);
        if (cand.indices == null) {
            return;
        }
        for (int i = 0; i < cand.indices.length; ++i) {
            Candidate nextCand;
            int[] nextIndices = new int[cand.indices.length];
            for (int m = 0; m < nextIndices.length; ++m) {
                nextIndices[m] = cand.indices[m];
            }
            int n = i;
            nextIndices[n] = nextIndices[n] + 1;
            Edge next = this.getEdgeForIndices(cand.edge, cand.inputReps, nextIndices, derivsmap);
            if (next == null || cands.contains(nextCand = new Candidate(next, cand.inputReps, nextIndices))) continue;
            int index = Collections.binarySearch(cands, nextCand);
            if ((index = Math.abs(index) - 1) >= 0) {
                cands.add(index, nextCand);
                continue;
            }
            cands.add(nextCand);
        }
    }

    private List<Candidate> getCandidates(Edge edge, Map<Edge, List<Edge>> derivsmap) {
        ArrayList<Candidate> retval = new ArrayList<Candidate>(this._pruneVal);
        ArrayList<Edge> alts = new ArrayList<Edge>(edge.getAltEdges());
        if (alts.isEmpty()) {
            alts.add(edge);
        }
        for (Edge alt : alts) {
            Sign[] inputs = alt.sign.getDerivationHistory().getInputs();
            if (inputs == null) {
                retval.add(new Candidate(alt, null, null));
                continue;
            }
            Edge[] inputReps = new Edge[inputs.length];
            int[] indices = new int[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                inputReps[i] = Edge.getEdge(inputs[i]);
                indices[i] = 0;
            }
            Edge e = this.getEdgeForIndices(alt, inputReps, indices, derivsmap);
            if (e == null) continue;
            retval.add(new Candidate(e, inputReps, indices));
        }
        this.sortAndPrune(retval);
        return retval;
    }

    private Edge getEdgeForIndices(Edge edge, Edge[] inputReps, int[] indices, Map<Edge, List<Edge>> derivsmap) {
        DerivationHistory history = edge.sign.getDerivationHistory();
        Sign[] combo = new Sign[inputReps.length];
        for (int i = 0; i < inputReps.length; ++i) {
            Edge inputEdge = inputReps[i];
            this.findKBest(inputEdge, derivsmap);
            List<Edge> inputDerivs = derivsmap.get(inputEdge);
            if (indices[i] >= inputDerivs.size()) {
                return null;
            }
            combo[i] = inputDerivs.get((int)indices[i]).sign;
        }
        Sign[] inputSigns = history.getInputs();
        if (this.sameSigns(inputSigns, combo)) {
            return edge;
        }
        Rule rule = history.getRule();
        ArrayList<Sign> results = new ArrayList<Sign>(1);
        ((AbstractRule)rule).applyRule(combo, results);
        if (results.isEmpty()) {
            return null;
        }
        Sign sign = (Sign)results.get(0);
        Edge retval = new Edge(sign);
        ++this._numUnpackingEdges;
        boolean complete = sign.getWords().size() == this._size;
        retval.setScore(this._signScorer.score(sign, complete));
        return retval;
    }

    private void sortAndPrune(List<Candidate> cands) {
        Collections.sort(cands);
        while (cands.size() > this._pruneVal) {
            cands.remove(cands.size() - 1);
        }
    }

    public void saveChartEntries(File file) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        out.writeObject(this._table);
        out.flush();
        out.close();
    }

    public void loadChartEntries(File file) throws IOException {
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            this._table = (Cell[][])in.readObject();
            this._size = this._table.length;
            this._numUnpackingEdges = 0;
        }
        catch (ClassNotFoundException e) {
            in.close();
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        in.close();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._size; ++i) {
            for (int j = 0; j < this._size; ++j) {
                sb.append(this.get(i, j).size()).append('\t');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public void printChart() {
        int p;
        int p2;
        int pad;
        int[] sizes = new int[this._size];
        int rows = 0;
        for (int i = 0; i < this._size; ++i) {
            for (int j = i; j < this._size; ++j) {
                if (this.get(i, j).size() <= sizes[i]) continue;
                sizes[i] = this.get(i, j).size();
            }
            rows += sizes[i];
        }
        String[][] toprint = new String[rows][this._size];
        String[] words = new String[this._size];
        int maxwidth = 0;
        int i = 0;
        int row = 0;
        while (i < this._size) {
            for (int j = 0; j < this._size; ++j) {
                for (int s = 0; s < sizes[i]; ++s) {
                    SignHash cell = this.getSigns(i, j);
                    if (i == j) {
                        words[i] = cell.asSignSet().iterator().next().getOrthography();
                    }
                    if (cell.size() < s + 1) continue;
                    toprint[row + s][j] = ((Sign)cell.toArray()[s]).getCategory().toString();
                    if (toprint[row + s][j].length() <= maxwidth) continue;
                    maxwidth = toprint[row + s][j].length();
                }
            }
            row += sizes[i++];
        }
        int fullwidth = this._size * (maxwidth + 3) - 1;
        System.out.print(" ");
        for (String w : words) {
            System.out.print(w);
            pad = maxwidth + 3 - w.length();
            for (p2 = 0; p2 < pad; ++p2) {
                System.out.print(" ");
            }
        }
        System.out.print("|");
        System.out.println();
        for (p = 0; p < fullwidth; ++p) {
            System.out.print("-");
        }
        System.out.print("| ");
        System.out.println();
        int entry = sizes[0];
        int e = 0;
        for (int i2 = 0; i2 < rows; ++i2) {
            if (i2 == entry) {
                System.out.print("|");
                for (int p3 = 0; p3 < fullwidth; ++p3) {
                    System.out.print("-");
                }
                System.out.print("|");
                System.out.println();
                entry += sizes[++e];
            }
            System.out.print("| ");
            for (int j = 0; j < this._size; ++j) {
                pad = 1 + maxwidth;
                if (toprint[i2][j] != null) {
                    System.out.print(toprint[i2][j]);
                    pad -= toprint[i2][j].length();
                }
                for (p2 = 0; p2 < pad; ++p2) {
                    System.out.print(" ");
                }
                System.out.print("| ");
            }
            System.out.println();
        }
        System.out.print("|");
        for (p = 0; p < fullwidth; ++p) {
            System.out.print("-");
        }
        System.out.print("| ");
        System.out.println();
    }

    static /* synthetic */ Map access$000() {
        return Chart.createEdgeMap();
    }

    private static class Candidate
    implements Comparable<Candidate> {
        Edge edge;
        Edge[] inputReps;
        int[] indices;

        Candidate(Edge edge, Edge[] inputReps, int[] indices) {
            this.edge = edge;
            this.inputReps = inputReps;
            this.indices = indices;
        }

        @Override
        public int compareTo(Candidate c) {
            int retval = edgeComparator.compare(this.edge, c.edge);
            if (retval != 0) {
                return retval;
            }
            if (this.indices == null && c.indices == null) {
                return 0;
            }
            if (this.indices == null && c.indices != null) {
                return -1;
            }
            if (this.indices != null && c.indices == null) {
                return 1;
            }
            if (this.indices.length < c.indices.length) {
                return -1;
            }
            if (this.indices.length > c.indices.length) {
                return 1;
            }
            for (int i = 0; i < this.indices.length; ++i) {
                if (this.indices[i] < c.indices[i]) {
                    return -1;
                }
                if (this.indices[i] <= c.indices[i]) continue;
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Candidate)) {
                return false;
            }
            Candidate c = (Candidate)o;
            if (this.indices != null && c.indices == null) {
                return false;
            }
            if (this.indices == null && c.indices != null) {
                return false;
            }
            if (this.indices != null && c.indices != null) {
                if (this.indices.length != c.indices.length) {
                    return false;
                }
                for (int i = 0; i < this.indices.length; ++i) {
                    if (this.indices[i] == c.indices[i]) continue;
                    return false;
                }
            }
            return this.edge.equals(c.edge);
        }
    }

    private class Cell
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final List<Edge> list = new ArrayList<Edge>();
        final Map<Edge, Edge> map = Chart.access$000();

        private Cell() {
        }

        int size() {
            return this.list.size();
        }

        Edge get(Edge edge) {
            return this.map.get(edge);
        }

        boolean add(Edge edge) {
            if (this.map.containsKey(edge)) {
                return false;
            }
            return Chart.this.addEdgeSorted(edge, this.list, this.map, Chart.this._cellLimit);
        }

        List<Sign> getSignsSorted() {
            ArrayList<Sign> retval = new ArrayList<Sign>(this.list.size());
            for (Edge e : this.list) {
                retval.add(e.sign);
            }
            return retval;
        }

        SignHash getSigns() {
            SignHash retval = new SignHash();
            for (Edge e : this.list) {
                retval.insert(e.sign);
            }
            return retval;
        }
    }
}

