/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.realize;

import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import opennlp.ccg.TextCCG;
import opennlp.ccg.grammar.FragmentJoining;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.grammar.Rule;
import opennlp.ccg.grammar.RuleGroup;
import opennlp.ccg.grammar.TypeChangingRule;
import opennlp.ccg.hylo.Alt;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.hylo.NominalAtom;
import opennlp.ccg.hylo.SatOp;
import opennlp.ccg.lexicon.Lexicon;
import opennlp.ccg.lexicon.LicensingFeature;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.realize.Edge;
import opennlp.ccg.realize.EdgeCombos;
import opennlp.ccg.realize.FeatureLicenser;
import opennlp.ccg.realize.Hypertagger;
import opennlp.ccg.realize.RuleInstance;
import opennlp.ccg.synsem.Arg;
import opennlp.ccg.synsem.AtomCat;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.CategoryFcn;
import opennlp.ccg.synsem.CategoryFcnAdapter;
import opennlp.ccg.synsem.ComplexCat;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.synsem.SignScorer;
import opennlp.ccg.unify.FeatureStructure;
import opennlp.ccg.unify.SimpleSubstitution;
import opennlp.ccg.unify.Substitution;
import opennlp.ccg.unify.Unifier;
import opennlp.ccg.unify.UnifyControl;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.util.Pair;

public class EdgeFactory {
    public static final String USE_INDEXING = "Use Indexing";
    public static final String ALLOW_MISSING_INDEX_COMBOS = "Allow Missing Index Combos";
    public static final String USE_CHUNKS = "Use Chunks";
    public static final String USE_FEATURE_LICENSING = "Use Feature Licensing";
    public final Grammar grammar;
    public final List<SatOp> preds;
    public final SignScorer signScorer;
    public final Hypertagger hypertagger;
    public final List<Edge> initialEdges = new ArrayList<Edge>();
    public final List<Edge> markedEdges = new ArrayList<Edge>();
    public final List<Edge> instantiatedNoSemEdges = new ArrayList<Edge>();
    public final List<Edge> noSemEdges = new ArrayList<Edge>();
    public final List<RuleInstance> ruleInstances = new ArrayList<RuleInstance>();
    public final List<BitSet> lfChunks = new ArrayList<BitSet>();
    public final List<List<Alt>> lfAlts = new ArrayList<List<Alt>>();
    public final List<BitSet> lfOpts = new ArrayList<BitSet>();
    public boolean hasLfAltsOrOpts = false;
    private final BitSet allPreds;
    private final Lexicon lexicon;
    private final RuleGroup generalRules;
    private final RuleGroup ruleInstancesGroup;
    private final FragmentJoining fragmentRule = new FragmentJoining();
    private final FeatureLicenser featureLicenser;
    public final Set<Nominal> labeledNominals = new HashSet<Nominal>();
    final TObjectIntHashMap nominals = new TObjectIntHashMap();
    private final Map<String, List<Integer>> predMap = new HashMap<String, List<Integer>>();
    private final List<BitSet[]> pairedNominals = new ArrayList<BitSet[]>();
    private boolean anyPairedNominals = false;
    final Set<Nominal> boundVarNominals = new HashSet<Nominal>();
    private final List<Object> catNominals = new ArrayList<Object>();
    public boolean useIndexing = true;
    private boolean allowMissingIndexCombos = false;
    private boolean useChunks = true;
    private boolean useFeatureLicensing = true;
    public boolean debugInstantiation = false;
    private int unaryRuleApps = 0;
    private int unaryRuleInstApps = 0;
    private int binaryRuleApps = 0;
    public boolean gluingFragments = false;
    protected BitSet uncoveredEPs = null;
    public boolean hasUncoveredPreds = false;
    protected boolean useRelaxedRelationMatching = Boolean.getBoolean("useRelaxedRelationMatching");
    private CategoryFcn gatherIndices = new CategoryFcnAdapter(){

        @Override
        public void forall(Category c) {
            if (!(c instanceof AtomCat)) {
                return;
            }
            FeatureStructure fs = c.getFeatureStructure();
            if (fs == null) {
                return;
            }
            EdgeFactory.this.addCatNominal(fs.getValue("index"));
            EdgeFactory.this.addCatNominal(fs.getValue("mod-index"));
        }
    };
    private BitSet tmpBitSet = new BitSet();
    private BitSet tmpBitSetCompleteness = new BitSet();
    private BitSet tmpBitSetRetval = new BitSet();

    public EdgeFactory(Grammar grammar, List<SatOp> preds, SignScorer signScorer) {
        this(grammar, preds, signScorer, null);
    }

    public EdgeFactory(Grammar grammar, List<SatOp> preds, SignScorer signScorer, Hypertagger hypertagger) {
        this.grammar = grammar;
        this.preds = preds;
        this.signScorer = signScorer;
        this.hypertagger = hypertagger;
        this.lexicon = grammar.lexicon;
        this.generalRules = new RuleGroup(grammar);
        this.generalRules.borrowSupercatRuleCombos(grammar.rules);
        this.ruleInstancesGroup = new RuleGroup(grammar);
        this.ruleInstancesGroup.borrowSupercatRuleCombos(grammar.rules);
        this.allPreds = new BitSet(preds.size());
        this.allPreds.set(0, preds.size());
        Preferences prefs = Preferences.userNodeForPackage(TextCCG.class);
        this.useIndexing = prefs.getBoolean(USE_INDEXING, true);
        this.allowMissingIndexCombos = prefs.getBoolean(ALLOW_MISSING_INDEX_COMBOS, false);
        this.useChunks = prefs.getBoolean(USE_CHUNKS, true);
        this.useFeatureLicensing = prefs.getBoolean(USE_FEATURE_LICENSING, true);
        this.featureLicenser = this.useFeatureLicensing ? new FeatureLicenser(this) : new FeatureLicenser(this, new LicensingFeature[]{LicensingFeature.simpleLexFeature});
        UnifyControl.startUnifySequence();
        this.extractLabeledNominals();
        this.indexPreds();
        this.listNominals();
        this.listPairedNominals();
        this.addBoundVarNominals();
        this.fillLfChunks();
        this.fillLfAlts();
        this.fillLfOpts();
        boolean bl = this.hasLfAltsOrOpts = this.lfAlts.size() > 0 || this.lfOpts.size() > 0;
        if (hypertagger != null) {
            hypertagger.mapPreds(preds);
        }
    }

    public void addLFOptsForUncoveredPreds() {
        if (this.uncoveredEPs == null) {
            return;
        }
        BitSet opt = (BitSet)this.uncoveredEPs.clone();
        for (BitSet chunk : this.lfChunks) {
            if (!opt.intersects(chunk)) continue;
            BitSet optChunk = (BitSet)opt.clone();
            optChunk.and(chunk);
            if (!this.lfOpts.contains(optChunk)) {
                this.lfOpts.add(optChunk);
            }
            opt.andNot(optChunk);
        }
        if (!opt.isEmpty() && !this.lfOpts.contains(opt)) {
            this.lfOpts.add(opt);
        }
        this.hasLfAltsOrOpts = true;
    }

    public void addLFOptsForRuleInstances() {
        for (RuleInstance ruleInstance : this.ruleInstances) {
            BitSet opt = (BitSet)ruleInstance.bitset.clone();
            this.lfOpts.add(opt);
        }
        if (this.lfOpts.size() > 0) {
            this.hasLfAltsOrOpts = true;
        }
    }

    private BitSet uncoveredPreds() {
        BitSet retval = new BitSet(this.preds.size());
        for (Edge edge : this.initialEdges) {
            retval.or(edge.bitset);
        }
        for (Edge edge : this.markedEdges) {
            retval.or(edge.bitset);
        }
        for (RuleInstance ruleInstance : this.ruleInstances) {
            retval.or(ruleInstance.bitset);
        }
        if (retval.equals(this.allPreds)) {
            return null;
        }
        retval.xor(this.allPreds);
        int i = retval.nextSetBit(0);
        while (i >= 0) {
            SatOp pred = this.preds.get(i);
            if (HyloHelper.isLexPred(pred) || HyloHelper.isAttrPred(pred)) {
                this.hasUncoveredPreds = true;
                break;
            }
            i = retval.nextSetBit(i + 1);
        }
        return retval;
    }

    protected Edge makeEdge(Sign sign, BitSet bitset, List<List<Alt>> activeLfAlts) {
        BitSet indices = this.getIndices(sign.getCategory(), null);
        float completeness = (float)bitset.cardinality() / (float)this.preds.size();
        boolean complete = (double)completeness == 1.0;
        double score = this.signScorer.score(sign, complete);
        BitSet incompleteLfChunk = this.getIncompleteLfChunk(bitset, activeLfAlts);
        return new Edge(sign, bitset, indices, completeness, score, activeLfAlts, incompleteLfChunk);
    }

    protected Edge makeAltEdge(Sign altSign, Edge edge) {
        double score = this.signScorer.score(altSign, edge.complete());
        return new Edge(altSign, edge.bitset, edge.indices, edge.completeness, score, edge.activeLfAlts, edge.incompleteLfChunk);
    }

    public Edge makeJoinedEdge(Edge edge1, Edge edge2) {
        Sign sign = this.fragmentRule.applyRule(edge1.sign, edge2.sign);
        BitSet bitset = (BitSet)edge1.bitset.clone();
        bitset.or(edge2.bitset);
        float completeness = (float)bitset.cardinality() / (float)this.preds.size();
        boolean complete = (double)completeness == 1.0;
        double score = this.signScorer.score(sign, complete);
        return new Edge(sign, bitset, edge1.indices, completeness, score, edge1.activeLfAlts, edge1.incompleteLfChunk);
    }

    private List<List<Alt>> getActiveLfAlts(List<List<Alt>> fromLfAlts, BitSet bitset) {
        if (fromLfAlts.isEmpty()) {
            return fromLfAlts;
        }
        boolean checkingAllAlts = fromLfAlts == this.lfAlts;
        BitSet tmpBitSet = new BitSet(bitset.size());
        ArrayList<List<Alt>> retval = new ArrayList<List<Alt>>(fromLfAlts.size());
        for (List<Alt> altSet : fromLfAlts) {
            ArrayList<Alt> activeAltSet = null;
            boolean foundCoveredAlt = false;
            for (Alt alt : altSet) {
                if (checkingAllAlts && !alt.bitset.intersects(bitset)) continue;
                tmpBitSet.clear();
                tmpBitSet.or(bitset);
                tmpBitSet.and(alt.bitset);
                if (tmpBitSet.equals(alt.bitset)) {
                    foundCoveredAlt = true;
                    break;
                }
                if (activeAltSet == null) {
                    activeAltSet = new ArrayList<Alt>(3);
                }
                activeAltSet.add(alt);
            }
            if (foundCoveredAlt) {
                List<Alt> fullAltSet = this.lfAlts.get(altSet.get((int)0).altSet);
                for (Alt alt : fullAltSet) {
                    bitset.or(alt.bitset);
                }
                continue;
            }
            if (activeAltSet == null) continue;
            retval.add(activeAltSet);
        }
        return retval;
    }

    private List<List<Alt>> getCombinedLfAlts(List<List<Alt>> activeLfAlts1, List<List<Alt>> activeLfAlts2) {
        if (activeLfAlts1.isEmpty()) {
            return activeLfAlts2;
        }
        if (activeLfAlts2.isEmpty()) {
            return activeLfAlts1;
        }
        ArrayList<List<Alt>> retval = new ArrayList<List<Alt>>(activeLfAlts1.size() + activeLfAlts2.size());
        Iterator<List<Alt>> it1 = activeLfAlts1.iterator();
        Iterator<List<Alt>> it2 = activeLfAlts2.iterator();
        List<Alt> altSet1 = it1.next();
        List<Alt> altSet2 = it2.next();
        for (int i = 0; i < this.lfAlts.size(); ++i) {
            if (altSet1.get((int)0).altSet < i && it1.hasNext()) {
                altSet1 = it1.next();
            }
            if (altSet2.get((int)0).altSet < i && it2.hasNext()) {
                altSet2 = it2.next();
            }
            if (altSet1.get((int)0).altSet == i && altSet2.get((int)0).altSet != i) {
                retval.add(altSet1);
                continue;
            }
            if (altSet2.get((int)0).altSet == i && altSet1.get((int)0).altSet != i) {
                retval.add(altSet2);
                continue;
            }
            if (altSet1.get((int)0).altSet != i || altSet2.get((int)0).altSet != i) continue;
            ArrayList<Alt> combined = new ArrayList<Alt>(Math.min(altSet1.size(), altSet2.size()));
            for (Alt alt : altSet1) {
                if (!altSet2.contains(alt)) continue;
                combined.add(alt);
            }
            if (combined.isEmpty()) {
                return null;
            }
            retval.add(combined);
        }
        return retval;
    }

    private void extractLabeledNominals() {
        Iterator<SatOp> it = this.preds.iterator();
        while (it.hasNext()) {
            String rel;
            Nominal nom1;
            SatOp pred = it.next();
            if (!HyloHelper.isAttrPred(pred) || !((nom1 = HyloHelper.getPrincipalNominal(pred)) instanceof NominalAtom) || (rel = HyloHelper.getRel(pred)) == null || !rel.equals("mark")) continue;
            this.labeledNominals.add(nom1);
            it.remove();
        }
    }

    private void listNominals() {
        for (SatOp pred : this.preds) {
            Nominal nom1 = HyloHelper.getPrincipalNominal(pred);
            Nominal nom2 = HyloHelper.getSecondaryNominal(pred);
            if (nom1 instanceof NominalAtom && !this.nominals.containsKey((Object)nom1)) {
                this.nominals.put((Object)nom1, this.nominals.size());
            }
            if (!(nom2 instanceof NominalAtom) || this.nominals.containsKey((Object)nom2)) continue;
            this.nominals.put((Object)nom2, this.nominals.size());
        }
    }

    private BitSet getIndices(Category cat, Category cat2) {
        this.catNominals.clear();
        cat.forall(this.gatherIndices);
        if (cat2 != null) {
            cat2.forall(this.gatherIndices);
        }
        BitSet retval = new BitSet(this.nominals.size());
        for (Object nom : this.catNominals) {
            int index = this.nominals.get(nom);
            retval.set(index);
        }
        return retval;
    }

    private void checkInstantiation(List<Edge> edges) {
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.get(i);
            if (this.noSemEdges.contains(edge) || !this.outerArgUninstantiated(edge.sign.getCategory())) continue;
            edge.indices.set(0, this.nominals.size());
            if (!this.debugInstantiation) continue;
            System.err.println("Warning: outer arg uninstantiated: " + edge.sign);
        }
    }

    private boolean outerArgUninstantiated(Category cat) {
        if (!(cat instanceof ComplexCat)) {
            return false;
        }
        Arg outer = ((ComplexCat)cat).getOuterArg();
        this.catNominals.clear();
        outer.forall(this.gatherIndices);
        return this.catNominals.isEmpty();
    }

    private void addCatNominal(Object indexVal) {
        if (indexVal instanceof NominalAtom && !this.catNominals.contains(indexVal)) {
            this.catNominals.add(indexVal);
        }
    }

    private void listPairedNominals() {
        for (int i = 0; i < this.preds.size(); ++i) {
            SatOp predJ;
            SatOp pred = this.preds.get(i);
            if (!"tup".equals(HyloHelper.getLexPred(pred))) continue;
            Nominal tupNom = HyloHelper.getPrincipalNominal(pred);
            Nominal nom1 = null;
            Nominal nom2 = null;
            for (int j = i + 1; j < this.preds.size() && tupNom.equals(HyloHelper.getPrincipalNominal(predJ = this.preds.get(j))); ++j) {
                if ("Item1".equals(HyloHelper.getRel(predJ))) {
                    nom1 = HyloHelper.getSecondaryNominal(predJ);
                }
                if (!"Item2".equals(HyloHelper.getRel(predJ))) continue;
                nom2 = HyloHelper.getSecondaryNominal(predJ);
            }
            if (nom1 == null || nom2 == null) {
                System.err.println("Warning, couldn't find paired nominals for tuple: " + tupNom);
                continue;
            }
            if (!(nom1 instanceof NominalAtom) || !(nom2 instanceof NominalAtom)) continue;
            BitSet[] pair = new BitSet[2];
            pair[0] = new BitSet(this.nominals.size());
            pair[0].set(this.nominals.get((Object)nom1));
            pair[1] = new BitSet(this.nominals.size());
            pair[1].set(this.nominals.get((Object)nom2));
            this.pairedNominals.add(pair);
            this.anyPairedNominals = true;
        }
    }

    private void addBoundVarNominals() {
        for (int i = 0; i < this.preds.size(); ++i) {
            Nominal nom2;
            SatOp pred = this.preds.get(i);
            String rel = HyloHelper.getRel(pred);
            if (rel == null || !rel.equals("BoundVar") || !((nom2 = HyloHelper.getSecondaryNominal(pred)) instanceof NominalAtom)) continue;
            this.boundVarNominals.add(nom2);
            for (int j = 0; j < this.preds.size(); ++j) {
                SatOp predK;
                SatOp predJ = this.preds.get(j);
                if (!nom2.equals(HyloHelper.getPrincipalNominal(predJ)) || !"tup".equals(HyloHelper.getLexPred(predJ))) continue;
                for (int k = j + 1; k < this.preds.size() && nom2.equals(HyloHelper.getPrincipalNominal(predK = this.preds.get(k))); ++k) {
                    Nominal nom2K;
                    String relK = HyloHelper.getRel(predK);
                    if (!"Item1".equals(relK) && !"Item2".equals(relK) || !((nom2K = HyloHelper.getSecondaryNominal(predK)) instanceof NominalAtom)) continue;
                    this.boundVarNominals.add(nom2K);
                }
            }
        }
    }

    public boolean pairedWith(Edge edgeA, Edge edgeB) {
        for (int i = 0; i < this.pairedNominals.size(); ++i) {
            BitSet[] pair = this.pairedNominals.get(i);
            if (!pair[0].equals(edgeA.indices) || !pair[1].equals(edgeB.indices)) continue;
            return true;
        }
        return false;
    }

    private void indexPreds() {
        for (int i = 0; i < this.preds.size(); ++i) {
            String[] keys = EdgeFactory.predKeys(this.preds.get(i));
            for (int j = 0; j < keys.length; ++j) {
                List<Integer> indices = this.predMap.get(keys[j]);
                if (indices == null) {
                    indices = new ArrayList<Integer>(1);
                    this.predMap.put(keys[j], indices);
                }
                indices.add(i);
            }
        }
    }

    private static String[] predKeys(LF pred) {
        Nominal nom = HyloHelper.getPrincipalNominal(pred);
        String lexPred = HyloHelper.getLexPred(pred);
        String rel = HyloHelper.getRel(pred);
        Nominal nom2 = HyloHelper.getSecondaryNominal(pred);
        ArrayList<String> keys = new ArrayList<String>(2);
        if (nom instanceof NominalAtom && lexPred != null) {
            keys.add(nom.toString() + "(" + lexPred + ")");
        }
        if (nom instanceof NominalAtom && rel != null) {
            keys.add(nom.toString() + "<" + rel + ">");
        }
        if (nom2 instanceof NominalAtom && rel != null) {
            keys.add("<" + rel + ">" + nom2.toString());
        }
        return keys.toArray(new String[keys.size()]);
    }

    private void fillLfChunks() {
        for (int i = 0; i < this.preds.size(); ++i) {
            SatOp pred = this.preds.get(i);
            TIntArrayList chunks = pred.getChunks();
            if (chunks == null) continue;
            for (int j = 0; j < chunks.size(); ++j) {
                int chunkId = chunks.get(j);
                while (this.lfChunks.size() < chunkId + 1) {
                    this.lfChunks.add(new BitSet(this.preds.size()));
                }
                BitSet chunk = this.lfChunks.get(chunkId);
                chunk.set(i);
            }
        }
        ArrayList<BitSet> tmpList = new ArrayList<BitSet>(this.lfChunks);
        this.lfChunks.clear();
        block3: for (BitSet chunk : tmpList) {
            for (int i = 0; i < this.lfChunks.size(); ++i) {
                BitSet sortedChunk = this.lfChunks.get(i);
                if (!this.subset(chunk, sortedChunk)) continue;
                this.lfChunks.add(i, chunk);
                continue block3;
            }
            this.lfChunks.add(chunk);
        }
    }

    private BitSet getIncompleteLfChunk(BitSet bitset, List<List<Alt>> activeLfAlts) {
        block0: for (BitSet lfChunk : this.lfChunks) {
            if (!lfChunk.intersects(bitset) || this.subset(lfChunk, bitset) || !this.subset(bitset, lfChunk)) continue;
            for (List<Alt> altSet : activeLfAlts) {
                for (Alt alt : altSet) {
                    if (this.subset(lfChunk, alt.bitset)) continue;
                    continue block0;
                }
            }
            return lfChunk;
        }
        return null;
    }

    private boolean subset(BitSet bitset1, BitSet bitset2) {
        this.tmpBitSet.clear();
        this.tmpBitSet.or(bitset1);
        this.tmpBitSet.andNot(bitset2);
        return this.tmpBitSet.isEmpty();
    }

    private boolean completesChunk(Edge edgeA, Edge edgeB) {
        if (edgeA.incompleteLfChunk != null) {
            this.tmpBitSet.clear();
            this.tmpBitSet.or(edgeA.incompleteLfChunk);
            this.tmpBitSet.andNot(edgeA.bitset);
            this.tmpBitSet.andNot(edgeB.bitset);
            if (this.tmpBitSet.isEmpty()) {
                return true;
            }
        }
        if (edgeB.incompleteLfChunk != null) {
            this.tmpBitSet.clear();
            this.tmpBitSet.or(edgeB.incompleteLfChunk);
            this.tmpBitSet.andNot(edgeA.bitset);
            this.tmpBitSet.andNot(edgeB.bitset);
            if (this.tmpBitSet.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private void fillLfAlts() {
        for (int i = 0; i < this.preds.size(); ++i) {
            SatOp pred = this.preds.get(i);
            List<Alt> alts = pred.getAlts();
            if (alts == null) continue;
            for (Alt alt : alts) {
                while (this.lfAlts.size() < alt.altSet + 1) {
                    this.lfAlts.add(null);
                }
                List<Alt> altSet = this.lfAlts.get(alt.altSet);
                if (altSet == null) {
                    altSet = new ArrayList<Alt>(5);
                    this.lfAlts.set(alt.altSet, altSet);
                }
                while (altSet.size() < alt.numInSet + 1) {
                    altSet.add(null);
                }
                altSet.set(alt.numInSet, alt);
                alt.bitset.set(i);
            }
        }
    }

    private void fillLfOpts() {
        for (int i = 0; i < this.preds.size(); ++i) {
            SatOp pred = this.preds.get(i);
            TIntArrayList opts = pred.getOpts();
            if (opts == null) continue;
            for (int j = 0; j < opts.size(); ++j) {
                int optId = opts.get(j);
                while (this.lfOpts.size() < optId + 1) {
                    this.lfOpts.add(new BitSet(this.preds.size()));
                }
                BitSet opt = this.lfOpts.get(optId);
                opt.set(i);
            }
        }
    }

    private List<String> getCoartRels(int predIndex) {
        SatOp relPred;
        SatOp pred = this.preds.get(predIndex);
        Nominal nom = HyloHelper.getPrincipalNominal(pred);
        ArrayList<String> retval = null;
        for (int i = predIndex + 1; i < this.preds.size() && nom.equals(HyloHelper.getPrincipalNominal(relPred = this.preds.get(i))); ++i) {
            String rel = HyloHelper.getRel(relPred);
            if (rel == null || !this.grammar.lexicon.isCoartRel(rel)) continue;
            if (retval == null) {
                retval = new ArrayList<String>(3);
            }
            retval.add(rel);
        }
        return retval;
    }

    public List<Edge> createInitialEdges() {
        int prevSize;
        ArrayList<Edge> markedEdgesForLicensing = new ArrayList<Edge>();
        for (int i = 0; i < this.preds.size(); ++i) {
            SatOp pred = this.preds.get(i);
            String key = HyloHelper.getLexPred(pred);
            String rel = HyloHelper.getRel(pred);
            if (key == null && rel == null) continue;
            if (this.hypertagger != null) {
                this.hypertagger.setPred(i);
            }
            ArrayList<Sign> signs = new ArrayList<Sign>();
            ArrayList<TypeChangingRule> typeChangingRules = new ArrayList<TypeChangingRule>();
            if (key != null) {
                Collection<TypeChangingRule> lexPredRules;
                List<String> coartRels = this.getCoartRels(i);
                Collection<Sign> lexPredSigns = this.lexicon.getSignsFromPred(key, coartRels);
                if (lexPredSigns != null) {
                    signs.addAll(lexPredSigns);
                }
                if ((lexPredRules = this.grammar.rules.getRulesForPred(key)) != null) {
                    typeChangingRules.addAll(lexPredRules);
                }
            }
            if (rel != null) {
                Collection<TypeChangingRule> indexedRelRules;
                Collection<Sign> indexedRelSigns = this.lexicon.getSignsFromRel(rel);
                if (indexedRelSigns != null) {
                    signs.addAll(indexedRelSigns);
                }
                if ((indexedRelRules = this.grammar.rules.getRulesForRel(rel)) != null) {
                    typeChangingRules.addAll(indexedRelRules);
                }
            }
            for (Sign sign : signs) {
                List<Edge> initialEdgesForSign = this.createInitialEdges(sign, i);
                if (initialEdgesForSign == null) continue;
                for (Edge initialEdge : initialEdgesForSign) {
                    Category cat = initialEdge.sign.getCategory();
                    if (this.featureLicenser.needsLicensing(cat)) {
                        markedEdgesForLicensing.add(initialEdge);
                        continue;
                    }
                    this.initialEdges.add(initialEdge);
                    this.featureLicenser.updateFeatureMap(cat);
                }
            }
            for (TypeChangingRule rule : typeChangingRules) {
                List<RuleInstance> ruleInstancesForRule = this.createRuleInstances(rule, i);
                if (ruleInstancesForRule == null) continue;
                for (RuleInstance ruleInst : ruleInstancesForRule) {
                    this.ruleInstances.add(ruleInst);
                    this.featureLicenser.updateFeatureMap(ruleInst.rule.getArg());
                    this.featureLicenser.updateFeatureMap(ruleInst.rule.getResult());
                }
            }
        }
        do {
            prevSize = markedEdgesForLicensing.size();
            Iterator it = markedEdgesForLicensing.iterator();
            while (it.hasNext()) {
                Edge edge = (Edge)it.next();
                Category cat = edge.sign.getCategory();
                if (!this.featureLicenser.isLicensed(cat)) continue;
                this.markedEdges.add(edge);
                it.remove();
                this.featureLicenser.updateFeatureMap(cat);
            }
        } while (markedEdgesForLicensing.size() != prevSize);
        this.initGeneralRules();
        this.initNoSemEdges();
        ArrayList<Edge> retval = new ArrayList<Edge>(this.initialEdges.size() + this.markedEdges.size() + this.instantiatedNoSemEdges.size() + this.noSemEdges.size());
        retval.addAll(this.initialEdges);
        retval.addAll(this.markedEdges);
        retval.addAll(this.instantiatedNoSemEdges);
        retval.addAll(this.noSemEdges);
        this.checkInstantiation(retval);
        this.uncoveredEPs = this.uncoveredPreds();
        if (this.uncoveredEPs != null && this.debugInstantiation) {
            System.err.println("Warning, uncovered preds after lex instantiation: " + Edge.toString(this.uncoveredEPs));
        }
        if (this.useRelaxedRelationMatching) {
            this.addLFOptsForUncoveredPreds();
        }
        return retval;
    }

    private List<Edge> createInitialEdges(Sign sign, int predIndex) {
        List<Word> words = sign.getWords();
        Category cat = sign.getCategory();
        List<Pair<Substitution, BitSet>> instantiations = this.instantiate(cat, null, predIndex);
        if (instantiations == null) {
            return null;
        }
        ArrayList<Edge> retval = new ArrayList<Edge>(instantiations.size());
        for (Pair<Substitution, BitSet> inst : instantiations) {
            Substitution subst = (Substitution)inst.a;
            BitSet bitset = (BitSet)inst.b;
            Category filledCat = null;
            try {
                filledCat = (Category)cat.fill(subst);
            }
            catch (UnifyFailure uf) {
                throw new RuntimeException("Unable to fill cat: " + uf);
            }
            this.featureLicenser.indexSemanticallyNullWords(filledCat);
            Sign newSign = new Sign(words, filledCat);
            newSign.setOrigin();
            List<List<Alt>> activeLfAlts = this.getActiveLfAlts(this.lfAlts, bitset);
            retval.add(this.makeEdge(newSign, bitset, activeLfAlts));
        }
        return retval;
    }

    private List<RuleInstance> createRuleInstances(TypeChangingRule rule, int predIndex) {
        Category arg;
        Category result = rule.getResult();
        List<Pair<Substitution, BitSet>> instantiations = this.instantiate(result, arg = rule.getArg(), predIndex);
        if (instantiations == null) {
            return null;
        }
        ArrayList<RuleInstance> retval = new ArrayList<RuleInstance>(instantiations.size());
        for (Pair<Substitution, BitSet> inst : instantiations) {
            Substitution subst = (Substitution)inst.a;
            BitSet bitset = (BitSet)inst.b;
            Category filledResult = null;
            Category filledArg = null;
            try {
                filledResult = (Category)result.fill(subst);
                filledArg = (Category)arg.fill(subst);
            }
            catch (UnifyFailure uf) {
                throw new RuntimeException("Unable to fill cat: " + uf);
            }
            this.featureLicenser.indexSemanticallyNullWords(filledArg);
            this.featureLicenser.indexSemanticallyNullWords(filledResult);
            BitSet indices = this.getIndices(filledResult, filledArg);
            TypeChangingRule newRule = new TypeChangingRule(filledArg, filledResult, rule.name(), rule.getFirstEP());
            this.ruleInstancesGroup.addRule(newRule);
            List<List<Alt>> activeLfAlts = this.getActiveLfAlts(this.lfAlts, bitset);
            RuleInstance ruleInst = new RuleInstance(newRule, bitset, indices, activeLfAlts);
            retval.add(ruleInst);
        }
        return retval;
    }

    private List<Pair<Substitution, BitSet>> instantiate(Category cat, Category cat2, int predIndex) {
        UnifyControl.reindex(cat, cat2);
        List<SatOp> lfPreds = HyloHelper.getPreds(cat.getLF());
        SimpleSubstitution subst = null;
        SatOp indexedPred = this.preds.get(predIndex);
        int lfPredIndex = -1;
        for (int i = 0; i < lfPreds.size(); ++i) {
            LF lfPred = lfPreds.get(i);
            subst = new SimpleSubstitution();
            try {
                Unifier.unify(lfPred, indexedPred, subst);
                lfPredIndex = i;
                break;
            }
            catch (UnifyFailure unifyFailure) {
                continue;
            }
        }
        if (lfPredIndex == -1) {
            return null;
        }
        BitSet bitset = new BitSet(this.preds.size());
        bitset.set(predIndex);
        ArrayList<SatOp> remainingPreds = new ArrayList<SatOp>(lfPreds.size());
        remainingPreds.addAll(lfPreds);
        remainingPreds.remove(lfPredIndex);
        int prevSize = -1;
        ArrayList<Pair<Substitution, BitSet>> retval = new ArrayList<Pair<Substitution, BitSet>>(3);
        ArrayList<Object> prev = new ArrayList(3);
        retval.add(new Pair<SimpleSubstitution, BitSet>(subst, bitset));
        while (!remainingPreds.isEmpty() && remainingPreds.size() != prevSize) {
            prevSize = remainingPreds.size();
            Iterator it = remainingPreds.iterator();
            while (it.hasNext()) {
                SatOp lfPred = (SatOp)it.next();
                try {
                    lfPred = (SatOp)lfPred.fill(subst);
                }
                catch (UnifyFailure uf) {
                    throw new RuntimeException("Unable to fill lfPred: " + uf);
                }
                String[] lfPredKeys = EdgeFactory.predKeys(lfPred);
                if (lfPredKeys.length == 0) continue;
                ArrayList<Integer> matchingPredIndices = new ArrayList<Integer>(3);
                for (int i = 0; i < lfPredKeys.length; ++i) {
                    List<Integer> indices = this.predMap.get(lfPredKeys[i]);
                    if (indices == null) continue;
                    matchingPredIndices.addAll(indices);
                }
                if (matchingPredIndices.isEmpty()) {
                    if (this.useRelaxedRelationMatching && HyloHelper.isRelPred(lfPred)) continue;
                    return null;
                }
                ArrayList tmp = prev;
                prev = retval;
                retval = tmp;
                retval.clear();
                for (Pair pair : prev) {
                    Substitution s = (Substitution)pair.a;
                    BitSet b = (BitSet)pair.b;
                    if (matchingPredIndices.size() == 1) {
                        int matchingPredIndex = (Integer)matchingPredIndices.get(0);
                        b.set(matchingPredIndex);
                        if (!this.checkAlts(b)) continue;
                        try {
                            SatOp matchingPred = this.preds.get(matchingPredIndex);
                            Unifier.unify(lfPred, matchingPred, s);
                            retval.add(pair);
                        }
                        catch (UnifyFailure matchingPred) {}
                        continue;
                    }
                    Iterator iterator = matchingPredIndices.iterator();
                    while (iterator.hasNext()) {
                        int matchingPredIndex = (Integer)iterator.next();
                        SimpleSubstitution s2 = new SimpleSubstitution((SimpleSubstitution)s);
                        BitSet b2 = (BitSet)b.clone();
                        b2.set(matchingPredIndex);
                        if (!this.checkAlts(b2)) continue;
                        try {
                            SatOp matchingPred = this.preds.get(matchingPredIndex);
                            Unifier.unify(lfPred, matchingPred, s2);
                            Pair<SimpleSubstitution, BitSet> inst2 = new Pair<SimpleSubstitution, BitSet>(s2, b2);
                            retval.add(inst2);
                        }
                        catch (UnifyFailure unifyFailure) {}
                    }
                }
                if (retval.isEmpty()) {
                    if (this.useRelaxedRelationMatching && HyloHelper.isRelPred(lfPred)) {
                        retval.addAll(prev);
                        continue;
                    }
                    return null;
                }
                it.remove();
            }
        }
        if (remainingPreds.size() > 1) {
            return null;
        }
        return retval;
    }

    private boolean checkAlts(BitSet b) {
        for (List<Alt> altSet : this.lfAlts) {
            int intersects = 0;
            for (Alt alt : altSet) {
                if (!alt.bitset.intersects(b)) continue;
                ++intersects;
            }
            if (intersects <= true) continue;
            for (int i = 0; i < altSet.size(); ++i) {
                Alt alt;
                alt = altSet.get(i);
                if (!alt.bitset.intersects(b)) continue;
                for (int j = i + 1; j < altSet.size(); ++j) {
                    Alt alt2 = altSet.get(j);
                    if (!alt2.bitset.intersects(b)) continue;
                    BitSet altOnly = (BitSet)alt.bitset.clone();
                    altOnly.andNot(alt2.bitset);
                    BitSet alt2Only = (BitSet)alt2.bitset.clone();
                    alt2Only.andNot(alt.bitset);
                    if (!altOnly.intersects(b) || !alt2Only.intersects(b)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public List<Edge> createNewEdges(Edge edge, Edge next) {
        return this.createNewEdges(edge, next, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Edge> createNewEdges(Edge edge, Edge next, boolean collectCombos) {
        if (edge.intersects(next)) {
            return Collections.emptyList();
        }
        if (!(!this.useChunks || edge.meetsLfChunkConstraints(next) && next.meetsLfChunkConstraints(edge))) {
            return Collections.emptyList();
        }
        List<Edge> newEdges = null;
        if (this.useIndexing) {
            if (edge.indicesIntersect(next)) {
                newEdges = this.createNewEdges(edge, next, collectCombos, true);
            } else if (this.anyPairedNominals && this.pairedWith(edge, next)) {
                newEdges = this.createNewEdges(edge, next, collectCombos, false);
            } else if (this.anyPairedNominals && this.pairedWith(next, edge)) {
                newEdges = this.createNewEdges(next, edge, collectCombos, false);
            } else {
                if (!this.allowMissingIndexCombos || edge.getIndexNominal() != null && next.getIndexNominal() != null) return Collections.emptyList();
                newEdges = this.createNewEdges(edge, next, collectCombos, true);
            }
        } else {
            newEdges = this.createNewEdges(edge, next, collectCombos, true);
        }
        if (collectCombos && edge.altEdges.size() > 0) {
            int numNewEdges = newEdges.size();
            for (int i = 0; i < numNewEdges; ++i) {
                Edge resultEdge = newEdges.get(i);
                Sign resultSign = resultEdge.sign;
                Category resultCat = resultSign.getCategory();
                Rule rule = resultSign.getDerivationHistory().getRule();
                Sign[] resultInputs = resultSign.getDerivationHistory().getInputs();
                boolean rightward = resultInputs[0] == next.sign;
                boolean lefthead = resultSign.getLexHead() == resultInputs[0].getLexHead();
                for (int j = 0; j < edge.altEdges.size(); ++j) {
                    Sign[] signArray;
                    Edge furtherEdge = edge.altEdges.get(j);
                    if (furtherEdge == edge) continue;
                    if (rightward) {
                        Sign[] signArray2 = new Sign[2];
                        signArray2[0] = next.sign;
                        signArray = signArray2;
                        signArray2[1] = furtherEdge.sign;
                    } else {
                        Sign[] signArray3 = new Sign[2];
                        signArray3[0] = furtherEdge.sign;
                        signArray = signArray3;
                        signArray3[1] = next.sign;
                    }
                    Sign[] signs = signArray;
                    Sign lexHead = rightward == lefthead ? next.sign.getLexHead() : furtherEdge.sign.getLexHead();
                    Sign altSign = Sign.createDerivedSignWithNewLF(resultCat, signs, rule, lexHead);
                    newEdges.add(this.makeAltEdge(altSign, resultEdge));
                }
            }
        }
        this.checkInstantiation(newEdges);
        return newEdges;
    }

    private List<Edge> createNewEdges(Edge edgeA, Edge edgeB, boolean collectCombos, boolean bothDirections) {
        List<List<Alt>> combinedLfAlts = this.getCombinedLfAlts(edgeA.activeLfAlts, edgeB.activeLfAlts);
        if (combinedLfAlts == null) {
            return Collections.emptyList();
        }
        boolean fragCompletion = false;
        if (this.gluingFragments) {
            fragCompletion = this.completesChunk(edgeA, edgeB);
        }
        List<Sign> results = this.gluingFragments ? this.generalRules.applyGlueRule(edgeA.sign, edgeB.sign) : this.generalRules.applyBinaryRules(edgeA.sign, edgeB.sign);
        ++this.binaryRuleApps;
        int numResults = results.size();
        List<Object> reversedResults = Collections.emptyList();
        if (bothDirections) {
            reversedResults = this.gluingFragments ? this.generalRules.applyGlueRule(edgeB.sign, edgeA.sign) : this.generalRules.applyBinaryRules(edgeB.sign, edgeA.sign);
            ++this.binaryRuleApps;
        }
        int numReversedResults = reversedResults.size();
        List<Edge> retval = Collections.emptyList();
        if (numResults + numReversedResults > 0) {
            Edge resultEdge;
            Sign sign;
            int i;
            retval = new ArrayList<Edge>(numResults + numReversedResults);
            BitSet union = (BitSet)edgeA.bitset.clone();
            union.or(edgeB.bitset);
            int cardBefore = union.cardinality();
            List<List<Alt>> activeLfAlts = this.getActiveLfAlts(combinedLfAlts, union);
            if (this.gluingFragments && union.cardinality() > cardBefore) {
                fragCompletion = true;
            }
            for (i = 0; i < numResults; ++i) {
                sign = results.get(i);
                if (fragCompletion) {
                    ((AtomCat)sign.getCategory()).fragCompletion = true;
                }
                resultEdge = this.makeEdge(sign, union, activeLfAlts);
                retval.add(resultEdge);
                if (!collectCombos) continue;
                edgeA.edgeCombos.addRightwardCombo(edgeB, resultEdge);
                edgeB.edgeCombos.addLeftwardCombo(edgeA, resultEdge);
            }
            for (i = 0; i < numReversedResults; ++i) {
                sign = (Sign)reversedResults.get(i);
                if (fragCompletion) {
                    ((AtomCat)sign.getCategory()).fragCompletion = true;
                }
                resultEdge = this.makeEdge(sign, union, activeLfAlts);
                retval.add(resultEdge);
                if (!collectCombos) continue;
                edgeB.edgeCombos.addRightwardCombo(edgeA, resultEdge);
                edgeA.edgeCombos.addLeftwardCombo(edgeB, resultEdge);
            }
        }
        return retval;
    }

    public List<Edge> createNewEdges(Edge edge) {
        return this.createNewEdges(edge, false);
    }

    public List<Edge> createNewEdges(Edge edge, boolean collectCombos) {
        List<Edge> retval = null;
        if (!this.gluingFragments) {
            List<Sign> genResults = this.generalRules.applyUnaryRules(edge.sign);
            ++this.unaryRuleApps;
            if (genResults.size() > 0) {
                if (retval == null) {
                    retval = new ArrayList<Edge>(genResults.size());
                }
                for (int i = 0; i < genResults.size(); ++i) {
                    Sign sign = genResults.get(i);
                    if (sign.getDerivationHistory().containsCycle()) continue;
                    Edge resultEdge = this.makeEdge(sign, edge.bitset, edge.activeLfAlts);
                    retval.add(resultEdge);
                    if (!collectCombos) continue;
                    edge.edgeCombos.unaryResults.add(resultEdge);
                }
            }
            Sign[] signs = new Sign[]{edge.sign};
            for (int i = 0; i < this.ruleInstances.size(); ++i) {
                List<List<Alt>> combinedLfAlts;
                RuleInstance ruleInst = this.ruleInstances.get(i);
                if (edge.intersects(ruleInst) || this.useIndexing && !edge.indicesIntersect(ruleInst) || this.useChunks && !edge.meetsLfChunkConstraints(ruleInst) || (combinedLfAlts = this.getCombinedLfAlts(edge.activeLfAlts, ruleInst.activeLfAlts)) == null) continue;
                ArrayList<Sign> instResults = new ArrayList<Sign>(1);
                ruleInst.rule.applyRule(signs, instResults);
                ++this.unaryRuleInstApps;
                if (instResults.size() <= 0) continue;
                if (retval == null) {
                    retval = new ArrayList<Edge>(instResults.size());
                }
                BitSet union = (BitSet)edge.bitset.clone();
                union.or(ruleInst.bitset);
                List<List<Alt>> activeLfAlts = this.getActiveLfAlts(combinedLfAlts, union);
                for (int j = 0; j < instResults.size(); ++j) {
                    Sign sign = (Sign)instResults.get(j);
                    if (sign.getDerivationHistory().containsCycle()) continue;
                    Edge resultEdge = this.makeEdge(sign, union, activeLfAlts);
                    retval.add(resultEdge);
                    if (!collectCombos) continue;
                    edge.edgeCombos.unaryResults.add(resultEdge);
                }
            }
        }
        if (!this.lfOpts.isEmpty() && !edge.complete()) {
            ArrayList<BitSet> optCompleted = new ArrayList<BitSet>(2);
            this.addOptCompletedBitSet(edge, this.allPreds, optCompleted);
            for (List altSet : edge.activeLfAlts) {
                for (Alt alt : altSet) {
                    this.addOptCompletedBitSet(edge, alt.bitset, optCompleted);
                }
            }
            for (BitSet chunk : this.lfChunks) {
                this.addOptCompletedBitSet(edge, chunk, optCompleted);
            }
            for (BitSet completed : optCompleted) {
                AtomCat ac;
                List<List<Alt>> activeLfAlts = this.getActiveLfAlts(edge.activeLfAlts, completed);
                if (this.gluingFragments && edge.sign.getCategory() instanceof AtomCat && (ac = (AtomCat)edge.sign.getCategory()).isFragment()) {
                    ac.fragCompletion = true;
                }
                Edge resultEdge = this.makeEdge(edge.sign, completed, activeLfAlts);
                resultEdge.optCompletes = edge;
                if (retval == null) {
                    retval = new ArrayList<Edge>(1);
                }
                retval.add(resultEdge);
                if (!collectCombos) continue;
                edge.edgeCombos.optionalResults.add(resultEdge);
            }
        }
        if (retval == null) {
            retval = Collections.emptyList();
        }
        if (!this.gluingFragments) {
            this.checkInstantiation(retval);
        }
        return retval;
    }

    private void addOptCompletedBitSet(Edge edge, BitSet bitset, List<BitSet> optCompleted) {
        this.tmpBitSetRetval.clear();
        this.tmpBitSetRetval.or(edge.bitset);
        this.tmpBitSetRetval.and(bitset);
        if (this.tmpBitSetRetval.cardinality() == bitset.cardinality()) {
            return;
        }
        this.tmpBitSetRetval.or(edge.bitset);
        for (BitSet opt : this.lfOpts) {
            if (!this.subset(opt, bitset) || edge.bitset.intersects(opt)) continue;
            this.tmpBitSetRetval.or(opt);
        }
        this.tmpBitSetCompleteness.clear();
        this.tmpBitSetCompleteness.or(bitset);
        this.tmpBitSetCompleteness.and(this.tmpBitSetRetval);
        if (this.tmpBitSetCompleteness.cardinality() == bitset.cardinality() && !optCompleted.contains(this.tmpBitSetRetval)) {
            optCompleted.add((BitSet)this.tmpBitSetRetval.clone());
        }
    }

    public List<Edge> createAltEdges(Edge edge, Edge repEdge) {
        EdgeCombos edgeCombos = repEdge.edgeCombos;
        int numResults = this.numResultsFromCombos(edgeCombos.rightwardCombos);
        numResults += this.numResultsFromCombos(edgeCombos.leftwardCombos);
        numResults += edgeCombos.unaryResults.size();
        ArrayList<Edge> retval = new ArrayList<Edge>(numResults += edgeCombos.optionalResults.size());
        this.addAltsFromCombos(edge, edgeCombos.rightwardCombos, true, retval);
        this.addAltsFromCombos(edge, edgeCombos.leftwardCombos, false, retval);
        this.addAltsFromUnaryResults(edge, edgeCombos.unaryResults, retval);
        this.addAltsFromOptionalResults(edge, edgeCombos.optionalResults, retval);
        return retval;
    }

    private int numResultsFromCombos(List<EdgeCombos.CatCombo> combos) {
        int retval = 0;
        for (int i = 0; i < combos.size(); ++i) {
            EdgeCombos.CatCombo combo = combos.get(i);
            retval += combo.inputEdge.altEdges.size();
        }
        return retval;
    }

    private void addAltsFromCombos(Edge edge, List<EdgeCombos.CatCombo> combos, boolean rightward, List<Edge> results) {
        for (EdgeCombos.CatCombo combo : combos) {
            Edge resultEdge = combo.resultEdge;
            Sign resultSign = resultEdge.sign;
            Category resultCat = resultSign.getCategory();
            Rule rule = resultSign.getDerivationHistory().getRule();
            Sign[] resultInputs = resultSign.getDerivationHistory().getInputs();
            boolean lefthead = resultSign.getLexHead() == resultInputs[0].getLexHead();
            List<Edge> comboEdges = combo.inputEdge.altEdges;
            for (Edge comboEdge : comboEdges) {
                Sign[] signArray;
                if (rightward) {
                    Sign[] signArray2 = new Sign[2];
                    signArray2[0] = edge.sign;
                    signArray = signArray2;
                    signArray2[1] = comboEdge.sign;
                } else {
                    Sign[] signArray3 = new Sign[2];
                    signArray3[0] = comboEdge.sign;
                    signArray = signArray3;
                    signArray3[1] = edge.sign;
                }
                Sign[] signs = signArray;
                Sign lexHead = rightward == lefthead ? edge.sign.getLexHead() : comboEdge.sign.getLexHead();
                Sign altSign = Sign.createDerivedSignWithNewLF(resultCat, signs, rule, lexHead);
                results.add(this.makeAltEdge(altSign, resultEdge));
            }
        }
    }

    private void addAltsFromUnaryResults(Edge edge, List<Edge> unaryResults, List<Edge> results) {
        for (Edge resultEdge : unaryResults) {
            Sign resultSign = resultEdge.sign;
            Category resultCat = resultSign.getCategory();
            Rule rule = resultSign.getDerivationHistory().getRule();
            Sign[] signs = new Sign[]{edge.sign};
            Sign lexHead = edge.sign.getLexHead();
            Sign altSign = Sign.createDerivedSignWithNewLF(resultCat, signs, rule, lexHead);
            results.add(this.makeAltEdge(altSign, resultEdge));
        }
    }

    private void addAltsFromOptionalResults(Edge edge, List<Edge> optionalResults, List<Edge> results) {
        for (Edge resultEdge : optionalResults) {
            results.add(this.makeAltEdge(edge.sign, resultEdge));
        }
    }

    public int ruleApps() {
        return this.unaryRuleApps * this.generalRules.getUnaryRules().size() + this.unaryRuleInstApps + this.binaryRuleApps * this.generalRules.getBinaryRules().size();
    }

    private void initGeneralRules() {
        for (Rule r : this.grammar.rules.getBinaryRules()) {
            this.generalRules.addRule(r);
        }
        for (Rule r : this.grammar.rules.getUnaryRules()) {
            TypeChangingRule rule;
            if (r instanceof TypeChangingRule && (rule = (TypeChangingRule)r).getResult().getLF() != null) continue;
            this.generalRules.addRule(r);
        }
    }

    private void initNoSemEdges() {
        int numUninstEdges;
        int numInstEdges;
        this.lexicon.setSupertagger(null);
        Collection<Sign> noSemSigns = this.lexicon.getSignsFromRel("*NoSem*");
        this.lexicon.setSupertagger(this.hypertagger);
        if (noSemSigns == null) {
            return;
        }
        HashSet<Edge> instEdges = new HashSet<Edge>();
        HashSet<Edge> uninstEdges = new HashSet<Edge>();
        HashSet<Category> instantiatedCats = new HashSet<Category>();
        HashSet<Category> uninstantiatedCats = new HashSet<Category>();
        List<List<Alt>> emptyLfAlts = Collections.emptyList();
        do {
            numInstEdges = instEdges.size();
            numUninstEdges = uninstEdges.size();
            for (Sign sign : noSemSigns) {
                Category cat = sign.getCategory();
                instantiatedCats.clear();
                uninstantiatedCats.clear();
                this.featureLicenser.licenseEmptyCat(cat, instantiatedCats, uninstantiatedCats);
                for (Category instCat : instantiatedCats) {
                    this.featureLicenser.updateFeatureMap(instCat);
                    this.featureLicenser.indexSemanticallyNullWords(instCat);
                    Sign instSign = new Sign(sign.getWords(), instCat);
                    instEdges.add(this.makeEdge(instSign, new BitSet(this.preds.size()), emptyLfAlts));
                }
                for (Category uninstCat : uninstantiatedCats) {
                    this.featureLicenser.updateFeatureMap(uninstCat);
                    this.featureLicenser.indexSemanticallyNullWords(uninstCat);
                    Sign uninstSign = new Sign(sign.getWords(), uninstCat);
                    Edge noSemEdge = this.makeEdge(uninstSign, new BitSet(this.preds.size()), emptyLfAlts);
                    uninstEdges.add(noSemEdge);
                }
            }
        } while (numInstEdges != instEdges.size() || numUninstEdges != uninstEdges.size());
        this.instantiatedNoSemEdges.addAll(instEdges);
        this.noSemEdges.addAll(uninstEdges);
    }
}

