/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.test;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import opennlp.ccg.TextCCG;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.hylo.EPsScorer;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.lexicon.Tokenizer;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.ngrams.AAnFilter;
import opennlp.ccg.ngrams.AbstractStandardNgramModel;
import opennlp.ccg.ngrams.FactoredNgramModelFamily;
import opennlp.ccg.ngrams.NgramDiversityPruningStrategy;
import opennlp.ccg.ngrams.NgramPrecisionModel;
import opennlp.ccg.ngrams.NgramScorer;
import opennlp.ccg.ngrams.SRILMNgramModel;
import opennlp.ccg.ngrams.SRILMNgramModelType;
import opennlp.ccg.ngrams.SelfParaphraseBiaser;
import opennlp.ccg.ngrams.StandardNgramModel;
import opennlp.ccg.parse.ParseException;
import opennlp.ccg.parse.Parser;
import opennlp.ccg.parse.Supertagger;
import opennlp.ccg.parse.supertagger.WordAndPOSDictionaryLabellingStrategy;
import opennlp.ccg.perceptron.Alphabet;
import opennlp.ccg.perceptron.ComposedFeatureExtractor;
import opennlp.ccg.perceptron.EventFile;
import opennlp.ccg.perceptron.FeatureExtractor;
import opennlp.ccg.realize.Chart;
import opennlp.ccg.realize.Edge;
import opennlp.ccg.realize.Hypertagger;
import opennlp.ccg.realize.PruningStrategy;
import opennlp.ccg.realize.Realizer;
import opennlp.ccg.realize.hypertagger.ZLMaxentHypertagger;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.GenerativeSyntacticModel;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.synsem.SignScorer;
import opennlp.ccg.test.RegressionInfo;
import opennlp.ccg.test.TimingMap;
import opennlp.ccg.util.Pair;
import opennlp.ccg.util.SingletonList;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Regression {
    public boolean doParsing = true;
    public boolean doRealization = true;
    public boolean evenOnly = false;
    public boolean oddOnly = false;
    public boolean doGC = false;
    public String eventfile = null;
    public boolean includeGoldInEvents = false;
    public String apmldir = null;
    public boolean showStats = true;
    public boolean showParseStats = false;
    public String statsfile = null;
    public String bleufileprefix = null;
    public String nbestrealfile = null;
    public boolean nbestnormbleu = false;
    public String realserdir = null;
    public String rescorefile = null;
    public Map<String, Sign> bestRealMap = null;
    public boolean nbestincludelfs = false;
    public String nbestparsefile = null;
    public Grammar grammar = null;
    public Parser parser = null;
    public Realizer realizer = null;
    public SignScorer scorer = null;
    public SignScorer parseScorer = null;
    public boolean exactMatches = false;
    public int ngramOrder = 0;
    public FeatureExtractor featureExtractor = null;
    public int pCount = 0;
    public int pBadCount = 0;
    public int pFailedCount = 0;
    public int pExactCount = 0;
    public double totalF = 0.0;
    public double totalRecall = 0.0;
    public double totalPrecision = 0.0;
    public double totalDepsF = 0.0;
    public double totalDepsRecall = 0.0;
    public double totalDepsPrecision = 0.0;
    public double totalUnlabeledDepsF = 0.0;
    public double totalUnlabeledDepsRecall = 0.0;
    public double totalUnlabeledDepsPrecision = 0.0;
    public double totalFComplete = 0.0;
    public double totalRecallComplete = 0.0;
    public double totalPrecisionComplete = 0.0;
    public double totalDepsFComplete = 0.0;
    public double totalDepsRecallComplete = 0.0;
    public double totalDepsPrecisionComplete = 0.0;
    public double totalUnlabeledDepsFComplete = 0.0;
    public double totalUnlabeledDepsRecallComplete = 0.0;
    public double totalUnlabeledDepsPrecisionComplete = 0.0;
    public int pTotalEdges = 0;
    public int pTotalEdgesGood = 0;
    public int pMaxEdges = 0;
    public int pMaxEdgesGood = 0;
    public int pTotalUnpackingEdges = 0;
    public int pMaxUnpackingEdges = 0;
    public int pTotalCellMax = 0;
    public int pTotalCellMaxGood = 0;
    public int pMaxCellMax = 0;
    public int pMaxCellMaxGood = 0;
    public int pTotalLexTime = 0;
    public int pTotalParseTime = 0;
    public int pTotalChartTime = 0;
    public int pTotalUnpackingTime = 0;
    public int pMaxLexTime = 0;
    public int pMaxParseTime = 0;
    public int pMaxChartTime = 0;
    public int pMaxUnpackingTime = 0;
    public Map<Double, Integer> pBetaTallies = null;
    public int rCount = 0;
    public int rDoneCount = 0;
    public int rBadCount = 0;
    public int rExactCount = 0;
    public double totalScore = 0.0;
    public double totalScoreComplete = 0.0;
    public double totalReciprocalRank = 0.0;
    public int totalNominals = 0;
    public int totalTokens = 0;
    public int minTokens = 0;
    public int maxTokens = 0;
    public int totalRuleApps = 0;
    public int totalEdges = 0;
    public int totalEdgesCreated = 0;
    public int totalUnprunedEdges = 0;
    public int totalPrunedRemoved = 0;
    public int totalPrunedNeverAdded = 0;
    public int totalCellMax = 0;
    public int totalNewBest = 0;
    public int totalLex = 0;
    public int totalFirst = 0;
    public int totalBest = 0;
    public int totalPacked = 0;
    public int totalStoppedOrDone = 0;
    public int maxLex = 0;
    public int maxFirst = 0;
    public int maxBest = 0;
    public int maxNewBest = 0;
    public int maxPacked = 0;
    public int maxStoppedOrDone = 0;
    public int oracleBetter = 0;
    public int goldMissing = 0;
    public String maxLexStr = null;
    public String maxFirstStr = null;
    public String maxBestStr = null;
    public String maxNewBestStr = null;
    public String maxPackedStr = null;
    public String maxStoppedOrDoneStr = null;
    public List<Double> bestEstimatedScores = null;
    public List<Double> bestActualScores = null;
    public List<Integer> itemRanks = null;
    public TimingMap lexMap = null;
    public TimingMap firstMap = null;
    public TimingMap bestMap = null;
    public TimingMap allMap = null;
    private PrintWriter events = null;
    private PrintWriter bleuGen = null;
    private PrintWriter bleuRef = null;
    private PrintWriter bleuSrc = null;
    private PrintWriter nbestrealPW = null;
    private PrintWriter rescorePW = null;
    private PrintWriter nbestparsePW = null;
    private XMLOutputter xmlOutputter = new XMLOutputter();
    private static final NumberFormat nf = Regression.initNF();
    private static final NumberFormat nfE = Regression.initNFE();

    public Regression() {
        this.resetTotals();
    }

    public void resetTotals() {
        this.pCount = 0;
        this.pBadCount = 0;
        this.pFailedCount = 0;
        this.pExactCount = 0;
        this.totalF = 0.0;
        this.totalRecall = 0.0;
        this.totalPrecision = 0.0;
        this.totalDepsF = 0.0;
        this.totalDepsRecall = 0.0;
        this.totalDepsPrecision = 0.0;
        this.totalUnlabeledDepsF = 0.0;
        this.totalUnlabeledDepsRecall = 0.0;
        this.totalUnlabeledDepsPrecision = 0.0;
        this.totalFComplete = 0.0;
        this.totalRecallComplete = 0.0;
        this.totalPrecisionComplete = 0.0;
        this.totalDepsFComplete = 0.0;
        this.totalDepsRecallComplete = 0.0;
        this.totalDepsPrecisionComplete = 0.0;
        this.totalUnlabeledDepsFComplete = 0.0;
        this.totalUnlabeledDepsRecallComplete = 0.0;
        this.totalUnlabeledDepsPrecisionComplete = 0.0;
        this.pTotalEdges = 0;
        this.pTotalEdgesGood = 0;
        this.pMaxEdges = 0;
        this.pMaxEdgesGood = 0;
        this.pTotalUnpackingEdges = 0;
        this.pMaxUnpackingEdges = 0;
        this.pTotalCellMax = 0;
        this.pTotalCellMaxGood = 0;
        this.pMaxCellMax = 0;
        this.pMaxCellMaxGood = 0;
        this.pTotalLexTime = 0;
        this.pTotalParseTime = 0;
        this.pTotalChartTime = 0;
        this.pTotalUnpackingTime = 0;
        this.pMaxLexTime = 0;
        this.pMaxParseTime = 0;
        this.pMaxChartTime = 0;
        this.pMaxUnpackingTime = 0;
        if (this.doParsing) {
            this.pBetaTallies = new TreeMap<Double, Integer>();
        }
        this.rCount = 0;
        this.rDoneCount = 0;
        this.rBadCount = 0;
        this.rExactCount = 0;
        this.totalScore = 0.0;
        this.totalScoreComplete = 0.0;
        this.totalReciprocalRank = 0.0;
        this.totalNominals = 0;
        this.totalTokens = 0;
        this.minTokens = 0;
        this.maxTokens = 0;
        this.totalRuleApps = 0;
        this.totalEdges = 0;
        this.totalEdgesCreated = 0;
        this.totalUnprunedEdges = 0;
        this.totalPrunedRemoved = 0;
        this.totalPrunedNeverAdded = 0;
        this.totalCellMax = 0;
        this.totalNewBest = 0;
        this.totalLex = 0;
        this.totalFirst = 0;
        this.totalBest = 0;
        this.totalPacked = 0;
        this.totalStoppedOrDone = 0;
        this.maxLex = 0;
        this.maxFirst = 0;
        this.maxBest = 0;
        this.maxNewBest = 0;
        this.maxPacked = 0;
        this.maxStoppedOrDone = 0;
        this.oracleBetter = 0;
        this.goldMissing = 0;
        this.maxLexStr = null;
        this.maxFirstStr = null;
        this.maxBestStr = null;
        this.maxNewBestStr = null;
        this.maxPackedStr = null;
        this.maxStoppedOrDoneStr = null;
        if (this.doRealization) {
            this.bestActualScores = new ArrayList<Double>();
            this.bestEstimatedScores = new ArrayList<Double>();
            this.itemRanks = new ArrayList<Integer>();
            this.lexMap = new TimingMap("lex");
            this.firstMap = new TimingMap("first");
            this.bestMap = new TimingMap("best");
            this.allMap = new TimingMap("all");
        }
    }

    private void bleuSetup() throws IOException {
        if (this.bleufileprefix != null && this.doRealization) {
            this.bleuGen = new PrintWriter(new BufferedWriter(new FileWriter(this.bleufileprefix + "-gen.sgm")));
            this.bleuRef = new PrintWriter(new BufferedWriter(new FileWriter(this.bleufileprefix + "-ref.sgm")));
            this.bleuSrc = new PrintWriter(new BufferedWriter(new FileWriter(this.bleufileprefix + "-src.sgm")));
            this.bleuGen.println("<tstset setid=\"ccg-test\" srclang=\"en\" trglang=\"en\">");
            this.bleuRef.println("<refset setid=\"ccg-test\" srclang=\"en\" trglang=\"en\">");
            this.bleuSrc.println("<srcset setid=\"ccg-test\" srclang=\"en\">");
        }
    }

    private void nbestrealSetup() throws IOException {
        if (this.nbestrealfile != null && this.doRealization) {
            this.nbestrealPW = new PrintWriter(new BufferedWriter(new FileWriter(this.nbestrealfile)));
            this.nbestrealPW.println("<nbest>");
        }
    }

    private void rescoreSetup() throws IOException {
        if (this.rescorefile != null) {
            this.rescorePW = new PrintWriter(new BufferedWriter(new FileWriter(this.rescorefile)));
            this.rescorePW.println("<rescored>");
        }
    }

    private void nbestparseSetup() throws IOException {
        if (this.nbestparsefile != null && this.doParsing) {
            this.nbestparsePW = new PrintWriter(new BufferedWriter(new FileWriter(this.nbestparsefile)));
            this.nbestparsePW.println("<nbest>");
        }
    }

    private void bleuStartDoc(String id) {
        if (this.bleufileprefix != null && this.doRealization) {
            this.bleuGen.println("<doc docid=\"" + id + "\" sysid=\"openccg\">");
            this.bleuRef.println("<doc docid=\"" + id + "\" sysid=\"ref\">");
            this.bleuSrc.println("<doc docid=\"" + id + "\">");
        }
    }

    private void bleuEndDoc() {
        if (this.bleufileprefix != null && this.doRealization) {
            this.bleuGen.println("</doc>");
            this.bleuRef.println("</doc>");
            this.bleuSrc.println("</doc>");
        }
    }

    private void bleuFinish() throws IOException {
        if (this.bleufileprefix != null && this.doRealization) {
            this.bleuGen.println("</tstset>");
            this.bleuRef.println("</refset>");
            this.bleuSrc.println("</srcset>");
            this.bleuGen.flush();
            this.bleuGen.close();
            this.bleuRef.flush();
            this.bleuRef.close();
            this.bleuSrc.flush();
            this.bleuSrc.close();
        }
    }

    private void nbestrealFinish() throws IOException {
        if (this.nbestrealfile != null && this.doRealization) {
            this.nbestrealPW.println("</nbest>");
            this.nbestrealPW.flush();
            this.nbestrealPW.close();
        }
    }

    private void rescoreFinish() throws IOException {
        if (this.rescorefile != null) {
            this.rescorePW.println("</rescored>");
            this.rescorePW.flush();
            this.rescorePW.close();
        }
    }

    private void nbestparseFinish() throws IOException {
        if (this.nbestparsefile != null && this.doParsing) {
            this.nbestparsePW.println("</nbest>");
            this.nbestparsePW.flush();
            this.nbestparsePW.close();
        }
    }

    private void realserStartDoc() {
        if (this.realserdir != null && this.doRealization) {
            this.bestRealMap = new HashMap<String, Sign>();
        }
    }

    private void realserEndDoc(String testName) throws IOException {
        if (this.realserdir != null && this.doRealization) {
            File serFile = new File(new File(this.realserdir), testName + ".ser");
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(serFile));
            oos.writeObject(this.bestRealMap);
            oos.close();
        }
    }

    private String xmlEscape(String s) {
        return this.xmlOutputter.outputString(new Text(s));
    }

    private String norm_bleu(String s) {
        return this.xmlEscape(s.replace('_', ' '));
    }

    public void runTest(File regressionFile) throws IOException {
        if (this.eventfile != null) {
            this.events = EventFile.openWriter(new File(this.eventfile));
        }
        this.bleuSetup();
        this.nbestrealSetup();
        this.rescoreSetup();
        this.nbestparseSetup();
        for (File f : Regression.getXMLFiles(regressionFile)) {
            this.runSingleTest(f);
        }
        this.bleuFinish();
        this.nbestrealFinish();
        this.rescoreFinish();
        this.nbestparseFinish();
        if (this.events != null) {
            this.events.flush();
            this.events.close();
        }
        if (this.rescorefile != null) {
            return;
        }
        if (this.doParsing && this.showParseStats) {
            this.showParseStats();
        }
        if (this.doRealization && this.showStats) {
            this.showStats();
        }
    }

    public static List<File> getXMLFiles(File file) {
        if (!file.isDirectory()) {
            return new SingletonList<File>(file);
        }
        ArrayList<File> retval = new ArrayList<File>();
        Object[] files = file.listFiles();
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            if (((File)files[i]).isDirectory() || !((File)files[i]).getName().endsWith(".xml")) continue;
            retval.add((File)files[i]);
        }
        return retval;
    }

    private void runSingleTest(File regressionFile) throws IOException {
        String testName = regressionFile.getName();
        int lastDot = testName.lastIndexOf(46);
        if (lastDot > 0) {
            testName = testName.substring(0, lastDot);
        }
        System.out.println("Loading: " + testName);
        System.out.println();
        RegressionInfo rinfo = new RegressionInfo(this.grammar, regressionFile);
        this.bleuStartDoc(testName);
        this.realserStartDoc();
        int numItems = rinfo.numberOfItems();
        System.out.println("Parse\tRealize\tString");
        System.out.println("-----\t-------\t------");
        for (int i = 0; i < numItems; ++i) {
            List<Edge> bestEdges;
            String[] stringArray;
            String parseResult;
            if (i % 2 == 1 && this.evenOnly || i % 2 == 0 && this.oddOnly) continue;
            RegressionInfo.TestItem testItem = rinfo.getItem(i);
            if (this.doGC) {
                System.gc();
            }
            if (this.rescorefile != null) {
                String id = testItem.info;
                double score = this.scorer.score(testItem.sign, true);
                this.rescorePW.println("<seg id=\"" + id + "\" score=\"" + score + "\"/>");
                Regression.showOutcome("-", nfE.format(score), "", testItem.sign.getOrthography());
                continue;
            }
            List<Object> parses = null;
            List<Double> parseScores = null;
            LF parsedLF = null;
            LF compactedLF = null;
            LF transformedParsedLF = null;
            boolean parsed = false;
            boolean parsedComplete = false;
            if (this.doParsing) {
                int n;
                try {
                    List<Word> words = null;
                    if (testItem.fullWords != null) {
                        words = this.grammar.lexicon.tokenizer.tokenize(testItem.fullWords, true);
                        if (words.get(0).getForm() == "<s>") {
                            words.remove(0);
                        }
                        if (words.get(words.size() - 1).getForm() == "</s>") {
                            words.remove(words.size() - 1);
                        }
                    } else if (testItem.sign != null) {
                        words = testItem.sign.getWords();
                    }
                    if (words != null) {
                        this.parser.parse(words);
                    } else {
                        this.parser.parse(testItem.sentence);
                    }
                    parses = this.parser.getResult();
                    parseScores = this.parser.getScores();
                    parsed = true;
                    boolean bl = parsedComplete = !((Sign)parses.get(0)).getCategory().isFragment();
                    if (this.showParseStats || this.doRealization && testItem.lfElt == null && testItem.sign == null) {
                        Sign sign = (Sign)parses.get(0);
                        Category cat = sign.getCategory().copy();
                        Nominal index = cat.getIndexNominal();
                        parsedLF = cat.getLF();
                        index = HyloHelper.convertNominals(parsedLF, sign, index);
                        compactedLF = HyloHelper.compact(parsedLF, index);
                        if (testItem.sign == null) {
                            transformedParsedLF = this.grammar.transformLF(compactedLF);
                        }
                    }
                }
                catch (ParseException e) {
                    parses = Collections.emptyList();
                    parsed = false;
                }
                catch (Exception e) {
                    parses = Collections.emptyList();
                    parsed = false;
                    System.err.println("Uncaught exception in parsing: " + testItem.sentence);
                    e.printStackTrace(System.err);
                }
                int count = this.parser.edgeCount();
                this.pTotalEdges += count;
                if (count > this.pMaxEdges) {
                    this.pMaxEdges = count;
                }
                if (parsedComplete) {
                    this.pTotalEdgesGood += count;
                    if (count > this.pMaxEdgesGood) {
                        this.pMaxEdgesGood = count;
                    }
                }
                count = this.parser.unpackingEdgeCount();
                this.pTotalUnpackingEdges += count;
                if (count > this.pMaxUnpackingEdges) {
                    this.pMaxUnpackingEdges = count;
                }
                int cellMax = this.parser.maxCellSize();
                this.pTotalCellMax += cellMax;
                if (cellMax > this.pMaxCellMax) {
                    this.pMaxCellMax = cellMax;
                }
                if (parsedComplete) {
                    this.pTotalCellMaxGood += cellMax;
                    if (cellMax > this.pMaxCellMaxGood) {
                        this.pMaxCellMaxGood = cellMax;
                    }
                }
                int time = this.parser.getLexTime();
                this.pTotalLexTime += time;
                if (time > this.pMaxLexTime) {
                    this.pMaxLexTime = time;
                }
                time = this.parser.getParseTime();
                this.pTotalParseTime += time;
                if (time > this.pMaxParseTime) {
                    this.pMaxParseTime = time;
                }
                time = this.parser.getChartTime();
                this.pTotalChartTime += time;
                if (time > this.pMaxChartTime) {
                    this.pMaxChartTime = time;
                }
                time = this.parser.getUnpackingTime();
                this.pTotalUnpackingTime += time;
                if (time > this.pMaxUnpackingTime) {
                    this.pMaxUnpackingTime = time;
                }
                double beta = this.parser.getSupertaggerBeta();
                Integer betaTally = this.pBetaTallies.get(beta);
                Double d = beta;
                if (betaTally != null) {
                    betaTally = betaTally + 1;
                    n = betaTally;
                } else {
                    n = 1;
                }
                this.pBetaTallies.put(d, n);
            }
            LF testItemLF = null;
            if (testItem.lfElt != null && (this.doRealization || this.showParseStats && parsed && testItem.sign == null)) {
                Element lfElt = testItem.lfElt;
                Document doc = new Document();
                lfElt.detach();
                doc.setRootElement(lfElt);
                testItemLF = this.grammar.loadLF(doc);
            }
            EPsScorer.Results parseScore = null;
            LF goldLF = null;
            if (this.showParseStats && parsedLF != null) {
                LF lfToScore = null;
                if (testItem.sign != null) {
                    lfToScore = parsedLF;
                    Category cat = testItem.sign.getCategory().copy();
                    Nominal index = cat.getIndexNominal();
                    goldLF = cat.getLF();
                    index = HyloHelper.convertNominals(goldLF, testItem.sign, index);
                } else {
                    lfToScore = transformedParsedLF;
                    goldLF = testItemLF;
                }
                if (goldLF == null) {
                    throw new RuntimeException("Can't score parse: " + testItem.sentence + "!\nNo gold LF.");
                }
                parseScore = EPsScorer.score(lfToScore, goldLF);
            }
            if (this.showParseStats && testItem.numOfParses > 0) {
                ++this.pCount;
                if (parses.size() == 0 || !parsedComplete) {
                    ++this.pBadCount;
                }
                if (parses.size() == 0) {
                    ++this.pFailedCount;
                }
                if (parseScore != null) {
                    if (parseScore.fscore == 1.0) {
                        ++this.pExactCount;
                    }
                    this.totalF += parseScore.fscore;
                    this.totalRecall += parseScore.recall;
                    this.totalPrecision += parseScore.precision;
                    this.totalDepsF += parseScore.depsFscore;
                    this.totalDepsRecall += parseScore.depsRecall;
                    this.totalDepsPrecision += parseScore.depsPrecision;
                    this.totalUnlabeledDepsF += parseScore.unlabeledDepsFscore;
                    this.totalUnlabeledDepsRecall += parseScore.unlabeledDepsRecall;
                    this.totalUnlabeledDepsPrecision += parseScore.unlabeledDepsPrecision;
                    if (parsedComplete) {
                        this.totalFComplete += parseScore.fscore;
                        this.totalRecallComplete += parseScore.recall;
                        this.totalPrecisionComplete += parseScore.precision;
                        this.totalDepsFComplete += parseScore.depsFscore;
                        this.totalDepsRecallComplete += parseScore.depsRecall;
                        this.totalDepsPrecisionComplete += parseScore.depsPrecision;
                        this.totalUnlabeledDepsFComplete += parseScore.unlabeledDepsFscore;
                        this.totalUnlabeledDepsRecallComplete += parseScore.unlabeledDepsRecall;
                        this.totalUnlabeledDepsPrecisionComplete += parseScore.unlabeledDepsPrecision;
                    }
                }
            }
            if (this.events != null && this.doParsing && parses.size() > 0 && testItem.sign != null) {
                ArrayList<Object> bestSigns = new ArrayList<Object>(parses);
                Sign best = (Sign)parses.get(0);
                if (parseScore.fscore != 1.0) {
                    Pair<Sign, Boolean> bestPair = this.parser.oracleBest(goldLF);
                    if (bestPair.a != null) {
                        ++this.oracleBetter;
                    }
                    if (((Boolean)bestPair.b).booleanValue()) {
                        best = (Sign)bestPair.a;
                        if (!bestSigns.contains(best)) {
                            bestSigns.add(best);
                        }
                    } else {
                        ++this.goldMissing;
                        if (this.includeGoldInEvents) {
                            best = testItem.sign;
                            bestSigns.add(best);
                        }
                    }
                }
                EventFile.writeEvents(this.events, bestSigns, best, this.featureExtractor);
            }
            if (this.nbestparsePW != null) {
                String tagend;
                String id;
                XMLOutputter outputter = new XMLOutputter();
                outputter.setFormat(Format.getPrettyFormat());
                String extras = "";
                if (parsedComplete) {
                    extras = extras + " complete=\"true\"";
                }
                if ((id = testItem.info) == null) {
                    id = "" + i;
                }
                this.nbestparsePW.println("<seg id=\"" + id + "\" str=\"" + this.xmlEscape(testItem.sentence) + "\"" + extras + ">");
                String string = tagend = this.nbestincludelfs ? ">" : "/>";
                if (parseScore != null) {
                    double edgeScore = parseScores.get(0);
                    String scores = "score=\"" + nf.format(parseScore.fscore) + "\" edge-score=\"" + nfE.format(edgeScore) + "\"";
                    this.nbestparsePW.println("<best " + scores + tagend);
                    if (this.nbestincludelfs) {
                        Element lfElt = this.grammar.makeLfElt(compactedLF);
                        this.nbestparsePW.println(outputter.outputString(lfElt));
                        this.nbestparsePW.println("</best>");
                    }
                }
                for (int k = 1; k < parses.size(); ++k) {
                    Sign sign = (Sign)parses.get(k);
                    double edgeScore = parseScores.get(k);
                    Category cat = sign.getCategory().copy();
                    Nominal index = cat.getIndexNominal();
                    LF parsedLFk = cat.getLF();
                    index = HyloHelper.convertNominals(parsedLFk, sign, index);
                    LF compactedLFk = HyloHelper.compact(parsedLFk, index);
                    LF lfToScore = parsedLFk;
                    if (testItem.sign != null) {
                        lfToScore = this.grammar.transformLF(compactedLFk);
                    }
                    EPsScorer.Results parseScoreK = EPsScorer.score(lfToScore, goldLF);
                    String scores = "score=\"" + nf.format(parseScoreK.fscore) + "\" edge-score=\"" + nfE.format(edgeScore) + "\"";
                    this.nbestparsePW.println("<next " + scores + tagend);
                    if (!this.nbestincludelfs) continue;
                    Element lfElt = this.grammar.makeLfElt(compactedLFk);
                    this.nbestparsePW.println(outputter.outputString(lfElt));
                    this.nbestparsePW.println("</next>");
                }
                this.nbestparsePW.println("</seg>");
            }
            String starForBadSentence = "";
            if (testItem.numOfParses == 0) {
                starForBadSentence = "*";
            }
            if (!this.doParsing) {
                parseResult = "-";
            } else if (parseScore != null) {
                parseResult = nf.format(parseScore.fscore);
                if (!parsedComplete) {
                    parseResult = "[" + parseResult + "]";
                }
            } else {
                parseResult = testItem.numOfParses == parses.size() ? "ok" : (testItem.numOfParses > 0 && parses.size() > 0 ? "(" + parses.size() + ")" : (testItem.knownFailure ? "(known)" : "FAILED"));
            }
            if (!this.doRealization || this.doParsing && !parsed || testItem.numOfParses == 0) {
                Regression.showOutcome(parseResult, "-", starForBadSentence, testItem.sentence);
                continue;
            }
            LF inputLF = null;
            if (testItemLF != null) {
                inputLF = testItemLF;
            } else if (testItem.sign != null) {
                Sign sign = testItem.sign;
                Category cat = sign.getCategory().copy();
                Nominal index = cat.getIndexNominal();
                LF convertedLF = HyloHelper.compactAndConvertNominals(cat.getLF(), index, sign);
                inputLF = this.grammar.transformLF(convertedLF);
            } else if (transformedParsedLF != null) {
                inputLF = transformedParsedLF;
            } else {
                String suggestion = !this.doParsing ? "Try leaving off -noparsing option." : "";
                throw new RuntimeException("No LF to realize! " + suggestion);
            }
            if (testItem.alt == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = testItem.sentence;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = testItem.sentence;
                stringArray = stringArray3;
                stringArray3[1] = testItem.alt;
            }
            String[] targets = stringArray;
            NgramPrecisionModel defaultNgramScorer = new NgramPrecisionModel(targets);
            SignScorer scorerToUse = this.scorer;
            if (scorerToUse == null) {
                if (this.ngramOrder > 0 || this.exactMatches) {
                    scorerToUse = this.ngramOrder > 0 ? new NgramPrecisionModel(targets, this.ngramOrder) : new NgramPrecisionModel(targets);
                    ((NgramPrecisionModel)scorerToUse).setExactMatches(this.exactMatches);
                } else {
                    scorerToUse = defaultNgramScorer;
                }
            } else if (scorerToUse instanceof SelfParaphraseBiaser) {
                ((SelfParaphraseBiaser)((Object)scorerToUse)).setTargets(targets);
            }
            if (this.doGC) {
                System.gc();
            }
            try {
                if (this.events != null && this.realizer.hypertagger != null && testItem.predInfo != null) {
                    this.realizer.hypertagger.storeGoldStdPredInfo(testItem.predInfo);
                }
                this.realizer.realize(inputLF, scorerToUse);
            }
            catch (Throwable thrwbl) {
                System.out.println("Unable to process: " + testItem.sentence);
                thrwbl.printStackTrace(System.out);
                continue;
            }
            Chart chart = this.realizer.getChart();
            String realizeResult = "ok";
            boolean gramcomplete = true;
            boolean joined = false;
            Edge bestEdge = chart.bestEdge;
            if (!bestEdge.complete() || bestEdge.getSign().getCategory().isFragment()) {
                realizeResult = "[ok]";
                gramcomplete = false;
                ++this.rBadCount;
                if (chart.joinFragments) {
                    bestEdge = chart.bestJoinedEdge;
                    joined = true;
                }
            }
            String bestRealization = bestEdge.getSign().getOrthography();
            double score = defaultNgramScorer.score(bestEdge.getSign(), false);
            if (this.events != null && (bestEdges = chart.bestEdges()).size() > 0) {
                Pair<Edge, Boolean> bestPair = chart.oracleBest(testItem.sentence);
                Edge oracleBest = (Edge)bestPair.a;
                if (oracleBest != null) {
                    Sign best = oracleBest.getSign();
                    ArrayList<Sign> bestSigns = new ArrayList<Sign>(bestEdges.size() + 1);
                    for (Edge e : bestEdges) {
                        bestSigns.add(e.getSign());
                    }
                    if (bestEdge != oracleBest) {
                        ++this.oracleBetter;
                    }
                    if (!((Boolean)bestPair.b).booleanValue()) {
                        ++this.goldMissing;
                        if (this.includeGoldInEvents) {
                            best = testItem.sign;
                        }
                    }
                    if (!bestSigns.contains(best)) {
                        bestSigns.add(best);
                    }
                    EventFile.writeEvents(this.events, bestSigns, best, this.featureExtractor);
                }
            }
            if (this.bleufileprefix != null) {
                String id;
                String extras = " time=\"";
                extras = chart.done ? extras + chart.timeTilDone : extras + chart.timeTilStopped;
                extras = extras + "\"";
                extras = extras + " score=\"" + nf.format(score) + "\"";
                if (gramcomplete) {
                    extras = extras + " complete=\"true\"";
                }
                if (joined) {
                    extras = extras + " joined=\"true\"";
                }
                if ((id = testItem.info) == null) {
                    id = "" + i;
                }
                this.bleuGen.println("<seg id=\"" + id + "\"" + extras + ">" + this.norm_bleu(bestRealization) + "</seg>");
                String sent = this.norm_bleu(testItem.sentence);
                this.bleuRef.println("<seg id=\"" + id + "\">" + sent + "</seg>");
                this.bleuSrc.println("<seg id=\"" + id + "\">" + sent + "</seg>");
            }
            if (this.nbestrealPW != null) {
                String best;
                String id;
                XMLOutputter outputter = new XMLOutputter();
                outputter.setFormat(Format.getPrettyFormat());
                String extras = "";
                if (gramcomplete) {
                    extras = extras + " complete=\"true\"";
                }
                if (joined) {
                    extras = extras + " joined=\"true\"";
                }
                if ((id = testItem.info) == null) {
                    id = "" + i;
                }
                this.nbestrealPW.println("<seg id=\"" + id + "\"" + extras + ">");
                String ref = this.nbestnormbleu ? this.norm_bleu(testItem.sentence) : this.xmlEscape(testItem.sentence);
                this.nbestrealPW.println("<ref>" + ref + "</ref>");
                String scores = "score=\"" + nf.format(score) + "\" edge-score=\"" + nfE.format(bestEdge.score) + "\"";
                String string = best = this.nbestnormbleu ? this.norm_bleu(bestRealization) : this.xmlEscape(bestRealization);
                if (!this.nbestincludelfs) {
                    this.nbestrealPW.println("<best " + scores + ">" + best + "</best>");
                } else {
                    this.nbestrealPW.println("<best " + scores + ">");
                    this.nbestrealPW.println("<str>" + best + "</str>");
                    Sign sign = bestEdge.getSign();
                    Category cat = sign.getCategory().copy();
                    Nominal index = cat.getIndexNominal();
                    LF lf = cat.getLF();
                    index = HyloHelper.convertNominalsToVars(lf, index);
                    index = HyloHelper.convertNominals(lf, sign, index);
                    LF lfc = HyloHelper.compact(lf, index);
                    Element lfElt = this.grammar.makeLfElt(lfc);
                    this.nbestrealPW.println(outputter.outputString(lfElt));
                    this.nbestrealPW.println("</best>");
                }
                if (bestEdge.complete()) {
                    List<Edge> bestEdges2 = chart.bestEdges();
                    for (int j = 1; j < bestEdges2.size(); ++j) {
                        String next;
                        Edge e = bestEdges2.get(j);
                        String eSent = e.getSign().getOrthography();
                        double eScore = defaultNgramScorer.score(e.getSign(), false);
                        String eScores = " score=\"" + nf.format(eScore) + "\" edge-score=\"" + nfE.format(e.score) + "\"";
                        String string2 = next = this.nbestnormbleu ? this.norm_bleu(eSent) : this.xmlEscape(eSent);
                        if (!this.nbestincludelfs) {
                            this.nbestrealPW.println("<next" + eScores + ">" + next + "</next>");
                            continue;
                        }
                        this.nbestrealPW.println("<next" + eScores + ">");
                        this.nbestrealPW.println("<str>" + next + "</str>");
                        Sign sign = e.getSign();
                        Category cat = sign.getCategory().copy();
                        Nominal index = cat.getIndexNominal();
                        LF lf = cat.getLF();
                        index = HyloHelper.convertNominalsToVars(lf, index);
                        index = HyloHelper.convertNominals(lf, sign, index);
                        LF lfc = HyloHelper.compact(lf, index);
                        Element lfElt = this.grammar.makeLfElt(lfc);
                        this.nbestrealPW.println(outputter.outputString(lfElt));
                        this.nbestrealPW.println("</next>");
                    }
                }
                this.nbestrealPW.println("</seg>");
            }
            if (this.apmldir != null) {
                String apmlfn = this.apmldir + "/ex" + (i + 1) + ".apml";
                this.grammar.saveToApml(bestEdge.getSign(), apmlfn);
            }
            if (this.realserdir != null && gramcomplete) {
                String id = testItem.info;
                if (id == null) {
                    id = "i" + i;
                }
                this.bestRealMap.put(testItem.info, bestEdge.getSign());
            }
            ++this.rCount;
            this.totalScore += score;
            if (gramcomplete) {
                this.totalScoreComplete += score;
            }
            int itemRank = 1;
            Tokenizer tokenizer = this.grammar.lexicon.tokenizer;
            String itemOrth = tokenizer.getOrthography(tokenizer.tokenize(testItem.sentence));
            if (!bestRealization.equals(itemOrth)) {
                itemRank = 0;
                List<Edge> bestEdges3 = chart.bestEdges();
                for (int j = 0; j < bestEdges3.size(); ++j) {
                    Edge edge = bestEdges3.get(j);
                    String str = edge.getSign().getOrthography();
                    if (!str.equals(itemOrth)) continue;
                    itemRank = j + 1;
                    break;
                }
                if (itemRank > 0) {
                    this.totalReciprocalRank += 1.0 / (double)itemRank;
                }
                if (gramcomplete) {
                    realizeResult = nf.format(score);
                    if (itemRank > 0 && itemRank < 10) {
                        realizeResult = realizeResult + " ";
                    }
                    if (itemRank > 0 && itemRank < 100) {
                        realizeResult = realizeResult + "#" + itemRank;
                    }
                } else {
                    realizeResult = "[" + nf.format(score) + "]";
                    if (joined) {
                        realizeResult = realizeResult + "j";
                    }
                }
                Regression.showOutcome(parseResult, realizeResult, starForBadSentence, testItem.sentence, bestRealization);
            } else {
                ++this.rExactCount;
                this.totalReciprocalRank += 1.0;
                Regression.showOutcome(parseResult, realizeResult, starForBadSentence, testItem.sentence);
            }
            this.totalNominals += chart.numNominals;
            int tokens = testItem.sentence.split("\\s+").length;
            this.totalTokens += tokens;
            if (tokens < this.minTokens || this.minTokens == 0) {
                this.minTokens = tokens;
            }
            if (tokens > this.maxTokens) {
                this.maxTokens = tokens;
            }
            this.totalRuleApps += chart.edgeFactory.ruleApps();
            this.totalEdges += chart.numEdgesInChart();
            this.totalEdgesCreated += chart.numEdges;
            this.totalUnprunedEdges += chart.numUnprunedEdges();
            this.totalPrunedRemoved += chart.numPrunedRemoved;
            this.totalPrunedNeverAdded += chart.numPrunedNeverAdded;
            this.totalCellMax += chart.cellMax;
            this.totalNewBest += chart.newBest;
            this.bestActualScores.add(new Double(score));
            this.bestEstimatedScores.add(new Double(bestEdge.score));
            this.itemRanks.add(new Integer(itemRank));
            this.totalLex += chart.timeTilLex;
            if (chart.timeTilLex > this.maxLex) {
                this.maxLex = chart.timeTilLex;
                this.maxLexStr = testItem.sentence;
            }
            this.lexMap.add(chart.numNominals, chart.timeTilLex);
            this.totalFirst += chart.timeTilFirst;
            if (chart.timeTilFirst > this.maxFirst) {
                this.maxFirst = chart.timeTilFirst;
                this.maxFirstStr = testItem.sentence;
            }
            this.firstMap.add(chart.numNominals, chart.timeTilFirst);
            this.totalBest += chart.timeTilBest;
            if (chart.timeTilBest > this.maxBest) {
                this.maxBest = chart.timeTilBest;
                this.maxBestStr = testItem.sentence;
            }
            this.bestMap.add(chart.numNominals, chart.timeTilBest);
            if (chart.newBest > 0 && chart.timeTilBest - chart.timeTilFirst >= this.maxNewBest) {
                this.maxNewBest = chart.timeTilBest - chart.timeTilFirst;
                this.maxNewBestStr = testItem.sentence;
            }
            this.totalPacked += chart.timeTilPacked;
            if (chart.timeTilPacked > this.maxPacked) {
                this.maxPacked = chart.timeTilPacked;
                this.maxPackedStr = testItem.sentence;
            }
            if (chart.done) {
                ++this.rDoneCount;
                this.totalStoppedOrDone += chart.timeTilDone;
                if (chart.timeTilDone > this.maxStoppedOrDone) {
                    this.maxStoppedOrDone = chart.timeTilDone;
                    this.maxStoppedOrDoneStr = testItem.sentence;
                }
                this.allMap.add(chart.numNominals, chart.timeTilDone);
                continue;
            }
            this.totalStoppedOrDone += chart.timeTilStopped;
            if (chart.timeTilStopped > this.maxStoppedOrDone) {
                this.maxStoppedOrDone = chart.timeTilStopped;
                this.maxStoppedOrDoneStr = testItem.sentence;
            }
            this.allMap.add(chart.numNominals, chart.timeTilStopped);
        }
        this.bleuEndDoc();
        System.out.println();
        this.realserEndDoc(testName);
    }

    public void showParseStats() {
        int pCompleteCount = this.pCount - this.pBadCount;
        int pFragCount = this.pBadCount - this.pFailedCount;
        String pComplete = "" + pCompleteCount;
        String pCompletePct = "" + nf.format(100.0 * (double)pCompleteCount / (double)this.pCount) + "%";
        System.out.println("Strings parsed completely (in fragments, failed): " + pComplete + " (" + pFragCount + ", " + this.pFailedCount + ") " + pCompletePct);
        String pInexact = "" + (this.pCount - this.pExactCount);
        String pExactPct = "" + nf.format(100.0 * (double)this.pExactCount / (double)this.pCount) + "%";
        System.out.println("Strings parsed exactly (inexactly): " + this.pExactCount + " (" + pInexact + ") " + pExactPct);
        String avgEdges = nf.format(1.0 * (double)this.pTotalEdges / (double)this.pCount);
        System.out.println("Average edge count (before unpacking): " + avgEdges);
        String avgEdgesGood = nf.format(1.0 * (double)this.pTotalEdgesGood / (double)pCompleteCount);
        System.out.println("Average edge count (before unpacking) for complete parses: " + avgEdgesGood);
        System.out.println("Max edge count: " + this.pMaxEdges);
        System.out.println("Max edge count for complete parses: " + this.pMaxEdgesGood);
        String avgUnpacked = nf.format(1.0 * (double)this.pTotalUnpackingEdges / (double)this.pCount);
        System.out.println("Average edges unpacked (created while unpacking): " + avgUnpacked);
        System.out.println("Max unpacked edges: " + this.pMaxUnpackingEdges);
        String avgLexTime = nf.format(1.0 * (double)this.pTotalLexTime / (double)this.pCount);
        String avgCellMax = nf.format(1.0 * (double)this.pTotalCellMax / (double)this.pCount);
        System.out.println("Average max cell size (before unpacking): " + avgCellMax);
        String avgCellMaxGood = nf.format(1.0 * (double)this.pTotalCellMaxGood / (double)pCompleteCount);
        System.out.println("Average max cell size (before unpacking) for complete parses: " + avgCellMaxGood);
        System.out.println("Max max cell size: " + this.pMaxCellMax);
        System.out.println("Max max cell size for complete parses: " + this.pMaxCellMaxGood);
        System.out.println("Average lex lookup time: " + avgLexTime);
        String avgParseTime = nf.format(1.0 * (double)this.pTotalParseTime / (double)this.pCount);
        System.out.println("Max lex lookup time: " + this.pMaxLexTime);
        System.out.println("Average parse time: " + avgParseTime);
        System.out.println("Max parse time: " + this.pMaxParseTime);
        String avgChartTime = nf.format(1.0 * (double)this.pTotalChartTime / (double)this.pCount);
        System.out.println("Average chart construction time: " + avgChartTime);
        System.out.println("Max chart construction time: " + this.pMaxChartTime);
        String avgUnpackingTime = nf.format(1.0 * (double)this.pTotalUnpackingTime / (double)this.pCount);
        System.out.println("Average unpacking time: " + avgUnpackingTime);
        System.out.println("Max unpacking time: " + this.pMaxUnpackingTime);
        System.out.println("Supertagger beta tallies:");
        Set<Double> betas = this.pBetaTallies.keySet();
        for (double beta : betas) {
            int tally = this.pBetaTallies.get(beta);
            System.out.println(beta + "\t" + tally);
        }
        String avgF = nf.format(100.0 * this.totalF / (double)this.pCount);
        System.out.println("Labeled f-score: " + avgF);
        String avgRecall = nf.format(100.0 * this.totalRecall / (double)this.pCount);
        System.out.println("Labeled recall: " + avgRecall);
        String avgPrecision = nf.format(100.0 * this.totalPrecision / (double)this.pCount);
        System.out.println("Labeled precision: " + avgPrecision);
        String avgDepsF = nf.format(100.0 * this.totalDepsF / (double)this.pCount);
        System.out.println("Labeled f-score deps only: " + avgDepsF);
        String avgDepsRecall = nf.format(100.0 * this.totalDepsRecall / (double)this.pCount);
        System.out.println("Labeled recall deps only: " + avgDepsRecall);
        String avgDepsPrecision = nf.format(100.0 * this.totalDepsPrecision / (double)this.pCount);
        System.out.println("Labeled precision deps only: " + avgDepsPrecision);
        String avgUnlabeledDepsF = nf.format(100.0 * this.totalUnlabeledDepsF / (double)this.pCount);
        System.out.println("Unlabeled deps f-score: " + avgUnlabeledDepsF);
        String avgUnlabeledDepsRecall = nf.format(100.0 * this.totalUnlabeledDepsRecall / (double)this.pCount);
        System.out.println("Unlabeled deps recall: " + avgUnlabeledDepsRecall);
        String avgUnlabeledDepsPrecision = nf.format(100.0 * this.totalUnlabeledDepsPrecision / (double)this.pCount);
        System.out.println("Unlabeled deps precision: " + avgUnlabeledDepsPrecision);
        String avgFComplete = nf.format(100.0 * this.totalFComplete / (double)pCompleteCount);
        System.out.println("Labeled f-score for complete parses: " + avgFComplete);
        String avgRecallComplete = nf.format(100.0 * this.totalRecallComplete / (double)pCompleteCount);
        System.out.println("Labeled recall for complete parses: " + avgRecallComplete);
        String avgPrecisionComplete = nf.format(100.0 * this.totalPrecisionComplete / (double)pCompleteCount);
        System.out.println("Labeled precision for complete parses: " + avgPrecisionComplete);
        String avgDepsFComplete = nf.format(100.0 * this.totalDepsFComplete / (double)pCompleteCount);
        System.out.println("Labeled f-score deps only for complete parses: " + avgDepsFComplete);
        String avgDepsRecallComplete = nf.format(100.0 * this.totalDepsRecallComplete / (double)pCompleteCount);
        System.out.println("Labeled recall deps only for complete parses: " + avgDepsRecallComplete);
        String avgDepsPrecisionComplete = nf.format(100.0 * this.totalDepsPrecisionComplete / (double)pCompleteCount);
        System.out.println("Labeled precision deps only for complete parses: " + avgDepsPrecisionComplete);
        String avgUnlabeledDepsFComplete = nf.format(100.0 * this.totalUnlabeledDepsFComplete / (double)pCompleteCount);
        System.out.println("Unlabeled deps f-score for complete parses: " + avgUnlabeledDepsFComplete);
        String avgUnlabeledDepsRecallComplete = nf.format(100.0 * this.totalUnlabeledDepsRecallComplete / (double)pCompleteCount);
        System.out.println("Unlabeled deps recall for complete parses: " + avgUnlabeledDepsRecallComplete);
        String avgUnlabeledDepsPrecisionComplete = nf.format(100.0 * this.totalUnlabeledDepsPrecisionComplete / (double)pCompleteCount);
        System.out.println("Unlabeled deps precision for complete parses: " + avgUnlabeledDepsPrecisionComplete);
        if (this.oracleBetter > 0) {
            System.out.println("Oracle better: " + this.oracleBetter);
        }
        if (this.goldMissing > 0) {
            System.out.println("Gold missing: " + this.goldMissing);
        }
        System.out.println();
    }

    public void showStats() {
        int rCompleteCount = this.rCount - this.rBadCount;
        String rComplete = "" + rCompleteCount;
        String rCompletePct = "" + nf.format(100.0 * (double)rCompleteCount / (double)this.rCount) + "%";
        System.out.println("Strings realized completely (in fragments): " + rComplete + " (" + this.rBadCount + ") " + rCompletePct);
        String rInexact = "" + (this.rCount - this.rExactCount);
        String rExactPct = "" + nf.format(100.0 * (double)this.rExactCount / (double)this.rCount) + "%";
        System.out.println("Strings realized exactly (inexactly): " + this.rExactCount + " (" + rInexact + ") " + rExactPct);
        System.out.println("Strings where realization finished: " + this.rDoneCount);
        String avgScore = nf.format(this.totalScore / (double)this.rCount);
        System.out.println("Avg score: " + avgScore);
        String avgScoreComplete = nf.format(this.totalScoreComplete / (double)rCompleteCount);
        System.out.println("Avg score for complete realizations: " + avgScoreComplete);
        String meanReciprocalRank = nf.format(this.totalReciprocalRank / (double)this.rCount);
        System.out.println("Mean reciprocal rank: " + meanReciprocalRank);
        String residualMRR = this.rCount == this.rExactCount ? "n/a" : nf.format((this.totalReciprocalRank - (double)this.rExactCount) / (double)(this.rCount - this.rExactCount));
        System.out.println("Residual mean reciprocal rank: " + residualMRR);
        String avgNodes = nf.format((double)this.totalNominals * 1.0 / (double)this.rCount);
        String avgTokens = nf.format((double)this.totalTokens * 1.0 / (double)this.rCount);
        System.out.println("Avg num nodes, words: " + avgNodes + ", " + avgTokens);
        System.out.println("Num words (min-max): " + this.minTokens + "-" + this.maxTokens);
        String avgRuleApps = nf.format((double)this.totalRuleApps * 1.0 / (double)this.rCount);
        System.out.println("Avg num rule apps: " + avgRuleApps);
        String avgEdges = nf.format((double)this.totalEdges * 1.0 / (double)this.rCount);
        String avgEdgesCreated = nf.format((double)this.totalEdgesCreated * 1.0 / (double)this.rCount);
        String avgUnprunedEdges = nf.format((double)this.totalUnprunedEdges * 1.0 / (double)this.rCount);
        System.out.println("Avg num edges in chart: " + avgEdges);
        System.out.println("Avg num edges created: " + avgEdgesCreated);
        System.out.println("Avg num unpruned edges: " + avgUnprunedEdges);
        String avgRemoved = nf.format((double)this.totalPrunedRemoved * 1.0 / (double)this.rCount);
        String avgNeverAdded = nf.format((double)this.totalPrunedNeverAdded * 1.0 / (double)this.rCount);
        System.out.println("Avg num pruned edges removed, never added: " + avgRemoved + ", " + avgNeverAdded);
        String avgCellMax = nf.format((double)this.totalCellMax * 1.0 / (double)this.rCount);
        System.out.println("Avg cell max: " + avgCellMax);
        String avgNewBest = nf.format((double)this.totalNewBest * 1.0 / (double)this.rCount);
        System.out.println("Total, avg num new best realizations: " + this.totalNewBest + ", " + avgNewBest);
        String avgLex = nf.format(this.lexMap.mean());
        String stdLex = nf.format(this.lexMap.sigma());
        System.out.println("Avg (std) time 'til lex lookup finished: " + avgLex + " (" + stdLex + ")");
        System.out.println("Max time 'til lex lookup finished: " + this.maxLex + " (" + this.maxLexStr + ")");
        String avgFirst = nf.format(this.firstMap.mean());
        String stdFirst = nf.format(this.firstMap.sigma());
        System.out.println("Avg (std) time 'til first realization: " + avgFirst + " (" + stdFirst + ")");
        System.out.println("Max time 'til first realization: " + this.maxFirst + " (" + this.maxFirstStr + ")");
        String avgBest = nf.format(this.bestMap.mean());
        String stdBest = nf.format(this.bestMap.sigma());
        System.out.println("Avg (std) time 'til best realization: " + avgBest + " (" + stdBest + ")");
        System.out.println("Max time 'til best realization: " + this.maxBest + " (" + this.maxBestStr + ")");
        System.out.println("Max time 'til new best realization: " + this.maxNewBest + " (" + this.maxNewBestStr + ")");
        String avgPacked = nf.format(this.totalPacked / this.rCount);
        System.out.println("Avg time 'til done packing: " + avgPacked);
        System.out.println("Max time 'til done packing: " + this.maxPacked + " (" + this.maxPackedStr + ")");
        String avgStoppedOrDone = nf.format(this.allMap.mean());
        String stdStoppedOrDone = nf.format(this.allMap.sigma());
        System.out.println("Avg (std) time 'til stopped/done with realizations: " + avgStoppedOrDone + " (" + stdStoppedOrDone + ")");
        System.out.println("Max time 'til stopped/done with realizations: " + this.maxStoppedOrDone + " (" + this.maxStoppedOrDoneStr + ")");
        if (this.oracleBetter > 0) {
            System.out.println("Oracle better: " + this.oracleBetter);
        }
        if (this.goldMissing > 0) {
            System.out.println("Gold missing: " + this.goldMissing);
        }
        if (this.statsfile != null) {
            Document doc = new Document();
            Element root = new Element("rstats");
            doc.setRootElement(root);
            Element counts = new Element("counts");
            root.addContent((Content)counts);
            counts.setAttribute("realized", "" + this.rCount);
            counts.setAttribute("complete", "" + rComplete);
            counts.setAttribute("fragments", "" + this.rBadCount);
            counts.setAttribute("exact", "" + this.rExactCount);
            counts.setAttribute("inexact", rInexact);
            counts.setAttribute("finished", "" + this.rDoneCount);
            Element overall = new Element("overall");
            root.addContent((Content)overall);
            overall.setAttribute("avg-score", avgScore);
            overall.setAttribute("mean-reciprocal-rank", meanReciprocalRank);
            overall.setAttribute("residual-mrr", residualMRR);
            overall.setAttribute("avg-nodes", avgNodes);
            overall.setAttribute("avg-words", avgTokens);
            overall.setAttribute("min-words", "" + this.minTokens);
            overall.setAttribute("max-words", "" + this.maxTokens);
            Element rules = new Element("rules");
            root.addContent((Content)rules);
            rules.setAttribute("avg-apps", avgRuleApps);
            Element edges = new Element("edges");
            root.addContent((Content)edges);
            edges.setAttribute("avg", avgEdges);
            edges.setAttribute("avg-unpruned", avgUnprunedEdges);
            edges.setAttribute("avg-removed", avgRemoved);
            edges.setAttribute("avg-never-added", avgNeverAdded);
            edges.setAttribute("avg-cell-max", avgCellMax);
            if (this.oracleBetter > 0) {
                edges.setAttribute("oracle-better", "" + this.oracleBetter);
            }
            if (this.goldMissing > 0) {
                edges.setAttribute("gold-missing", "" + this.goldMissing);
            }
            Element newBest = new Element("new-best");
            root.addContent((Content)newBest);
            newBest.setAttribute("total", "" + this.totalNewBest);
            newBest.setAttribute("avg", avgNewBest);
            Element times = new Element("times-summary");
            root.addContent((Content)times);
            times.setAttribute("avg-lex", avgLex);
            times.setAttribute("std-lex", stdLex);
            times.setAttribute("avg-first", avgFirst);
            times.setAttribute("std-first", stdFirst);
            times.setAttribute("max-first", "" + this.maxFirst);
            times.setAttribute("avg-best", avgBest);
            times.setAttribute("std-best", stdBest);
            times.setAttribute("max-best", "" + this.maxBest);
            times.setAttribute("max-new-best", "" + this.maxNewBest);
            times.setAttribute("avg-packed", avgPacked);
            times.setAttribute("max-packed", "" + this.maxPacked);
            times.setAttribute("avg-stopped-or-done", avgStoppedOrDone);
            times.setAttribute("std-stopped-or-done", stdStoppedOrDone);
            times.setAttribute("max-stopped-or-done", "" + this.maxStoppedOrDone);
            Element strings = new Element("max-strings");
            root.addContent((Content)strings);
            Element lex = new Element("lex");
            strings.addContent((Content)lex);
            lex.addContent(this.maxLexStr);
            Element first = new Element("first");
            strings.addContent((Content)first);
            first.addContent(this.maxFirstStr);
            Element best = new Element("best");
            strings.addContent((Content)best);
            best.addContent(this.maxBestStr);
            Element newBest2 = new Element("new-best");
            strings.addContent((Content)newBest2);
            newBest2.addContent(this.maxNewBestStr);
            Element packed = new Element("packed");
            strings.addContent((Content)packed);
            packed.addContent(this.maxPackedStr);
            Element stoppedOrDone = new Element("stopped-or-done");
            strings.addContent((Content)stoppedOrDone);
            stoppedOrDone.addContent(this.maxStoppedOrDoneStr);
            Element scores = new Element("scores");
            root.addContent((Content)scores);
            for (int i = 0; i < this.bestActualScores.size(); ++i) {
                Element score = new Element("score");
                scores.addContent((Content)score);
                score.setAttribute("val", this.bestActualScores.get(i).toString());
                score.setAttribute("est", this.bestEstimatedScores.get(i).toString());
                score.setAttribute("rank", this.itemRanks.get(i).toString());
            }
            this.firstMap.saveTimes(root);
            this.bestMap.saveTimes(root);
            this.allMap.saveTimes(root);
            try {
                FileOutputStream out = new FileOutputStream(this.statsfile);
                this.grammar.serializeXml(doc, out);
                out.flush();
            }
            catch (IOException exc) {
                System.out.println("Unable to write stats to: " + this.statsfile + " (" + exc + ")");
            }
        }
    }

    private static void showOutcome(String parseResult, String realizeResult, String starForBadSentence, String str) {
        Regression.showOutcome(parseResult, realizeResult, starForBadSentence, str, null);
    }

    private static void showOutcome(String parseResult, String realizeResult, String starForBadSentence, String str, String bestRealization) {
        System.out.print(parseResult + "\t" + realizeResult + "\t");
        Regression.simpleWrap(starForBadSentence + str);
        if (bestRealization != null) {
            System.out.print("\t\t");
            Regression.simpleWrap("(best: " + bestRealization + ")");
        }
    }

    private static void simpleWrap(String str) {
        int TEXTWIDTH = 60;
        for (int i = 0; i <= (str.length() - 1) / TEXTWIDTH; ++i) {
            if (i != 0) {
                System.out.print("\t\t");
            }
            System.out.println(str.substring(i * TEXTWIDTH, Math.min(i * TEXTWIDTH + TEXTWIDTH, str.length())));
        }
    }

    private static NumberFormat initNF() {
        NumberFormat f = NumberFormat.getInstance();
        f.setMinimumIntegerDigits(1);
        f.setMinimumFractionDigits(1);
        f.setMaximumFractionDigits(2);
        return f;
    }

    private static NumberFormat initNFE() {
        DecimalFormat f = new DecimalFormat("0.###E0");
        return f;
    }

    static void showRealizerSettings() {
        Preferences prefs = Preferences.userNodeForPackage(TextCCG.class);
        boolean useIndexing = prefs.getBoolean("Use Indexing", true);
        boolean useChunks = prefs.getBoolean("Use Chunks", true);
        boolean useLicensing = prefs.getBoolean("Use Feature Licensing", true);
        boolean useCombos = prefs.getBoolean("Use Combos", true);
        boolean usePacking = prefs.getBoolean("Use Packing", false);
        int timeLimit = prefs.getInt("Time Limit", 0);
        double nbTimeLimit = prefs.getDouble("New Best Time Limit", 0.0);
        int pruningVal = prefs.getInt("Pruning Value", 0);
        int cellPruningVal = prefs.getInt("Cell Pruning Value", 0);
        String msg = "Timing realization with index filtering " + (useIndexing ? "on" : "off") + ", ";
        msg = msg + "chunks " + (useChunks ? "on" : "off") + ", ";
        msg = msg + "licensing " + (useLicensing ? "on" : "off") + ", ";
        if (usePacking) {
            msg = msg + "packing on, ";
        } else {
            msg = msg + "combos " + (useCombos ? "on" : "off") + ", ";
            msg = timeLimit == 0 ? msg + "no time limit, " : msg + "a time limit of " + timeLimit + " ms, ";
            if (nbTimeLimit == 0.0) {
                msg = msg + "no new best time limit, ";
            } else {
                msg = msg + "a new best time limit of ";
                msg = nbTimeLimit >= 1.0 ? msg + (int)nbTimeLimit + " ms, " : msg + nbTimeLimit + " of first, ";
            }
        }
        msg = pruningVal == 0 ? msg + "no pruning, " : msg + "a pruning value of " + pruningVal + ", ";
        msg = msg + "and ";
        msg = cellPruningVal == 0 ? msg + "no cell pruning" : msg + "a cell pruning value of " + cellPruningVal;
        System.out.println(msg);
        System.out.println();
    }

    public void writeTargets(File tbFile, String textfile) throws IOException {
        this.writeTargets(tbFile, textfile, false, false, false);
    }

    public void writeTargetsSC(File tbFile, String textfile) throws IOException {
        this.writeTargets(tbFile, textfile, true, false, false);
    }

    public void writeTargetsF(File tbFile, String textfile) throws IOException {
        this.writeTargets(tbFile, textfile, false, true, false);
    }

    public void writeTargetsFSC(File tbFile, String textfile) throws IOException {
        this.writeTargets(tbFile, textfile, true, true, false);
    }

    private void writeTargets(File tbFile, String filename, boolean semClassReplacement, boolean withFactors, boolean reverse) throws IOException {
        String option = "";
        if (withFactors) {
            option = " with factors";
        }
        if (semClassReplacement) {
            option = option + " with semantic class replacement";
        }
        if (reverse) {
            option = option + ", reversed";
        }
        System.out.println("Writing text file" + option + ": " + filename);
        System.out.println();
        PrintWriter tOut = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
        HashSet<String> unique = new HashSet<String>();
        Tokenizer tokenizer = this.grammar.lexicon.tokenizer;
        for (File f : Regression.getXMLFiles(tbFile)) {
            System.out.println("Loading testbed from: " + f);
            RegressionInfo tbInfo = new RegressionInfo(this.grammar, f);
            int numItems = tbInfo.numberOfItems();
            for (int i = 0; i < numItems; ++i) {
                if (i % 2 == 1 && this.evenOnly || i % 2 == 0 && this.oddOnly) continue;
                RegressionInfo.TestItem testItem = tbInfo.getItem(i);
                if (testItem.numOfParses == 0) continue;
                String s = testItem.sentence;
                List<Word> words = null;
                words = semClassReplacement || withFactors ? (testItem.sign != null ? testItem.sign.getWords() : (testItem.fullWords != null ? tokenizer.tokenize(testItem.fullWords, true) : this.grammar.getParsedWords(s))) : tokenizer.tokenize(s);
                if (reverse) {
                    List<Word> tmp = words;
                    words = new ArrayList<Word>(words.size());
                    words.add(Word.createWord("<s>"));
                    for (int j = tmp.size() - 1; j >= 0; --j) {
                        Word w = tmp.get(j);
                        if (w.getForm() == "<s>" || w.getForm() == "</s>") continue;
                        words.add(w);
                    }
                    words.add(Word.createWord("</s>"));
                }
                String str = !withFactors ? tokenizer.getOrthography(words, semClassReplacement) : tokenizer.format(words, semClassReplacement);
                tOut.println(str);
                unique.add(str);
                System.out.print(".");
            }
            System.out.println();
        }
        tOut.flush();
        tOut.close();
        System.out.println();
        System.out.println("Unique strings: " + unique.size());
        System.out.println();
    }

    private void writeDerivationFactors(File tbFile, String filename) throws IOException {
        System.out.println("Writing derivation factors file: " + filename);
        System.out.println();
        PrintWriter tOut = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
        Tokenizer tokenizer = this.grammar.lexicon.tokenizer;
        for (File f : Regression.getXMLFiles(tbFile)) {
            System.out.println("Loading testbed from: " + f);
            RegressionInfo tbInfo = new RegressionInfo(this.grammar, f);
            int numItems = tbInfo.numberOfItems();
            for (int i = 0; i < numItems; ++i) {
                RegressionInfo.TestItem testItem = tbInfo.getItem(i);
                if (testItem.numOfParses == 0) continue;
                Sign sign = testItem.sign;
                List<Word> factors = GenerativeSyntacticModel.getFactors(sign);
                for (Word w : factors) {
                    tOut.print(tokenizer.format(w));
                    tOut.print(" ");
                }
                tOut.println();
                System.out.print(".");
            }
            System.out.println();
        }
        tOut.flush();
        tOut.close();
        System.out.println();
    }

    public static void main(String[] args) throws IOException {
        File tmpParent;
        String usage = "java opennlp.ccg.test.Regression \n  (-noparsing) (-norealization) (-even|-odd) (-gc) \n  (-nullscorer) (-randomscorer) \n  (-depthfirst) (-exactmatches) (-aanfilter (<excfile>)) \n  (-scorer <scorerclass>) \n  (-parsescorer <scorerclass>) \n  (-extractor <extractorclass>) \n  (-ngrampruningstrategy) (-pruningstrategy <pruningstrategyclass>) \n  (-hypertagger <hypertaggerclass> | -htconfig <configfile>) (-htgold) \n  (-supertagger <supertaggerclass> | -stconfig <configfile>) \n  (-ngramorder N) (-lm|-lmsc <lmfile>) \n  (-srilm " + Arrays.toString((Object[])SRILMNgramModelType.values()) + ")\n  (-flm|-flmsc <flmfile>) \n  (-text|-textsc|-textf|-textfsc <textfile>) (-reverse) \n  (-derivf <derivfactorsfile>) \n  (-2events <eventfile>) (-includegoldinevents) \n  (-2apml <apmldir>) (-bleu <bleufileprefix>) \n  (-nbestrealfile <nbestrealfile>) (-nbestnormbleu) (-realserdir <realserdir>) \n  (-nbestincludelfs) \n  (-rescorefile <rescorefile>) \n  (-nbestparsefile <nbestparsefile>) \n  (-g <grammarfile>) (-s <statsfile>) (<regressionfile>|<regressiondir>)";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println("Usage: \n\n" + usage);
            System.exit(0);
        }
        Regression tester = new Regression();
        String grammarfile = "grammar.xml";
        String regressionfile = "testbed.xml";
        boolean depthFirst = false;
        boolean aanfilter = false;
        String excfile = null;
        String scorerClass = null;
        String parseScorerClass = null;
        String extractorClass = null;
        boolean ngrampruningstrategy = false;
        String pruningStrategyClass = null;
        String hypertaggerClass = null;
        String htconfig = null;
        boolean htgold = false;
        String supertaggerClass = null;
        String stconfig = null;
        String lmfile = null;
        String flmfile = null;
        boolean useSemClasses = false;
        boolean withFactors = false;
        boolean reverse = false;
        String textfile = null;
        String derivfactorsfile = null;
        boolean srilm = false;
        SRILMNgramModelType srilmModelType = SRILMNgramModelType.STANDARD;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-D")) {
                String prop = args[i].substring(2);
                int equalpos = prop.indexOf("=");
                String key = prop.substring(0, equalpos);
                String val = prop.substring(equalpos + 1);
                System.setProperty(key, val);
                continue;
            }
            if (args[i].equals("-noparsing")) {
                tester.doParsing = false;
                continue;
            }
            if (args[i].equals("-norealization")) {
                tester.doRealization = false;
                continue;
            }
            if (args[i].equals("-even")) {
                tester.evenOnly = true;
                continue;
            }
            if (args[i].equals("-odd")) {
                tester.oddOnly = true;
                continue;
            }
            if (args[i].equals("-gc")) {
                tester.doGC = true;
                continue;
            }
            if (args[i].equals("-nullscorer")) {
                tester.scorer = SignScorer.nullScorer;
                tester.parseScorer = SignScorer.nullScorer;
                continue;
            }
            if (args[i].equals("-randomscorer")) {
                tester.scorer = SignScorer.randomScorer;
                tester.parseScorer = SignScorer.randomScorer;
                continue;
            }
            if (args[i].equals("-depthfirst")) {
                depthFirst = true;
                continue;
            }
            if (args[i].equals("-exactmatches")) {
                tester.exactMatches = true;
                continue;
            }
            if (args[i].equals("-aanfilter")) {
                aanfilter = true;
                if (i >= args.length - 1 || args[i + 1].charAt(0) == '-') continue;
                excfile = args[++i];
                continue;
            }
            if (args[i].equals("-scorer")) {
                scorerClass = args[++i];
                continue;
            }
            if (args[i].equals("-parsescorer")) {
                parseScorerClass = args[++i];
                continue;
            }
            if (args[i].equals("-extractor")) {
                extractorClass = args[++i];
                continue;
            }
            if (args[i].equals("-ngrampruningstrategy")) {
                ngrampruningstrategy = true;
                continue;
            }
            if (args[i].equals("-pruningstrategy")) {
                pruningStrategyClass = args[++i];
                continue;
            }
            if (args[i].equals("-hypertagger")) {
                hypertaggerClass = args[++i];
                continue;
            }
            if (args[i].equals("-htconfig")) {
                htconfig = args[++i];
                continue;
            }
            if (args[i].equals("-htgold")) {
                htgold = true;
                continue;
            }
            if (args[i].equals("-supertagger")) {
                supertaggerClass = args[++i];
                continue;
            }
            if (args[i].equals("-stconfig")) {
                stconfig = args[++i];
                continue;
            }
            if (args[i].equals("-ngramorder")) {
                tester.ngramOrder = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-lm")) {
                lmfile = args[++i];
                continue;
            }
            if (args[i].equals("-lmsc")) {
                lmfile = args[++i];
                useSemClasses = true;
                continue;
            }
            if (args[i].equals("-flm")) {
                flmfile = args[++i];
                continue;
            }
            if (args[i].equals("-flmsc")) {
                flmfile = args[++i];
                useSemClasses = true;
                continue;
            }
            if (args[i].equals("-reverse")) {
                reverse = true;
                continue;
            }
            if (args[i].equals("-text")) {
                textfile = args[++i];
                continue;
            }
            if (args[i].equals("-textsc")) {
                textfile = args[++i];
                useSemClasses = true;
                continue;
            }
            if (args[i].equals("-textf")) {
                textfile = args[++i];
                withFactors = true;
                continue;
            }
            if (args[i].equals("-textfsc")) {
                textfile = args[++i];
                useSemClasses = true;
                withFactors = true;
                continue;
            }
            if (args[i].equals("-derivf")) {
                derivfactorsfile = args[++i];
                continue;
            }
            if (args[i].equals("-2events")) {
                tester.eventfile = args[++i];
                continue;
            }
            if (args[i].equals("-includegoldinevents")) {
                tester.includeGoldInEvents = true;
                continue;
            }
            if (args[i].equals("-2apml")) {
                tester.apmldir = args[++i];
                continue;
            }
            if (args[i].equals("-bleu")) {
                tester.bleufileprefix = args[++i];
                continue;
            }
            if (args[i].equals("-nbestrealfile")) {
                tester.nbestrealfile = args[++i];
                continue;
            }
            if (args[i].equals("-nbestnormbleu")) {
                tester.nbestnormbleu = true;
                continue;
            }
            if (args[i].equals("-realserdir")) {
                tester.realserdir = args[++i];
                continue;
            }
            if (args[i].equals("-nbestincludelfs")) {
                tester.nbestincludelfs = true;
                continue;
            }
            if (args[i].equals("-rescorefile")) {
                tester.rescorefile = args[++i];
                continue;
            }
            if (args[i].equals("-nbestparsefile")) {
                tester.nbestparsefile = args[++i];
                continue;
            }
            if (args[i].equals("-g")) {
                grammarfile = args[++i];
                continue;
            }
            if (args[i].equals("-s")) {
                tester.statsfile = args[++i];
                continue;
            }
            if (args[i].equals("-srilm")) {
                srilm = true;
                if (i >= args.length - 1) continue;
                String type = args[i + 1];
                try {
                    srilmModelType = SRILMNgramModelType.valueOf(type);
                    ++i;
                }
                catch (IllegalArgumentException iae) {
                    srilmModelType = SRILMNgramModelType.STANDARD;
                    System.err.println("Warning: unknown SRILM n-gram model type " + type + " specified, using default (" + (Object)((Object)srilmModelType) + ")");
                }
                continue;
            }
            regressionfile = args[i];
        }
        URL grammarURL = new File(grammarfile).toURI().toURL();
        System.out.println("Loading grammar from URL: " + grammarURL);
        tester.grammar = new Grammar(grammarURL);
        System.out.println();
        AAnFilter aanFilter = null;
        if (aanfilter) {
            if (excfile != null) {
                System.out.println("Loading a/an exceptions from file: " + excfile);
            }
            AAnFilter aAnFilter = aanFilter = excfile != null ? new AAnFilter(excfile) : new AAnFilter();
        }
        if (scorerClass != null) {
            try {
                System.out.println("Instantiating sign scorer from class: " + scorerClass);
                SignScorer scorer = (SignScorer)Class.forName(scorerClass).newInstance();
                if (scorer instanceof NgramScorer) {
                    NgramScorer lmScorer = (NgramScorer)scorer;
                    if (aanfilter) {
                        lmScorer.addFilter(aanFilter);
                    }
                    tester.ngramOrder = lmScorer.getOrder();
                }
                tester.scorer = scorer;
                System.out.println();
            }
            catch (Exception exc) {
                throw (RuntimeException)new RuntimeException().initCause(exc);
            }
        }
        if (lmfile != null) {
            AbstractStandardNgramModel lmScorer;
            int order = tester.ngramOrder > 0 ? tester.ngramOrder : 3;
            String reversedStr = reverse ? "reversed " : "";
            System.out.println("Loading " + reversedStr + order + "-gram model from file: " + lmfile);
            AbstractStandardNgramModel abstractStandardNgramModel = lmScorer = srilm ? new SRILMNgramModel(order, new File(lmfile), useSemClasses, srilmModelType) : new StandardNgramModel(order, lmfile, useSemClasses);
            if (reverse) {
                lmScorer.setReverse(true);
            }
            if (aanfilter) {
                lmScorer.addFilter(aanFilter);
            }
            tester.scorer = lmScorer;
            System.out.println();
        }
        if (flmfile != null) {
            String reversedStr = reverse ? "reversed " : "";
            System.out.println("Loading " + reversedStr + "factored n-gram model family from file: " + flmfile);
            FactoredNgramModelFamily flmScorer = new FactoredNgramModelFamily(flmfile, useSemClasses);
            if (reverse) {
                ((NgramScorer)flmScorer).setReverse(true);
            }
            if (aanfilter) {
                flmScorer.addFilter(aanFilter);
            }
            tester.scorer = flmScorer;
            tester.ngramOrder = flmScorer.getOrder();
            System.out.println();
        }
        if (textfile != null) {
            File tbFile = new File(regressionfile);
            tester.writeTargets(tbFile, textfile, useSemClasses, withFactors, reverse);
            System.exit(0);
        }
        if (derivfactorsfile != null) {
            File tbFile = new File(regressionfile);
            tester.writeDerivationFactors(tbFile, derivfactorsfile);
            System.exit(0);
        }
        if (tester.doParsing) {
            tester.parser = new Parser(tester.grammar);
            if (parseScorerClass != null) {
                try {
                    System.out.println("Instantiating parsing sign scorer from class: " + parseScorerClass);
                    tester.parseScorer = (SignScorer)Class.forName(parseScorerClass).newInstance();
                    tester.showParseStats = true;
                    System.out.println();
                }
                catch (Exception exc) {
                    throw (RuntimeException)new RuntimeException().initCause(exc);
                }
            }
            if (tester.parseScorer != null) {
                tester.parser.setSignScorer(tester.parseScorer);
            }
            if (tester.nbestparsefile != null) {
                tester.showParseStats = true;
            }
            if (supertaggerClass != null || stconfig != null) {
                try {
                    Supertagger supertagger;
                    if (supertaggerClass != null) {
                        System.out.println("Instantiating supertagger from class: " + supertaggerClass);
                        supertagger = (Supertagger)Class.forName(supertaggerClass).newInstance();
                    } else {
                        System.out.println("Instantiating supertagger from config file: " + stconfig);
                        supertagger = WordAndPOSDictionaryLabellingStrategy.supertaggerFactory(stconfig);
                    }
                    tester.parser.setSupertagger(supertagger);
                    if (tester.eventfile != null) {
                        supertagger.setIncludeGold(true);
                        tester.parser.setSupertaggerMostToLeastRestrictiveDirection(false);
                    }
                    System.out.println();
                }
                catch (Exception exc) {
                    throw (RuntimeException)new RuntimeException().initCause(exc);
                }
            }
        }
        if (tester.doRealization) {
            tester.realizer = new Realizer(tester.grammar);
            tester.realizer.depthFirst = depthFirst;
            if (ngrampruningstrategy) {
                int order = tester.ngramOrder > 0 ? tester.ngramOrder : 3;
                System.out.println("Instantiating n-gram diversity pruning strategy with order " + order);
                tester.realizer.pruningStrategy = new NgramDiversityPruningStrategy(order);
                System.out.println();
            }
            if (pruningStrategyClass != null) {
                try {
                    System.out.println("Instantiating pruning strategy from class: " + pruningStrategyClass);
                    tester.realizer.pruningStrategy = (PruningStrategy)Class.forName(pruningStrategyClass).newInstance();
                    System.out.println();
                }
                catch (Exception exc) {
                    throw (RuntimeException)new RuntimeException().initCause(exc);
                }
            }
            if (hypertaggerClass != null || htconfig != null) {
                try {
                    Hypertagger hypertagger;
                    if (hypertaggerClass != null) {
                        System.out.println("Instantiating hypertagger from class: " + hypertaggerClass);
                        hypertagger = (Hypertagger)Class.forName(hypertaggerClass).newInstance();
                    } else {
                        System.out.println("Instantiating hypertagger from config file: " + htconfig);
                        hypertagger = ZLMaxentHypertagger.ZLMaxentHypertaggerFactory(htconfig);
                    }
                    tester.realizer.hypertagger = hypertagger;
                    if (tester.eventfile != null) {
                        hypertagger.setIncludeGold(true);
                    }
                    if (htgold) {
                        hypertagger.setIncludeGold(true);
                    }
                    System.out.println();
                }
                catch (Exception exc) {
                    throw (RuntimeException)new RuntimeException().initCause(exc);
                }
            }
            Regression.showRealizerSettings();
        }
        if (tester.eventfile != null) {
            File tmp = new File(tester.eventfile);
            tmpParent = tmp.getParentFile();
            if (tmpParent != null) {
                tmpParent.mkdirs();
            }
            System.out.println("Writing event file to: " + tester.eventfile);
            System.out.println();
        }
        if (tester.eventfile != null) {
            if (tester.doParsing && tester.doRealization) {
                throw new RuntimeException("Events can't be generated for parsing and realization at the same time.");
            }
            FeatureExtractor extractor = null;
            if (extractorClass != null) {
                try {
                    System.out.println("Instantiating feature extractor from class: " + extractorClass);
                    tester.featureExtractor = extractor = (FeatureExtractor)Class.forName(extractorClass).newInstance();
                    System.out.println();
                }
                catch (Exception exc) {
                    throw (RuntimeException)new RuntimeException().initCause(exc);
                }
            }
            if (tester.scorer instanceof FeatureExtractor) {
                tester.featureExtractor = extractor != null ? new ComposedFeatureExtractor(new FeatureExtractor[]{(FeatureExtractor)((Object)tester.scorer), extractor}) : (FeatureExtractor)((Object)tester.scorer);
            } else if (tester.parseScorer instanceof FeatureExtractor) {
                tester.featureExtractor = extractor != null ? new ComposedFeatureExtractor(new FeatureExtractor[]{(FeatureExtractor)((Object)tester.parseScorer), extractor}) : (FeatureExtractor)((Object)tester.parseScorer);
            }
            if (tester.featureExtractor == null) {
                tester.featureExtractor = new NgramPrecisionModel(new String[]{""}, true);
            }
            tester.featureExtractor.setAlphabet(new Alphabet(10000));
        }
        if (tester.apmldir != null) {
            File apmlDir = new File(tester.apmldir);
            if (!apmlDir.exists()) {
                apmlDir.mkdirs();
            }
            System.out.println("Writing APML files to dir: " + tester.apmldir);
            System.out.println();
        }
        if (tester.bleufileprefix != null) {
            File tmp = new File(tester.bleufileprefix + "-gen.sgm");
            tmpParent = tmp.getParentFile();
            if (tmpParent != null) {
                tmpParent.mkdirs();
            }
            System.out.println("Writing BLEU files to: " + tester.bleufileprefix + "-*.sgm");
            System.out.println();
        }
        if (tester.nbestrealfile != null) {
            File tmp = new File(tester.nbestrealfile);
            tmpParent = tmp.getParentFile();
            if (tmpParent != null) {
                tmpParent.mkdirs();
            }
            System.out.println("Writing N-best realizations to: " + tester.nbestrealfile);
            System.out.println();
        }
        if (tester.realserdir != null) {
            File realserDir = new File(tester.realserdir);
            if (!realserDir.exists()) {
                realserDir.mkdirs();
            }
            System.out.println("Writing best realization serialization files to dir: " + tester.realserdir);
            System.out.println();
        }
        if (tester.rescorefile != null) {
            File tmp = new File(tester.rescorefile);
            tmpParent = tmp.getParentFile();
            if (tmpParent != null) {
                tmpParent.mkdirs();
            }
            System.out.println("Writing rescored sign scores to: " + tester.rescorefile);
            System.out.println();
        }
        tester.runTest(new File(regressionfile));
    }
}

