/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXTransformerFactory;
import opennlp.ccgbank.CCGBankTaskTemplates;
import opennlp.ccgbank.XSLTProcessor;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class XMLFilterProcessor
extends XSLTProcessor {
    List<Templates> templates = null;
    XMLFilter filter;
    ErrorHandler errorHandler;
    static final String XSLT_KEY = "javax.xml.transform.TransformerFactory";
    static final String XSLTC_VALUE = "org.apache.xalan.xsltc.trax.TransformerFactoryImpl";

    XMLFilterProcessor(ErrorListener errorListener, ErrorHandler errorHandler) {
        super(errorListener);
        this.errorHandler = errorHandler;
    }

    @Override
    SAXTransformerFactory newTransformerFactory() {
        return super.newTransformerFactory();
    }

    @Override
    void process(InputSource inputSource) throws IOException, SAXException, TransformerException {
        this.filter = this.makeFilter(this.taskTemplatesList);
        this.filter.setContentHandler(this.serializer.asContentHandler());
        this.filter.parse(inputSource);
    }

    XMLFilter makeFilter(CCGBankTaskTemplates templates) throws FileNotFoundException, SAXException, TransformerConfigurationException {
        return this.makeFilter(Collections.singletonList(templates));
    }

    XMLFilter makeFilter(List<CCGBankTaskTemplates> templateList) throws FileNotFoundException, SAXException, TransformerConfigurationException {
        if (this.templates == null) {
            this.templates = this.makeTemplates(this.taskTemplatesList);
        }
        XMLReader currentFilter = null;
        XMLReader previousFilter = null;
        for (Templates t : this.templates) {
            currentFilter = this.transformerFactory.newXMLFilter(t);
            currentFilter.setErrorHandler(this.errorHandler);
            if (previousFilter == null) {
                currentFilter.setParent(XMLReaderFactory.createXMLReader());
            } else {
                currentFilter.setParent(previousFilter);
            }
            previousFilter = currentFilter;
        }
        if (currentFilter == null) {
            throw new IllegalArgumentException("no templates specified");
        }
        currentFilter.setErrorHandler(this.errorHandler);
        currentFilter.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        return currentFilter;
    }
}

