/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank.convert;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;

public class InfoHelper {
    private int termNo = 0;
    private int ntNo = 500;
    private static Hashtable<String, String> bbnInfo = new Hashtable();
    private static Hashtable<String, ArrayList<String>> bbnSpans = new Hashtable();
    private static ArrayList<String> bbnClasses = new ArrayList();
    private static Hashtable<String, String> quoteInfo = new Hashtable();
    private static Hashtable<String, String> sbjInfo = new Hashtable();
    private static Hashtable<String, String> fntagInfo = new Hashtable();
    private static Hashtable<String, String> tpcInfo = new Hashtable();
    private static Hashtable<String, String> treeInfo = new Hashtable();
    static File auxFileDirectory = null;
    static File bbnAuxDirectory = null;
    private ArrayList<String> treeCont = new ArrayList();
    private boolean collStatus = false;
    private String collPhr = "";
    String res = "";
    private Hashtable<String, Integer> idTally = new Hashtable();
    int plessInd = 0;

    public static void init(File auxDir, File bbnAuxDir) {
        auxFileDirectory = auxDir;
        bbnAuxDirectory = bbnAuxDir;
    }

    public static void readBBNAuxfiles(String sect) {
        String bbnAuxFile = bbnAuxDirectory + "/bbn-ccg" + sect + ".aux";
        try {
            if (new File(bbnAuxFile).exists()) {
                BufferedReader inp = new BufferedReader(new FileReader(bbnAuxFile));
                System.out.println("Reading in BBN aux file: " + bbnAuxFile);
                String line = "";
                while ((line = inp.readLine()) != null) {
                    if (line.length() == 0) continue;
                    String[] bbn = line.trim().split(" ");
                    String sentId = bbn[0];
                    String span = bbn[1] + "," + bbn[2];
                    String key = sentId + " " + span;
                    String bbnData = "";
                    for (int i = 3; i < bbn.length; ++i) {
                        bbnData = bbnData + " " + bbn[i];
                    }
                    bbnData = bbnData.trim();
                    bbnData = bbnData.replaceAll(":", "|");
                    bbnInfo.put(key, bbnData);
                    ArrayList<Object> spanList = new ArrayList();
                    if (!bbnSpans.containsKey(sentId)) {
                        bbnSpans.put(sentId, spanList);
                    }
                    spanList = bbnSpans.get(sentId);
                    spanList.add(span);
                    bbnSpans.put(sentId, spanList);
                }
                inp.close();
            }
        }
        catch (IOException e) {
            System.out.println("Error reading: " + bbnAuxFile);
        }
    }

    public static void readQuoteAuxfiles(String sect) {
        String quoteAuxFile = auxFileDirectory + "/aux-quotes-" + sect + ".txt";
        try {
            if (new File(quoteAuxFile).exists()) {
                System.out.println("Reading in quotes aux File: " + quoteAuxFile);
                String line = "";
                BufferedReader inp = new BufferedReader(new FileReader(quoteAuxFile));
                while ((line = inp.readLine()) != null) {
                    if (line.length() == 0) continue;
                    String[] quoteData = line.trim().split(" ");
                    String sentId = quoteData[0];
                    String span = quoteData[1] + "," + quoteData[2];
                    String key = sentId + " " + span;
                    String quotedText = "";
                    for (int i = 3; i < quoteData.length; ++i) {
                        quotedText = quotedText + " " + quoteData[i];
                    }
                    quotedText = quotedText.trim();
                    quoteInfo.put(key, quotedText);
                }
                inp.close();
            }
        }
        catch (IOException e) {
            System.out.println("Error reading: " + quoteAuxFile);
        }
    }

    public static void readPTBAuxfiles(String sect) {
        String ptbAuxFile = auxFileDirectory + "/ptb-aux-" + sect + ".txt";
        try {
            if (new File(ptbAuxFile).exists()) {
                System.out.println("Reading in PTB aux file: " + ptbAuxFile);
                String line = "";
                BufferedReader inp = new BufferedReader(new FileReader(ptbAuxFile));
                while ((line = inp.readLine()) != null) {
                    String key;
                    if ((line = line.trim()).length() == 0) continue;
                    String[] info = line.split(" ");
                    String wsjId = info[0];
                    String label = info[1];
                    String head = info[2];
                    String dep = info[3];
                    String rel = info[4].replaceFirst("ARG", "Arg");
                    if (label.equals("SBJ")) {
                        key = wsjId + " " + head;
                        sbjInfo.put(key, rel);
                        continue;
                    }
                    key = wsjId + " " + dep;
                    if (label.equals("FNT")) {
                        fntagInfo.put(key, rel);
                        continue;
                    }
                    if (!label.equals("TPC")) continue;
                    tpcInfo.put(key, rel);
                }
                inp.close();
            }
        }
        catch (IOException e) {
            System.out.println("Error reading: " + ptbAuxFile);
        }
    }

    public static void readTreeAuxfiles(String sect) {
        String treeAuxFile = auxFileDirectory + "/tree-aux-" + sect + ".txt";
        try {
            if (new File(treeAuxFile).exists()) {
                System.out.println("Reading in Tree aux file: " + treeAuxFile);
                BufferedReader inp = new BufferedReader(new FileReader(treeAuxFile));
                String line = "";
                while ((line = inp.readLine()) != null) {
                    String[] treeParts;
                    if (line.length() == 0 || (treeParts = line.split(" ")).length != 3) continue;
                    String key = treeParts[0] + " " + treeParts[1];
                    String catId = treeParts[2];
                    treeInfo.put(key, catId);
                }
                inp.close();
            }
        }
        catch (IOException e) {
            System.out.println("Error reading: " + treeAuxFile);
        }
    }

    public boolean checkTreeInfo(String header2, String ntId, int numCats) {
        String key = header2 + " " + ntId;
        if (treeInfo.containsKey(key)) {
            String treeCats = treeInfo.get(key);
            String[] x = treeCats.split(",");
            return numCats == x.length;
        }
        return false;
    }

    public String getTreeInfo(String key) {
        String retVal = "";
        this.treeCont = new ArrayList();
        if (treeInfo.containsKey(key)) {
            String[] temp;
            retVal = treeInfo.get(key);
            for (String x : temp = retVal.split(",")) {
                this.treeCont.add(x);
            }
        }
        return retVal;
    }

    public String getTreeId() {
        String retVal = "";
        if (this.treeCont.size() > 0) {
            retVal = this.treeCont.get(0);
            this.treeCont.remove(0);
            String[] x = retVal.split("_");
            retVal = x[1];
            if (x.length == 3) {
                retVal = "M_" + retVal;
            }
        }
        return retVal;
    }

    public String getTreeSlash() {
        String retVal = "";
        if (this.treeCont.size() > 0) {
            String slash = this.treeCont.get(0);
            String mode = "";
            if (slash.length() > 1) {
                mode = Character.toString(slash.charAt(1));
            } else if (slash.startsWith("/")) {
                mode = ">";
            } else if (slash.startsWith("\\")) {
                mode = "<";
            }
            this.treeCont.remove(0);
            retVal = Character.toString(slash.charAt(0));
            retVal = retVal + "_" + mode;
        }
        return retVal;
    }

    public String getBBNClass(String header2, String lex, String pos, String cat, int nodeInd) {
        String retVal = "";
        String semClass = "";
        boolean relFlag = false;
        if (cat.matches("pp\\[[a-z]+\\]_~2/np_2")) {
            return "";
        }
        if (pos.startsWith("NN") || pos.startsWith("RB") || pos.startsWith("JJ") || pos.startsWith("VB") || pos.equals("CD") || lex.equals("%") || pos.equals("$")) {
            relFlag = true;
        }
        if (!relFlag) {
            return "";
        }
        String sentId = header2.replaceFirst("ID=", "");
        ArrayList<Object> spanList = new ArrayList();
        String key = sentId + " " + Integer.toString(nodeInd) + "," + Integer.toString(nodeInd);
        if (bbnInfo.containsKey(key)) {
            String bbnData = bbnInfo.get(key);
            String[] info = bbnData.split(" ");
            if (info.length >= 2 && (retVal = this.classReplace(semClass = this.getCleanClass(info[0]), lex, info[1]).trim()).length() > 0 && !bbnClasses.contains(retVal)) {
                bbnClasses.add(retVal);
            }
            return retVal;
        }
        if (bbnSpans.containsKey(sentId)) {
            spanList = bbnSpans.get(sentId);
        }
        for (String span : spanList) {
            String bbnData;
            String[] info;
            String[] inds = span.split(",");
            if (inds.length != 2 || !inds[0].matches("[0-9]+") || !inds[1].matches("[0-9]+") || inds[0].equals("NA") || inds[1].equals("NA")) continue;
            int ind1 = Integer.parseInt(inds[0]);
            int ind2 = Integer.parseInt(inds[1]);
            if (nodeInd < ind1 || nodeInd > ind2 || (info = (bbnData = bbnInfo.get(key = sentId + " " + span)).split(" ")).length == 0) continue;
            semClass = this.getCleanClass(info[0]);
            boolean accClasses = false;
            if (!(semClass.startsWith("DATE") || semClass.startsWith("TIME") || semClass.startsWith("ORDINAL") || semClass.startsWith("QUANTITY") || semClass.startsWith("PERCENT") || semClass.startsWith("MONEY"))) {
                accClasses = true;
            }
            if (!accClasses && !pos.startsWith("NN") && !pos.equals("CD") && !lex.equals("%") && !pos.equals("$")) continue;
            String wordBit = "";
            int relInd = nodeInd - ind1 + 1;
            if (relInd < info.length && relInd >= 0) {
                wordBit = info[nodeInd - ind1 + 1];
            }
            if ((retVal = this.classReplace(semClass, lex, wordBit)).length() <= 0 || bbnClasses.contains(retVal)) break;
            bbnClasses.add(retVal);
            break;
        }
        return retVal;
    }

    public String classReplace(String semClass, String lex, String wordBit) {
        String retVal = "";
        if (wordBit.equals(lex)) {
            retVal = semClass;
        }
        return retVal;
    }

    public String getCleanClass(String semClass) {
        String retVal = "";
        String[] x = semClass.split("=");
        if (x.length >= 2) {
            retVal = x[1];
        }
        return retVal;
    }

    public String getBBNInfo(String header2, String span, String words) {
        String sentId = header2.replaceFirst("ID=", "");
        String bbnData = "";
        String key = sentId + " " + span;
        boolean legitPhr = false;
        if (bbnInfo.containsKey(key)) {
            String[] ccgWords = words.split("_");
            bbnData = bbnInfo.get(key);
            String[] bbnWords = bbnData.split(" ");
            if (ccgWords.length > 0 && bbnWords.length > 1 && ccgWords.length == bbnWords.length - 1) {
                for (int i = 0; i < ccgWords.length; ++i) {
                    if (!ccgWords[i].toLowerCase().contains(bbnWords[i + 1].toLowerCase())) {
                        legitPhr = false;
                        break;
                    }
                    legitPhr = true;
                }
            } else {
                legitPhr = false;
            }
            bbnData = legitPhr ? bbnData + " " + span : "";
        }
        return bbnData.trim();
    }

    public boolean getCollapseStatus() {
        boolean retVal = this.collStatus;
        this.collStatus = false;
        return retVal;
    }

    public String collapse(String word, String choice) {
        String retVal = "";
        if (choice.equals("1")) {
            this.collPhr = this.collPhr + "_" + word;
        } else {
            retVal = this.collPhr.trim();
            retVal = retVal.replaceFirst("_", "");
            this.collPhr = "";
        }
        return retVal;
    }

    public String getQuoteInfo(String header2, int ind1, int ind2, String words) {
        String[] qInfo;
        String sentId = header2.replaceFirst("ID=", "");
        String span1 = Integer.toString(ind1) + "," + Integer.toString(ind2);
        String span2 = Integer.toString(ind1) + "," + Integer.toString(ind2 + 1);
        String quotedText = "";
        String retVal = "";
        String key1 = sentId + " " + span1;
        String key2 = sentId + " " + span2;
        if (quoteInfo.containsKey(key1)) {
            quotedText = quoteInfo.get(key1);
            String[] qInfo2 = quotedText.split(" ");
            if (qInfo2.length > 0) {
                retVal = span1 + " " + qInfo2[0];
            }
        } else if (quoteInfo.containsKey(key2) && (qInfo = (quotedText = quoteInfo.get(key2)).split(" ")).length > 0 && qInfo[qInfo.length - 1].matches("\\p{Punct}")) {
            retVal = span2 + " " + qInfo[0] + " " + qInfo[qInfo.length - 1];
        }
        return retVal;
    }

    public void storeRes(String str) {
        this.res = str.replaceAll("\\[.*", "");
    }

    public String getRes() {
        String retVal = this.res;
        return retVal;
    }

    public String id(String cat) {
        String retVal = "";
        int idNum = this.idTally.size() + 2;
        if (!this.idTally.containsKey(cat)) {
            this.idTally.put(cat, idNum);
        } else {
            idNum = this.idTally.get(cat);
        }
        retVal = this.idTally.size() == 1 ? "first_" + Integer.toString(idNum) : "later_" + Integer.toString(idNum);
        return retVal;
    }

    public void id() {
        this.idTally = new Hashtable();
    }

    public String getTermNo() {
        String tn = Integer.toString(this.termNo);
        ++this.termNo;
        return tn;
    }

    public String getNonTermNo() {
        String ntNo = Integer.toString(this.ntNo);
        ++this.ntNo;
        return ntNo;
    }

    public String getPunctlessIndex(String word) {
        boolean isCCGWord = this.isCCGWord(word);
        int retval = -1;
        if (isCCGWord) {
            retval = this.plessInd++;
        }
        return Integer.toString(retval);
    }

    public boolean isCCGWord(String word) {
        boolean retval = true;
        if (word.matches("\\p{Punct}|[\\.]+|(-lrb-)|(-rrb-)|(-lcb-)|(-rcb-)|(--)|(`)|(')|(``)|('')") && !word.equals("$") && !word.equals("%")) {
            retval = false;
        }
        return retval;
    }

    public String initId() {
        this.termNo = 0;
        this.ntNo = 500;
        this.plessInd = 0;
        return null;
    }

    public String getPTBInfo(String label, String sentId, String head, String lexInd) {
        String retval = "";
        sentId = sentId.replaceFirst("ID=", "");
        String key = sentId + " " + head + "_" + lexInd;
        String rel = null;
        if (label.equals("SBJ")) {
            rel = sbjInfo.get(key);
        } else if (label.equals("FNT")) {
            rel = fntagInfo.get(key);
        } else if (label.equals("TPC")) {
            rel = tpcInfo.get(key);
        }
        if (rel != null) {
            retval = rel;
        }
        return retval;
    }

    public void printBBNClasses() {
        try {
            System.out.println("Printing BBN classes used in the corpus to bbn-types.txt (for use in grammar.xml)");
            FileWriter file_writer = new FileWriter("bbn-types.txt");
            BufferedWriter buf_writer = new BufferedWriter(file_writer);
            PrintWriter print_writer = new PrintWriter((Writer)buf_writer, true);
            print_writer.print("<tokenizer replacement-sem-classes=\"");
            for (int i = 0; i < bbnClasses.size(); ++i) {
                String bbn = bbnClasses.get(i);
                if (i == 0) {
                    print_writer.print(bbn);
                } else {
                    print_writer.print(" " + bbn);
                }
                if (i == bbnClasses.size() - 1) {
                    print_writer.print("\"/>");
                }
                print_writer.flush();
            }
            print_writer.close();
        }
        catch (Exception e) {
            System.err.println("Error writing info to file");
        }
    }

    public String replaceColon(String str) {
        String replacedStr = str.replace(":", "|");
        return replacedStr;
    }
}

