/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank.extract;

import java.util.ArrayList;
import java.util.Hashtable;

public class DefaultLFHelper {
    private ArrayList<String> idTally = new ArrayList();
    private Hashtable<String, Integer> freqTable = new Hashtable();
    private String lfType = "ord";
    private int argCounter = 0;

    public void init() {
        this.lfType = "ord";
        this.idTally = new ArrayList();
        this.freqTable = new Hashtable();
        this.argCounter = 0;
    }

    public void storeCat(String cat, String id, String idType) {
        int freq = 1;
        if (id.length() > 0) {
            if (!this.freqTable.containsKey(id)) {
                this.freqTable.put(id, freq);
            } else {
                freq = this.freqTable.get(id) + 1;
                this.freqTable.put(id, freq);
            }
            if (id.equals("1") && idType.equals("inherits")) {
                this.lfType = "mod-mod";
            } else if (!this.lfType.equals("mod-mod") && id.equals("1") && this.idTally.size() > 0 && this.idTally.get(0).equals("1")) {
                this.lfType = "mod";
            }
            this.idTally.add(id);
        }
    }

    public String getType() {
        String retVal = this.lfType;
        this.lfType = "";
        this.argCounter = 0;
        return retVal;
    }

    public String getArgNo(int argCount) {
        int argNo = argCount - this.argCounter;
        ++this.argCounter;
        return Integer.toString(argNo);
    }

    public boolean isArg(String id) {
        int freq = 0;
        if (this.freqTable.containsKey(id)) {
            freq = this.freqTable.get(id);
        }
        boolean retVal = false;
        if (freq == 1) {
            retVal = true;
        }
        return retVal;
    }

    public String purgeCat(String cat) {
        cat = cat.replaceAll("\"", "");
        cat = cat.replaceAll("~", "");
        cat = cat.replaceAll("_[0-9]+", "");
        cat = cat.replaceAll(">", "");
        return cat;
    }
}

