/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank.extract;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import opennlp.ccgbank.extract.LexExtract;
import opennlp.ccgbank.extract.MorphExtract;
import opennlp.ccgbank.extract.RulesExtract;

public class ExtractGrammar {
    public static void main(String[] args) throws Exception {
        File gramFile;
        List<String> arguments = Arrays.asList(args);
        ExtractionProperties extractProps = new ExtractionProperties();
        boolean doLex = true;
        boolean doMorph = true;
        boolean doRules = true;
        boolean doTestbed = true;
        if (arguments.contains("-h") || arguments.contains("--help")) {
            System.out.println("usage: extractGrammar \n\t[-noPPs|--noPPHeads] \n\t[-lexF] \n\t[-origPuncts] \n\t[-s|--section sectnum] [-ss|--startSection sectnum] [-es|endSection sectnum] \n\t[-f|--file filenum] \n\t[--lexOnly|--morpOnly|--rulesOnly|--testbedOnly] [--skipLex] [--skipMorph] [--skipRules] [--skipTestbed]\n\t[-tmp|--tempDir tempDir] \n\t[-cfc|--catFreqCutoff num] \n\t[-lfc|--lexFreqCutoff num] \n\t[-ofc|--openFreqCutoff num] \n\t[-rfc|--ruleFreqCutoff num] \n\t[--skipUnmatched] \n\t[-dd|--debugDerivs] \n\t[--text textfile] [--textf factorsfile] \n\t[--combos combosfile] \n\t[srcDir] [destDir]");
            System.exit(0);
        }
        if (arguments.contains("-noPPs") || arguments.contains("--noPPHeads")) {
            extractProps.ppHeads = false;
        }
        Iterator<String> it = arguments.iterator();
        boolean seenSrc = false;
        while (it.hasNext()) {
            int num;
            String s = it.next();
            if (s.equals("-s") || s.equals("--section") || s.equals("-ss") || s.equals("--startSection") || s.equals("-es") || s.equals("--endSection")) {
                if (!it.hasNext()) {
                    throw new IllegalArgumentException("encountered flag " + s + ", but no sectnum specified");
                }
                int sectNum = Integer.parseInt(it.next());
                if (s.equals("-s") || s.equals("--section") || s.equals("-ss") || s.equals("--startSection")) {
                    extractProps.startSection = sectNum;
                }
                if (!s.equals("-s") && !s.equals("--section") && !s.equals("-es") && !s.equals("--endSection")) continue;
                extractProps.endSection = sectNum;
                continue;
            }
            if (s.equals("-f") || s.equals("--filenum")) {
                if (!it.hasNext()) {
                    throw new IllegalArgumentException("encountered flag " + s + ", but no filenum specified");
                }
                extractProps.fileNum = Integer.parseInt(it.next());
                continue;
            }
            if (s.equals("-lexF")) {
                System.out.println("Inserting lexicon specific feats - Punct filter placeholder feats now");
                extractProps.lexF = true;
                continue;
            }
            if (s.equals("-origPuncts")) {
                extractProps.origPuncts = true;
                continue;
            }
            if (s.equals("--lexOnly")) {
                doMorph = false;
                doRules = false;
                doTestbed = false;
                continue;
            }
            if (s.equals("--morphOnly")) {
                doLex = false;
                doRules = false;
                doTestbed = false;
                continue;
            }
            if (s.equals("--rulesOnly")) {
                doLex = false;
                doMorph = false;
                doTestbed = false;
                continue;
            }
            if (s.equals("--testbedOnly")) {
                doLex = false;
                doMorph = false;
                doRules = false;
                continue;
            }
            if (s.equals("--skipLex")) {
                doLex = false;
                continue;
            }
            if (s.equals("--skipMorph")) {
                doMorph = false;
                continue;
            }
            if (s.equals("--skipRules")) {
                doRules = false;
                continue;
            }
            if (s.equals("--skipTestbed")) {
                doTestbed = false;
                continue;
            }
            if (s.equals("-tmp") || s.equals("--tempDir")) {
                if (!it.hasNext()) {
                    throw new IllegalArgumentException("encountered flag " + s + ", but no temp dir specified");
                }
                extractProps.tempDir = it.next();
                continue;
            }
            if (s.equals("-cfc") || s.equals("--catFreqCutoff")) {
                if (!it.hasNext()) {
                    throw new IllegalArgumentException("encountered flag " + s + ", but no num specified");
                }
                extractProps.catFreqCutoff = num = Integer.parseInt(it.next());
                continue;
            }
            if (s.equals("-lfc") || s.equals("--lexFreqCutoff")) {
                if (!it.hasNext()) {
                    throw new IllegalArgumentException("encountered flag " + s + ", but no num specified");
                }
                extractProps.lexFreqCutoff = num = Integer.parseInt(it.next());
                continue;
            }
            if (s.equals("-ofc") || s.equals("--openFreqCutoff")) {
                if (!it.hasNext()) {
                    throw new IllegalArgumentException("encountered flag " + s + ", but no num specified");
                }
                extractProps.openFreqCutoff = num = Integer.parseInt(it.next());
                continue;
            }
            if (s.equals("-rfc") || s.equals("--ruleFreqCutoff")) {
                if (!it.hasNext()) {
                    throw new IllegalArgumentException("encountered flag " + s + ", but no num specified");
                }
                extractProps.ruleFreqCutoff = num = Integer.parseInt(it.next());
                continue;
            }
            if (s.equals("--skipUnmatched")) {
                extractProps.skipUnmatched = true;
                continue;
            }
            if (s.equals("-dd") || s.equals("--debugDerivs")) {
                extractProps.debugDerivs = true;
                continue;
            }
            if (s.equals("--text")) {
                if (!it.hasNext()) {
                    throw new IllegalArgumentException("encountered flag " + s + ", but no file name specified");
                }
                extractProps.textfile = it.next();
                continue;
            }
            if (s.equals("--textf")) {
                if (!it.hasNext()) {
                    throw new IllegalArgumentException("encountered flag " + s + ", but no file name specified");
                }
                extractProps.factorsfile = it.next();
                continue;
            }
            if (s.equals("--combos")) {
                if (!it.hasNext()) {
                    throw new IllegalArgumentException("encountered flag " + s + ", but no file name specified");
                }
                extractProps.combosfile = it.next();
                continue;
            }
            if (!seenSrc) {
                extractProps.srcDir = s;
                seenSrc = true;
                continue;
            }
            extractProps.destDir = s;
        }
        File tempDir = new File(extractProps.tempDir);
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw new IllegalArgumentException("could not create temp directory: " + extractProps.tempDir);
        }
        File srcDir = new File(extractProps.srcDir);
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            throw new IllegalArgumentException("source directory does not exist: " + extractProps.srcDir);
        }
        File destDir = new File(extractProps.destDir);
        if (!destDir.exists() && !destDir.mkdirs()) {
            throw new IllegalArgumentException("could not create destination directory: " + extractProps.destDir);
        }
        System.out.println("Extracting Grammar");
        System.out.println("Reading from: " + srcDir);
        System.out.println("Writing to: " + destDir);
        System.out.println("Temp dir: " + tempDir);
        System.out.println("Start section: " + extractProps.startSection);
        System.out.println("End section: " + extractProps.endSection);
        if (extractProps.fileNum >= 0) {
            System.out.println("File: " + extractProps.fileNum);
        }
        if (doLex) {
            LexExtract.extractLex(extractProps);
        }
        if (doMorph) {
            MorphExtract.extractMorph(extractProps);
        }
        if (doRules) {
            RulesExtract.extractRules(extractProps);
        }
        if (!(gramFile = new File(destDir, "grammar.xml")).exists()) {
            System.out.println("Generating grammar.xml");
            PrintWriter gramOut = new PrintWriter(new FileWriter(gramFile));
            gramOut.println("<?xml version=\"1.0\"?>");
            gramOut.println("<grammar name=\"proto\"");
            gramOut.println("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
            gramOut.println("  xsi:noNamespaceSchemaLocation=\"../grammar.xsd\"");
            gramOut.println(">");
            gramOut.println("  <lexicon file=\"lexicon.xml\"/>");
            gramOut.println("  <morphology file=\"morph.xml\"/>");
            gramOut.println("  <rules file=\"rules.xml\"/>");
            gramOut.println("</grammar>");
            gramOut.close();
        }
        if (!doTestbed || !doTestbed) {
            // empty if block
        }
    }

    public static StreamSource getSource(String resourceName) {
        ClassLoader cl = ExtractGrammar.class.getClassLoader();
        return new StreamSource(cl.getResourceAsStream(resourceName));
    }

    public static class ExtractionProperties {
        public boolean ppHeads = true;
        public String srcDir = "/scratch/ccgbank/converted";
        public String destDir = "/scratch/grammars/protogrammar";
        public String tempDir = "/tmp/ccgbankextract";
        public int startSection = 0;
        public int endSection = 24;
        public int fileNum = -1;
        public int catFreqCutoff = 1;
        public int lexFreqCutoff = 1;
        public int openFreqCutoff = 100;
        public int ruleFreqCutoff = 1;
        public boolean skipUnmatched = false;
        public boolean debugDerivs = false;
        public String textfile = null;
        public String factorsfile = null;
        public String combosfile = null;
        public boolean lexF = false;
        public boolean origPuncts = false;
        public String macroSpecs = "";
        public String lfSpecs = "";
    }
}

