/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.lexicon.LexException;
import opennlp.ccg.parse.ParseException;
import opennlp.ccg.parse.Parser;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.util.Visualizer;

public class WebCCG {
    public static void main(String[] args) throws IOException, LexException {
        String input;
        int i;
        String usage = "java opennlp.ccg.WebCCG [-showall] [-showderivs] [-showsem] [-showfeats] [-visualize FILE] GRAMMARDIR\n\n-showall shows all parses rather than just the first one.\n-showderivs shows the derivation history of each parse.\n-showsem shows the logical form of each parse.\n-showfeats shows the features associated with each nonterminal.\n-visualize output a visualization of the parses into FILE (in TEX format).\n   to convert to an image, try this:\n   latex foo.tex; dvips foo.dvi | pstopnm | pnmtopng > foo.png\n\nSentences to parse are read from standard input.\n";
        if (args.length > 0 && (args[0].equals("-h") || args[0].equals("-help"))) {
            System.out.println("Usage: " + usage);
            System.exit(0);
        }
        boolean showall = false;
        boolean showderivs = false;
        boolean showsem = false;
        boolean showfeats = false;
        String visfile = null;
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-showall")) {
                showall = true;
                continue;
            }
            if (args[i].equals("-showderivs")) {
                showderivs = true;
                continue;
            }
            if (args[i].equals("-showsem")) {
                showsem = true;
                continue;
            }
            if (args[i].equals("-showfeats")) {
                showfeats = true;
                continue;
            }
            if (!args[i].equals("-visualize")) break;
            visfile = args[++i];
        }
        if (i != args.length - 1) {
            System.out.println("Usage: " + usage);
            System.exit(0);
        }
        String grammarfile = args[i] + "/grammar.xml";
        URL grammarURL = new File(grammarfile).toURI().toURL();
        Grammar grammar = new Grammar(grammarURL);
        Parser parser = new Parser(grammar);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while ((input = br.readLine()) != null) {
            if ((input = input.trim()).equals("")) continue;
            try {
                parser.parse(input);
                List<Sign> parses = parser.getResult();
                Sign[] results = new Sign[parses.size()];
                parses.toArray(results);
                int resLength = results.length;
                System.out.print("\"" + input + "\": ");
                switch (resLength) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        System.out.println(resLength + " parse found.\n");
                        break;
                    }
                    default: {
                        System.out.println(resLength + " parses found.\n");
                    }
                }
                Visualizer vis = null;
                grammar.prefs.showSem = showsem;
                grammar.prefs.showFeats = showfeats;
                grammar.prefs.featsToShow = "";
                if (visfile != null) {
                    vis = new Visualizer();
                    vis.writeHeader(visfile);
                }
                int numToShow = showall ? resLength : 1;
                for (i = 0; i < numToShow; ++i) {
                    Category cat = results[i].getCategory();
                    LF convertedLF = null;
                    if (cat.getLF() != null) {
                        cat = cat.copy();
                        Nominal index = cat.getIndexNominal();
                        convertedLF = HyloHelper.compactAndConvertNominals(cat.getLF(), index, results[i]);
                        cat.setLF(null);
                    }
                    String parseNum = resLength == 1 ? "Parse: " : "Parse " + (i + 1) + ": ";
                    System.out.print(parseNum + cat.toString());
                    if (showsem && convertedLF != null) {
                        System.out.println(" : ");
                        System.out.println("  " + convertedLF.prettyPrint("  "));
                    } else {
                        System.out.println();
                    }
                    if (showderivs) {
                        System.out.println("------------------------------");
                        System.out.println(results[i].getDerivationHistory());
                    }
                    if (visfile == null) continue;
                    vis.saveTeXFile(results[i], visfile);
                }
                if (visfile == null) continue;
                vis.writeFooter(visfile);
            }
            catch (ParseException pe) {
                System.out.print("\"" + input + "\": ");
                System.out.println(pe + ".\n");
            }
        }
    }
}

