/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.alignment;

import opennlp.ccg.alignment.Alignments;
import opennlp.ccg.alignment.PhrasePosition;
import opennlp.ccg.alignment.Status;

public class Mapping
implements Comparable<Mapping> {
    final Integer phraseNumber;
    final Integer a;
    final Integer b;
    Status status;
    Double confidence;

    public Mapping(Integer a, Integer b) {
        this(null, a, b);
    }

    public Mapping(Integer phraseNumber, Integer a, Integer b) {
        this(phraseNumber, a, b, Alignments.DEFAULT_STATUS);
    }

    public Mapping(Integer phraseNumber, Integer a, Integer b, Status status) {
        this(phraseNumber, a, b, status, Alignments.DEFAULT_CONFIDENCE);
    }

    public Mapping(Integer phraseNumber, Integer a, Integer b, Status status, Double confidence) {
        this.checkPhraseNumber(phraseNumber);
        this.checkIndex(a);
        this.checkIndex(b);
        this.checkField((Object)status, "status");
        this.checkField(confidence, "confidence");
        this.phraseNumber = phraseNumber;
        this.a = a;
        this.b = b;
        this.status = status;
        this.confidence = confidence;
    }

    public Mapping copyWithPhraseNumber(Integer phraseNumber) {
        if (this.phraseNumber == null && phraseNumber == null || this.phraseNumber != null && this.phraseNumber.equals(phraseNumber)) {
            return this;
        }
        return new Mapping(phraseNumber, this.a, this.b, this.status, this.confidence);
    }

    public static Mapping mappingByPosition(Integer phraseNumber, Integer a, Integer b, PhrasePosition firstPosition) {
        return Mapping.mappingByPosition(phraseNumber, a, b, Alignments.DEFAULT_STATUS, Alignments.DEFAULT_CONFIDENCE, firstPosition);
    }

    public static Mapping mappingByPosition(Integer phraseNumber, Integer a, Integer b, Status status, Double confidence, PhrasePosition firstPosition) {
        return new Mapping(phraseNumber, firstPosition == PhrasePosition.A ? a : b, firstPosition == PhrasePosition.B ? a : b, status, confidence);
    }

    public Mapping reverse() {
        return Mapping.mappingByPosition(this.phraseNumber, this.a, this.b, this.status, this.confidence, PhrasePosition.B);
    }

    public Integer getPhraseNumber() {
        return this.phraseNumber;
    }

    public Integer getA() {
        return this.get(PhrasePosition.A);
    }

    public Integer getB() {
        return this.get(PhrasePosition.B);
    }

    public Integer get(PhrasePosition pos) {
        return pos == PhrasePosition.A ? this.a : this.b;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.checkField((Object)status, "status");
        this.status = status;
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public void setConfidence(Double confidence) {
        this.checkField(confidence, "confidence");
        this.confidence = confidence;
    }

    @Override
    public int compareTo(Mapping o) {
        int i;
        int n = i = this.phraseNumber == null && o.phraseNumber == null ? 0 : this.phraseNumber.compareTo(o.phraseNumber);
        if (i == 0) {
            i = this.a.compareTo(o.a);
        }
        if (i == 0) {
            i = this.b.compareTo(o.b);
        }
        if (i == 0) {
            i = this.status.compareTo(o.status);
        }
        if (i == 0) {
            i = this.confidence.compareTo(o.confidence);
        }
        return i;
    }

    public int hashCode() {
        int h = 37 + this.a + this.b;
        return this.phraseNumber == null ? h : h + this.phraseNumber;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Mapping) {
            Mapping m = (Mapping)obj;
            return (this.phraseNumber == null && m.phraseNumber == null || this.phraseNumber.equals(m.phraseNumber)) && this.a.equals(m.a) && this.b.equals(m.b) && this.status.equals((Object)m.status) && this.confidence.equals(m.confidence);
        }
        return false;
    }

    void checkPhraseNumber(Integer phraseNumber) throws IndexOutOfBoundsException {
        if (phraseNumber != null && !Alignments.DEFAULT_PHRASE_NUMBER_BASE.isValidIndex(phraseNumber)) {
            throw new IndexOutOfBoundsException("invalid phrase number: " + phraseNumber);
        }
    }

    void checkIndex(Integer index) throws IndexOutOfBoundsException {
        if (index == null) {
            throw new IllegalArgumentException("null index");
        }
        if (!Alignments.DEFAULT_INDEX_BASE.isValidIndex(index)) {
            throw new IndexOutOfBoundsException("invalid index: " + index);
        }
    }

    void checkField(Object obj, String name) throws IllegalArgumentException {
        if (obj == null) {
            throw new IllegalArgumentException("null " + name);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.a.toString());
        sb.append(" <-> ");
        sb.append(this.b.toString());
        return sb.toString();
    }
}

