/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.disjunctivizer;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import opennlp.ccg.disjunctivizer.LabelMatchFilter;
import opennlp.ccg.disjunctivizer.MatchType;
import opennlp.ccg.disjunctivizer.VertexMatchFilter;
import opennlp.ccg.hylo.graph.LFEdge;
import opennlp.ccg.util.CompositeFilter;
import opennlp.ccg.util.Filter;
import opennlp.ccg.util.InverseFilter;

public class EdgeMatchFilter
extends CompositeFilter<LFEdge> {
    LFEdge basis;
    final EnumSet<MatchType> matchTypes;

    public EdgeMatchFilter(LFEdge basis, MatchType ... matchTypes) {
        this(basis, Arrays.asList(matchTypes));
    }

    public EdgeMatchFilter(LFEdge basis, Collection<MatchType> matchTypes) {
        this.checkBasis(basis);
        this.basis = basis;
        this.matchTypes = EnumSet.copyOf(matchTypes);
        for (MatchType t : matchTypes) {
            Filter<LFEdge> f = null;
            if (t == MatchType.LABEL_MATCH || t == MatchType.LABEL_MISMATCH) {
                f = new LabelMatchFilter(basis.getLabel());
                if (t == MatchType.LABEL_MISMATCH) {
                    f = new InverseFilter<LFEdge>(f);
                }
            } else if (t == MatchType.SOURCE_MATCH || t == MatchType.SOURCE_MISMATCH || t == MatchType.SOURCE_PREDICATE_MATCH || t == MatchType.SOURCE_PREDICATE_MISMATCH) {
                f = new VertexMatchFilter(basis.getSource(), t);
            } else if (t == MatchType.TARGET_MATCH || t == MatchType.TARGET_MISMATCH || t == MatchType.TARGET_PREDICATE_MATCH || t == MatchType.TARGET_PREDICATE_MISMATCH) {
                f = new VertexMatchFilter(basis.getTarget(), t);
            }
            if (f == null) continue;
            this.addFilter(f);
        }
    }

    private void checkBasis(LFEdge basis) {
        if (basis == null) {
            throw new IllegalArgumentException("basis is null");
        }
    }

    public LFEdge getBasis() {
        return this.basis;
    }

    public void setBasis(LFEdge basis) {
        this.checkBasis(basis);
        this.basis = basis;
    }

    public EnumSet<MatchType> getMatchTypes() {
        return this.matchTypes;
    }
}

