/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.disjunctivizer;

import java.util.Collection;
import opennlp.ccg.disjunctivizer.MatchType;
import opennlp.ccg.disjunctivizer.MatchTypeFilter;
import opennlp.ccg.hylo.graph.LFEdge;
import opennlp.ccg.hylo.graph.LFVertex;

public class VertexMatchFilter
extends MatchTypeFilter {
    LFVertex basis;

    public VertexMatchFilter(LFVertex basis, MatchType ... matchTypes) {
        super(matchTypes);
        this.checkBasis(basis);
        this.basis = basis;
    }

    public VertexMatchFilter(LFVertex basis, Collection<MatchType> matchTypes) {
        super(matchTypes);
        this.checkBasis(basis);
        this.basis = basis;
    }

    private void checkBasis(LFVertex basis) {
        if (basis == null) {
            throw new IllegalArgumentException("basis is null");
        }
    }

    public LFVertex getBasis() {
        return this.basis;
    }

    public void setBasis(LFVertex basis) {
        this.checkBasis(basis);
        this.basis = basis;
    }

    @Override
    public boolean allows(LFEdge edge) {
        for (MatchType t : this.matchTypes) {
            if (t == MatchType.SOURCE_MATCH && !this.basis.equals(edge.getSource())) {
                return false;
            }
            if (t == MatchType.SOURCE_MISMATCH && this.basis.equals(edge.getSource())) {
                return false;
            }
            if (t == MatchType.TARGET_MATCH && !this.basis.equals(edge.getTarget())) {
                return false;
            }
            if (t == MatchType.TARGET_MISMATCH && this.basis.equals(edge.getTarget())) {
                return false;
            }
            if (this.basis.getPredicate() == null) continue;
            if (t == MatchType.SOURCE_PREDICATE_MATCH && !this.basis.getPredicate().equals(edge.getSource().getPredicate())) {
                return false;
            }
            if (t == MatchType.SOURCE_PREDICATE_MISMATCH && this.basis.getPredicate().equals(edge.getSource().getPredicate())) {
                return false;
            }
            if (t == MatchType.TARGET_PREDICATE_MATCH && !this.basis.getPredicate().equals(edge.getTarget().getPredicate())) {
                return false;
            }
            if (t != MatchType.TARGET_PREDICATE_MISMATCH || !this.basis.getPredicate().equals(edge.getTarget().getPredicate())) continue;
            return false;
        }
        return true;
    }
}

