/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.hylo;

import gnu.trove.TObjectIntHashMap;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.hylo.HyloFormula;
import opennlp.ccg.hylo.NominalVar;
import opennlp.ccg.hylo.Proposition;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.unify.Indexed;
import opennlp.ccg.unify.SimpleType;
import opennlp.ccg.unify.Substitution;
import opennlp.ccg.unify.UnifyControl;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.unify.Variable;
import org.jdom.Element;

public class HyloVar
extends HyloFormula
implements Variable,
Indexed {
    private static final long serialVersionUID = 3455577234911944031L;
    protected final String _name;
    protected int _index;
    protected int _hashCode;
    protected SimpleType type;

    public HyloVar(String name) {
        this(name, 0, null);
    }

    public HyloVar(String name, SimpleType st) {
        this(name, 0, st);
    }

    protected HyloVar(String name, int index, SimpleType st) {
        this._name = name;
        this._index = index;
        this.type = st != null ? st : Grammar.theGrammar.types.getSimpleType("top");
        this._hashCode = this._name.hashCode() + this._index + this.type.getIndex();
    }

    @Override
    public String name() {
        return this._name;
    }

    @Override
    public LF copy() {
        return new HyloVar(this._name, this._index, this.type);
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    @Override
    public void setIndex(int index) {
        this._hashCode += index - this._index;
        this._index = index;
    }

    @Override
    public SimpleType getType() {
        return this.type;
    }

    @Override
    public boolean occurs(Variable var) {
        return this.equals(var);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HyloVar)) {
            return false;
        }
        HyloVar var = (HyloVar)o;
        return this._index == var._index && this._name.equals(var._name) && this.type.equals(var.type);
    }

    public int compareTo(HyloVar hv) {
        int retval = this._name.compareTo(hv._name);
        if (retval == 0) {
            if (this._index < hv._index) {
                retval = -1;
            } else if (this._index > hv._index) {
                retval = 1;
            }
        }
        return retval;
    }

    @Override
    public Object unify(Object u, Substitution sub) throws UnifyFailure {
        if (u instanceof NominalVar) {
            return ((NominalVar)u).unify(this, sub);
        }
        if (this.equals(u)) {
            return this;
        }
        if (!(u instanceof LF)) {
            throw new UnifyFailure();
        }
        LF lf = (LF)u;
        SimpleType st = null;
        if (lf.getType() != null) {
            st = (SimpleType)this.type.unify(lf.getType(), sub);
        }
        if (u instanceof HyloVar) {
            HyloVar u_hv = (HyloVar)u;
            if (this.type.equals(u_hv.getType())) {
                if (this.compareTo(u_hv) >= 0) {
                    return sub.makeSubstitution(this, u_hv);
                }
                return sub.makeSubstitution(u_hv, this);
            }
            if (this.type.equals(st)) {
                return sub.makeSubstitution(u_hv, this);
            }
            if (u_hv.getType().equals(st)) {
                return sub.makeSubstitution(this, u_hv);
            }
            String name = this.compareTo(u_hv) >= 0 ? u_hv._name + u_hv._index : this._name + this._index;
            HyloVar hv_st = new HyloVar(name, UnifyControl.getUniqueVarIndex(), st);
            sub.makeSubstitution(u_hv, hv_st);
            return sub.makeSubstitution(this, hv_st);
        }
        if (u instanceof Proposition) {
            Proposition prop = (Proposition)u;
            if (st == null || prop.getType().equals(st)) {
                return sub.makeSubstitution(this, prop);
            }
            Proposition prop_st = new Proposition(st.getName(), st);
            return sub.makeSubstitution(this, prop_st);
        }
        if (((LF)u).occurs(this)) {
            throw new UnifyFailure();
        }
        return sub.makeSubstitution(this, u);
    }

    @Override
    public Object fill(Substitution sub) throws UnifyFailure {
        Object val = sub.getValue(this);
        if (val != null) {
            return val;
        }
        return this;
    }

    public String toString() {
        String retval = this._name + "_" + this._index;
        if (!this.type.getName().equals("top")) {
            retval = retval + ":" + this.type.getName();
        }
        return retval;
    }

    public String nameWithType() {
        String retval = this._name;
        if (!this.type.getName().equals("top")) {
            retval = retval + ":" + this.type.getName();
        }
        return retval;
    }

    @Override
    public String prettyPrint(String indent) {
        return this.toString();
    }

    public int hashCode() {
        return this._hashCode;
    }

    @Override
    public int hashCode(TObjectIntHashMap varMap) {
        if (varMap.containsKey((Object)this)) {
            return varMap.get((Object)this);
        }
        int next = varMap.size() + 1;
        varMap.put((Object)this, next);
        return next;
    }

    @Override
    public boolean equals(Object obj, TObjectIntHashMap varMap, TObjectIntHashMap varMap2) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        HyloVar hv = (HyloVar)obj;
        if (varMap.get((Object)this) != varMap2.get((Object)hv)) {
            return false;
        }
        return this.type.equals(hv.type);
    }

    @Override
    public Element toXml() {
        Element retval = new Element("var");
        retval.setAttribute("name", this.nameWithType());
        return retval;
    }
}

