/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.hylo.graph;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.hylo.graph.LFEdge;
import opennlp.ccg.hylo.graph.LFEdgeFactory;
import opennlp.ccg.hylo.graph.LFEdgeLabel;
import opennlp.ccg.hylo.graph.LFGraphFactory;
import opennlp.ccg.hylo.graph.LFVertex;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.DirectedMultigraph;

public class LFGraph
extends DirectedMultigraph<LFVertex, LFEdge> {
    private static final long serialVersionUID = 1L;
    protected Map<LFVertex, LFVertex> highestAncestorMap = new HashMap<LFVertex, LFVertex>();
    protected Map<Nominal, LFVertex> nominalVertexMap = new HashMap<Nominal, LFVertex>();

    public LFGraph() {
        this(LFGraphFactory.DEFAULT_EDGE_FACTORY);
    }

    public LFGraph(LFEdgeFactory lfEdgeFactory) {
        super((EdgeFactory)lfEdgeFactory);
    }

    public LFEdgeFactory getLFEdgeFactory() {
        return (LFEdgeFactory)this.getEdgeFactory();
    }

    public LFEdge addLabeledEdge(LFVertex source, LFVertex target, LFEdgeLabel label) {
        LFEdge e = this.getLFEdgeFactory().createLabeledEdge(source, target, label);
        return this.addEdge(source, target, e) ? e : null;
    }

    public LFVertex findVertexByNominal(Nominal nominal) {
        return this.nominalVertexMap.get(nominal);
    }

    public boolean addVertex(LFVertex v) {
        boolean b = super.addVertex((Object)v);
        if (b) {
            this.nominalVertexMap.put(v.nominal, v);
        }
        return b;
    }

    public boolean removeVertex(LFVertex v) {
        boolean b = super.removeVertex((Object)v);
        if (b) {
            this.nominalVertexMap.values().remove(v);
        }
        return b;
    }

    public LFVertex highestLFAncestorOf(LFVertex vertex) {
        return this.highestAncestorMap.get(vertex);
    }

    public Set<LFVertex> getLFAncestry(LFVertex vertex) {
        LFVertex a = this.highestLFAncestorOf(vertex);
        LinkedHashSet<LFVertex> as = new LinkedHashSet<LFVertex>();
        for (LFVertex v : this.vertexSet()) {
            if (v.equals(vertex) || !this.highestLFAncestorOf(v).equals(a)) continue;
            as.add(v);
        }
        return as;
    }

    public Set<LFVertex> highestLFAncestors() {
        LinkedHashSet<LFVertex> ps = new LinkedHashSet<LFVertex>();
        for (LFVertex v : this.vertexSet()) {
            if (this.highestLFAncestorOf(v) != null) continue;
            ps.add(v);
        }
        return ps;
    }
}

