/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse.supertagger;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.parse.Supertagger;
import opennlp.ccg.parse.postagger.DummyPOSTagger;
import opennlp.ccg.parse.postagger.POSTagger;
import opennlp.ccg.parse.supertagger.LabellingStrategy;
import opennlp.ccg.parse.supertagger.io.XMLPOSDictionaryReader;
import opennlp.ccg.parse.supertagger.io.XMLWordDictionaryReader;
import opennlp.ccg.parse.supertagger.ml.FeatureExtractor;
import opennlp.ccg.parse.supertagger.ml.STFex;
import opennlp.ccg.parse.supertagger.ml.STPriorModel;
import opennlp.ccg.parse.supertagger.util.STTaggerPOSDictionary;
import opennlp.ccg.parse.supertagger.util.STTaggerWordDictionary;
import opennlp.ccg.parse.tagger.Constants;
import opennlp.ccg.parse.tagger.ProbIndexPair;
import opennlp.ccg.parse.tagger.TaggedWord;
import opennlp.ccg.parse.tagger.io.SRILMFactoredBundleCorpusIterator;
import opennlp.ccg.parse.tagger.ml.MaxentModel;
import opennlp.ccg.parse.tagger.ml.ZLMEM;
import opennlp.ccg.parse.tagger.sequencescoring.SequenceScorer;
import opennlp.ccg.parse.tagger.util.ConfigFileProcessor;
import opennlp.ccg.parse.tagger.util.ResultSink;
import opennlp.ccg.util.Pair;

public class WordAndPOSDictionaryLabellingStrategy
implements LabellingStrategy,
Supertagger {
    private boolean verbose = false;
    private boolean useWordDict = false;
    private boolean usePOSDict = false;
    private SequenceScorer seqScorer = null;
    private STTaggerWordDictionary wd;
    private STTaggerPOSDictionary pd;
    private int K;
    private int usualK;
    private int finalK;
    private MaxentModel mo;
    private FeatureExtractor fexer = new STFex();
    private POSTagger posTagger;
    private List<TaggedWord> tagging;
    public Map<String, Double> betaMultipliers = new HashMap<String, Double>();
    public double minMultiplier = 1.0;
    protected double[] betas = null;
    protected int betaIndex = 0;
    protected List<List<Pair<Double, String>>> currentTagging = null;
    protected int currentWord = 0;
    protected boolean includeGold = false;

    public WordAndPOSDictionaryLabellingStrategy(STTaggerWordDictionary wd, STTaggerPOSDictionary pd, int K, MaxentModel mo, FeatureExtractor fexer) {
        this(wd, pd, K, mo, fexer, null, null);
    }

    public WordAndPOSDictionaryLabellingStrategy(STTaggerWordDictionary wd, STTaggerPOSDictionary pd, int K, MaxentModel mo, FeatureExtractor fexer, String tagSequenceModel, Constants.TaggingAlgorithm alg) {
        this(wd, pd, K, mo, fexer, tagSequenceModel, alg, new DummyPOSTagger());
    }

    public WordAndPOSDictionaryLabellingStrategy(STTaggerWordDictionary wd, STTaggerPOSDictionary pd, int K, MaxentModel mo, FeatureExtractor fexer, String tagSequenceModel, Constants.TaggingAlgorithm alg, POSTagger posTagger) {
        this.wd = wd;
        this.pd = pd;
        this.mo = mo;
        this.posTagger = posTagger;
        this.K = K > 0 ? K : 0;
        this.usualK = K;
        this.finalK = K;
        this.fexer = fexer;
        try {
            if (tagSequenceModel != null) {
                int ord = SequenceScorer.findOrder(tagSequenceModel);
                this.seqScorer = new SequenceScorer(ord, tagSequenceModel);
                this.seqScorer.setSearchBeam(5);
                this.seqScorer.setAlgorithm(alg);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(WordAndPOSDictionaryLabellingStrategy.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void useWordDict(boolean useIt) {
        this.useWordDict = useIt;
    }

    public void usePOSDict(boolean useIt) {
        this.usePOSDict = useIt;
    }

    public WordAndPOSDictionaryLabellingStrategy(STTaggerWordDictionary wd, STTaggerPOSDictionary pd, int K, MaxentModel mo) {
        this(wd, pd, K, mo, new STFex());
    }

    public void setMaxSearchBeam(int maxSearchBeam) {
        if (this.seqScorer != null) {
            this.seqScorer.setSearchBeam(maxSearchBeam);
        }
    }

    @Override
    public void setK(int newK) {
        this.K = newK;
    }

    public void setUsualK(int newK) {
        this.usualK = newK;
    }

    public void setFinalK(int newK) {
        this.finalK = newK;
    }

    @Override
    public List<String> multitag(Word w, Collection<Pair<String, Double>> context, double beta) {
        List<Pair<Double, String>> temp = this.multitagWithScores(w, context, beta);
        ArrayList<String> res = new ArrayList<String>(temp.size());
        for (Pair<Double, String> t : temp) {
            res.add((String)t.b);
        }
        return res;
    }

    @Override
    public List<Pair<Double, String>> multitagWithScores(Word thisWord, Collection<Pair<String, Double>> context, double beta) {
        double currentOutcomeProb;
        Object temp;
        Collection<String> wordPermittedOutcomes;
        double[] ocs = this.mo.eval(context);
        Object[] sortedOutcomes = new ProbIndexPair[ocs.length];
        for (int i = 0; i < ocs.length; ++i) {
            sortedOutcomes[i] = new ProbIndexPair(new Double(ocs[i]), new Integer(i));
        }
        Arrays.sort(sortedOutcomes);
        String tempOutcome = "";
        String word = thisWord.getForm();
        String pos = thisWord.getPOS();
        ArrayList<Pair<Double, String>> retVal = new ArrayList<Pair<Double, String>>(30);
        double bestOutcomeProb = 0.0;
        Collection<String> collection = wordPermittedOutcomes = this.wd != null ? this.wd.getEntry(word, this.K) : null;
        if (wordPermittedOutcomes != null && this.useWordDict) {
            for (int ocInd = 0; ocInd < sortedOutcomes.length; ++ocInd) {
                temp = sortedOutcomes[ocInd];
                tempOutcome = this.mo.getOutcome(((ProbIndexPair)temp).b);
                currentOutcomeProb = ((ProbIndexPair)temp).a;
                if (!wordPermittedOutcomes.contains(tempOutcome)) continue;
                if (bestOutcomeProb == 0.0) {
                    bestOutcomeProb = currentOutcomeProb;
                }
                if (currentOutcomeProb >= bestOutcomeProb * beta) {
                    retVal.add(new Pair<Double, String>(((ProbIndexPair)temp).a, tempOutcome));
                    if (!(currentOutcomeProb > bestOutcomeProb)) continue;
                    bestOutcomeProb = currentOutcomeProb;
                    continue;
                }
                break;
            }
        } else {
            Collection<String> posPermittedOutcomes = null;
            if (pos != null) {
                posPermittedOutcomes = this.pd != null ? this.pd.getEntry(pos) : null;
            } else if (this.verbose) {
                System.err.println("warning: null POS for: " + word);
            }
            if (posPermittedOutcomes != null && this.usePOSDict) {
                for (int ocInd2 = 0; ocInd2 < sortedOutcomes.length; ++ocInd2) {
                    temp = sortedOutcomes[ocInd2];
                    tempOutcome = this.mo.getOutcome(((ProbIndexPair)temp).b);
                    currentOutcomeProb = ((ProbIndexPair)temp).a;
                    if (!posPermittedOutcomes.contains(tempOutcome.trim())) continue;
                    if (bestOutcomeProb == 0.0) {
                        bestOutcomeProb = currentOutcomeProb;
                    }
                    if (currentOutcomeProb >= bestOutcomeProb * beta) {
                        retVal.add(new Pair<Double, String>(((ProbIndexPair)temp).a, tempOutcome));
                        if (!(currentOutcomeProb > bestOutcomeProb)) continue;
                        bestOutcomeProb = currentOutcomeProb;
                        continue;
                    }
                    break;
                }
            } else {
                for (int ocInd3 = 0; ocInd3 < sortedOutcomes.length; ++ocInd3) {
                    temp = sortedOutcomes[ocInd3];
                    currentOutcomeProb = ((ProbIndexPair)temp).a;
                    if (bestOutcomeProb == 0.0) {
                        bestOutcomeProb = currentOutcomeProb;
                    }
                    if (currentOutcomeProb >= bestOutcomeProb * beta) {
                        retVal.add(new Pair<Double, String>(((ProbIndexPair)temp).a, this.mo.getOutcome(((ProbIndexPair)temp).b)));
                        if (!(currentOutcomeProb > bestOutcomeProb)) continue;
                        bestOutcomeProb = currentOutcomeProb;
                        continue;
                    }
                    break;
                }
            }
        }
        if (this.includeGold) {
            String gold = thisWord.getSupertag();
            boolean containsGold = false;
            for (Pair<Double, String> tg : retVal) {
                if (!((String)tg.b).equals(gold)) continue;
                containsGold = true;
                break;
            }
            if (!containsGold) {
                containsGold = false;
                for (Object oc : sortedOutcomes) {
                    if (!this.mo.getOutcome(((ProbIndexPair)oc).b).equals(gold)) continue;
                    retVal.add(new Pair<Double, String>(((ProbIndexPair)oc).a, this.mo.getOutcome(((ProbIndexPair)oc).b)));
                    containsGold = true;
                    break;
                }
            }
            if (!containsGold) {
                retVal.add(new Pair<Double, String>(((ProbIndexPair)sortedOutcomes[0]).a < 0.0 ? -99.0 : 1.0112214926104486E-43, thisWord.getSupertag()));
            }
        }
        return retVal;
    }

    public List<TaggedWord> getCurrentTagging() {
        return this.tagging;
    }

    public void setCurrentTagging(List<TaggedWord> tgging) {
        this.tagging = tgging;
    }

    public List<List<Pair<Double, String>>> multitag(List<Word> sentence, double beta) {
        ArrayList<List<Pair<Double, String>>> results = new ArrayList<List<Pair<Double, String>>>(sentence.size());
        TreeMap<Integer, TaggedWord> sent = new TreeMap<Integer, TaggedWord>();
        int cnt = 0;
        List<TaggedWord> taggedSent = this.posTagger.tagSentence(sentence);
        this.setCurrentTagging(taggedSent);
        for (TaggedWord werd : taggedSent) {
            sent.put(new Integer(cnt++), werd);
        }
        List<Collection<Pair<String, Double>>> contexts = this.fexer.getSentenceFeatures(sent);
        Iterator<Word> wds = sentence.iterator();
        Word w = null;
        Iterator<Collection<Pair<String, Double>>> ctxts = contexts.iterator();
        Collection<Pair<String, Double>> context = null;
        int cursor = 0;
        while (wds.hasNext() && ctxts.hasNext()) {
            w = wds.next();
            if (w.getPOS() == null) {
                w = Word.createFullWord(w, w.getForm(), (String)this.tagging.get((int)cursor).getPOSTagging().get((int)0).b, w.getSupertag(), w.getSemClass());
            }
            context = ctxts.next();
            if (this.seqScorer != null) {
                double newBeta = Math.min(beta * this.minMultiplier, beta / 8.0);
                if (beta < 1.0E-5) {
                    newBeta = Math.min(beta * this.minMultiplier, beta / 2.0);
                }
                results.add(this.multitagWithScores(w, context, newBeta));
            } else {
                results.add(this.multitagWithScores(w, context, beta));
            }
            ++cursor;
        }
        List<List<Pair<Double, String>>> finalResults = null;
        finalResults = this.seqScorer != null ? this.betaBestFilter(this.seqScorer.rescoreSequence(results), beta, sentence) : results;
        return finalResults;
    }

    private List<List<Pair<Double, String>>> betaBestFilter(List<List<Pair<Double, String>>> multitaggings, double beta, List<Word> inputSentence) {
        ArrayList<List<Pair<Double, String>>> res = new ArrayList<List<Pair<Double, String>>>(multitaggings.size());
        int wordIndex = 0;
        for (List<Pair<Double, String>> mtagging : multitaggings) {
            ArrayList<Pair<Double, String>> tempTagging = new ArrayList<Pair<Double, String>>(mtagging.size());
            Word thisWord = inputSentence.get(wordIndex);
            Double bmult = this.betaMultipliers.get(thisWord.getPOS());
            double possiblyNewBeta = Math.min(1.0, bmult != null ? bmult * beta : beta);
            double best = (Double)mtagging.get((int)0).a;
            for (Pair<Double, String> tg : mtagging) {
                if ((Double)tg.a >= possiblyNewBeta * best || this.includeGold && ((String)tg.b).equals(thisWord.getSupertag())) {
                    tempTagging.add(tg);
                    continue;
                }
                if (this.includeGold) continue;
                break;
            }
            res.add(tempTagging);
            ++wordIndex;
        }
        return res;
    }

    @Override
    public void setBetas(double[] betas) {
        this.betas = betas;
    }

    @Override
    public double[] getBetas() {
        return this.betas;
    }

    @Override
    public double getCurrentBetaValue() {
        return this.betas[this.betaIndex];
    }

    @Override
    public void nextBeta() {
        ++this.betaIndex;
    }

    @Override
    public void previousBeta() {
        --this.betaIndex;
    }

    @Override
    public boolean hasMoreBetas() {
        return this.betaIndex < this.betas.length - 1;
    }

    @Override
    public boolean hasLessBetas() {
        return this.betaIndex > 0;
    }

    @Override
    public void resetBeta() {
        this.betaIndex = 0;
    }

    @Override
    public void resetBetaToMax() {
        this.betaIndex = this.betas.length - 1;
    }

    @Override
    public void setIncludeGold(boolean includeGold) {
        this.includeGold = includeGold;
    }

    @Override
    public void mapWords(List<Word> words) {
        this.K = this.hasMoreBetas() ? this.usualK : this.finalK;
        this.currentTagging = this.multitag(words, this.getCurrentBetaValue());
    }

    @Override
    public void setWord(int index) {
        this.currentWord = index;
    }

    @Override
    public Map<String, Double> getSupertags() {
        HashMap<String, Double> retval = new HashMap<String, Double>();
        List<Pair<Double, String>> tags = this.currentTagging.get(this.currentWord);
        for (Pair<Double, String> tag : tags) {
            retval.put((String)tag.b, (Double)tag.a);
        }
        return retval;
    }

    public static WordAndPOSDictionaryLabellingStrategy supertaggerFactory(String configFile) {
        WordAndPOSDictionaryLabellingStrategy res = null;
        String[] pathKeys = new String[]{"priormodel", "priormodelvocab", "sequencemodel", "wdict", "posdict", "maxentmodel", "posconfig"};
        Map<String, String> opts = ConfigFileProcessor.readInConfig(configFile, pathKeys);
        boolean verbose = opts.get("verbose").equals("true");
        String priorModS = opts.get("priormodel");
        String priorVocabS = opts.get("priormodelvocab");
        String seqModS = opts.get("sequencemodel");
        String wDictS = opts.get("wdict");
        String pDictS = opts.get("posdict");
        String firstKS = opts.get("firstk");
        String lastKS = opts.get("lastk");
        String maxentModS = opts.get("maxentmodel");
        String posConfigS = opts.get("posconfig");
        String betasS = opts.get("betas");
        String betaMults = opts.get("betamultipliers");
        String includeGold = opts.get("includegold");
        assert (maxentModS != null) : "Empty maxent model.";
        assert (priorModS != null && priorVocabS != null || priorModS == null && priorVocabS == null) : "using prior model with no vocab file.";
        assert ((wDictS == null || pDictS == null) && priorModS == null) : "need tagging dicts if no supertagging prior model and prior vocab are specified.";
        assert (priorModS != null && pDictS == null) : "need POS-keyed tagging dict for prior model.";
        assert (priorModS == null || firstKS != null & lastKS != null) : "need to specify first and last 'K' value when not using prior model.";
        if (seqModS == null && verbose) {
            System.err.println("Warning: empty sequence model. Performance will suffer.");
        }
        STPriorModel priorM = null;
        if (priorModS != null && priorVocabS != null) {
            try {
                priorM = new STPriorModel(priorModS, priorVocabS);
            }
            catch (IOException ex) {
                Logger.getLogger(WordAndPOSDictionaryLabellingStrategy.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        STFex fex = new STFex(priorM);
        STTaggerWordDictionary wD = wDictS != null ? new XMLWordDictionaryReader(new File(wDictS)).read() : null;
        STTaggerPOSDictionary pD = pDictS != null ? new XMLPOSDictionaryReader(new File(pDictS)).read() : null;
        int kay = opts.get("firstk") == null ? 20 : Integer.parseInt(opts.get("firstk"));
        int firstK = opts.get("firstk") == null ? 20 : Integer.parseInt(opts.get("firstk"));
        int lastK = opts.get("lastk") == null ? 100 : Integer.parseInt(opts.get("lastk"));
        double[] betaz = new double[betasS.split("\\s+").length];
        int cursor = 0;
        for (String beta : betasS.split("\\s+")) {
            betaz[cursor++] = Double.parseDouble(beta);
        }
        boolean useWordDictionary = wDictS != null;
        boolean usePOSDictionary = pDictS != null;
        POSTagger pTagger = posConfigS == null ? null : POSTagger.posTaggerFactory(posConfigS);
        Constants.TaggingAlgorithm alg = opts.get("taggingalgorithm") == null || opts.get("taggingalgorithm").equals("forward-backward") ? Constants.TaggingAlgorithm.FORWARDBACKWARD : Constants.TaggingAlgorithm.FORWARD;
        ZLMEM mem = new ZLMEM(new File(maxentModS));
        res = pTagger != null ? new WordAndPOSDictionaryLabellingStrategy(wD, pD, kay, mem, fex, seqModS, alg, pTagger) : new WordAndPOSDictionaryLabellingStrategy(wD, pD, kay, mem, fex, seqModS, alg);
        res.setK(kay);
        res.setUsualK(firstK);
        res.setFinalK(lastK);
        res.setBetas(betaz);
        res.useWordDict(useWordDictionary);
        res.usePOSDict(usePOSDictionary);
        res.setIncludeGold(opts.get("includegold") != null && !opts.get("includegold").equals("false"));
        if (betaMults != null) {
            String[] bmts = betaMults.split("\\s+");
            int a = 0;
            for (int b = 1; b < bmts.length; b += 2) {
                double mul = Double.parseDouble(bmts[b]);
                res.betaMultipliers.put(bmts[a], mul);
                if (mul < res.minMultiplier) {
                    res.minMultiplier = mul;
                }
                a += 2;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String usage = "\nWordAndPOSDictLabellingStrategy (-h [gets this message]) -e <areWeTesting> [defaults to not testing] -c <configFile> > -beta [0.0,1.0]\n                                  (-i <input> [default=<stdin>]) (-o <output> [default=<stdout>])\n";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println(usage);
            System.exit(0);
        }
        SRILMFactoredBundleCorpusIterator in = null;
        BufferedWriter out = null;
        try {
            String inputCorp = "<stdin>";
            String output = "<stdout>";
            String configFile = null;
            double beta = 1.0;
            boolean test = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-i")) {
                    inputCorp = args[++i];
                    continue;
                }
                if (args[i].equals("-o")) {
                    output = args[++i];
                    continue;
                }
                if (args[i].equals("-e")) {
                    test = true;
                    continue;
                }
                if (args[i].equals("-c")) {
                    configFile = args[++i];
                    continue;
                }
                if (args[i].equals("-beta")) {
                    beta = Double.parseDouble(args[++i]);
                    continue;
                }
                System.out.println("Unrecognized option: " + args[i]);
            }
            ResultSink rs = new ResultSink(ResultSink.ResultSinkType.SUPERTAG);
            try {
                in = new SRILMFactoredBundleCorpusIterator(inputCorp.equals("<stdin>") ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(new File(inputCorp))));
            }
            catch (FileNotFoundException ex) {
                System.err.print("Input corpus " + inputCorp + " not found.  Exiting...");
                Logger.getLogger(WordAndPOSDictionaryLabellingStrategy.class.getName()).log(Level.SEVERE, null, ex);
                System.exit(-1);
            }
            try {
                out = output.equals("<stdout>") ? new BufferedWriter(new OutputStreamWriter(System.out)) : new BufferedWriter(new FileWriter(new File(output)));
            }
            catch (IOException ex) {
                System.err.print("Output file " + output + " not found.  Exiting...");
                Logger.getLogger(WordAndPOSDictionaryLabellingStrategy.class.getName()).log(Level.SEVERE, null, ex);
                System.exit(-1);
            }
            WordAndPOSDictionaryLabellingStrategy stgger = WordAndPOSDictionaryLabellingStrategy.supertaggerFactory(configFile);
            for (List<Word> inLine : in) {
                List<List<Pair<Double, String>>> taggedSent = stgger.multitag(inLine, beta);
                if (test) {
                    rs.addSent(taggedSent, inLine);
                }
                out.write("<s>" + System.getProperty("line.separator"));
                List<TaggedWord> posTagging = stgger.getCurrentTagging();
                int cursor = -1;
                while (++cursor < taggedSent.size()) {
                    Word wdIn = inLine.get(cursor);
                    out.write(wdIn.getForm());
                    TaggedWord posT = posTagging.get(cursor);
                    out.write("\t" + posT.getPOSTagging().size());
                    for (Pair<Double, String> pt : posT.getPOSTagging()) {
                        out.write("\t" + (String)pt.b + "\t" + pt.a);
                    }
                    out.write("\t" + taggedSent.get(cursor).size());
                    for (Pair<Double, String> stg : taggedSent.get(cursor)) {
                        out.write("\t" + (String)stg.b + "\t" + stg.a);
                    }
                    out.write(System.getProperty("line.separator"));
                }
                out.write("</s>" + System.getProperty("line.separator"));
            }
            out.flush();
            if (test) {
                System.err.println(rs.report());
            }
        }
        catch (IOException ex) {
            Logger.getLogger(WordAndPOSDictionaryLabellingStrategy.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                out.close();
                in.close();
            }
            catch (IOException ex) {
                Logger.getLogger(WordAndPOSDictionaryLabellingStrategy.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

