/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse.supertagger.io;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import opennlp.ccg.parse.supertagger.util.STTaggerPOSDictionary;
import opennlp.ccg.util.Pair;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLPOSDictionaryReader {
    private File dictFile;
    private XMLReader reader;
    private Map<String, Collection<String>> dict;

    public XMLPOSDictionaryReader(File df) {
        if (!df.exists()) {
            throw new RuntimeException("File " + df.getAbsolutePath().toString() + " does not exist.");
        }
        this.dictFile = df;
    }

    public STTaggerPOSDictionary read() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            this.reader = parser.getXMLReader();
            this.reader.setContentHandler(new wdContentHandler());
            this.reader.parse(this.dictFile.toURI().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new STTaggerPOSDictionary(this.dict);
    }

    public static void main(String[] args) {
        String fname = args[0];
        XMLPOSDictionaryReader rdr = new XMLPOSDictionaryReader(new File(fname));
        STTaggerPOSDictionary dct = rdr.read();
        Iterator<Pair<String, Collection<String>>> it = dct.getMappings();
        Pair<String, Collection<String>> tempP = null;
        System.out.println("<posdict>");
        while (it.hasNext()) {
            tempP = it.next();
            System.out.println("     <entry pos=\"" + (String)tempP.a + "\">");
            Iterator stgs = ((Collection)tempP.b).iterator();
            while (stgs.hasNext()) {
                System.out.println("          <supertag> " + ((String)stgs.next()).trim() + " </supertag>");
            }
            System.out.println("     </entry>");
        }
        System.out.print("</posdict>");
    }

    class wdContentHandler
    extends DefaultHandler {
        private boolean inEntry = false;
        private boolean inSupertag = false;
        private String curPOS = null;
        private String currSTFrag = null;

        wdContentHandler() {
        }

        @Override
        public void startDocument() {
            XMLPOSDictionaryReader.this.dict = new TreeMap();
        }

        @Override
        public void startElement(String namespaceURI, String lname, String qname, Attributes attrs) throws SAXException {
            if (qname.equalsIgnoreCase("entry")) {
                if (this.inEntry) {
                    throw new SAXException("Something is wrong.\nThis is not a well-formed dictionary.");
                }
                this.inEntry = true;
                String pos = attrs.getValue(0).trim();
                XMLPOSDictionaryReader.this.dict.put(pos, new HashSet());
                this.curPOS = pos;
            } else if (qname.equalsIgnoreCase("supertag")) {
                if (!this.inEntry) {
                    throw new SAXException("Something is wrong.\nThis is not a well-formed dictionary.");
                }
                this.inSupertag = true;
                this.currSTFrag = "";
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            if (qName.equalsIgnoreCase("entry")) {
                this.inEntry = false;
                this.curPOS = null;
            } else if (qName.equalsIgnoreCase("supertag")) {
                this.inSupertag = false;
                Collection tempL = (Collection)XMLPOSDictionaryReader.this.dict.get(this.curPOS);
                tempL.add(this.currSTFrag.trim());
                XMLPOSDictionaryReader.this.dict.put(this.curPOS, tempL);
                this.currSTFrag = null;
            }
        }

        @Override
        public void characters(char[] ch, int start2, int length) {
            if (this.inSupertag && this.curPOS != null) {
                String temp = new String(ch);
                temp = temp.substring(start2, start2 + length);
                this.currSTFrag = this.currSTFrag + temp;
            } else if (this.inSupertag) {
                System.err.println("Something is wrong.\nThis is not a well-formed dictionary.");
            }
        }
    }
}

