/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse.supertagger.ml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import opennlp.ccg.lexicon.DefaultTokenizer;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.ngrams.ConditionalProbabilityTable;
import opennlp.ccg.parse.supertagger.util.ProbPairComparator;
import opennlp.ccg.parse.supertagger.util.STTaggerPOSDictionary;
import opennlp.ccg.parse.tagger.ProbIndexPair;
import opennlp.ccg.parse.tagger.io.SRILMFactoredBundleCorpusIterator;
import opennlp.ccg.util.Interner;
import opennlp.ccg.util.Pair;

public class STPriorModel
extends ConditionalProbabilityTable {
    public static final String WORD = "W";
    public static final String POS_TAG = "P";
    public static final String SUPERTAG = "T";
    private Interner<Pair<String, String>> pairs = new Interner();
    public List<Pair<String, String>> attrVals = new ArrayList<Pair<String, String>>(5);
    private ProbPairComparator ppcomp = new ProbPairComparator();
    List<Pair<Double, String>> priors = new ArrayList<Pair<Double, String>>(1000);
    private String[] stagVocab = null;
    private double[] stagDistro = null;
    private STTaggerPOSDictionary posDict = null;
    private ProbIndexPair[] stagPointers = null;

    public STPriorModel(String flmFile, String vocabFile) throws IOException {
        this(flmFile, vocabFile, null);
    }

    public STPriorModel(String flmFile, String vocabFile, STTaggerPOSDictionary posDict) throws IOException {
        super(flmFile);
        this.posDict = posDict;
        String st = null;
        BufferedReader br = new BufferedReader(new FileReader(new File(vocabFile)));
        st = br.readLine().trim();
        while (st != null && !st.trim().startsWith("T-")) {
            st = br.readLine();
        }
        if (st != null) {
            st = st.trim().split("-")[1];
        }
        HashSet<String> allSupertags = new HashSet<String>();
        int cnt = 0;
        while (st != null) {
            ++cnt;
            allSupertags.add(st);
            while (st != null && !st.trim().startsWith("T-")) {
                st = br.readLine();
            }
            if (st == null) continue;
            st = st.trim().split("-")[1];
        }
        br.close();
        this.stagVocab = new String[cnt];
        this.stagPointers = new ProbIndexPair[cnt];
        this.stagDistro = new double[cnt];
        cnt = 0;
        for (String stag : allSupertags) {
            this.stagVocab[cnt++] = stag.intern();
        }
    }

    public void setPOSDict(STTaggerPOSDictionary posDict) {
        this.posDict = posDict;
    }

    public double getPriorOf(String supertag, String word, String pos) {
        this.attrVals.clear();
        Pair<String, String> surfaceForm = this.pairs.intern(new Pair<String, String>(WORD, DefaultTokenizer.escape(word).intern()));
        this.attrVals.add(surfaceForm);
        Pair<String, String> partOfSpeech = this.pairs.intern(new Pair<String, String>(POS_TAG, DefaultTokenizer.escape(pos).intern()));
        this.attrVals.add(partOfSpeech);
        this.attrVals.add(this.pairs.intern(new Pair<String, String>(SUPERTAG, DefaultTokenizer.escape(supertag).intern())));
        return this.score(this.attrVals);
    }

    public List<Pair<String, Double>> getBetaBestPriors(Word w, double beta) {
        List<Pair<String, Double>> allPriors = this.getAllPriors(w);
        ArrayList<Pair<String, Double>> betaBestPriors = new ArrayList<Pair<String, Double>>(100);
        double best = (Double)allPriors.get((int)0).b;
        for (Pair<String, Double> prior : allPriors) {
            if (!(best * beta <= (Double)prior.b)) break;
            betaBestPriors.add(prior);
        }
        return betaBestPriors;
    }

    public void computePriors(Word w) {
        if (this.posDict != null) {
            this.priors = this.getPOSRestrictedPriors(w);
        }
    }

    protected List<Pair<Double, String>> getPOSRestrictedPriors(Word w) {
        Collection<String> tagsAllowed = this.posDict.getEntry(w.getPOS());
        if (tagsAllowed == null || tagsAllowed.size() == 0) {
            return this.priors;
        }
        ArrayList<Pair<Double, String>> sortedTags = new ArrayList<Pair<Double, String>>(tagsAllowed.size());
        for (String tag : tagsAllowed) {
            sortedTags.add(new Pair<Double, String>(this.getPriorOf(tag, w.getForm(), w.getPOS()), tag));
        }
        Collections.sort(sortedTags, this.ppcomp);
        return sortedTags;
    }

    public List<Pair<String, Double>> getRestrictedBetaBestPriors(Word w, double beta) {
        if (this.posDict == null) {
            return this.getBetaBestPriors(w, beta);
        }
        ArrayList<Pair<String, Double>> rez = new ArrayList<Pair<String, Double>>(50);
        double best = (Double)this.priors.get((int)0).a;
        for (Pair<Double, String> tg : this.priors) {
            if (!((Double)tg.a >= beta * best)) break;
            rez.add(new Pair(tg.b, tg.a));
        }
        return rez;
    }

    public List<Pair<String, Double>> getRestrictedBetaWorstPriors(Word w, double beta) {
        if (this.posDict == null) {
            throw new UnsupportedOperationException("Cannot get beta-worst without a pos-keyed tagging dict.\nNot yet implemented.");
        }
        ArrayList<Pair<String, Double>> rez = new ArrayList<Pair<String, Double>>(50);
        ArrayList<Pair<Double, String>> cpy = new ArrayList<Pair<Double, String>>(this.priors);
        Collections.reverse(cpy);
        double worst = (Double)((Pair)cpy.get((int)0)).a;
        for (Pair pair : cpy) {
            if (!((Double)pair.a * beta <= worst)) break;
            rez.add(new Pair(pair.b, pair.a));
        }
        return rez;
    }

    public List<Pair<String, Double>> getAllPriors(Word w) {
        return this.getNBestPriors(w, this.stagVocab.length);
    }

    public List<Pair<String, Double>> getNBestPriors(Word w, int n) {
        this.attrVals.clear();
        Pair<String, String> surfaceForm = this.pairs.intern(new Pair<String, String>(WORD, DefaultTokenizer.escape(w.getForm()).intern()));
        this.attrVals.add(surfaceForm);
        Pair<String, String> pos = this.pairs.intern(new Pair<String, String>(POS_TAG, DefaultTokenizer.escape(w.getPOS()).intern()));
        this.attrVals.add(pos);
        int cnt = 0;
        for (String st : this.stagVocab) {
            double sc;
            if (this.attrVals.size() == 3) {
                this.attrVals.remove(this.attrVals.size() - 1);
            }
            this.attrVals.add(this.pairs.intern(new Pair<String, String>(SUPERTAG, st)));
            this.stagDistro[cnt] = sc = this.score(this.attrVals);
            this.stagPointers[cnt] = new ProbIndexPair(sc, cnt);
            ++cnt;
        }
        Arrays.sort(this.stagPointers);
        ArrayList<Pair<String, Double>> result = new ArrayList<Pair<String, Double>>(n);
        for (int i = 0; i < n; ++i) {
            result.add(new Pair<String, Double>(this.stagVocab[this.stagPointers[i].b], this.stagPointers[i].a));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String usage = "\nSTPriorModel -vocab <vocabfile> (-c <corpus>) (-o <output>) (-u <catFreqCutoff> ) (-v [ or '-verbose'])\n";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println(usage);
            System.exit(0);
        }
        SRILMFactoredBundleCorpusIterator in = null;
        BufferedWriter out = null;
        BufferedWriter voc = null;
        try {
            String wform;
            String pos;
            String st;
            String inputCorp = "<stdin>";
            String output = "<stdout>";
            String vocabFile = "vocab.voc";
            int catCutoff = 10;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-c")) {
                    inputCorp = args[++i];
                    continue;
                }
                if (args[i].equals("-o")) {
                    output = args[++i];
                    continue;
                }
                if (args[i].equals("-vocab")) {
                    vocabFile = args[++i];
                    continue;
                }
                if (args[i].equals("-u")) {
                    catCutoff = Integer.parseInt(args[++i]);
                    continue;
                }
                System.out.println("Unrecognized option: " + args[i]);
            }
            try {
                in = new SRILMFactoredBundleCorpusIterator(inputCorp.equals("<stdin>") ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(new File(inputCorp))));
            }
            catch (FileNotFoundException ex) {
                System.err.print("Input corpus " + inputCorp + " not found.  Exiting...");
                Logger.getLogger(STPriorModel.class.getName()).log(Level.SEVERE, null, ex);
                System.exit(-1);
            }
            try {
                out = output.equals("<stdout>") ? new BufferedWriter(new OutputStreamWriter(System.out)) : new BufferedWriter(new FileWriter(new File(output)));
            }
            catch (IOException ex) {
                System.err.print("Output file " + output + " not found.  Exiting...");
                Logger.getLogger(STPriorModel.class.getName()).log(Level.SEVERE, null, ex);
                System.exit(-1);
            }
            try {
                voc = new BufferedWriter(new FileWriter(new File(vocabFile)));
            }
            catch (IOException ex) {
                Logger.getLogger(STPriorModel.class.getName()).log(Level.SEVERE, null, ex);
            }
            HashMap<String, Integer> vocab = new HashMap<String, Integer>();
            for (List<Word> inLine : in) {
                for (Word w : inLine) {
                    st = "T-" + DefaultTokenizer.escape(w.getSupertag());
                    pos = "P-" + DefaultTokenizer.escape(w.getPOS());
                    wform = "W-" + DefaultTokenizer.escape(w.getForm());
                    vocab.put(st, vocab.get(st) == null ? 1 : (Integer)vocab.get(st) + 1);
                    vocab.put(pos, vocab.get(pos) == null ? 1 : (Integer)vocab.get(pos) + 1);
                    vocab.put(wform, vocab.get(wform) == null ? 1 : (Integer)vocab.get(wform) + 1);
                }
            }
            try {
                in = new SRILMFactoredBundleCorpusIterator(inputCorp.equals("<stdin>") ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(new File(inputCorp))));
            }
            catch (FileNotFoundException ex) {
                System.err.print("Input corpus " + inputCorp + " not found.  Exiting...");
                Logger.getLogger(STPriorModel.class.getName()).log(Level.SEVERE, null, ex);
                System.exit(-1);
            }
            for (List<Word> inLine : in) {
                for (Word w : inLine) {
                    st = "T-" + DefaultTokenizer.escape(w.getSupertag());
                    pos = "P-" + DefaultTokenizer.escape(w.getPOS());
                    wform = "W-" + DefaultTokenizer.escape(w.getForm());
                    if ((Integer)vocab.get(st) <= catCutoff) continue;
                    out.write(wform + ":" + pos + ":" + st + " ");
                }
                out.write(System.getProperty("line.separator"));
            }
            out.flush();
            for (String str : vocab.keySet()) {
                if ((Integer)vocab.get(str) <= catCutoff) continue;
                voc.write(str + System.getProperty("line.separator"));
            }
            voc.flush();
        }
        finally {
            try {
                out.close();
                in.close();
                voc.close();
            }
            catch (IOException ex) {
                Logger.getLogger(STPriorModel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

