/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank.extract;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.grammar.RuleGroup;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.hylo.Proposition;
import opennlp.ccg.hylo.SatOp;
import opennlp.ccg.lexicon.DefaultTokenizer;
import opennlp.ccg.lexicon.LexException;
import opennlp.ccg.lexicon.Lexicon;
import opennlp.ccg.lexicon.SupertaggerAdapter;
import opennlp.ccg.lexicon.Tokenizer;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.parse.ParseException;
import opennlp.ccg.synsem.ArgStack;
import opennlp.ccg.synsem.AtomCat;
import opennlp.ccg.synsem.BasicArg;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.ComplexCat;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.synsem.SignHash;
import opennlp.ccg.synsem.Slash;
import opennlp.ccg.test.RegressionInfo;
import opennlp.ccg.unify.FeatureStructure;
import opennlp.ccg.unify.UnifyControl;
import opennlp.ccgbank.CCGBankTaskSources;
import opennlp.ccgbank.CCGBankTaskTestbed;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Testbed {
    private Grammar grammar;
    private Lexicon lexicon;
    private RuleGroup rules;
    private SupertaggerStandIn supertaggerStandIn = new SupertaggerStandIn();
    private Sign sign = null;
    private LF lf = null;
    private String str = "";
    private int numParses = 0;
    private String header = "";
    private static ArrayList<String> treeInfo = new ArrayList();
    private static boolean treeInfoFlag = false;
    private static Hashtable<String, String> predInfo = new Hashtable();
    private Set<String> combos = null;
    Set<CCGBankTaskSources> sourcesSet;
    CCGBankTaskTestbed ccgBankTaskTestbed;
    File grammarFile;
    File targetDirectory;
    private static Set<String> rolesSet = new HashSet<String>();

    public Testbed(Set<CCGBankTaskSources> sourcesSet, File targetDirectory, CCGBankTaskTestbed testbed) throws IOException {
        this.grammarFile = new File(targetDirectory, "grammar.xml");
        this.grammar = new Grammar(this.grammarFile.toURI().toURL(), true);
        this.lexicon = this.grammar.lexicon;
        this.rules = this.grammar.rules;
        this.sourcesSet = sourcesSet;
        this.targetDirectory = targetDirectory;
        this.ccgBankTaskTestbed = testbed;
    }

    public void createTestFiles() throws IOException, JDOMException {
        this.ccgBankTaskTestbed.log("Creating test files:");
        Tokenizer tokenizer = this.grammar.lexicon.tokenizer;
        this.grammar.prefs.showFeats = true;
        this.grammar.prefs.showSem = this.ccgBankTaskTestbed.isShowsSem();
        File testDir = new File(this.targetDirectory, "test");
        testDir.mkdirs();
        this.ccgBankTaskTestbed.log("Writing test files to: " + testDir.getPath());
        PrintWriter textPW = null;
        PrintWriter textscPW = null;
        PrintWriter factorsPW = null;
        PrintWriter combosPW = null;
        PrintWriter predsPW = null;
        PrintWriter treePW = null;
        File textFile = this.ccgBankTaskTestbed.getText();
        File factorsFile = this.ccgBankTaskTestbed.getFactors();
        File combosFile = this.ccgBankTaskTestbed.getCombos();
        File predsFile = this.ccgBankTaskTestbed.getPreds();
        File treeFile = this.ccgBankTaskTestbed.getTree();
        if (textFile != null) {
            File textscFile = new File(textFile.getParent() + "/" + textFile.getName().replaceFirst("text-", "textsc-"));
            this.ccgBankTaskTestbed.log("Writing text to: " + textFile);
            this.ccgBankTaskTestbed.log("Writing class-replaced text to: " + textscFile);
            textFile.getParentFile().mkdirs();
            textPW = new PrintWriter(new BufferedWriter(new FileWriter(textFile)));
            textscPW = new PrintWriter(new BufferedWriter(new FileWriter(textscFile)));
        }
        if (factorsFile != null) {
            this.ccgBankTaskTestbed.log("Writing factors to: " + factorsFile);
            factorsFile.getParentFile().mkdirs();
            factorsPW = new PrintWriter(new BufferedWriter(new FileWriter(factorsFile)));
        }
        if (combosFile != null) {
            this.ccgBankTaskTestbed.log("Writing supertag-rule combos to: " + combosFile);
            combosFile.getParentFile().mkdirs();
            this.combos = new HashSet<String>();
            combosPW = new PrintWriter(new BufferedWriter(new FileWriter(combosFile)));
        }
        if (predsFile != null) {
            this.ccgBankTaskTestbed.log("Writing preds to: " + predsFile);
            predsFile.getParentFile().mkdirs();
            predsPW = new PrintWriter(new BufferedWriter(new FileWriter(predsFile)));
        }
        if (treeFile != null) {
            this.ccgBankTaskTestbed.log("Writing tree node info to: " + treeFile);
            treeFile.getParentFile().mkdirs();
            treePW = new PrintWriter(new BufferedWriter(new FileWriter(treeFile)));
            treeInfoFlag = true;
        }
        SAXBuilder builder = new SAXBuilder();
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        int numWithLFs = 0;
        int numSingleRootLFs = 0;
        int numWithoutLFs = 0;
        for (CCGBankTaskSources sources : this.sourcesSet) {
            for (File file : sources) {
                File testSectDir = new File(testDir, file.getParentFile().getName());
                testSectDir.mkdir();
                this.ccgBankTaskTestbed.log("Debug Print: " + testSectDir.getAbsolutePath());
                Document inDoc = builder.build(file);
                Element inRoot = inDoc.getRootElement();
                Document outDoc = new Document();
                Element outRoot = new Element("regression");
                outDoc.setRootElement(outRoot);
                HashMap<String, Sign> signMap = new HashMap<String, Sign>();
                List derivElts = inRoot.getChildren();
                for (Object derivObj : derivElts) {
                    Element derivElt = (Element)derivObj;
                    this.followDeriv(derivElt);
                    if (this.lf != null) {
                        ++numWithLFs;
                        if (this.lf instanceof SatOp) {
                            ++numSingleRootLFs;
                        }
                        Element item = RegressionInfo.makeTestItem(this.grammar, this.str, this.numParses, this.lf);
                        if (this.header == null) {
                            this.header = "missing";
                            this.ccgBankTaskTestbed.log("Warning: missing header in " + file);
                        }
                        item.setAttribute("info", this.header);
                        if (this.header != null) {
                            signMap.put(this.header, this.sign);
                        }
                        Element fullWordsElt = new Element("full-words");
                        fullWordsElt.addContent(tokenizer.format(this.sign.getWords()));
                        Element predInfoElt = new Element("pred-info");
                        String predInfoText = Testbed.collectPredInfo(this.header);
                        predInfoElt.setAttribute("data", predInfoText);
                        item.addContent((Content)fullWordsElt);
                        item.addContent((Content)predInfoElt);
                        outRoot.addContent((Content)item);
                        if (textPW != null) {
                            textPW.println(this.str);
                        }
                        if (textscPW != null) {
                            textscPW.flush();
                            String textsc = "";
                            textsc = tokenizer.getOrthography(this.sign.getWords(), true);
                            textscPW.println(textsc);
                            textscPW.flush();
                        }
                        if (factorsPW != null) {
                            factorsPW.println(tokenizer.format(this.sign.getWords()));
                        }
                        if (combosPW != null) {
                            for (String combo : this.newCombos()) {
                                combosPW.println(combo);
                            }
                        }
                        if (predsPW != null) {
                            predsPW.println(predInfoText);
                        }
                        if (treePW != null) {
                            for (String info : treeInfo) {
                                treePW.println(info);
                                treePW.flush();
                            }
                        }
                        treeInfo = new ArrayList();
                        continue;
                    }
                    ++numWithoutLFs;
                }
                File regressionFile = new File(testSectDir, file.getName());
                outputter.output(outDoc, (OutputStream)new FileOutputStream(regressionFile));
                RegressionInfo.writeSerFile(signMap, regressionFile);
            }
        }
        if (textPW != null) {
            textPW.flush();
            textPW.close();
        }
        if (factorsPW != null) {
            factorsPW.flush();
            factorsPW.close();
        }
        if (combosPW != null) {
            combosPW.flush();
            combosPW.close();
        }
        if (predsPW != null) {
            predsPW.flush();
            predsPW.close();
        }
        if (treePW != null) {
            treePW.flush();
            treePW.close();
        }
        this.ccgBankTaskTestbed.log("numWithLFs: " + numWithLFs);
        this.ccgBankTaskTestbed.log("numSingleRootLFs: " + numSingleRootLFs);
        this.ccgBankTaskTestbed.log("numWithoutLFs: " + numWithoutLFs);
        this.ccgBankTaskTestbed.log("total: " + (numWithLFs + numWithoutLFs));
    }

    private void followDeriv(Element derivElt) {
        this.sign = null;
        this.lf = null;
        this.str = "";
        this.header = derivElt.getAttributeValue("Header");
        UnifyControl.startUnifySequence();
        try {
            Category cat = null;
            Nominal index = null;
            LF flatLF = null;
            SignHash signs = this.followDerivR(derivElt);
            if (!signs.isEmpty()) {
                Iterator<Sign> iter = signs.asSignSet().iterator();
                int matchSRLF = 0;
                while (iter.hasNext()) {
                    this.sign = iter.next();
                    cat = this.sign.getCategory();
                    index = cat.getIndexNominal();
                    flatLF = cat.getLF();
                    if (flatLF == null) continue;
                    this.lf = HyloHelper.compactAndConvertNominals(flatLF, index, this.sign);
                    if (!(this.lf instanceof SatOp)) continue;
                    ++matchSRLF;
                    break;
                }
                if (matchSRLF == 0) {
                    this.sign = signs.asSignSet().iterator().next();
                    cat = this.sign.getCategory();
                    index = cat.getIndexNominal();
                    flatLF = cat.getLF();
                    if (flatLF != null) {
                        this.lf = HyloHelper.compactAndConvertNominals(flatLF, index, this.sign);
                    }
                }
                if (flatLF != null) {
                    this.extrPredInfo(flatLF, "");
                }
                this.numParses = signs.size();
                this.str = this.str.trim();
            }
        }
        catch (ParseException exc) {
            this.ccgBankTaskTestbed.log("Warning for " + this.header + ": " + exc.toString());
        }
    }

    private SignHash followDerivR(Element derivElt) throws ParseException {
        String eltName = derivElt.getName();
        if (eltName.equals("Treenode")) {
            String cat = derivElt.getAttributeValue("cat");
            String ntId = derivElt.getAttributeValue("nt_id");
            String simpleCat = derivElt.getAttributeValue("stag");
            List childElts = derivElt.getChildren();
            int numChildren = childElts.size();
            if (numChildren == 0) {
                throw new ParseException(this.header + ": no child elements for TreeNode for cat: " + cat);
            }
            Element elt0 = (Element)childElts.get(0);
            String elt0name = elt0.getName();
            if (elt0name.equals("Treenode") || elt0name.equals("Leafnode")) {
                childElts.add(0, new Element("dummy"));
                ++numChildren;
            }
            if (numChildren != 2 && numChildren != 3) {
                throw new ParseException(this.header + ": wrong number of child elements: " + numChildren + " for cat: " + cat);
            }
            Element firstInputElt = (Element)childElts.get(1);
            SignHash firstSigns = this.followDerivR(firstInputElt);
            SignHash retval = new SignHash();
            if (numChildren == 2) {
                for (Sign s : firstSigns.asSignSet()) {
                    List<Sign> results = this.rules.applyUnaryRules(s);
                    for (Sign sign : results) {
                        retval.insert(sign);
                    }
                }
                if (!Testbed.containsCat(retval, simpleCat)) {
                    boolean noResults = retval.isEmpty();
                    String inCat = firstInputElt.getAttributeValue("cat");
                    String msg = "Unable to derive: " + cat + " from: " + inCat;
                    if (!noResults) {
                        this.ccgBankTaskTestbed.log("Caution for " + this.header + ": " + msg);
                    }
                    if (this.ccgBankTaskTestbed.isDebugDerivations()) {
                        this.ccgBankTaskTestbed.log(this.header + ": derivation stymied; inputs: ");
                        for (Sign sign : firstSigns.asSignSet()) {
                            this.ccgBankTaskTestbed.log(sign.toString());
                        }
                        if (!noResults) {
                            this.ccgBankTaskTestbed.log("Outputs: ");
                            for (Sign sign : retval.asSignSet()) {
                                this.ccgBankTaskTestbed.log(sign.toString());
                            }
                        }
                    }
                    if (noResults) {
                        throw new ParseException("Derivation blocked: " + msg);
                    }
                }
            } else if (numChildren == 3) {
                Element secondInputElt = (Element)childElts.get(2);
                SignHash secondSigns = this.followDerivR(secondInputElt);
                for (Sign sign1 : firstSigns.asSignSet()) {
                    for (Sign sign2 : secondSigns.asSignSet()) {
                        Iterator<Sign> results = this.rules.applyBinaryRules(sign1, sign2);
                        Iterator<Sign> iterator = results.iterator();
                        while (iterator.hasNext()) {
                            Sign rSign = iterator.next();
                            retval.insert(rSign);
                        }
                    }
                }
                if (retval.isEmpty()) {
                    if (Testbed.isPunct(secondInputElt)) {
                        return firstSigns;
                    }
                    if (Testbed.isPunct(firstInputElt)) {
                        return secondSigns;
                    }
                }
                if (!Testbed.containsCat(retval, simpleCat)) {
                    boolean noResults = retval.isEmpty();
                    String inCat1 = firstInputElt.getAttributeValue("cat");
                    String string = secondInputElt.getAttributeValue("cat");
                    String msg = "Unable to derive: " + cat + " from: " + inCat1 + " and: " + string;
                    if (!noResults) {
                        this.ccgBankTaskTestbed.log("Caution for " + this.header + ": " + msg);
                    }
                    if (this.ccgBankTaskTestbed.isDebugDerivations()) {
                        this.ccgBankTaskTestbed.log(this.header + ": derivation stymied; first inputs: ");
                        for (Sign sign : firstSigns.asSignSet()) {
                            this.ccgBankTaskTestbed.log(sign.toString());
                        }
                        this.ccgBankTaskTestbed.log("Second inputs: ");
                        for (Sign sign : secondSigns.asSignSet()) {
                            this.ccgBankTaskTestbed.log(sign.toString());
                        }
                        if (!noResults) {
                            this.ccgBankTaskTestbed.log("Outputs: ");
                            for (Sign sign : retval.asSignSet()) {
                                this.ccgBankTaskTestbed.log(sign.toString());
                            }
                        }
                    }
                    if (noResults) {
                        throw new ParseException("Derivation blocked: " + msg);
                    }
                }
            }
            if (treeInfoFlag) {
                for (Sign s : retval.asSignSet()) {
                    Hashtable<String, String> idConvTally = new Hashtable<String, String>();
                    Hashtable<String, Integer> freqTally = new Hashtable<String, Integer>();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    String catId = "";
                    Category treeCat = s.getCategory();
                    Testbed.recurseCat(treeCat, arrayList, idConvTally, freqTally);
                    if (arrayList.size() <= 1) continue;
                    for (String x : arrayList) {
                        String[] y = x.split("_");
                        if (y.length == 1) {
                            catId = catId + "," + y[0];
                            continue;
                        }
                        int freq = freqTally.get(y[1]);
                        freqTally.put(y[1], freq - 1);
                        if (x.endsWith("_M") && freq <= 1) {
                            x = x.replaceFirst("_M", "");
                        }
                        catId = catId + "," + x;
                    }
                    catId = catId.replaceFirst(",", "");
                    treeInfo.add(this.header + " " + ntId + " " + catId);
                }
            }
            return retval;
        }
        if (eltName.equals("Leafnode")) {
            try {
                String morphClass;
                Sign s;
                String lex = derivElt.getAttributeValue("lexeme");
                Word w = this.lexicon.tokenizer.parseToken(lex);
                this.str = this.str + w.getForm() + " ";
                String cat = derivElt.getAttributeValue("cat");
                String simpleCat = derivElt.getAttributeValue("stag");
                String rel = derivElt.getAttributeValue("rel");
                String indexRel = derivElt.getAttributeValue("indexRel");
                String semClass = "";
                semClass = derivElt.getAttributeValue("class");
                String roles = derivElt.getAttributeValue("argRoles");
                String pos = derivElt.getAttributeValue("pos");
                if (!pos.startsWith("VB")) {
                    rel = null;
                }
                this.lexicon.setSupertagger(this.supertaggerStandIn);
                this.supertaggerStandIn.setTag(simpleCat);
                SignHash lexSigns = this.lexicon.getSignsFromWord(w);
                if (semClass == null || semClass.length() == 0) {
                    semClass = "NoClass";
                }
                int matchPOS = 0;
                boolean matchNoClass = false;
                Iterator<Sign> it = lexSigns.asSignSet().iterator();
                while (it.hasNext()) {
                    s = it.next();
                    Word word = s.getWords().get(0);
                    morphClass = word.getSemClass();
                    if (morphClass == null || morphClass.length() == 0) {
                        morphClass = "NoClass";
                    }
                    Category lexcat = s.getCategory();
                    LF lF = lexcat.getLF();
                    if (!((semClass.equals("NoClass") || semClass.equals(morphClass)) && Testbed.containsPred(lF, rel) && Testbed.containsRoles(lF, roles) && Testbed.containsRel(lF, indexRel, s))) {
                        it.remove();
                        continue;
                    }
                    UnifyControl.reindex(lexcat);
                    if (!word.getPOS().equals(pos)) continue;
                    ++matchPOS;
                    if (!semClass.equals("NoClass") || !morphClass.equals("NoClass")) continue;
                    matchNoClass = true;
                }
                if (matchPOS > 0) {
                    it = lexSigns.asSignSet().iterator();
                    while (it.hasNext()) {
                        s = it.next();
                        Word word = s.getWords().get(0);
                        if (!word.getPOS().equals(pos)) {
                            it.remove();
                            continue;
                        }
                        if (!matchNoClass || (morphClass = word.getSemClass()) == null || morphClass.length() == 0) continue;
                        it.remove();
                    }
                }
                if (lexSigns.isEmpty()) {
                    throw new LexException("No matching category " + cat + " for: " + w);
                }
                return lexSigns;
            }
            catch (LexException exc) {
                if (Testbed.isPunct(derivElt)) {
                    if (this.ccgBankTaskTestbed.isDebugDerivations()) {
                        this.ccgBankTaskTestbed.log(this.header + ": " + exc.toString());
                    }
                    return new SignHash();
                }
                throw new ParseException(exc.toString());
            }
            catch (RuntimeException exc) {
                throw new ParseException(exc.toString());
            }
        }
        throw new RuntimeException(this.header + ": unrecognized element in derivation: " + eltName);
    }

    private static void recurseCat(Category cat, ArrayList<String> fullCat, Hashtable<String, String> idConvTally, Hashtable<String, Integer> freqTally) {
        AtomCat ac;
        FeatureStructure fs;
        if (cat instanceof ComplexCat) {
            ComplexCat cc = (ComplexCat)cat.copy();
            Category resCat = cc.getResult();
            Testbed.recurseCat(resCat, fullCat, idConvTally, freqTally);
            int argStart = 0;
            if (resCat instanceof ComplexCat) {
                ComplexCat temp = (ComplexCat)resCat.copy();
                argStart = temp.getArgStack().size();
            }
            ArgStack argStack = cc.getArgStack(argStart);
            for (int i = 0; i < argStack.size(); ++i) {
                if (!(argStack.get(i) instanceof BasicArg)) continue;
                BasicArg bArg = (BasicArg)argStack.get(i);
                Category argCat = bArg.getCat();
                Slash argSlash = bArg.getSlash();
                fullCat.add(argSlash.toString());
                Testbed.recurseCat(argCat, fullCat, idConvTally, freqTally);
            }
        } else if (cat instanceof AtomCat && (fs = (ac = (AtomCat)cat.copy()).getFeatureStructure()).hasAttribute("index")) {
            String index = fs.getValue("index").toString();
            String[] id = index.split(":");
            if (!idConvTally.containsKey(id[0])) {
                idConvTally.put(id[0], Integer.toString(idConvTally.size() + 1));
            }
            String numId = idConvTally.get(id[0]);
            String catId = ac.getType() + "_" + numId;
            if (!freqTally.containsKey(numId)) {
                freqTally.put(numId, 0);
            }
            int freq = freqTally.get(numId);
            freqTally.put(numId, freq + 1);
            if (fs.hasAttribute("mod-index")) {
                catId = catId + "_M";
            }
            fullCat.add(catId);
        }
    }

    private static boolean containsPred(LF lf, String pred) {
        if (pred == null) {
            return true;
        }
        if (lf == null) {
            return false;
        }
        for (SatOp satOp : HyloHelper.getPreds(lf)) {
            if (!HyloHelper.isLexPred(satOp) || !HyloHelper.getLexPred(satOp).equals(pred)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsRoles(LF lf, String roles) {
        if (roles == null) {
            return true;
        }
        if (lf == null) {
            return false;
        }
        String[] rolesArray = roles.split("\\s+");
        rolesSet.clear();
        for (SatOp satOp : HyloHelper.getPreds(lf)) {
            if (!HyloHelper.isRelPred(satOp)) continue;
            rolesSet.add(HyloHelper.getRel(satOp));
        }
        for (String role : rolesArray) {
            if (role.equals("null") || role.equals("e") || rolesSet.contains(role)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsRel(LF lf, String indexRel, Sign sign) {
        if (indexRel == null) {
            return true;
        }
        if (lf == null) {
            return false;
        }
        indexRel = "<" + indexRel + ">";
        return lf.toString().contains(indexRel);
    }

    private static boolean isPunct(Element elt) {
        String pos = elt.getAttributeValue("pos");
        if (pos == null) {
            return false;
        }
        return pos.equals("|") || pos.equals(".") || pos.equals(",") || pos.equals(";") || pos.equals(":") || pos.equals("LRB") || pos.equals("RRB") || pos.equals("``") || pos.equals("''");
    }

    private static boolean containsCat(SignHash signs, String cat) {
        String supertag;
        if (!signs.isEmpty() && cat.indexOf(36) >= 0) {
            return true;
        }
        boolean retval = false;
        for (Sign sign : signs.asSignSet()) {
            supertag = sign.getCategory().getSupertag();
            if (supertag.indexOf(36) < 0 && !cat.equals(supertag)) continue;
            retval = true;
            break;
        }
        if (retval) {
            Iterator<Sign> it = signs.asSignSet().iterator();
            while (it.hasNext()) {
                Sign sign;
                sign = it.next();
                supertag = sign.getCategory().getSupertag();
                if (supertag.indexOf(36) >= 0 || cat.equals(supertag)) continue;
                it.remove();
            }
        }
        return retval;
    }

    private List<String> newCombos() {
        ArrayList<String> retval = new ArrayList<String>();
        this.newCombos(this.sign, retval);
        return retval;
    }

    private void newCombos(Sign s, List<String> retval) {
        Sign[] inputs = s.getDerivationHistory().getInputs();
        if (inputs != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < inputs.length; ++i) {
                sb.append(inputs[i].getCategory().getSupertag()).append(' ');
            }
            sb.append(s.getDerivationHistory().getRule().name());
            String combo = sb.toString();
            if (!this.combos.contains(combo)) {
                retval.add(combo);
                this.combos.add(combo);
            }
            for (int i = 0; i < inputs.length; ++i) {
                this.newCombos(inputs[i], retval);
            }
        }
    }

    private void extrPredInfo(LF lf, String sentId) {
        Testbed.extractPredInfo(lf, predInfo);
    }

    public static void extractPredInfo(LF lf, Map<String, String> predInfoMap) {
        String predData = "";
        List<SatOp> preds = HyloHelper.getPreds(lf);
        for (SatOp pred : preds) {
            String lexPred = HyloHelper.getLexPred(pred);
            if (lexPred == null || !(pred.getArg() instanceof Proposition)) continue;
            Proposition p = (Proposition)pred.getArg();
            String lex = p.getName().toString();
            String stag = pred.getOrigin().getSupertag();
            String pos = pred.getOrigin().getPOS();
            Nominal nom = pred.getNominal();
            String nomInd = nom.toString();
            String[] nomIndParts = nomInd.split(":");
            if (stag == null || pos == null || lex == null) continue;
            predData = Testbed.escape(stag) + ":" + Testbed.escape(pos) + ":" + Testbed.escape(lex);
            predInfoMap.put(nomIndParts[0], predData);
        }
    }

    private static String collectPredInfo(String sentId) {
        String predData = "";
        Enumeration<String> e = predInfo.keys();
        while (e.hasMoreElements()) {
            String nomId = e.nextElement();
            predData = predData + " " + nomId + ":" + predInfo.get(nomId);
        }
        predInfo = new Hashtable();
        return predData.trim();
    }

    public static String getPredInfo(Map<String, String> predInfoMap) {
        String predData = "";
        for (String nomId : predInfoMap.keySet()) {
            predData = predData + " " + nomId + ":" + predInfoMap.get(nomId);
        }
        return predData.trim();
    }

    private static String escape(String s) {
        return DefaultTokenizer.escape(s);
    }

    private static class SupertaggerStandIn
    implements SupertaggerAdapter {
        private Map<String, Double> map = new HashMap<String, Double>(2);

        private SupertaggerStandIn() {
        }

        @Override
        public Map<String, Double> getSupertags() {
            return this.map;
        }

        void setTag(String tag) {
            this.map.clear();
            this.map.put(tag, 1.0);
        }

        @Override
        public void setIncludeGold(boolean includeGold) {
        }

        @Override
        public void resetBeta() {
        }

        @Override
        public void resetBetaToMax() {
        }

        @Override
        public void nextBeta() {
        }

        @Override
        public void previousBeta() {
        }

        @Override
        public boolean hasMoreBetas() {
            return false;
        }

        @Override
        public boolean hasLessBetas() {
            return false;
        }

        @Override
        public double[] getBetas() {
            return new double[]{1.0};
        }

        @Override
        public void setBetas(double[] betas) {
        }

        @Override
        public double getCurrentBetaValue() {
            return 1.0;
        }
    }
}

