# lein-sass [![Build Status](https://travis-ci.org/101loops/lein-sass.svg)](https://travis-ci.org/101loops/lein-sass)

Leiningen plugin to compile SASS/SCSS files with [SassC](https://github.com/sass/sassc) or
[Sass](http://sass-lang.com).

[![Clojars Project](http://clojars.org/lein-sass/latest-version.svg)](http://clojars.org/lein-sass)


## Installation

You can install the plugin by adding lein-sass to your `project.clj` file in the `plugins` section:

```clj
(defproject example "1.0.0"
  :plugins [[lein-sass "0.4.0"]])
```

[SassC](https://github.com/sass/sassc) needs to be installed manually.
For example on OSX run `brew install sassc`.

To install SassC on Ubuntu (should similarly apply to other Unixes) I usually follow this recipe:
http://askubuntu.com/questions/566675/how-to-install-node-sass-gulp-sass-on-ubuntu-14-04-or-linux-mint-17/566681#566681

Alternatively you can use sass to compile your sass or scss
files. This needs to be installed as well, but the process might be straight forward. Please see http://sass-lang.com/install for install instructions.

On a Linux system you can just run `sudo gem install sass` (provided a decent Ruby runtime is installed).


## Configuration

Here is an example of `project.clj` with all the possible definitions.

```clj
(defproject example-project "1.2.3"

  :sass {:src "resources/sass"
         :output-directory "resources/public/css"

         ;; other options (provided are default values):
         ;; :delete-output-dir true
         ;; :source-maps true
         ;; :style :nested
         ;; :command :sassc (:sass or :sassc are recognized values)
         }
```


## Usage

To compile your files once:

```sh
$ lein sass once
```

To keep the compiler running and watch for changes:

```sh
$ lein sass auto
```

To delete all the files generated by lein-sass

```
$ lein sass clean
```


## Hooks

The following hooks are supported by lein-sass:

```
$ lein compile
$ lein clean
```

To enable the hooks, add the following to your `project.clj` file:

```clj
:hooks [leiningen.sass]
```


## License

Copyright (C) 2013 Renaud Tircher, 2014 Stephan Behnke

Distributed under the Eclipse Public License, the same as Clojure.
