(ns leiningen.sass
  (:require [robert.hooke :as hooke]
            [leiningen.help :as lhelp]
            [leiningen.clean :as lclean]
            [leiningen.compile :as lcompile]
            [leiningen.core.main :as lmain])
  (:use leiningen.utils
        leiningen.render
        leiningen.cleaner))

(defn- once
  [options]
  (println "Compiling files located in" (:src options) "to" (:output-directory options))
  (render-once! options))

(defn- compile-hook [task & args]
  (apply task args)
  (once (normalize-options (:sass (first args)))))

(defn- auto
  [options]
  (println "Ready to compile files located in" (:src options) "to" (:output-directory options))
  (render-loop! options))

(defn- clean
  [options]
  (println "Deleting files generated by lein-sass in" (:output-directory options))
  (clean-all! options))

(defn- clean-hook [task & args]
  (apply task args)
  (clean (normalize-options (:sass (first args)))))

(defn- abort [s]
  (println s)
  (lmain/abort))

(defn sass
  {:help-arglists '([once auto clean]) :subtasks [#'once #'auto #'clean]}
  ([_]
    (abort (lhelp/help-for "sass")))

  ([project subtask & args]
    (let [options (normalize-options (:sass project))]
      (case (keyword subtask)
        :once (once options)
        :auto (auto options)
        :clean (clean options)
        (abort (str "Subtask" \" subtask \" "not found. " (lhelp/subtask-help-for *ns* #'sass)))))))

(defn activate []
  (hooke/add-hook #'lclean/clean #'clean-hook)
  (hooke/add-hook #'lcompile/compile #'compile-hook))
