/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.CSVIterator;
import com.opencsv.CSVParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CSVReader
implements Closeable,
Iterable<String[]> {
    public static final int DEFAULT_SKIP_LINES = 0;
    private CSVParser parser;
    private int skipLines;
    private BufferedReader br;
    private boolean hasNext = true;
    private boolean linesSkiped;

    public CSVReader(Reader reader2) {
        this(reader2, ',', '\"', '\\');
    }

    public CSVReader(Reader reader2, char separator) {
        this(reader2, separator, '\"', '\\');
    }

    public CSVReader(Reader reader2, char separator, char quotechar) {
        this(reader2, separator, quotechar, '\\', 0, false);
    }

    public CSVReader(Reader reader2, char separator, char quotechar, boolean strictQuotes) {
        this(reader2, separator, quotechar, '\\', 0, strictQuotes);
    }

    public CSVReader(Reader reader2, char separator, char quotechar, char escape2) {
        this(reader2, separator, quotechar, escape2, 0, false);
    }

    public CSVReader(Reader reader2, char separator, char quotechar, int line) {
        this(reader2, separator, quotechar, '\\', line, false);
    }

    public CSVReader(Reader reader2, char separator, char quotechar, char escape2, int line) {
        this(reader2, separator, quotechar, escape2, line, false);
    }

    public CSVReader(Reader reader2, char separator, char quotechar, char escape2, int line, boolean strictQuotes) {
        this(reader2, separator, quotechar, escape2, line, strictQuotes, true);
    }

    public CSVReader(Reader reader2, char separator, char quotechar, char escape2, int line, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        this(reader2, line, new CSVParser(separator, quotechar, escape2, strictQuotes, ignoreLeadingWhiteSpace));
    }

    public CSVReader(Reader reader2, int line, CSVParser csvParser) {
        this.br = reader2 instanceof BufferedReader ? (BufferedReader)reader2 : new BufferedReader(reader2);
        this.skipLines = line;
        this.parser = csvParser;
    }

    public CSVParser getParser() {
        return this.parser;
    }

    public int getSkipLines() {
        return this.skipLines;
    }

    public List<String[]> readAll() throws IOException {
        ArrayList<String[]> allElements = new ArrayList<String[]>();
        while (this.hasNext) {
            String[] nextLineAsTokens = this.readNext();
            if (nextLineAsTokens == null) continue;
            allElements.add(nextLineAsTokens);
        }
        return allElements;
    }

    public String[] readNext() throws IOException {
        String[] result = null;
        do {
            String nextLine = this.getNextLine();
            if (!this.hasNext) {
                return result;
            }
            String[] r = this.parser.parseLineMulti(nextLine);
            if (r.length <= 0) continue;
            result = result == null ? r : this.combineResultsFromMultipleReads(result, r);
        } while (this.parser.isPending());
        return result;
    }

    private String[] combineResultsFromMultipleReads(String[] buffer, String[] lastRead) {
        String[] t = new String[buffer.length + lastRead.length];
        System.arraycopy(buffer, 0, t, 0, buffer.length);
        System.arraycopy(lastRead, 0, t, buffer.length, lastRead.length);
        return t;
    }

    private String getNextLine() throws IOException {
        String nextLine;
        if (this.isClosed()) {
            this.hasNext = false;
            return null;
        }
        if (!this.linesSkiped) {
            for (int i = 0; i < this.skipLines; ++i) {
                this.br.readLine();
            }
            this.linesSkiped = true;
        }
        if ((nextLine = this.br.readLine()) == null) {
            this.hasNext = false;
        }
        return this.hasNext ? nextLine : null;
    }

    private boolean isClosed() {
        try {
            return !this.br.ready();
        }
        catch (IOException e2) {
            return true;
        }
    }

    @Override
    public void close() throws IOException {
        this.br.close();
    }

    @Override
    public Iterator<String[]> iterator() {
        try {
            return new CSVIterator(this);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }
}

