/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.MappingStrategy;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HeaderColumnNameMappingStrategy<T>
implements MappingStrategy<T> {
    protected String[] header;
    protected Map<String, Integer> indexLookup = new HashMap<String, Integer>();
    protected Map<String, PropertyDescriptor> descriptorMap = null;
    protected Class<T> type;

    @Override
    public void captureHeader(CSVReader reader2) throws IOException {
        this.header = reader2.readNext();
    }

    protected void createIndexLookup(String[] values) {
        if (this.indexLookup.isEmpty()) {
            for (int i = 0; i < values.length; ++i) {
                this.indexLookup.put(values[i], i);
            }
        }
    }

    protected void resetIndexMap() {
        this.indexLookup.clear();
    }

    @Override
    public Integer getColumnIndex(String name2) {
        if (null == this.header) {
            throw new IllegalStateException("The header row hasn't been read yet.");
        }
        this.createIndexLookup(this.header);
        return this.indexLookup.get(name2);
    }

    @Override
    public PropertyDescriptor findDescriptor(int col) throws IntrospectionException {
        String columnName = this.getColumnName(col);
        return StringUtils.isNotBlank(columnName) ? this.findDescriptor(columnName) : null;
    }

    public String getColumnName(int col) {
        return null != this.header && col < this.header.length ? this.header[col] : null;
    }

    protected PropertyDescriptor findDescriptor(String name2) throws IntrospectionException {
        if (null == this.descriptorMap) {
            this.descriptorMap = this.loadDescriptorMap();
        }
        return this.descriptorMap.get(name2.toUpperCase().trim());
    }

    protected boolean matches(String name2, PropertyDescriptor desc) {
        return desc.getName().equals(name2.trim());
    }

    protected Map<String, PropertyDescriptor> loadDescriptorMap() throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        HashMap<String, PropertyDescriptor> map2 = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor descriptor2 : descriptors = this.loadDescriptors(this.getType())) {
            map2.put(descriptor2.getName().toUpperCase().trim(), descriptor2);
        }
        return map2;
    }

    private PropertyDescriptor[] loadDescriptors(Class<T> cls) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(cls);
        return beanInfo.getPropertyDescriptors();
    }

    @Override
    public T createBean() throws InstantiationException, IllegalAccessException {
        return this.type.newInstance();
    }

    @Deprecated
    public Class<T> getType() {
        return this.type;
    }

    @Deprecated
    public void setType(Class<T> type2) {
        this.type = type2;
    }
}

