/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;

public final class LongField
extends Field {
    public static final FieldType TYPE_NOT_STORED = new FieldType();
    public static final FieldType TYPE_STORED;

    public LongField(String name2, long value, Field.Store stored) {
        super(name2, stored == Field.Store.YES ? TYPE_STORED : TYPE_NOT_STORED);
        this.fieldsData = value;
    }

    public LongField(String name2, long value, FieldType type2) {
        super(name2, type2);
        if (type2.numericType() != FieldType.NumericType.LONG) {
            throw new IllegalArgumentException("type.numericType() must be LONG but got " + (Object)((Object)type2.numericType()));
        }
        this.fieldsData = value;
    }

    static {
        TYPE_NOT_STORED.setTokenized(true);
        TYPE_NOT_STORED.setOmitNorms(true);
        TYPE_NOT_STORED.setIndexOptions(IndexOptions.DOCS);
        TYPE_NOT_STORED.setNumericType(FieldType.NumericType.LONG);
        TYPE_NOT_STORED.freeze();
        TYPE_STORED = new FieldType();
        TYPE_STORED.setTokenized(true);
        TYPE_STORED.setOmitNorms(true);
        TYPE_STORED.setIndexOptions(IndexOptions.DOCS);
        TYPE_STORED.setNumericType(FieldType.NumericType.LONG);
        TYPE_STORED.setStored(true);
        TYPE_STORED.freeze();
    }
}

