/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import java.util.List;
import java.util.Locale;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.BasicStats;
import org.apache.lucene.search.similarities.LMSimilarity;

public class LMDirichletSimilarity
extends LMSimilarity {
    private final float mu;

    public LMDirichletSimilarity(LMSimilarity.CollectionModel collectionModel, float mu) {
        super(collectionModel);
        this.mu = mu;
    }

    public LMDirichletSimilarity(float mu) {
        this.mu = mu;
    }

    public LMDirichletSimilarity(LMSimilarity.CollectionModel collectionModel) {
        this(collectionModel, 2000.0f);
    }

    public LMDirichletSimilarity() {
        this(2000.0f);
    }

    @Override
    protected float score(BasicStats stats, float freq, float docLen) {
        float score = stats.getTotalBoost() * (float)(Math.log(1.0f + freq / (this.mu * ((LMSimilarity.LMStats)stats).getCollectionProbability())) + Math.log(this.mu / (docLen + this.mu)));
        return score > 0.0f ? score : 0.0f;
    }

    @Override
    protected void explain(List<Explanation> subs2, BasicStats stats, int doc2, float freq, float docLen) {
        if (stats.getTotalBoost() != 1.0f) {
            subs2.add(Explanation.match(stats.getTotalBoost(), "boost", new Explanation[0]));
        }
        subs2.add(Explanation.match(this.mu, "mu", new Explanation[0]));
        Explanation weightExpl = Explanation.match((float)Math.log(1.0f + freq / (this.mu * ((LMSimilarity.LMStats)stats).getCollectionProbability())), "term weight", new Explanation[0]);
        subs2.add(weightExpl);
        subs2.add(Explanation.match((float)Math.log(this.mu / (docLen + this.mu)), "document norm", new Explanation[0]));
        super.explain(subs2, stats, doc2, freq, docLen);
    }

    public float getMu() {
        return this.mu;
    }

    @Override
    public String getName() {
        return String.format(Locale.ROOT, "Dirichlet(%f)", Float.valueOf(this.getMu()));
    }
}

