/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.text.csv;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.AbstractQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriter;

public class SPARQLResultsCSVWriter
extends AbstractQueryResultWriter
implements TupleQueryResultWriter {
    private Writer writer;
    private List<String> bindingNames;

    public SPARQLResultsCSVWriter(OutputStream out) {
        OutputStreamWriter w = new OutputStreamWriter(out, Charset.forName("UTF-8"));
        this.writer = new BufferedWriter(w, 1024);
    }

    @Override
    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        this.bindingNames = bindingNames;
        try {
            for (int i = 0; i < bindingNames.size(); ++i) {
                this.writer.write(bindingNames.get(i));
                if (i >= bindingNames.size() - 1) continue;
                this.writer.write(",");
            }
            this.writer.write("\r\n");
        }
        catch (IOException e2) {
            throw new TupleQueryResultHandlerException(e2);
        }
    }

    @Override
    public void endQueryResult() throws TupleQueryResultHandlerException {
        if (this.bindingNames == null) {
            throw new IllegalStateException("Could not end query result as startQueryResult was not called first.");
        }
        try {
            this.writer.flush();
        }
        catch (IOException e2) {
            throw new TupleQueryResultHandlerException(e2);
        }
    }

    @Override
    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        if (this.bindingNames == null) {
            throw new IllegalStateException("Must call startQueryResult before handleSolution");
        }
        try {
            for (int i = 0; i < this.bindingNames.size(); ++i) {
                String name2 = this.bindingNames.get(i);
                Value value = bindingSet.getValue(name2);
                if (value != null) {
                    this.writeValue(value);
                }
                if (i >= this.bindingNames.size() - 1) continue;
                this.writer.write(",");
            }
            this.writer.write("\r\n");
        }
        catch (IOException e2) {
            throw new TupleQueryResultHandlerException(e2);
        }
    }

    @Override
    public final TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.CSV;
    }

    @Override
    public final TupleQueryResultFormat getQueryResultFormat() {
        return this.getTupleQueryResultFormat();
    }

    protected void writeValue(Value val2) throws IOException {
        if (val2 instanceof Resource) {
            this.writeResource((Resource)val2);
        } else {
            this.writeLiteral((Literal)val2);
        }
    }

    protected void writeResource(Resource res) throws IOException {
        if (res instanceof IRI) {
            this.writeURI((IRI)res);
        } else {
            this.writeBNode((BNode)res);
        }
    }

    protected void writeURI(IRI uri) throws IOException {
        String uriString = uri.toString();
        boolean quoted = uriString.contains(",");
        if (quoted) {
            this.writer.write("\"");
        }
        this.writer.write(uriString);
        if (quoted) {
            this.writer.write("\"");
        }
    }

    protected void writeBNode(BNode bNode) throws IOException {
        this.writer.write("_:");
        this.writer.write(bNode.getID());
    }

    private void writeLiteral(Literal literal) throws IOException {
        String label = literal.getLabel();
        IRI datatype = literal.getDatatype();
        Optional<String> language = literal.getLanguage();
        boolean quoted = false;
        if (XMLDatatypeUtil.isIntegerDatatype(datatype) || XMLDatatypeUtil.isDecimalDatatype(datatype) || XMLSchema.DOUBLE.equals(datatype)) {
            try {
                String normalized = XMLDatatypeUtil.normalize(label, datatype);
                this.writer.write(normalized);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (label.contains(",") || label.contains("\r") || label.contains("\n") || label.contains("\"")) {
            quoted = true;
            label = label.replaceAll("\"", "\"\"");
        }
        if (quoted) {
            this.writer.write("\"");
        }
        this.writer.write(label);
        if (quoted) {
            this.writer.write("\"");
        }
    }

    @Override
    public void startDocument() throws QueryResultHandlerException {
    }

    @Override
    public void handleStylesheet(String stylesheetUrl) throws QueryResultHandlerException {
    }

    @Override
    public void startHeader() throws QueryResultHandlerException {
    }

    @Override
    public void handleLinks(List<String> linkUrls) throws QueryResultHandlerException {
    }

    @Override
    public void endHeader() throws QueryResultHandlerException {
    }

    @Override
    public void handleBoolean(boolean value) throws QueryResultHandlerException {
        throw new UnsupportedOperationException("Cannot handle boolean results");
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws QueryResultHandlerException {
    }
}

