/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail;

import java.io.File;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.HttpClientSessionManager;
import org.eclipse.rdf4j.http.client.SessionManagerDependent;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryLockedException;
import org.eclipse.rdf4j.repository.base.AbstractRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.repository.sail.config.RepositoryResolver;
import org.eclipse.rdf4j.repository.sail.config.RepositoryResolverClient;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.SailLockedException;
import org.eclipse.rdf4j.sail.StackableSail;

public class SailRepository
extends AbstractRepository
implements FederatedServiceResolverClient,
RepositoryResolverClient,
HttpClientDependent,
SessionManagerDependent {
    private final Sail sail;

    public SailRepository(Sail sail) {
        this.sail = sail;
    }

    @Override
    public File getDataDir() {
        return this.sail.getDataDir();
    }

    @Override
    public void setDataDir(File dataDir) {
        this.sail.setDataDir(dataDir);
    }

    @Override
    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        FederatedServiceResolverClient stack = this.findSailOf(this.sail, FederatedServiceResolverClient.class);
        if (stack != null) {
            stack.setFederatedServiceResolver(resolver);
        }
    }

    @Override
    public void setRepositoryResolver(RepositoryResolver resolver) {
        RepositoryResolverClient stack = this.findSailOf(this.sail, RepositoryResolverClient.class);
        if (stack != null) {
            stack.setRepositoryResolver(resolver);
        }
    }

    @Override
    public HttpClientSessionManager getHttpClientSessionManager() {
        SessionManagerDependent stack = this.findSailOf(this.sail, SessionManagerDependent.class);
        if (stack != null) {
            return stack.getHttpClientSessionManager();
        }
        return null;
    }

    @Override
    public void setHttpClientSessionManager(HttpClientSessionManager client) {
        SessionManagerDependent stack = this.findSailOf(this.sail, SessionManagerDependent.class);
        if (stack != null) {
            stack.setHttpClientSessionManager(client);
        }
    }

    @Override
    public HttpClient getHttpClient() {
        HttpClientDependent stack = this.findSailOf(this.sail, HttpClientDependent.class);
        if (stack != null) {
            return stack.getHttpClient();
        }
        return null;
    }

    @Override
    public void setHttpClient(HttpClient client) {
        HttpClientDependent stack = this.findSailOf(this.sail, HttpClientDependent.class);
        if (stack != null) {
            stack.setHttpClient(client);
        }
    }

    @Override
    protected void initializeInternal() throws RepositoryException {
        try {
            this.sail.initialize();
        }
        catch (SailLockedException e2) {
            String l = e2.getLockedBy();
            String r = e2.getRequestedBy();
            String m = e2.getMessage();
            throw new RepositoryLockedException(l, r, m, e2);
        }
        catch (SailException e3) {
            throw new RepositoryException(e3.getMessage(), e3);
        }
    }

    @Override
    protected void shutDownInternal() throws RepositoryException {
        try {
            this.sail.shutDown();
        }
        catch (SailException e2) {
            throw new RepositoryException("Unable to shutdown Sail", e2);
        }
    }

    public Sail getSail() {
        return this.sail;
    }

    @Override
    public boolean isWritable() throws RepositoryException {
        try {
            return this.sail.isWritable();
        }
        catch (SailException e2) {
            throw new RepositoryException("Unable to determine writable status of Sail", e2);
        }
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.sail.getValueFactory();
    }

    @Override
    public SailRepositoryConnection getConnection() throws RepositoryException {
        try {
            return new SailRepositoryConnection(this, this.sail.getConnection());
        }
        catch (SailException e2) {
            throw new RepositoryException(e2);
        }
    }

    public String toString() {
        return this.sail.toString();
    }

    private <T> T findSailOf(Sail sail, Class<T> type2) {
        if (type2.isInstance(sail)) {
            return type2.cast(sail);
        }
        if (sail instanceof StackableSail) {
            return this.findSailOf(((StackableSail)sail).getBaseSail(), type2);
        }
        return null;
    }
}

