/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public class RDFHandlerWrapper
implements RDFHandler {
    private final RDFHandler[] rdfHandlers;

    public RDFHandlerWrapper(RDFHandler ... rdfHandlers) {
        assert (rdfHandlers != null);
        this.rdfHandlers = rdfHandlers;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        for (RDFHandler rdfHandler : this.rdfHandlers) {
            rdfHandler.startRDF();
        }
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        for (RDFHandler rdfHandler : this.rdfHandlers) {
            rdfHandler.endRDF();
        }
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        for (RDFHandler rdfHandler : this.rdfHandlers) {
            rdfHandler.handleNamespace(prefix, uri);
        }
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        for (RDFHandler rdfHandler : this.rdfHandlers) {
            rdfHandler.handleStatement(st);
        }
    }

    @Override
    public void handleComment(String comment2) throws RDFHandlerException {
        for (RDFHandler rdfHandler : this.rdfHandlers) {
            rdfHandler.handleComment(comment2);
        }
    }
}

