/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.helpers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileLock;
import java.security.AccessControlException;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.sail.LockManager;
import org.eclipse.rdf4j.sail.SailLockedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryLockManager
implements LockManager {
    private static final String LOCK_DIR_NAME = "lock";
    private static final String LOCK_FILE_NAME = "locked";
    private static final String INFO_FILE_NAME = "process";
    private final Logger logger = LoggerFactory.getLogger(DirectoryLockManager.class);
    private final File dir;

    public DirectoryLockManager(File dir2) {
        this.dir = dir2;
    }

    @Override
    public String getLocation() {
        return this.dir.toString();
    }

    private File getLockDir() {
        return new File(this.dir, LOCK_DIR_NAME);
    }

    @Override
    public boolean isLocked() {
        return this.getLockDir().exists();
    }

    @Override
    public Lock tryLock() {
        File lockDir = this.getLockDir();
        if (lockDir.exists()) {
            this.removeInvalidLock(lockDir);
        }
        if (!lockDir.mkdir()) {
            return null;
        }
        Lock lock = null;
        try {
            File infoFile = new File(lockDir, INFO_FILE_NAME);
            File lockedFile = new File(lockDir, LOCK_FILE_NAME);
            RandomAccessFile raf = new RandomAccessFile(lockedFile, "rw");
            try {
                FileLock fileLock = raf.getChannel().lock();
                lock = this.createLock(raf, fileLock);
                this.sign(infoFile);
            }
            catch (IOException e2) {
                if (lock != null) {
                    lock.release();
                } else {
                    raf.close();
                }
                throw e2;
            }
        }
        catch (IOException e3) {
            this.logger.error(e3.toString(), e3);
        }
        return lock;
    }

    @Override
    public Lock lockOrFail() throws SailLockedException {
        Lock lock = this.tryLock();
        if (lock != null) {
            return lock;
        }
        String requestedBy = this.getProcessName();
        String lockedBy = this.getLockedBy();
        if (lockedBy != null) {
            throw new SailLockedException(lockedBy, requestedBy, this);
        }
        lock = this.tryLock();
        if (lock != null) {
            return lock;
        }
        throw new SailLockedException(requestedBy);
    }

    @Override
    public boolean revokeLock() {
        File lockDir = this.getLockDir();
        File lockedFile = new File(lockDir, LOCK_FILE_NAME);
        File infoFile = new File(lockDir, INFO_FILE_NAME);
        lockedFile.delete();
        infoFile.delete();
        return lockDir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInvalidLock(File lockDir) {
        try {
            boolean revokeLock = false;
            File lockedFile = new File(lockDir, LOCK_FILE_NAME);
            try (RandomAccessFile raf = new RandomAccessFile(lockedFile, "rw");){
                FileLock fileLock = raf.getChannel().tryLock();
                if (fileLock != null) {
                    this.logger.warn("Removing invalid lock {}", (Object)this.getLockedBy());
                    fileLock.release();
                    revokeLock = true;
                }
            }
            if (revokeLock) {
                this.revokeLock();
            }
        }
        catch (IOException e2) {
            this.logger.warn(e2.toString(), e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLockedBy() {
        String string2;
        File lockDir = this.getLockDir();
        File infoFile = new File(lockDir, INFO_FILE_NAME);
        BufferedReader reader2 = new BufferedReader(new FileReader(infoFile));
        try {
            string2 = reader2.readLine();
        }
        catch (Throwable throwable) {
            try {
                reader2.close();
                throw throwable;
            }
            catch (IOException e2) {
                this.logger.warn(e2.toString(), e2);
                return null;
            }
        }
        reader2.close();
        return string2;
    }

    private Lock createLock(final RandomAccessFile raf, final FileLock fileLock) {
        return new Lock(){
            private Thread hook;
            {
                try {
                    Thread hook = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            this.delete();
                        }
                    });
                    Runtime.getRuntime().addShutdownHook(hook);
                    this.hook = hook;
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
            }

            @Override
            public boolean isActive() {
                return fileLock.isValid() || this.hook != null;
            }

            @Override
            public void release() {
                try {
                    if (this.hook != null) {
                        Runtime.getRuntime().removeShutdownHook(this.hook);
                        this.hook = null;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (AccessControlException e2) {
                    DirectoryLockManager.this.logger.warn(e2.toString(), e2);
                }
                this.delete();
            }

            synchronized void delete() {
                try {
                    if (raf.getChannel().isOpen()) {
                        fileLock.release();
                        raf.close();
                    }
                }
                catch (IOException e2) {
                    DirectoryLockManager.this.logger.warn(e2.toString(), e2);
                }
                DirectoryLockManager.this.revokeLock();
            }
        };
    }

    private void sign(File infoFile) throws IOException {
        try (FileWriter out = new FileWriter(infoFile);){
            out.write(this.getProcessName());
            out.flush();
        }
    }

    private String getProcessName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }
}

