/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.query.algebra.evaluation.function.FunctionRegistry;

final class SpinWellKnownFunctions {
    private static final ValueFactory valueFactory = SimpleValueFactory.getInstance();
    private static final FunctionRegistry functionRegistry = FunctionRegistry.getInstance();
    static final SpinWellKnownFunctions INSTANCE = new SpinWellKnownFunctions();
    private final BiMap<String, IRI> stringToUri = HashBiMap.create(64);
    private final BiMap<IRI, String> uriToString = this.stringToUri.inverse();

    public SpinWellKnownFunctions() {
        this.stringToUri.put(FN.SUBSTRING.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "substr"));
        this.stringToUri.put(FN.SUBSTRING_BEFORE.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "strbefore"));
        this.stringToUri.put(FN.SUBSTRING_AFTER.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "strafter"));
        this.stringToUri.put(FN.STARTS_WITH.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "strstarts"));
        this.stringToUri.put(FN.ENDS_WITH.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "strends"));
        this.stringToUri.put(FN.STRING_LENGTH.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "strlen"));
        this.stringToUri.put(FN.CONCAT.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "concat"));
        this.stringToUri.put(FN.CONTAINS.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "contains"));
        this.stringToUri.put(FN.LOWER_CASE.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "lcase"));
        this.stringToUri.put(FN.UPPER_CASE.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "ucase"));
        this.stringToUri.put(FN.REPLACE.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "replace"));
        this.stringToUri.put(FN.NUMERIC_ABS.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "abs"));
        this.stringToUri.put(FN.NUMERIC_CEIL.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "ceil"));
        this.stringToUri.put(FN.NUMERIC_FLOOR.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "floor"));
        this.stringToUri.put(FN.NUMERIC_ROUND.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "round"));
        this.stringToUri.put(FN.YEAR_FROM_DATETIME.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "year"));
        this.stringToUri.put(FN.MONTH_FROM_DATETIME.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "month"));
        this.stringToUri.put(FN.DAY_FROM_DATETIME.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "day"));
        this.stringToUri.put(FN.HOURS_FROM_DATETIME.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "hours"));
        this.stringToUri.put(FN.MINUTES_FROM_DATETIME.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "minutes"));
        this.stringToUri.put(FN.SECONDS_FROM_DATETIME.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "seconds"));
        this.stringToUri.put(FN.TIMEZONE_FROM_DATETIME.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "timezone"));
        this.stringToUri.put(FN.ENCODE_FOR_URI.stringValue(), valueFactory.createIRI("http://spinrdf.org/sp#", "encode_for_uri"));
        this.stringToUri.put("NOW", valueFactory.createIRI("http://spinrdf.org/sp#", "now"));
        this.stringToUri.put("RAND", valueFactory.createIRI("http://spinrdf.org/sp#", "rand"));
        this.stringToUri.put("STRDT", valueFactory.createIRI("http://spinrdf.org/sp#", "strdt"));
        this.stringToUri.put("STRLANG", valueFactory.createIRI("http://spinrdf.org/sp#", "strlang"));
        this.stringToUri.put("TZ", valueFactory.createIRI("http://spinrdf.org/sp#", "tz"));
        this.stringToUri.put("UUID", valueFactory.createIRI("http://spinrdf.org/sp#", "uuid"));
        this.stringToUri.put("STRUUID", valueFactory.createIRI("http://spinrdf.org/sp#", "struuid"));
        this.stringToUri.put("MD5", valueFactory.createIRI("http://spinrdf.org/sp#", "md5"));
        this.stringToUri.put("SHA1", valueFactory.createIRI("http://spinrdf.org/sp#", "sha1"));
        this.stringToUri.put("SHA256", valueFactory.createIRI("http://spinrdf.org/sp#", "sha256"));
        this.stringToUri.put("SHA384", valueFactory.createIRI("http://spinrdf.org/sp#", "sha384"));
        this.stringToUri.put("SHA512", valueFactory.createIRI("http://spinrdf.org/sp#", "sha512"));
    }

    public IRI getURI(String name2) {
        IRI iri = (IRI)this.stringToUri.get(name2);
        if (iri == null && functionRegistry.has(name2)) {
            iri = valueFactory.createIRI(name2);
        }
        return iri;
    }

    public String getName(IRI IRI2) {
        String name2 = (String)this.uriToString.get(IRI2);
        if (name2 == null && functionRegistry.has(IRI2.stringValue())) {
            name2 = IRI2.stringValue();
        }
        return name2;
    }
}

